/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.sun.security.auth.PrincipalComparator;
import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import sun.misc.JavaSecurityProtectionDomainAccess;
import sun.misc.SharedSecrets;
import sun.net.www.ParseUtil;
import sun.security.provider.PolicyParser;
import sun.security.util.Debug;
import sun.security.util.PolicyUtil;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;
import sun.security.util.SecurityConstants;

public class PolicyFile
extends Policy {
    private static final Debug debug = Debug.getInstance("policy");
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String SELF = "${{self}}";
    private static final String X500PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final String POLICY = "java.security.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String POLICY_URL = "policy.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static final int DEFAULT_CACHE_SIZE = 1;
    private AtomicReference<PolicyInfo> policyInfo;
    private boolean constructed;
    private boolean expandProperties;
    private boolean ignoreIdentityScope;
    private boolean allowSystemProperties;
    private boolean notUtf8;
    private URL url;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};

    public PolicyFile() {
        this.policyInfo = new AtomicReference();
        this.constructed = false;
        this.expandProperties = true;
        this.ignoreIdentityScope = true;
        this.allowSystemProperties = true;
        this.notUtf8 = false;
        this.init(null);
    }

    public PolicyFile(URL uRL) {
        this.policyInfo = new AtomicReference();
        this.constructed = false;
        this.expandProperties = true;
        this.ignoreIdentityScope = true;
        this.allowSystemProperties = true;
        this.notUtf8 = false;
        this.url = uRL;
        this.init(uRL);
    }

    private void init(URL uRL) {
        int n2;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(this){
            final /* synthetic */ PolicyFile this$0;
            {
                this.this$0 = policyFile;
            }

            public String run() {
                PolicyFile.access$002(this.this$0, "true".equalsIgnoreCase(Security.getProperty("policy.expandProperties")));
                PolicyFile.access$102(this.this$0, "true".equalsIgnoreCase(Security.getProperty("policy.ignoreIdentityScope")));
                PolicyFile.access$202(this.this$0, "true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty")));
                PolicyFile.access$302(this.this$0, "false".equalsIgnoreCase(System.getProperty("sun.security.policy.utf8")));
                return System.getProperty("sun.security.policy.numcaches");
            }

            static /* synthetic */ PolicyFile _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, PolicyFile policyFile) {
                (object).this$0 = policyFile;
            }
        });
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
        } else {
            n2 = 1;
        }
        PolicyInfo policyInfo = new PolicyInfo(n2);
        this.initPolicyFile(policyInfo, uRL);
        this.policyInfo.set(policyInfo);
    }

    private void initPolicyFile(PolicyInfo policyInfo, URL uRL) {
        if (uRL != null) {
            if (debug != null) {
                debug.println("reading " + uRL);
            }
            AccessController.doPrivileged(new PrivilegedAction(this, uRL, policyInfo){
                final /* synthetic */ URL val$url;
                final /* synthetic */ PolicyInfo val$newInfo;
                final /* synthetic */ PolicyFile this$0;
                {
                    this.this$0 = policyFile;
                    this.val$url = uRL;
                    this.val$newInfo = policyInfo;
                }

                public Void run() {
                    if (!this.this$0.init((this).val$url, (this).val$newInfo)) {
                        this.this$0.initStaticPolicy((this).val$newInfo);
                    }
                    return null;
                }

                static /* synthetic */ void _jr$ip$val$url(Object object, URL uRL) {
                    (object).val$url = uRL;
                }

                static /* synthetic */ void _jr$ip$val$newInfo(Object object, PolicyInfo policyInfo) {
                    (object).val$newInfo = policyInfo;
                }

                static /* synthetic */ PolicyFile _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, PolicyFile policyFile) {
                    (object).this$0 = policyFile;
                }
            });
        } else {
            boolean bl = this.initPolicyFile(POLICY, POLICY_URL, policyInfo);
            if (!bl) {
                this.initStaticPolicy(policyInfo);
            }
            this.initPolicyFile(AUTH_POLICY, AUTH_POLICY_URL, policyInfo);
        }
    }

    private boolean initPolicyFile(String string, String string2, PolicyInfo policyInfo) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(this, string, policyInfo, string2){
            final /* synthetic */ URL val$url;
            final /* synthetic */ PolicyInfo val$newInfo;
            {
                this.val$url = uRL;
                this.val$newInfo = policyInfo;
            }

            @Override
            public Void run() {
                if (!PolicyFile.this.init(this.val$url, this.val$newInfo)) {
                    PolicyFile.this.initStaticPolicy(this.val$newInfo);
                }
                return null;
            }
        });
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean init(URL uRL, PolicyInfo policyInfo) {
        boolean bl;
        block25: {
            InputStreamReader inputStreamReader;
            block22: {
                KeyStore keyStore;
                PolicyParser policyParser;
                block21: {
                    bl = false;
                    policyParser = new PolicyParser(this.expandProperties);
                    inputStreamReader = null;
                    inputStreamReader = this.notUtf8 ? new InputStreamReader(PolicyUtil.getInputStream(uRL)) : new InputStreamReader(PolicyUtil.getInputStream(uRL), "UTF-8");
                    policyParser.read(inputStreamReader);
                    keyStore = null;
                    try {
                        keyStore = PolicyUtil.getKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType(), policyParser.getKeyStoreProvider(), policyParser.getStorePassURL(), debug);
                    }
                    catch (Exception exception) {
                        if (debug == null) break block21;
                        exception.printStackTrace();
                    }
                }
                Enumeration<PolicyParser.GrantEntry> enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)((Object)g.convertForCast((Object)((Object)enumeration.nextElement()), PolicyParser.GrantEntry.class));
                    this.addGrantEntry(grantEntry, keyStore, policyInfo);
                }
                if (inputStreamReader == null) break block22;
                try {
                    inputStreamReader.close();
                    bl = true;
                }
                catch (IOException iOException) {}
                break block25;
            }
            bl = true;
            break block25;
            catch (PolicyParser.ParsingException parsingException) {
                block23: {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("java.security.policy.error.parsing.policy.message"));
                    Object[] objectArray = new Object[2];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)uRL);
                    a.arrayStore((Object[])objectArray, (int)1, (Object)parsingException.getLocalizedMessage());
                    Object[] objectArray2 = objectArray;
                    System.err.println(messageFormat.format(objectArray2));
                    if (debug != null) {
                        parsingException.printStackTrace();
                    }
                    if (inputStreamReader == null) break block23;
                    try {
                        inputStreamReader.close();
                        bl = true;
                    }
                    catch (IOException iOException) {}
                }
                bl = true;
            }
            catch (Exception exception) {
                block24: {
                    if (debug != null) {
                        debug.println("error parsing " + uRL);
                        debug.println(exception.toString());
                        exception.printStackTrace();
                    }
                    if (inputStreamReader == null) break block24;
                    {
                        catch (Throwable throwable) {
                            if (inputStreamReader != null) {
                                try {
                                    inputStreamReader.close();
                                    bl = true;
                                }
                                catch (IOException iOException) {}
                            } else {
                                bl = true;
                            }
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                    try {
                        inputStreamReader.close();
                        bl = true;
                    }
                    catch (IOException iOException) {}
                }
                bl = true;
            }
        }
        return bl;
    }

    private void initStaticPolicy(PolicyInfo policyInfo) {
        AccessController.doPrivileged(new PrivilegedAction<Boolean>(this, policyInfo){
            final /* synthetic */ String val$propname;
            final /* synthetic */ PolicyInfo val$newInfo;
            final /* synthetic */ String val$urlname;
            {
                this.val$propname = string;
                this.val$newInfo = policyInfo;
                this.val$urlname = string2;
            }

            @Override
            public Boolean run() {
                String policy_uri;
                String extra_policy;
                boolean loaded_policy = false;
                if (PolicyFile.this.allowSystemProperties && (extra_policy = System.getProperty(this.val$propname)) != null) {
                    boolean overrideAll;
                    block13: {
                        overrideAll = false;
                        if (extra_policy.startsWith("=")) {
                            overrideAll = true;
                            extra_policy = extra_policy.substring(1);
                        }
                        try {
                            extra_policy = PropertyExpander.expand(extra_policy);
                            File policyFile = new File(extra_policy);
                            URL policyURL = policyFile.exists() ? ParseUtil.fileToEncodedURL(new File(policyFile.getCanonicalPath())) : PolicyFile.newURL((String)extra_policy);
                            if (debug != null) {
                                debug.println("reading " + policyURL);
                            }
                            if (PolicyFile.this.init(policyURL, this.val$newInfo)) {
                                loaded_policy = true;
                            }
                        }
                        catch (Exception e2) {
                            if (debug == null) break block13;
                            debug.println("caught exception: " + e2);
                        }
                    }
                    if (overrideAll) {
                        if (debug != null) {
                            debug.println("overriding other policies!");
                        }
                        return loaded_policy;
                    }
                }
                int n2 = 1;
                while ((policy_uri = Security.getProperty(this.val$urlname + n2)) != null) {
                    block14: {
                        try {
                            URL policy_url = null;
                            String expanded_uri = PropertyExpander.expand(policy_uri).replace(File.separatorChar, '/');
                            policy_url = policy_uri.startsWith("file:${java.home}/") || policy_uri.startsWith("file:${user.home}/") ? new File(expanded_uri.substring(5)).toURI().toURL() : new URI(expanded_uri).toURL();
                            if (debug != null) {
                                debug.println("reading " + policy_url);
                            }
                            if (PolicyFile.this.init(policy_url, this.val$newInfo)) {
                                loaded_policy = true;
                            }
                        }
                        catch (Exception e3) {
                            if (debug == null) break block14;
                            debug.println("Debug info only. Error reading policy " + e3);
                            e3.printStackTrace();
                        }
                    }
                    ++n2;
                }
                return loaded_policy;
            }
        });
    }

    private CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (PolicyParser.GrantEntry._jr$ig$signedBy((Object)grantEntry) != null && (certificateArray = this.getCertificates(keyStore, PolicyParser.GrantEntry._jr$ig$signedBy((Object)grantEntry), policyInfo)) == null) {
            if (debug != null) {
                debug.println("  -- No certs for alias '" + PolicyParser.GrantEntry._jr$ig$signedBy((Object)grantEntry) + "' - ignoring entry");
            }
            return null;
        }
        URL uRL = PolicyParser.GrantEntry._jr$ig$codeBase((Object)grantEntry) != null ? new URL(PolicyParser.GrantEntry._jr$ig$codeBase((Object)grantEntry)) : null;
        return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) {
        h h2;
        Object object;
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + PolicyParser.GrantEntry._jr$ig$signedBy((Object)grantEntry));
            debug.println("  codeBase " + PolicyParser.GrantEntry._jr$ig$codeBase((Object)grantEntry));
            if (PolicyParser.GrantEntry._jr$ig$principals((Object)grantEntry) != null && PolicyParser.GrantEntry._jr$ig$principals((Object)grantEntry).size() > 0) {
                object = PolicyParser.GrantEntry._jr$ig$principals((Object)grantEntry).listIterator();
                while (object.hasNext()) {
                    h2 = (PolicyParser.PrincipalEntry)((Object)g.convertForCast(object.next(), PolicyParser.PrincipalEntry.class));
                    debug.println("  " + h2.toString());
                }
            }
        }
        try {
            object = this.getCodeSource(grantEntry, keyStore, policyInfo);
            if (object == null) {
                return;
            }
            if (!this.replacePrincipals(PolicyParser.GrantEntry._jr$ig$principals((Object)grantEntry), keyStore)) {
                return;
            }
            h2 = new PolicyEntry((CodeSource)object, PolicyParser.GrantEntry._jr$ig$principals((Object)grantEntry));
            Enumeration<PolicyParser.PermissionEntry> enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                Object object2;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)((Object)g.convertForCast((Object)((Object)enumeration.nextElement()), PolicyParser.PermissionEntry.class));
                try {
                    Permission permission;
                    this.expandPermissionName(permissionEntry, keyStore);
                    if (PolicyParser.PermissionEntry._jr$ig$permission((Object)permissionEntry).equals("javax.security.auth.PrivateCredentialPermission") && PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).endsWith(" self")) {
                        PolicyParser.PermissionEntry._jr$ip$name((Object)permissionEntry, PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).substring(0, PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).indexOf("self")) + SELF);
                    }
                    if (PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry) != null && PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).indexOf(SELF) != -1) {
                        object2 = PolicyParser.PermissionEntry._jr$ig$signedBy((Object)permissionEntry) != null ? this.getCertificates(keyStore, PolicyParser.PermissionEntry._jr$ig$signedBy((Object)permissionEntry), policyInfo) : null;
                        permission = new SelfPermission(PolicyParser.PermissionEntry._jr$ig$permission((Object)permissionEntry), PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry), PolicyParser.PermissionEntry._jr$ig$action((Object)permissionEntry), (Certificate[])object2);
                    } else {
                        permission = PolicyFile.getInstance(PolicyParser.PermissionEntry._jr$ig$permission((Object)permissionEntry), PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry), PolicyParser.PermissionEntry._jr$ig$action((Object)permissionEntry));
                    }
                    h2.add(permission);
                    if (debug == null) continue;
                    debug.println("  " + permission);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object2 = PolicyParser.PermissionEntry._jr$ig$signedBy((Object)permissionEntry) != null ? this.getCertificates(keyStore, PolicyParser.PermissionEntry._jr$ig$signedBy((Object)permissionEntry), policyInfo) : null;
                    if (object2 == null && PolicyParser.PermissionEntry._jr$ig$signedBy((Object)permissionEntry) != null) continue;
                    objectArray = new UnresolvedPermission(PolicyParser.PermissionEntry._jr$ig$permission((Object)permissionEntry), PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry), PolicyParser.PermissionEntry._jr$ig$action((Object)permissionEntry), (Certificate[])object2);
                    h2.add((Permission)objectArray);
                    if (debug == null) continue;
                    debug.println("  " + objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object2 = new MessageFormat(ResourcesMgr.getString("java.security.policy.error.adding.Permission.perm.message"));
                    a.arrayStore((Object[])new Object[2], (int)0, (Object)PolicyParser.PermissionEntry._jr$ig$permission((Object)permissionEntry));
                    a.arrayStore((Object[])objectArray, (int)1, (Object)invocationTargetException.getTargetException().toString());
                    System.err.println(object2.format(objectArray));
                }
                catch (Exception exception) {
                    object2 = new MessageFormat(ResourcesMgr.getString("java.security.policy.error.adding.Permission.perm.message"));
                    a.arrayStore((Object[])new Object[2], (int)0, (Object)PolicyParser.PermissionEntry._jr$ig$permission((Object)permissionEntry));
                    a.arrayStore((Object[])objectArray, (int)1, (Object)exception.toString());
                    System.err.println(object2.format(objectArray));
                }
            }
            ((PolicyInfo)((Object)((Object)policyInfo))).policyEntries.add(h2);
        }
        catch (Exception exception) {
            h2 = new MessageFormat(ResourcesMgr.getString("java.security.policy.error.adding.Entry.message"));
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)exception.toString());
            Object[] objectArray2 = objectArray;
            System.err.println(h2.format(objectArray2));
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        Permission permission = PolicyFile.getKnownInstance(clazz, string2, string3);
        if (permission != null) {
            return permission;
        }
        if (string2 == null && string3 == null) {
            try {
                aj aj2 = ai.convertArgs(clazz, (Class[])PARAMS0);
                Constructor constructor = aj2.clazz.getConstructor(aj2.args);
                return (Permission)g.convertForCast(constructor.newInstance(new Object[0]), Permission.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    aj aj3 = ai.convertArgs(clazz, (Class[])PARAMS1);
                    Constructor constructor = aj3.clazz.getConstructor(aj3.args);
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
                    return (Permission)g.convertForCast(constructor.newInstance(objectArray), Permission.class);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    aj aj4 = ai.convertArgs(clazz, (Class[])PARAMS2);
                    Constructor constructor = aj4.clazz.getConstructor(aj4.args);
                    Object[] objectArray = new Object[2];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
                    a.arrayStore((Object[])objectArray, (int)1, (Object)string3);
                    return (Permission)g.convertForCast(constructor.newInstance(objectArray), Permission.class);
                }
            }
        }
        if (string2 != null && string3 == null) {
            try {
                aj aj5 = ai.convertArgs(clazz, (Class[])PARAMS1);
                Constructor constructor = aj5.clazz.getConstructor(aj5.args);
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
                return (Permission)g.convertForCast(constructor.newInstance(objectArray), Permission.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                aj aj6 = ai.convertArgs(clazz, (Class[])PARAMS2);
                Constructor constructor = aj6.clazz.getConstructor(aj6.args);
                Object[] objectArray = new Object[2];
                a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
                a.arrayStore((Object[])objectArray, (int)1, (Object)string3);
                return (Permission)g.convertForCast(constructor.newInstance(objectArray), Permission.class);
            }
        }
        aj aj7 = ai.convertArgs(clazz, (Class[])PARAMS2);
        Constructor constructor = aj7.clazz.getConstructor(aj7.args);
        Object[] objectArray = new Object[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
        a.arrayStore((Object[])objectArray, (int)1, (Object)string3);
        return (Permission)g.convertForCast(constructor.newInstance(objectArray), Permission.class);
    }

    private static final Permission getKnownInstance(Class clazz, String string, String string2) {
        if (((Object)clazz).equals(FilePermission.class)) {
            return new FilePermission(string, string2);
        }
        if (((Object)clazz).equals(SocketPermission.class)) {
            return new SocketPermission(string, string2);
        }
        if (((Object)clazz).equals(RuntimePermission.class)) {
            return new RuntimePermission(string, string2);
        }
        if (((Object)clazz).equals(PropertyPermission.class)) {
            return new PropertyPermission(string, string2);
        }
        if (((Object)clazz).equals(NetPermission.class)) {
            return new NetPermission(string, string2);
        }
        if (((Object)clazz).equals(AllPermission.class)) {
            return SecurityConstants.ALL_PERMISSION;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate[] getCertificates(KeyStore keyStore, String string, PolicyInfo policyInfo) {
        Certificate[] certificateArray;
        ArrayList<Certificate> arrayList = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            certificateArray = stringTokenizer.nextToken().trim();
            ++n2;
            Certificate certificate = null;
            Object object = ah.getMonitor((Object)((PolicyInfo)((Object)((Object)policyInfo))).aliasMapping);
            synchronized (object) {
                try {
                    certificate = (Certificate)g.convertForCast(((PolicyInfo)((Object)((Object)policyInfo))).aliasMapping.get(certificateArray), Certificate.class);
                    if (certificate == null && keyStore != null) {
                        try {
                            certificate = keyStore.getCertificate((String)certificateArray);
                        }
                        catch (KeyStoreException keyStoreException) {
                            // empty catch block
                        }
                        if (certificate != null) {
                            ((PolicyInfo)((Object)((Object)policyInfo))).aliasMapping.put(certificateArray, certificate);
                            ((PolicyInfo)((Object)((Object)policyInfo))).aliasMapping.put(certificate, certificateArray);
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            if (certificate == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Certificate>();
            }
            arrayList.add(certificate);
        }
        if (arrayList != null && n2 == arrayList.size()) {
            certificateArray = new Certificate[arrayList.size()];
            arrayList.toArray(certificateArray);
            return certificateArray;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.init(this.url);
    }

    @Override
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PolicyInfo policyInfo = (PolicyInfo)((Object)g.convertForCast(this.policyInfo.get(), PolicyInfo.class));
        JavaSecurityProtectionDomainAccess.ProtectionDomainCache protectionDomainCache = policyInfo.getPdMapping();
        PermissionCollection permissionCollection = protectionDomainCache.get(protectionDomain);
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        protectionDomainCache.put(protectionDomain, permissionCollection);
        return permissionCollection.implies(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        Permissions permissions = new Permissions();
        if (protectionDomain == null) {
            return permissions;
        }
        this.getPermissions(permissions, protectionDomain);
        PermissionCollection permissionCollection = protectionDomain.getPermissions();
        if (permissionCollection != null) {
            Object object = ah.getMonitor((Object)permissionCollection);
            synchronized (object) {
                try {
                    Enumeration<Permission> enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        permissions.add((Permission)g.convertForCast((Object)enumeration.nextElement(), Permission.class));
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        return permissions;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.getPermissions(new Permissions(), codeSource);
    }

    private PermissionCollection getPermissions(Permissions permissions, ProtectionDomain protectionDomain) {
        CodeSource codeSource;
        if (debug != null) {
            debug.println("getPermissions:\n\t" + this.printPD(protectionDomain));
        }
        if ((codeSource = protectionDomain.getCodeSource()) == null) {
            return permissions;
        }
        CodeSource codeSource2 = (CodeSource)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedAction<Object>(this, codeSource){

            @Override
            public Void run() {
                PolicyEntry pe = new PolicyEntry(new CodeSource(null, (Certificate[])null));
                pe.add(SecurityConstants.LOCAL_LISTEN_PERMISSION);
                pe.add(new PropertyPermission("java.version", "read"));
                pe.add(new PropertyPermission("java.vendor", "read"));
                pe.add(new PropertyPermission("java.vendor.url", "read"));
                pe.add(new PropertyPermission("java.class.version", "read"));
                pe.add(new PropertyPermission("os.name", "read"));
                pe.add(new PropertyPermission("os.version", "read"));
                pe.add(new PropertyPermission("os.arch", "read"));
                pe.add(new PropertyPermission("file.separator", "read"));
                pe.add(new PropertyPermission("path.separator", "read"));
                pe.add(new PropertyPermission("line.separator", "read"));
                pe.add(new PropertyPermission("java.specification.version", "read"));
                pe.add(new PropertyPermission("java.specification.maintenance.version", "read"));
                pe.add(new PropertyPermission("java.specification.vendor", "read"));
                pe.add(new PropertyPermission("java.specification.name", "read"));
                pe.add(new PropertyPermission("java.vm.specification.version", "read"));
                pe.add(new PropertyPermission("java.vm.specification.vendor", "read"));
                pe.add(new PropertyPermission("java.vm.specification.name", "read"));
                pe.add(new PropertyPermission("java.vm.version", "read"));
                pe.add(new PropertyPermission("java.vm.vendor", "read"));
                pe.add(new PropertyPermission("java.vm.name", "read"));
                codeSource.policyEntries.add(pe);
                return null;
            }
        }), CodeSource.class);
        return this.getPermissions(permissions, codeSource2, protectionDomain.getPrincipals());
    }

    private PermissionCollection getPermissions(Permissions permissions, final CodeSource codeSource) {
        CodeSource codeSource2 = (CodeSource)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedAction<CodeSource>(){

            @Override
            public CodeSource run() {
                return PolicyFile.this.canonicalizeCodebase(codeSource, true);
            }
        }), CodeSource.class);
        return this.getPermissions(permissions, codeSource2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Permissions getPermissions(Permissions permissions, CodeSource codeSource, Principal[] principalArray) {
        PolicyEntry policyEntry;
        Object object;
        PolicyInfo policyInfo = (PolicyInfo)((Object)g.convertForCast(this.policyInfo.get(), PolicyInfo.class));
        Object[] objectArray = ((PolicyInfo)((Object)((Object)policyInfo))).policyEntries.iterator();
        while (objectArray.hasNext()) {
            object = (PolicyEntry)((Object)g.convertForCast(objectArray.next(), PolicyEntry.class));
            this.addPermissions(permissions, codeSource, principalArray, (PolicyEntry)((Object)object));
        }
        objectArray = ah.getMonitor((Object)((PolicyInfo)((Object)((Object)policyInfo))).identityPolicyEntries);
        synchronized (objectArray) {
            try {
                object = ((PolicyInfo)((Object)((Object)policyInfo))).identityPolicyEntries.iterator();
                while (object.hasNext()) {
                    policyEntry = (PolicyEntry)((Object)g.convertForCast(object.next(), PolicyEntry.class));
                    this.addPermissions(permissions, codeSource, principalArray, policyEntry);
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        if (!this.ignoreIdentityScope && (objectArray = codeSource.getCertificates()) != null) {
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                policyEntry = ((PolicyInfo)((Object)((Object)policyInfo))).aliasMapping.get((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Certificate.class));
                if (policyEntry != null || !this.checkForTrustedIdentity((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Certificate.class), policyInfo)) continue;
                permissions.add(SecurityConstants.ALL_PERMISSION);
            }
        }
        return permissions;
    }

    private void addPermissions(Permissions permissions, CodeSource codeSource, Principal[] principalArray, PolicyEntry policyEntry) {
        Boolean bl;
        if (debug != null) {
            debug.println("evaluate codesources:\n\tPolicy CodeSource: " + policyEntry.getCodeSource() + "\n" + "\tActive CodeSource: " + codeSource);
        }
        if (!(bl = (Boolean)((Object)AccessController.doPrivileged(new PrivilegedAction<CodeSource>(this, policyEntry, codeSource){
            final /* synthetic */ CodeSource val$cs;
            {
                this.val$cs = codeSource;
            }

            @Override
            public CodeSource run() {
                return PolicyFile.this.canonicalizeCodebase(this.val$cs, true);
            }
        }))).booleanValue()) {
            if (debug != null) {
                debug.println("evaluation (codesource) failed");
            }
            return;
        }
        List<PolicyParser.PrincipalEntry> list = policyEntry.getPrincipals();
        if (debug != null) {
            ArrayList<PolicyParser.PrincipalEntry> arrayList = new ArrayList<PolicyParser.PrincipalEntry>();
            if (principalArray != null) {
                for (int i = 0; i < a.arrayLength((Object[])principalArray); ++i) {
                    arrayList.add(new PolicyParser.PrincipalEntry(x.getName(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getClass()), ((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getName()));
                }
            }
            debug.println("evaluate principals:\n\tPolicy Principals: " + list + "\n" + "\tActive Principals: " + arrayList);
        }
        if (list == null || list.size() == 0) {
            this.addPerms(permissions, principalArray, policyEntry);
            if (debug != null) {
                debug.println("evaluation (codesource/principals) passed");
            }
            return;
        }
        if (principalArray == null || a.arrayLength((Object[])principalArray) == 0) {
            if (debug != null) {
                debug.println("evaluation (principals) failed");
            }
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)((Object)g.convertForCast((Object)((Object)list.get(i)), PolicyParser.PrincipalEntry.class));
            try {
                Class<?> clazz = Class.forName(PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry), true, Thread.currentThread().getContextClassLoader());
                if (!x.isAssignableFrom(PrincipalComparator.class, clazz)) {
                    if (this.checkEntryPs(principalArray, principalEntry)) continue;
                    if (debug != null) {
                        debug.println("evaluation (principals) failed");
                    }
                    return;
                }
                aj aj2 = ai.convertArgs(clazz, (Class[])PARAMS1);
                Constructor constructor = aj2.clazz.getConstructor(aj2.args);
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry));
                PrincipalComparator principalComparator = (PrincipalComparator)g.convertForCast(constructor.newInstance(objectArray), PrincipalComparator.class);
                if (debug != null) {
                    debug.println("found PrincipalComparator " + x.getName(principalComparator.getClass()));
                }
                HashSet<Principal> hashSet = new HashSet<Principal>(a.arrayLength((Object[])principalArray));
                for (int k = 0; k < a.arrayLength((Object[])principalArray); ++k) {
                    hashSet.add((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)k), Principal.class));
                }
                Subject subject = new Subject(true, hashSet, Collections.EMPTY_SET, Collections.EMPTY_SET);
                if (principalComparator.implies(subject)) continue;
                if (debug != null) {
                    debug.println("evaluation (principal comparator) failed");
                }
                return;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                if (this.checkEntryPs(principalArray, principalEntry)) continue;
                if (debug != null) {
                    debug.println("evaluation (principals) failed");
                }
                return;
            }
        }
        if (debug != null) {
            debug.println("evaluation (codesource/principals) passed");
        }
        this.addPerms(permissions, principalArray, policyEntry);
    }

    private void addPerms(Permissions permissions, Principal[] principalArray, PolicyEntry policyEntry) {
        for (int i = 0; i < ((PolicyEntry)((Object)((Object)policyEntry))).permissions.size(); ++i) {
            Permission permission = (Permission)g.convertForCast(((PolicyEntry)((Object)((Object)policyEntry))).permissions.get(i), Permission.class);
            if (debug != null) {
                debug.println("  granting " + permission);
            }
            if (g.convertForInstanceOf((Object)permission, SelfPermission.class) instanceof SelfPermission) {
                this.expandSelf((SelfPermission)g.convertForCast((Object)permission, SelfPermission.class), policyEntry.getPrincipals(), principalArray, permissions);
                continue;
            }
            permissions.add(permission);
        }
    }

    private boolean checkEntryPs(Principal[] principalArray, PolicyParser.PrincipalEntry principalEntry) {
        for (int i = 0; i < a.arrayLength((Object[])principalArray); ++i) {
            if (!PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry).equals("WILDCARD_PRINCIPAL_CLASS") && !PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry).equals(x.getName(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getClass())) || !PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry).equals("WILDCARD_PRINCIPAL_NAME") && !PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry).equals(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandSelf(SelfPermission selfPermission, List<PolicyParser.PrincipalEntry> list, Principal[] principalArray, Permissions permissions) {
        block21: {
            Object object;
            h h2;
            int n2;
            if (list == null || list.size() == 0) {
                if (debug != null) {
                    debug.println("Ignoring permission " + selfPermission.getSelfType() + " with target name (" + selfPermission.getSelfName() + ").  " + "No Principal(s) specified " + "in the grant clause.  " + "SELF-based target names are " + "only valid in the context " + "of a Principal-based grant entry.");
                }
                return;
            }
            int n3 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = selfPermission.getSelfName().indexOf(SELF, n3)) != -1) {
                stringBuilder.append(selfPermission.getSelfName().substring(n3, n2));
                ListIterator<PolicyParser.PrincipalEntry> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    h2 = (PolicyParser.PrincipalEntry)((Object)g.convertForCast((Object)((Object)listIterator.next()), PolicyParser.PrincipalEntry.class));
                    object = this.getPrincipalInfo((PolicyParser.PrincipalEntry)h2, principalArray);
                    for (int i = 0; i < ((String[][])object).length; ++i) {
                        if (i != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(object[i][0] + " " + "\"" + object[i][1] + "\"");
                    }
                    if (!listIterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                n3 = n2 + SELF.length();
            }
            stringBuilder.append(selfPermission.getSelfName().substring(n3));
            if (debug != null) {
                debug.println("  expanded:\n\t" + selfPermission.getSelfName() + "\n  into:\n\t" + stringBuilder.toString());
            }
            try {
                permissions.add(PolicyFile.getInstance(selfPermission.getSelfType(), stringBuilder.toString(), selfPermission.getSelfActions()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                h2 = null;
                object = ah.getMonitor((Object)permissions);
                synchronized (object) {
                    try {
                        Enumeration<Permission> enumeration = permissions.elements();
                        while (enumeration.hasMoreElements()) {
                            Permission permission = (Permission)g.convertForCast((Object)enumeration.nextElement(), Permission.class);
                            if (!x.getName(permission.getClass()).equals(selfPermission.getSelfType())) continue;
                            h2 = permission.getClass();
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
                if (h2 == null) {
                    permissions.add(new UnresolvedPermission(selfPermission.getSelfType(), stringBuilder.toString(), selfPermission.getSelfActions(), selfPermission.getCerts()));
                }
                try {
                    if (selfPermission.getSelfActions() == null) {
                        try {
                            aj aj2 = ai.convertArgs((Class)h2, (Class[])PARAMS1);
                            object = aj2.clazz.getConstructor(aj2.args);
                            Object[] objectArray = new Object[1];
                            a.arrayStore((Object[])objectArray, (int)0, (Object)stringBuilder.toString());
                            permissions.add((Permission)g.convertForCast(((Constructor)object).newInstance(objectArray), Permission.class));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            aj aj3 = ai.convertArgs((Class)h2, (Class[])PARAMS2);
                            object = aj3.clazz.getConstructor(aj3.args);
                            Object[] objectArray = new Object[2];
                            a.arrayStore((Object[])objectArray, (int)0, (Object)stringBuilder.toString());
                            a.arrayStore((Object[])objectArray, (int)1, (Object)selfPermission.getSelfActions());
                            permissions.add((Permission)g.convertForCast(((Constructor)object).newInstance(objectArray), Permission.class));
                        }
                    }
                    aj aj4 = ai.convertArgs((Class)h2, (Class[])PARAMS2);
                    object = aj4.clazz.getConstructor(aj4.args);
                    Object[] objectArray = new Object[2];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)stringBuilder.toString());
                    a.arrayStore((Object[])objectArray, (int)1, (Object)selfPermission.getSelfActions());
                    permissions.add((Permission)g.convertForCast(((Constructor)object).newInstance(objectArray), Permission.class));
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("self entry expansion  instantiation failed: " + exception.toString());
                    }
                }
            }
            catch (Exception exception) {
                if (debug == null) break block21;
                debug.println(exception.toString());
            }
        }
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principalEntry, Principal[] principalArray) {
        if (!PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry).equals("WILDCARD_PRINCIPAL_CLASS") && !PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry).equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry);
            stringArray[0][1] = PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry);
            return stringArray;
        }
        if (!PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry).equals("WILDCARD_PRINCIPAL_CLASS") && PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry).equals("WILDCARD_PRINCIPAL_NAME")) {
            ArrayList<Principal> arrayList = new ArrayList<Principal>();
            for (int i = 0; i < a.arrayLength((Object[])principalArray); ++i) {
                if (!PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry).equals(x.getName(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getClass()))) continue;
                arrayList.add((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class));
            }
            String[][] stringArray = new String[arrayList.size()][2];
            int n2 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)g.convertForCast(iterator.next(), Principal.class);
                stringArray[n2][0] = x.getName(principal.getClass());
                stringArray[n2][1] = principal.getName();
                ++n2;
            }
            return stringArray;
        }
        String[][] stringArray = new String[a.arrayLength((Object[])principalArray)][2];
        for (int i = 0; i < a.arrayLength((Object[])principalArray); ++i) {
            stringArray[i][0] = x.getName(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getClass());
            stringArray[i][1] = ((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class)).getName();
        }
        return stringArray;
    }

    protected Certificate[] getSignerCertificates(CodeSource codeSource) {
        int n2;
        Object[] objectArray = null;
        objectArray = codeSource.getCertificates();
        if (objectArray == null) {
            return null;
        }
        for (n2 = 0; n2 < a.arrayLength((Object[])objectArray); ++n2) {
            if (g.convertForInstanceOf((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Certificate.class)), X509Certificate.class) instanceof X509Certificate) continue;
            return codeSource.getCertificates();
        }
        int n3 = 0;
        for (n2 = 0; n2 < a.arrayLength((Object[])objectArray); ++n2) {
            ++n3;
            while (n2 + 1 < a.arrayLength((Object[])objectArray) && ((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Certificate.class)), X509Certificate.class)).getIssuerDN().equals(((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n2 + 1)), Certificate.class)), X509Certificate.class)).getSubjectDN())) {
                ++n2;
            }
        }
        if (n3 == a.arrayLength((Object[])objectArray)) {
            return objectArray;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (n2 = 0; n2 < a.arrayLength((Object[])objectArray); ++n2) {
            arrayList.add((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Certificate.class));
            while (n2 + 1 < a.arrayLength((Object[])objectArray) && ((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)n2), Certificate.class)), X509Certificate.class)).getIssuerDN().equals(((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(n2 + 1)), Certificate.class)), X509Certificate.class)).getSubjectDN())) {
                ++n2;
            }
        }
        Certificate[] certificateArray = new Certificate[arrayList.size()];
        arrayList.toArray(certificateArray);
        return certificateArray;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl) {
        CodeSource codeSource2;
        block12: {
            Object object;
            String string = null;
            codeSource2 = codeSource;
            URL uRL = codeSource.getLocation();
            if (uRL != null) {
                int n2;
                if (uRL.getProtocol().equals("jar") && (n2 = ((String)(object = uRL.getFile())).indexOf("!/")) != -1) {
                    try {
                        uRL = new URL(((String)object).substring(0, n2));
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (uRL.getProtocol().equals("file")) {
                    boolean bl2 = false;
                    String string2 = uRL.getHost();
                    boolean bl3 = bl2 = string2 == null || string2.equals("") || string2.equals("~") || string2.equalsIgnoreCase("localhost");
                    if (bl2) {
                        string = uRL.getFile().replace('/', File.separatorChar);
                        string = ParseUtil.decode(string);
                    }
                }
            }
            if (string != null) {
                try {
                    object = null;
                    string = PolicyFile.canonPath(string);
                    object = ParseUtil.fileToEncodedURL(new File(string));
                    if (bl) {
                        codeSource2 = new CodeSource((URL)object, this.getSignerCertificates(codeSource));
                        break block12;
                    }
                    codeSource2 = new CodeSource((URL)object, codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (bl) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                    }
                    break block12;
                }
            }
            if (bl) {
                codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
            }
        }
        return codeSource2;
    }

    private static String canonPath(String string) throws IOException {
        if (string.endsWith("*")) {
            string = string.substring(0, string.length() - 1) + "-";
            string = new File(string).getCanonicalPath();
            return string.substring(0, string.length() - 1) + "*";
        }
        return new File(string).getCanonicalPath();
    }

    private String printPD(ProtectionDomain protectionDomain) {
        Object[] objectArray = protectionDomain.getPrincipals();
        String string = "<no principals>";
        if (objectArray != null && a.arrayLength((Object[])objectArray) > 0) {
            StringBuilder stringBuilder = new StringBuilder("(principals ");
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                stringBuilder.append(x.getName(((Principal)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Principal.class)).getClass()) + " \"" + ((Principal)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Principal.class)).getName() + "\"");
                if (i < a.arrayLength((Object[])objectArray) - 1) {
                    stringBuilder.append(", ");
                    continue;
                }
                stringBuilder.append(")");
            }
            string = stringBuilder.toString();
        }
        return "PD CodeSource: " + protectionDomain.getCodeSource() + "\n\t" + "PD ClassLoader: " + (Object)((Object)protectionDomain.getClassLoader()) + "\n\t" + "PD Principals: " + string;
    }

    private boolean replacePrincipals(List<PolicyParser.PrincipalEntry> list, KeyStore keyStore) {
        if (list == null || list.size() == 0 || keyStore == null) {
            return true;
        }
        ListIterator<PolicyParser.PrincipalEntry> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)((Object)g.convertForCast((Object)((Object)listIterator.next()), PolicyParser.PrincipalEntry.class));
            if (!PolicyParser.PrincipalEntry._jr$ig$principalClass((Object)principalEntry).equals("PolicyParser.REPLACE_NAME")) continue;
            String string = this.getDN(PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry), keyStore);
            if (string == null) {
                return false;
            }
            if (debug != null) {
                debug.println("  Replacing \"" + PolicyParser.PrincipalEntry._jr$ig$principalName((Object)principalEntry) + "\" with " + X500PRINCIPAL + "/\"" + string + "\"");
            }
            PolicyParser.PrincipalEntry._jr$ip$principalClass((Object)principalEntry, X500PRINCIPAL);
            PolicyParser.PrincipalEntry._jr$ip$principalName((Object)principalEntry, string);
        }
        return true;
    }

    private void expandPermissionName(PolicyParser.PermissionEntry permissionEntry, KeyStore keyStore) throws Exception {
        int n2;
        int n3;
        if (PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry) == null || PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).indexOf("${{", 0) == -1) {
            return;
        }
        int n4 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n3 = PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).indexOf("${{", n4)) != -1 && (n2 = PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).indexOf("}}", n3)) >= 1) {
            String string;
            stringBuilder.append(PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).substring(n4, n3));
            String string2 = string = PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).substring(n3 + 3, n2);
            int n5 = string.indexOf(":");
            if (n5 != -1) {
                string2 = string.substring(0, n5);
            }
            if (string2.equalsIgnoreCase("self")) {
                stringBuilder.append(PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).substring(n3, n2 + 2));
                n4 = n2 + 2;
                continue;
            }
            if (string2.equalsIgnoreCase("alias")) {
                if (n5 == -1) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("alias.name.not.provided.pe.name."));
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry));
                    Object[] objectArray2 = objectArray;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Exception(messageFormat.format(objectArray2)));
                }
                String string3 = string.substring(n5 + 1);
                if ((string3 = this.getDN(string3, keyStore)) == null) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("unable.to.perform.substitution.on.alias.suffix"));
                    Object[] objectArray = new Object[1];
                    a.arrayStore((Object[])objectArray, (int)0, (Object)string.substring(n5 + 1));
                    Object[] objectArray3 = objectArray;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Exception(messageFormat.format(objectArray3)));
                }
                stringBuilder.append("javax.security.auth.x500.X500Principal \"" + string3 + "\"");
                n4 = n2 + 2;
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("substitution.value.prefix.unsupported"));
            Object[] objectArray = new Object[1];
            a.arrayStore((Object[])objectArray, (int)0, (Object)string2);
            Object[] objectArray4 = objectArray;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new Exception(messageFormat.format(objectArray4)));
        }
        stringBuilder.append(PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry).substring(n4));
        if (debug != null) {
            debug.println("  Permission name expanded from:\n\t" + PolicyParser.PermissionEntry._jr$ig$name((Object)permissionEntry) + "\nto\n\t" + stringBuilder.toString());
        }
        PolicyParser.PermissionEntry._jr$ip$name((Object)permissionEntry, stringBuilder.toString());
    }

    private String getDN(String string, KeyStore keyStore) {
        Certificate certificate = null;
        try {
            certificate = keyStore.getCertificate(string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("  Error retrieving certificate for '" + string + "': " + exception.toString());
            }
            return null;
        }
        if (certificate == null || !(g.convertForInstanceOf((Object)certificate, X509Certificate.class) instanceof X509Certificate)) {
            if (debug != null) {
                debug.println("  -- No certificate for '" + string + "' - ignoring entry");
            }
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)g.convertForCast((Object)certificate, X509Certificate.class);
        X500Principal x500Principal = new X500Principal(x509Certificate.getSubjectX500Principal().toString());
        return x500Principal.getName();
    }

    private boolean checkForTrustedIdentity(Certificate certificate, PolicyInfo policyInfo) {
        return false;
    }

    static /* synthetic */ boolean access$002(PolicyFile policyFile, boolean bl) {
        boolean bl2 = bl;
        policyFile.expandProperties = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$102(PolicyFile policyFile, boolean bl) {
        boolean bl2 = bl;
        policyFile.ignoreIdentityScope = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$202(PolicyFile policyFile, boolean bl) {
        boolean bl2 = bl;
        policyFile.allowSystemProperties = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$302(PolicyFile policyFile, boolean bl) {
        boolean bl2 = bl;
        policyFile.notUtf8 = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$200(PolicyFile policyFile) {
        return policyFile.allowSystemProperties;
    }

    static /* synthetic */ Debug access$600() {
        return debug;
    }

    static /* synthetic */ CodeSource access$700(PolicyFile policyFile, CodeSource codeSource, boolean bl) {
        return policyFile.canonicalizeCodebase(codeSource, bl);
    }

    private static /* synthetic */ void _jr$ip$policyInfo(PolicyFile policyFile, AtomicReference atomicReference) {
        policyFile.policyInfo = atomicReference;
    }

    private static /* synthetic */ boolean _jr$ig$constructed(PolicyFile policyFile) {
        return policyFile.constructed;
    }

    private static /* synthetic */ void _jr$ip$constructed(PolicyFile policyFile, boolean bl) {
        policyFile.constructed = bl;
    }

    private static /* synthetic */ void _jr$ip$url(PolicyFile policyFile, URL uRL) {
        policyFile.url = uRL;
    }

    protected /* synthetic */ PolicyFile(h h2) {
        super(h2);
    }

    private static class PolicyEntry
    extends h {
        private final CodeSource codesource;
        final List<Permission> permissions;
        private final List<PolicyParser.PrincipalEntry> principals;

        PolicyEntry(CodeSource codeSource, List<PolicyParser.PrincipalEntry> list) {
            this.codesource = codeSource;
            this.permissions = new ArrayList<Permission>();
            this.principals = list;
        }

        PolicyEntry(CodeSource codeSource) {
            this(codeSource, null);
        }

        List<PolicyParser.PrincipalEntry> getPrincipals() {
            return this.principals;
        }

        void add(Permission permission) {
            ((PolicyEntry)((Object)((Object)this))).permissions.add(permission);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ResourcesMgr.getString("LPARAM"));
            stringBuilder.append(this.getCodeSource());
            stringBuilder.append("\n");
            for (int i = 0; i < ((PolicyEntry)((Object)((Object)this))).permissions.size(); ++i) {
                Permission permission = (Permission)g.convertForCast(((PolicyEntry)((Object)((Object)this))).permissions.get(i), Permission.class);
                stringBuilder.append(ResourcesMgr.getString("SPACE"));
                stringBuilder.append(ResourcesMgr.getString("SPACE"));
                stringBuilder.append(permission);
                stringBuilder.append(ResourcesMgr.getString("NEWLINE"));
            }
            stringBuilder.append(ResourcesMgr.getString("RPARAM"));
            stringBuilder.append(ResourcesMgr.getString("NEWLINE"));
            return stringBuilder.toString();
        }

        private static /* synthetic */ void _jr$ip$codesource(PolicyEntry policyEntry, CodeSource codeSource) {
            policyEntry.codesource = codeSource;
        }

        static /* synthetic */ void _jr$ip$permissions(Object object, List list) {
            ((PolicyEntry)((Object)object)).permissions = list;
        }

        private static /* synthetic */ void _jr$ip$principals(PolicyEntry policyEntry, List list) {
            policyEntry.principals = list;
        }

        protected /* synthetic */ PolicyEntry(h h2) {
            super(h2);
        }
    }

    private static class PolicyInfo
    extends h {
        private static final boolean verbose = false;
        final List<PolicyEntry> policyEntries;
        final List<PolicyEntry> identityPolicyEntries;
        final Map aliasMapping;
        private final JavaSecurityProtectionDomainAccess.ProtectionDomainCache[] pdMapping;
        private Random random;

        PolicyInfo(int n2) {
            this.policyEntries = new ArrayList<PolicyEntry>();
            this.identityPolicyEntries = Collections.synchronizedList(new ArrayList(2));
            this.aliasMapping = Collections.synchronizedMap(new HashMap(11));
            this.pdMapping = new JavaSecurityProtectionDomainAccess.ProtectionDomainCache[n2];
            JavaSecurityProtectionDomainAccess javaSecurityProtectionDomainAccess = SharedSecrets.getJavaSecurityProtectionDomainAccess();
            for (int i = 0; i < n2; ++i) {
                a.arrayStore((Object[])this.pdMapping, (int)i, (Object)javaSecurityProtectionDomainAccess.getProtectionDomainCache());
            }
            if (n2 > 1) {
                this.random = new Random();
            }
        }

        JavaSecurityProtectionDomainAccess.ProtectionDomainCache getPdMapping() {
            if (a.arrayLength((Object[])this.pdMapping) == 1) {
                return (JavaSecurityProtectionDomainAccess.ProtectionDomainCache)g.convertForCast((Object)a.arrayLoad((Object[])this.pdMapping, (int)0), JavaSecurityProtectionDomainAccess.ProtectionDomainCache.class);
            }
            int n2 = Math.abs(this.random.nextInt() % a.arrayLength((Object[])this.pdMapping));
            return (JavaSecurityProtectionDomainAccess.ProtectionDomainCache)g.convertForCast((Object)a.arrayLoad((Object[])this.pdMapping, (int)n2), JavaSecurityProtectionDomainAccess.ProtectionDomainCache.class);
        }

        static /* synthetic */ void _jr$ip$policyEntries(Object object, List list) {
            ((PolicyInfo)((Object)object)).policyEntries = list;
        }

        static /* synthetic */ void _jr$ip$identityPolicyEntries(Object object, List list) {
            ((PolicyInfo)((Object)object)).identityPolicyEntries = list;
        }

        static /* synthetic */ void _jr$ip$aliasMapping(Object object, Map map) {
            ((PolicyInfo)((Object)object)).aliasMapping = map;
        }

        private static /* synthetic */ void _jr$ip$pdMapping(PolicyInfo policyInfo, JavaSecurityProtectionDomainAccess.ProtectionDomainCache[] protectionDomainCacheArray) {
            policyInfo.pdMapping = protectionDomainCacheArray;
        }

        private static /* synthetic */ void _jr$ip$random(PolicyInfo policyInfo, Random random) {
            policyInfo.random = random;
        }

        protected /* synthetic */ PolicyInfo(h h2) {
            super(h2);
        }
    }

    private static class SelfPermission
    extends Permission {
        private static final long serialVersionUID = -8315562579967246806L;
        private String type;
        private String name;
        private String actions;
        private Certificate[] certs;

        public SelfPermission(String string, String string2, String string3, Certificate[] certificateArray) {
            super(string);
            if (string == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException(ResourcesMgr.getString("type.can.t.be.null")));
            }
            this.type = string;
            this.name = string2;
            this.actions = string3;
            if (certificateArray != null) {
                int n2;
                for (n2 = 0; n2 < a.arrayLength((Object[])certificateArray); ++n2) {
                    if (g.convertForInstanceOf((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n2), Certificate.class)), X509Certificate.class) instanceof X509Certificate) continue;
                    this.certs = (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
                    break;
                }
                if (this.certs == null) {
                    int n3 = 0;
                    for (n2 = 0; n2 < a.arrayLength((Object[])certificateArray); ++n2) {
                        ++n3;
                        while (n2 + 1 < a.arrayLength((Object[])certificateArray) && ((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n2), Certificate.class)), X509Certificate.class)).getIssuerDN().equals(((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)(n2 + 1)), Certificate.class)), X509Certificate.class)).getSubjectDN())) {
                            ++n2;
                        }
                    }
                    if (n3 == a.arrayLength((Object[])certificateArray)) {
                        this.certs = (Certificate[])g.convertForCast((Object)a.cloneArray((Object)certificateArray), Certificate[].class);
                    }
                    if (this.certs == null) {
                        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
                        for (n2 = 0; n2 < a.arrayLength((Object[])certificateArray); ++n2) {
                            arrayList.add((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n2), Certificate.class));
                            while (n2 + 1 < a.arrayLength((Object[])certificateArray) && ((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)n2), Certificate.class)), X509Certificate.class)).getIssuerDN().equals(((X509Certificate)g.convertForCast((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])certificateArray, (int)(n2 + 1)), Certificate.class)), X509Certificate.class)).getSubjectDN())) {
                                ++n2;
                            }
                        }
                        this.certs = new Certificate[arrayList.size()];
                        arrayList.toArray(this.certs);
                    }
                }
            }
        }

        @Override
        public boolean implies(Permission permission) {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            int n2;
            boolean bl;
            int n3;
            if (!f.ifAcmp((Object)object, (Object)this)) {
                return true;
            }
            if (!(g.convertForInstanceOf((Object)object, SelfPermission.class) instanceof SelfPermission)) {
                return false;
            }
            SelfPermission selfPermission = (SelfPermission)g.convertForCast((Object)object, SelfPermission.class);
            if (!(this.type.equals(selfPermission.type) && this.name.equals(selfPermission.name) && this.actions.equals(selfPermission.actions))) {
                return false;
            }
            if (a.arrayLength((Object[])this.certs) != a.arrayLength((Object[])selfPermission.certs)) {
                return false;
            }
            for (n3 = 0; n3 < a.arrayLength((Object[])this.certs); ++n3) {
                bl = false;
                for (n2 = 0; n2 < a.arrayLength((Object[])selfPermission.certs); ++n2) {
                    if (!((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certs, (int)n3), Certificate.class)).equals((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])selfPermission.certs, (int)n2), Certificate.class))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            for (n3 = 0; n3 < a.arrayLength((Object[])selfPermission.certs); ++n3) {
                bl = false;
                for (n2 = 0; n2 < a.arrayLength((Object[])this.certs); ++n2) {
                    if (!((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])selfPermission.certs, (int)n3), Certificate.class)).equals((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])this.certs, (int)n2), Certificate.class))) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int n2 = this.type.hashCode();
            if (this.name != null) {
                n2 ^= this.name.hashCode();
            }
            if (this.actions != null) {
                n2 ^= this.actions.hashCode();
            }
            return n2;
        }

        @Override
        public String getActions() {
            return "";
        }

        public String getSelfType() {
            return this.type;
        }

        public String getSelfName() {
            return this.name;
        }

        public String getSelfActions() {
            return this.actions;
        }

        public Certificate[] getCerts() {
            return this.certs;
        }

        @Override
        public String toString() {
            return "(SelfPermission " + this.type + " " + this.name + " " + this.actions + ")";
        }

        private static /* synthetic */ void _jr$ip$type(SelfPermission selfPermission, String string) {
            selfPermission.type = string;
        }

        private static /* synthetic */ void _jr$ip$name(SelfPermission selfPermission, String string) {
            selfPermission.name = string;
        }

        private static /* synthetic */ void _jr$ip$actions(SelfPermission selfPermission, String string) {
            selfPermission.actions = string;
        }

        private static /* synthetic */ void _jr$ip$certs(SelfPermission selfPermission, Certificate[] certificateArray) {
            selfPermission.certs = certificateArray;
        }

        protected /* synthetic */ SelfPermission(h h2) {
            super(h2);
        }
    }
}

