/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import sun.net.www.ParseUtil;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public class PolicyParser
extends h {
    public static final String REPLACE_NAME = "PolicyParser.REPLACE_NAME";
    private static final String EXTDIRS_PROPERTY = "java.ext.dirs";
    private static final String OLD_EXTDIRS_EXPANSION = "${java.ext.dirs}";
    static final String EXTDIRS_EXPANSION = "${{java.ext.dirs}}";
    private Vector<GrantEntry> grantEntries;
    private static final Debug debug = Debug.getInstance("parser", "\t[Policy Parser]");
    private StreamTokenizer st;
    private int lookahead;
    private boolean expandProp;
    private String keyStoreUrlString;
    private String keyStoreType;
    private String keyStoreProvider;
    private String storePassURL;

    private String expand(String string) throws PropertyExpander.ExpandException {
        return this.expand(string, false);
    }

    private String expand(String string, boolean bl) throws PropertyExpander.ExpandException {
        if (!this.expandProp) {
            return string;
        }
        return PropertyExpander.expand(string, bl);
    }

    public PolicyParser() {
        this.expandProp = false;
        this.keyStoreUrlString = null;
        this.keyStoreType = null;
        this.keyStoreProvider = null;
        this.storePassURL = null;
        this.grantEntries = new Vector();
    }

    public PolicyParser(boolean bl) {
        this();
        this.expandProp = bl;
    }

    public void read(Reader reader) throws ParsingException, IOException {
        if (!(g.convertForInstanceOf((Object)reader, BufferedReader.class) instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                GrantEntry grantEntry = this.parseGrantEntry();
                if (grantEntry != null) {
                    this.add(grantEntry);
                }
            } else if (this.peek("keystore") && this.keyStoreUrlString == null) {
                this.parseKeyStoreEntry();
            } else if (this.peek("keystorePasswordURL") && this.storePassURL == null) {
                this.parseStorePassURL();
            }
            this.match(";");
        }
        if (this.keyStoreUrlString == null && this.storePassURL != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(ResourcesMgr.getString("keystorePasswordURL.can.not.be.specified.without.also.specifying.keystore")));
        }
    }

    public void add(GrantEntry grantEntry) {
        this.grantEntries.addElement(grantEntry);
    }

    public void replace(GrantEntry grantEntry, GrantEntry grantEntry2) {
        this.grantEntries.setElementAt(grantEntry2, this.grantEntries.indexOf((Object)grantEntry));
    }

    public boolean remove(GrantEntry grantEntry) {
        return this.grantEntries.removeElement((Object)grantEntry);
    }

    public String getKeyStoreUrl() {
        try {
            if (this.keyStoreUrlString != null && this.keyStoreUrlString.length() != 0) {
                return this.expand(this.keyStoreUrlString, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return null;
    }

    public void setKeyStoreUrl(String string) {
        this.keyStoreUrlString = string;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String string) {
        this.keyStoreType = string;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String string) {
        this.keyStoreProvider = string;
    }

    public String getStorePassURL() {
        try {
            if (this.storePassURL != null && this.storePassURL.length() != 0) {
                return this.expand(this.storePassURL, true).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return null;
    }

    public void setStorePassURL(String string) {
        this.storePassURL = string;
    }

    public Enumeration<GrantEntry> grantElements() {
        return this.grantEntries.elements();
    }

    public void write(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        Enumeration<GrantEntry> enumeration = this.grantElements();
        printWriter.println("/* AUTOMATICALLY GENERATED ON " + new Date() + "*/");
        printWriter.println("/* DO NOT EDIT */");
        printWriter.println();
        if (this.keyStoreUrlString != null) {
            this.writeKeyStoreEntry(printWriter);
        }
        if (this.storePassURL != null) {
            this.writeStorePassURL(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            GrantEntry grantEntry = (GrantEntry)((Object)g.convertForCast((Object)((Object)enumeration.nextElement()), GrantEntry.class));
            grantEntry.write(printWriter);
            printWriter.println();
        }
        printWriter.flush();
    }

    private void parseKeyStoreEntry() throws ParsingException, IOException {
        this.match("keystore");
        this.keyStoreUrlString = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.keystore.type")));
        }
        this.keyStoreType = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (!this.peek("\"")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.keystore.provider")));
        }
        this.keyStoreProvider = this.match("quoted string");
    }

    private void parseStorePassURL() throws ParsingException, IOException {
        this.match("keyStorePasswordURL");
        this.storePassURL = this.match("quoted string");
    }

    private void writeKeyStoreEntry(PrintWriter printWriter) {
        printWriter.print("keystore \"");
        printWriter.print(this.keyStoreUrlString);
        printWriter.print('\"');
        if (this.keyStoreType != null && this.keyStoreType.length() > 0) {
            printWriter.print(", \"" + this.keyStoreType + "\"");
        }
        if (this.keyStoreProvider != null && this.keyStoreProvider.length() > 0) {
            printWriter.print(", \"" + this.keyStoreProvider + "\"");
        }
        printWriter.println(";");
        printWriter.println();
    }

    private void writeStorePassURL(PrintWriter printWriter) {
        printWriter.print("keystorePasswordURL \"");
        printWriter.print(this.storePassURL);
        printWriter.print('\"');
        printWriter.println(";");
        printWriter.println();
    }

    private GrantEntry parseGrantEntry() throws ParsingException, IOException {
        Object object;
        int n2;
        Object object2;
        GrantEntry grantEntry = new GrantEntry();
        LinkedList<PrincipalEntry> linkedList = null;
        boolean bl = false;
        this.match("grant");
        while (!this.peek("{")) {
            if (this.peekAndMatch("Codebase")) {
                if (((GrantEntry)((Object)((Object)grantEntry))).codeBase != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple.Codebase.expressions")));
                }
                ((GrantEntry)((Object)((Object)grantEntry))).codeBase = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("SignedBy")) {
                if (((GrantEntry)((Object)((Object)grantEntry))).signedBy != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("multiple.SignedBy.expressions")));
                }
                ((GrantEntry)((Object)((Object)grantEntry))).signedBy = this.match("quoted string");
                object2 = new StringTokenizer(((GrantEntry)((Object)((Object)grantEntry))).signedBy, ",", true);
                int n3 = 0;
                n2 = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken().trim();
                    if (object.equals(",")) {
                        ++n2;
                        continue;
                    }
                    if (object.length() <= 0) continue;
                    ++n3;
                }
                if (n3 <= n2) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("SignedBy.has.empty.alias")));
                }
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("Principal")) {
                String string;
                if (linkedList == null) {
                    linkedList = new LinkedList<PrincipalEntry>();
                }
                if (this.peek("\"")) {
                    object2 = REPLACE_NAME;
                    string = this.match("principal type");
                } else {
                    if (this.peek("*")) {
                        this.match("*");
                        object2 = "WILDCARD_PRINCIPAL_CLASS";
                    } else {
                        object2 = this.match("principal type");
                    }
                    if (this.peek("*")) {
                        this.match("*");
                        string = "WILDCARD_PRINCIPAL_NAME";
                    } else {
                        string = this.match("quoted string");
                    }
                    if (((String)object2).equals("WILDCARD_PRINCIPAL_CLASS") && !string.equals("WILDCARD_PRINCIPAL_NAME")) {
                        if (debug != null) {
                            debug.println("disallowing principal that has WILDCARD class but no WILDCARD name");
                        }
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("can.not.specify.Principal.with.a.wildcard.class.without.a.wildcard.name")));
                    }
                }
                try {
                    string = this.expand(string);
                    if (((String)object2).equals("javax.security.auth.x500.X500Principal") && !string.equals("WILDCARD_PRINCIPAL_NAME")) {
                        X500Principal x500Principal = new X500Principal(new X500Principal(string).toString());
                        string = x500Principal.getName();
                    }
                    linkedList.add(new PrincipalEntry((String)object2, string));
                }
                catch (PropertyExpander.ExpandException expandException) {
                    if (debug != null) {
                        debug.println("principal name expansion failed: " + string);
                    }
                    bl = true;
                }
                this.peekAndMatch(",");
                continue;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.codeBase.or.SignedBy.or.Principal")));
        }
        if (linkedList != null) {
            ((GrantEntry)((Object)((Object)grantEntry))).principals = linkedList;
        }
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                try {
                    object2 = this.parsePermissionEntry();
                    grantEntry.add((PermissionEntry)((Object)object2));
                }
                catch (PropertyExpander.ExpandException expandException) {
                    if (debug != null) {
                        debug.println(expandException.toString());
                    }
                    this.skipEntry();
                }
                this.match(";");
                continue;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ResourcesMgr.getString("expected.permission.entry")));
        }
        this.match("}");
        try {
            if (((GrantEntry)((Object)((Object)grantEntry))).signedBy != null) {
                ((GrantEntry)((Object)((Object)grantEntry))).signedBy = this.expand(((GrantEntry)((Object)((Object)grantEntry))).signedBy);
            }
            if (((GrantEntry)((Object)((Object)grantEntry))).codeBase != null) {
                int n4;
                if (((GrantEntry)((Object)((Object)grantEntry))).codeBase.equals(OLD_EXTDIRS_EXPANSION)) {
                    ((GrantEntry)((Object)((Object)grantEntry))).codeBase = EXTDIRS_EXPANSION;
                }
                if ((n4 = ((GrantEntry)((Object)((Object)grantEntry))).codeBase.indexOf(EXTDIRS_EXPANSION)) < 0) {
                    ((GrantEntry)((Object)((Object)grantEntry))).codeBase = this.expand(((GrantEntry)((Object)((Object)grantEntry))).codeBase, true).replace(File.separatorChar, '/');
                } else {
                    Object[] objectArray = PolicyParser.parseExtDirs(((GrantEntry)((Object)((Object)grantEntry))).codeBase, n4);
                    if (objectArray != null && a.arrayLength((Object[])objectArray) > 0) {
                        for (n2 = 0; n2 < a.arrayLength((Object[])objectArray); ++n2) {
                            object = (GrantEntry)((Object)g.convertForCast((Object)grantEntry.clone(), GrantEntry.class));
                            ((GrantEntry)((Object)object)).codeBase = (String)a.arrayLoad((Object[])objectArray, (int)n2);
                            this.add((GrantEntry)((Object)object));
                            if (debug == null) continue;
                            debug.println("creating policy entry for expanded java.ext.dirs path:\n\t\t" + (String)a.arrayLoad((Object[])objectArray, (int)n2));
                        }
                    }
                    bl = true;
                }
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            if (debug != null) {
                debug.println(expandException.toString());
            }
            return null;
        }
        return bl ? null : grantEntry;
    }

    private PermissionEntry parsePermissionEntry() throws ParsingException, IOException, PropertyExpander.ExpandException {
        PermissionEntry permissionEntry = new PermissionEntry();
        this.match("Permission");
        ((PermissionEntry)((Object)((Object)permissionEntry))).permission = this.match("permission type");
        if (this.peek("\"")) {
            ((PermissionEntry)((Object)((Object)permissionEntry))).name = this.expand(this.match("quoted string"));
        }
        if (!this.peek(",")) {
            return permissionEntry;
        }
        this.match(",");
        if (this.peek("\"")) {
            ((PermissionEntry)((Object)((Object)permissionEntry))).action = this.expand(this.match("quoted string"));
            if (!this.peek(",")) {
                return permissionEntry;
            }
            this.match(",");
        }
        if (this.peekAndMatch("SignedBy")) {
            ((PermissionEntry)((Object)((Object)permissionEntry))).signedBy = this.expand(this.match("quoted string"));
        }
        return permissionEntry;
    }

    static String[] parseExtDirs(String string, int n2) {
        String string2 = System.getProperty(EXTDIRS_PROPERTY);
        String string3 = n2 > 0 ? string.substring(0, n2) : "file:";
        int n3 = n2 + EXTDIRS_EXPANSION.length();
        String string4 = n3 < string.length() ? string.substring(n3) : (String)null;
        Object[] objectArray = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            int n4 = stringTokenizer.countTokens();
            objectArray = new String[n4];
            for (int i = 0; i < n4; ++i) {
                File file = new File(stringTokenizer.nextToken());
                a.arrayStore((Object[])objectArray, (int)i, (Object)ParseUtil.encodePath(file.getAbsolutePath()));
                if (!((String)objectArray[i]).startsWith("/")) {
                    a.arrayStore((Object[])objectArray, (int)i, (Object)("/" + (String)objectArray[i]));
                }
                String string5 = string4 == null ? (((String)objectArray[i]).endsWith("/") ? "*" : "/*") : string4;
                a.arrayStore((Object[])objectArray, (int)i, (Object)(string3 + (String)objectArray[i] + string5));
            }
        }
        return objectArray;
    }

    private boolean peekAndMatch(String string) throws ParsingException, IOException {
        if (this.peek(string)) {
            this.match(string);
            return true;
        }
        return false;
    }

    private boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case -3: {
                if (!string.equalsIgnoreCase(StreamTokenizer._jr$ig$sval((Object)this.st))) break;
                bl = true;
                break;
            }
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl = true;
                break;
            }
            case 34: {
                if (!string.equalsIgnoreCase("\"")) break;
                bl = true;
                break;
            }
            case 42: {
                if (!string.equalsIgnoreCase("*")) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String match(String string) throws ParsingException, IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -2: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, ResourcesMgr.getString("number.") + String.valueOf(StreamTokenizer._jr$ig$nval((Object)this.st))));
            }
            case -1: {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("expected.expect.read.end.of.file."));
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)string);
                Object[] objectArray2 = objectArray;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(messageFormat.format(objectArray2)));
            }
            case -3: {
                if (string.equalsIgnoreCase(StreamTokenizer._jr$ig$sval((Object)this.st))) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = StreamTokenizer._jr$ig$sval((Object)this.st);
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("principal type")) {
                    string2 = StreamTokenizer._jr$ig$sval((Object)this.st);
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, StreamTokenizer._jr$ig$sval((Object)this.st)));
            }
            case 34: {
                if (string.equalsIgnoreCase("quoted string")) {
                    string2 = StreamTokenizer._jr$ig$sval((Object)this.st);
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = StreamTokenizer._jr$ig$sval((Object)this.st);
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("principal type")) {
                    string2 = StreamTokenizer._jr$ig$sval((Object)this.st);
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, StreamTokenizer._jr$ig$sval((Object)this.st)));
            }
            case 44: {
                if (string.equalsIgnoreCase(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, ","));
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, "{"));
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, "}"));
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, ";"));
            }
            case 42: {
                if (string.equalsIgnoreCase("*")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, "*"));
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), string, new String(new char[]{(char)this.lookahead})));
            }
        }
        return string2;
    }

    private void skipEntry() throws ParsingException, IOException {
        while (this.lookahead != 59) {
            switch (this.lookahead) {
                case -2: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(this.st.lineno(), ";", ResourcesMgr.getString("number.") + String.valueOf(StreamTokenizer._jr$ig$nval((Object)this.st))));
                }
                case -1: {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ParsingException(ResourcesMgr.getString("expected.read.end.of.file.")));
                }
            }
            this.lookahead = this.st.nextToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        OutputStreamWriter outputStreamWriter;
        block5: {
            InputStreamReader inputStreamReader = null;
            outputStreamWriter = null;
            try {
                PolicyParser policyParser = new PolicyParser(true);
                inputStreamReader = new FileReader((String)a.arrayLoad((Object[])stringArray, (int)0));
                policyParser.read(inputStreamReader);
                outputStreamWriter = new FileWriter((String)a.arrayLoad((Object[])stringArray, (int)1));
                policyParser.write(outputStreamWriter);
                if (inputStreamReader == null) break block5;
            }
            catch (Throwable throwable) {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
            inputStreamReader.close();
        }
        if (outputStreamWriter != null) {
            outputStreamWriter.close();
        }
    }

    private static /* synthetic */ void _jr$ip$grantEntries(PolicyParser policyParser, Vector vector) {
        policyParser.grantEntries = vector;
    }

    private static /* synthetic */ void _jr$ip$expandProp(PolicyParser policyParser, boolean bl) {
        policyParser.expandProp = bl;
    }

    protected /* synthetic */ PolicyParser(h h2) {
        super(h2);
    }

    public static class GrantEntry
    extends h {
        public String signedBy;
        public String codeBase;
        public LinkedList<PrincipalEntry> principals;
        public Vector<PermissionEntry> permissionEntries;

        public GrantEntry() {
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public GrantEntry(String string, String string2) {
            this.codeBase = string2;
            this.signedBy = string;
            this.principals = new LinkedList();
            this.permissionEntries = new Vector();
        }

        public void add(PermissionEntry permissionEntry) {
            ((GrantEntry)((Object)((Object)this))).permissionEntries.addElement(permissionEntry);
        }

        public boolean remove(PrincipalEntry principalEntry) {
            return ((GrantEntry)((Object)((Object)this))).principals.remove((Object)principalEntry);
        }

        public boolean remove(PermissionEntry permissionEntry) {
            return ((GrantEntry)((Object)((Object)this))).permissionEntries.removeElement((Object)permissionEntry);
        }

        public boolean contains(PrincipalEntry principalEntry) {
            return ((GrantEntry)((Object)((Object)this))).principals.contains((Object)principalEntry);
        }

        public boolean contains(PermissionEntry permissionEntry) {
            return ((GrantEntry)((Object)((Object)this))).permissionEntries.contains((Object)permissionEntry);
        }

        public Enumeration<PermissionEntry> permissionElements() {
            return ((GrantEntry)((Object)((Object)this))).permissionEntries.elements();
        }

        public void write(PrintWriter printWriter) {
            h h2;
            Object object;
            printWriter.print("grant");
            if (((GrantEntry)((Object)((Object)this))).signedBy != null) {
                printWriter.print(" signedBy \"");
                printWriter.print(((GrantEntry)((Object)((Object)this))).signedBy);
                printWriter.print('\"');
                if (((GrantEntry)((Object)((Object)this))).codeBase != null) {
                    printWriter.print(", ");
                }
            }
            if (((GrantEntry)((Object)((Object)this))).codeBase != null) {
                printWriter.print(" codeBase \"");
                printWriter.print(((GrantEntry)((Object)((Object)this))).codeBase);
                printWriter.print('\"');
                if (((GrantEntry)((Object)((Object)this))).principals != null && ((GrantEntry)((Object)((Object)this))).principals.size() > 0) {
                    printWriter.print(",\n");
                }
            }
            if (((GrantEntry)((Object)((Object)this))).principals != null && ((GrantEntry)((Object)((Object)this))).principals.size() > 0) {
                object = ((GrantEntry)((Object)((Object)this))).principals.listIterator();
                while (object.hasNext()) {
                    printWriter.print("      ");
                    h2 = (PrincipalEntry)((Object)g.convertForCast(object.next(), PrincipalEntry.class));
                    h2.write(printWriter);
                    if (!object.hasNext()) continue;
                    printWriter.print(",\n");
                }
            }
            printWriter.println(" {");
            object = ((GrantEntry)((Object)((Object)this))).permissionEntries.elements();
            while (object.hasMoreElements()) {
                h2 = (PermissionEntry)((Object)g.convertForCast(object.nextElement(), PermissionEntry.class));
                printWriter.write("  ");
                h2.write(printWriter);
            }
            printWriter.println("};");
        }

        public Object clone() {
            GrantEntry grantEntry = new GrantEntry();
            ((GrantEntry)((Object)((Object)grantEntry))).codeBase = ((GrantEntry)((Object)((Object)this))).codeBase;
            ((GrantEntry)((Object)((Object)grantEntry))).signedBy = ((GrantEntry)((Object)((Object)this))).signedBy;
            ((GrantEntry)((Object)((Object)grantEntry))).principals = new LinkedList(((GrantEntry)((Object)((Object)this))).principals);
            ((GrantEntry)((Object)((Object)grantEntry))).permissionEntries = new Vector(((GrantEntry)((Object)((Object)this))).permissionEntries);
            return grantEntry;
        }

        protected /* synthetic */ GrantEntry(h h2) {
            super(h2);
        }
    }

    public static class ParsingException
    extends GeneralSecurityException {
        private static final long serialVersionUID = -4330692689482574072L;
        private String i18nMessage;

        public ParsingException(String string) {
            super(string);
            this.i18nMessage = string;
        }

        public ParsingException(int n2, String string) {
            super("line " + n2 + ": " + string);
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("line.number.msg"));
            Object[] objectArray = new Object[2];
            a.arrayStore((Object[])objectArray, (int)0, (Object)new Integer(n2));
            a.arrayStore((Object[])objectArray, (int)1, (Object)string);
            Object[] objectArray2 = objectArray;
            this.i18nMessage = messageFormat.format(objectArray2);
        }

        public ParsingException(int n2, String string, String string2) {
            super("line " + n2 + ": expected [" + string + "], found [" + string2 + "]");
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("line.number.expected.expect.found.actual."));
            Object[] objectArray = new Object[3];
            a.arrayStore((Object[])objectArray, (int)0, (Object)new Integer(n2));
            a.arrayStore((Object[])objectArray, (int)1, (Object)string);
            a.arrayStore((Object[])objectArray, (int)2, (Object)string2);
            Object[] objectArray2 = objectArray;
            this.i18nMessage = messageFormat.format(objectArray2);
        }

        @Override
        public String getLocalizedMessage() {
            return this.i18nMessage;
        }

        private static /* synthetic */ void _jr$ip$i18nMessage(ParsingException parsingException, String string) {
            parsingException.i18nMessage = string;
        }

        protected /* synthetic */ ParsingException(h h2) {
            super(h2);
        }
    }

    public static class PermissionEntry
    extends h {
        public String permission;
        public String name;
        public String action;
        public String signedBy;

        public PermissionEntry() {
        }

        public PermissionEntry(String string, String string2, String string3) {
            this.permission = string;
            this.name = string2;
            this.action = string3;
        }

        public int hashCode() {
            int n2 = ((PermissionEntry)((Object)((Object)this))).permission.hashCode();
            if (((PermissionEntry)((Object)((Object)this))).name != null) {
                n2 ^= ((PermissionEntry)((Object)((Object)this))).name.hashCode();
            }
            if (((PermissionEntry)((Object)((Object)this))).action != null) {
                n2 ^= ((PermissionEntry)((Object)((Object)this))).action.hashCode();
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)object, (Object)((Object)this))) {
                return true;
            }
            if (!(g.convertForInstanceOf((Object)object, PermissionEntry.class) instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry permissionEntry = (PermissionEntry)((Object)g.convertForCast((Object)object, PermissionEntry.class));
            if (((PermissionEntry)((Object)((Object)this))).permission == null ? ((PermissionEntry)((Object)((Object)permissionEntry))).permission != null : !((PermissionEntry)((Object)((Object)this))).permission.equals(((PermissionEntry)((Object)((Object)permissionEntry))).permission)) {
                return false;
            }
            if (((PermissionEntry)((Object)((Object)this))).name == null ? ((PermissionEntry)((Object)((Object)permissionEntry))).name != null : !((PermissionEntry)((Object)((Object)this))).name.equals(((PermissionEntry)((Object)((Object)permissionEntry))).name)) {
                return false;
            }
            if (((PermissionEntry)((Object)((Object)this))).action == null ? ((PermissionEntry)((Object)((Object)permissionEntry))).action != null : !((PermissionEntry)((Object)((Object)this))).action.equals(((PermissionEntry)((Object)((Object)permissionEntry))).action)) {
                return false;
            }
            return !(((PermissionEntry)((Object)((Object)this))).signedBy == null ? ((PermissionEntry)((Object)((Object)permissionEntry))).signedBy != null : !((PermissionEntry)((Object)((Object)this))).signedBy.equals(((PermissionEntry)((Object)((Object)permissionEntry))).signedBy));
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("permission ");
            printWriter.print(((PermissionEntry)((Object)((Object)this))).permission);
            if (((PermissionEntry)((Object)((Object)this))).name != null) {
                printWriter.print(" \"");
                printWriter.print(((PermissionEntry)((Object)((Object)this))).name.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\\\""));
                printWriter.print('\"');
            }
            if (((PermissionEntry)((Object)((Object)this))).action != null) {
                printWriter.print(", \"");
                printWriter.print(((PermissionEntry)((Object)((Object)this))).action);
                printWriter.print('\"');
            }
            if (((PermissionEntry)((Object)((Object)this))).signedBy != null) {
                printWriter.print(", signedBy \"");
                printWriter.print(((PermissionEntry)((Object)((Object)this))).signedBy);
                printWriter.print('\"');
            }
            printWriter.println(";");
        }

        protected /* synthetic */ PermissionEntry(h h2) {
            super(h2);
        }
    }

    public static class PrincipalEntry
    extends h {
        public static final String WILDCARD_CLASS = "WILDCARD_PRINCIPAL_CLASS";
        public static final String WILDCARD_NAME = "WILDCARD_PRINCIPAL_NAME";
        String principalClass;
        String principalName;

        public PrincipalEntry(String string, String string2) {
            if (string == null || string2 == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException(ResourcesMgr.getString("null.principalClass.or.principalName")));
            }
            this.principalClass = string;
            this.principalName = string2;
        }

        public String getPrincipalClass() {
            return ((PrincipalEntry)((Object)((Object)this))).principalClass;
        }

        public String getPrincipalName() {
            return ((PrincipalEntry)((Object)((Object)this))).principalName;
        }

        public String getDisplayClass() {
            if (((PrincipalEntry)((Object)((Object)this))).principalClass.equals(WILDCARD_CLASS)) {
                return "*";
            }
            if (((PrincipalEntry)((Object)((Object)this))).principalClass.equals(PolicyParser.REPLACE_NAME)) {
                return "";
            }
            return ((PrincipalEntry)((Object)((Object)this))).principalClass;
        }

        public String getDisplayName() {
            return this.getDisplayName(false);
        }

        public String getDisplayName(boolean bl) {
            if (((PrincipalEntry)((Object)((Object)this))).principalName.equals(WILDCARD_NAME)) {
                return "*";
            }
            if (bl) {
                return "\"" + ((PrincipalEntry)((Object)((Object)this))).principalName + "\"";
            }
            return ((PrincipalEntry)((Object)((Object)this))).principalName;
        }

        public String toString() {
            if (!((PrincipalEntry)((Object)((Object)this))).principalClass.equals(PolicyParser.REPLACE_NAME)) {
                return this.getDisplayClass() + "/" + this.getDisplayName();
            }
            return this.getDisplayName();
        }

        public boolean equals(Object object) {
            if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
                return true;
            }
            if (!(g.convertForInstanceOf((Object)object, PrincipalEntry.class) instanceof PrincipalEntry)) {
                return false;
            }
            PrincipalEntry principalEntry = (PrincipalEntry)((Object)g.convertForCast((Object)object, PrincipalEntry.class));
            return ((PrincipalEntry)((Object)((Object)this))).principalClass.equals(((PrincipalEntry)((Object)((Object)principalEntry))).principalClass) && ((PrincipalEntry)((Object)((Object)this))).principalName.equals(((PrincipalEntry)((Object)((Object)principalEntry))).principalName);
        }

        public int hashCode() {
            return ((PrincipalEntry)((Object)((Object)this))).principalClass.hashCode();
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("principal " + this.getDisplayClass() + " " + this.getDisplayName(true));
        }

        static /* synthetic */ void _jr$ip$principalClass(Object object, String string) {
            ((PrincipalEntry)((Object)object)).principalClass = string;
        }

        static /* synthetic */ void _jr$ip$principalName(Object object, String string) {
            ((PrincipalEntry)((Object)object)).principalName = string;
        }

        protected /* synthetic */ PrincipalEntry(h h2) {
            super(h2);
        }
    }
}

