/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import sun.security.provider.ByteArrayAccess;
import sun.security.provider.DigestBase;

public final class SHA
extends DigestBase {
    private final int[] W;
    private final int[] state;
    private static final int round1_kt = 1518500249;
    private static final int round2_kt = 1859775393;
    private static final int round3_kt = -1894007588;
    private static final int round4_kt = -899497514;

    public SHA() {
        super("SHA-1", 20, 64);
        this.state = new int[5];
        this.W = new int[80];
        this.implReset();
    }

    private SHA(SHA sHA) {
        super(sHA);
        this.state = (int[])sHA.state.clone();
        this.W = new int[80];
    }

    @Override
    public Object clone() {
        return new SHA(this);
    }

    @Override
    void implReset() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
    }

    @Override
    void implDigest(byte[] byArray, int n2) {
        long l2 = this.bytesProcessed << 3;
        int n3 = (int)this.bytesProcessed & 0x3F;
        int n4 = n3 < 56 ? 56 - n3 : 120 - n3;
        this.engineUpdate(padding, 0, n4);
        ByteArrayAccess.i2bBig4((int)(l2 >>> 32), this.buffer, 56);
        ByteArrayAccess.i2bBig4((int)l2, this.buffer, 60);
        this.implCompress(this.buffer, 0);
        ByteArrayAccess.i2bBig(this.state, 0, byArray, n2, 20);
    }

    @Override
    void implCompress(byte[] byArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        ByteArrayAccess.b2iBig64(byArray, n2, this.W);
        for (n6 = 16; n6 <= 79; ++n6) {
            n5 = this.W[n6 - 3] ^ this.W[n6 - 8] ^ this.W[n6 - 14] ^ this.W[n6 - 16];
            this.W[n6] = n5 << 1 | n5 >>> 31;
        }
        n6 = this.state[0];
        n5 = this.state[1];
        int n7 = this.state[2];
        int n8 = this.state[3];
        int n9 = this.state[4];
        for (n4 = 0; n4 < 20; ++n4) {
            n3 = (n6 << 5 | n6 >>> 27) + (n5 & n7 | ~n5 & n8) + n9 + this.W[n4] + 1518500249;
            n9 = n8;
            n8 = n7;
            n7 = n5 << 30 | n5 >>> 2;
            n5 = n6;
            n6 = n3;
        }
        for (n4 = 20; n4 < 40; ++n4) {
            n3 = (n6 << 5 | n6 >>> 27) + (n5 ^ n7 ^ n8) + n9 + this.W[n4] + 1859775393;
            n9 = n8;
            n8 = n7;
            n7 = n5 << 30 | n5 >>> 2;
            n5 = n6;
            n6 = n3;
        }
        for (n4 = 40; n4 < 60; ++n4) {
            n3 = (n6 << 5 | n6 >>> 27) + (n5 & n7 | n5 & n8 | n7 & n8) + n9 + this.W[n4] + -1894007588;
            n9 = n8;
            n8 = n7;
            n7 = n5 << 30 | n5 >>> 2;
            n5 = n6;
            n6 = n3;
        }
        for (n4 = 60; n4 < 80; ++n4) {
            n3 = (n6 << 5 | n6 >>> 27) + (n5 ^ n7 ^ n8) + n9 + this.W[n4] + -899497514;
            n9 = n8;
            n8 = n7;
            n7 = n5 << 30 | n5 >>> 2;
            n5 = n6;
            n6 = n3;
        }
        this.state[0] = this.state[0] + n6;
        this.state[1] = this.state[1] + n5;
        this.state[2] = this.state[2] + n7;
        this.state[3] = this.state[3] + n8;
        this.state[4] = this.state[4] + n9;
    }

    private static /* synthetic */ int[] _jr$ig$W(SHA sHA) {
        return sHA.W;
    }

    private static /* synthetic */ void _jr$ip$W(SHA sHA, int[] nArray) {
        sHA.W = nArray;
    }

    private static /* synthetic */ int[] _jr$ig$state(SHA sHA) {
        return sHA.state;
    }

    private static /* synthetic */ void _jr$ip$state(SHA sHA, int[] nArray) {
        sHA.state = nArray;
    }
}

