/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import sun.security.provider.FileInputStreamPool;
import sun.security.provider.NativeSeedGenerator;
import sun.security.provider.SunEntries;
import sun.security.util.Debug;

abstract class SeedGenerator
extends h {
    private static SeedGenerator instance;
    private static final Debug debug;
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";

    SeedGenerator() {
    }

    public static void generateSeed(byte[] byArray) {
        instance.getSeedBytes(byArray);
    }

    abstract void getSeedBytes(byte[] var1);

    static byte[] getSystemEntropy() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("internal error: SHA-1 not available."));
        }
        byte by = (byte)System.currentTimeMillis();
        messageDigest.update(by);
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Void run() {
                Object object;
                Object object2;
                block14: {
                    try {
                        DirectoryStream<Path> directoryStream;
                        block15: {
                            object2 = System.getProperties();
                            Enumeration<?> enumeration = ((Properties)object2).propertyNames();
                            while (enumeration.hasMoreElements()) {
                                object = (String)enumeration.nextElement();
                                messageDigest.update(((String)object).getBytes());
                                messageDigest.update(((Properties)object2).getProperty((String)object).getBytes());
                            }
                            messageDigest.update(InetAddress.getLocalHost().toString().getBytes());
                            File file = new File(((Properties)object2).getProperty("java.io.tmpdir"));
                            int n2 = 0;
                            directoryStream = Files.newDirectoryStream(file.toPath());
                            Throwable throwable = null;
                            try {
                                Random random = new Random();
                                Iterator<Path> iterator = directoryStream.iterator();
                                while (iterator.hasNext()) {
                                    Path path = (Path)g.convertForCast((Object)iterator.next(), Path.class);
                                    if (n2 < 512 || random.nextBoolean()) {
                                        messageDigest.update(path.getFileName().toString().getBytes());
                                    }
                                    if (n2++ <= 1024) continue;
                                }
                                if (directoryStream == null) break block14;
                                if (throwable == null) break block15;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable3);
                                }
                                catch (Throwable throwable4) {
                                    if (directoryStream == null) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                    if (throwable == null) {
                                        directoryStream.close();
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                    }
                                    try {
                                        directoryStream.close();
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable4);
                                    }
                                }
                            }
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block14;
                        }
                        directoryStream.close();
                    }
                    catch (Exception exception) {
                        messageDigest.update((byte)exception.hashCode());
                    }
                }
                object = Runtime.getRuntime();
                object2 = SeedGenerator.longToByteArray(((Runtime)((Object)object)).totalMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                object2 = SeedGenerator.longToByteArray(((Runtime)((Object)object)).freeMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                return null;
            }

            static /* synthetic */ MessageDigest _jr$ig$val$md(Object object) {
                return (object).messageDigest;
            }

            static /* synthetic */ void _jr$ip$val$md(Object object, MessageDigest messageDigest2) {
                (object).messageDigest = messageDigest2;
            }
        });
        return messageDigest.digest();
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    static {
        block11: {
            debug = Debug.getInstance("provider");
            String string = SunEntries.getSeedSource();
            if (string.equals(URL_DEV_RANDOM) || string.equals(URL_DEV_URANDOM)) {
                try {
                    instance = new NativeSeedGenerator();
                    if (debug != null) {
                        debug.println("Using operating system seed generator");
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        debug.println("Failed to use operating system seed generator: " + iOException.toString());
                    }
                    break block11;
                }
            }
            if (string.length() != 0) {
                try {
                    instance = new URLSeedGenerator(string);
                    if (debug != null) {
                        debug.println("Using URL seed generator reading from " + string);
                    }
                }
                catch (IOException iOException) {
                    if (debug == null) break block11;
                    debug.println("Failed to create seed generator with " + string + ": " + iOException.toString());
                }
            }
        }
        if (instance == null) {
            if (debug != null) {
                debug.println("Using default threaded seed generator");
            }
            instance = new ThreadedSeedGenerator();
        }
    }

    protected /* synthetic */ SeedGenerator(h h2) {
        super(h2);
    }

    private static class ThreadedSeedGenerator
    extends SeedGenerator
    implements Runnable {
        private byte[] pool;
        private int start;
        private int end;
        private int count;
        ThreadGroup seedGroup;
        private static byte[] rndTab = new byte[]{56, 30, -107, -6, -86, 25, -83, 75, -12, -64, 5, -128, 78, 21, 16, 32, 70, -81, 37, -51, -43, -46, -108, 87, 29, 17, -55, 22, -11, -111, -115, 84, -100, 108, -45, -15, -98, 72, -33, -28, 31, -52, -37, -117, -97, -27, 93, -123, 47, 126, -80, -62, -93, -79, 61, -96, -65, -5, -47, -119, 14, 89, 81, -118, -88, 20, 67, -126, -113, 60, -102, 55, 110, 28, 85, 121, 122, -58, 2, 45, 43, 24, -9, 103, -13, 102, -68, -54, -101, -104, 19, 13, -39, -26, -103, 62, 77, 51, 44, 111, 73, 18, -127, -82, 4, -30, 11, -99, -74, 40, -89, 42, -76, -77, -94, -35, -69, 35, 120, 76, 33, -73, -7, 82, -25, -10, 88, 125, -112, 58, 83, 95, 6, 10, 98, -34, 80, 15, -91, 86, -19, 52, -17, 117, 49, -63, 118, -90, 36, -116, -40, -71, 97, -53, -109, -85, 109, -16, -3, 104, -95, 68, 54, 34, 26, 114, -1, 106, -121, 3, 66, 0, 100, -84, 57, 107, 119, -42, 112, -61, 1, 48, 38, 12, -56, -57, 39, -106, -72, 41, 7, 71, -29, -59, -8, -38, 79, -31, 124, -124, 8, 91, 116, 99, -4, 9, -36, -78, 63, -49, -67, -87, 59, 101, -32, 92, 94, 53, -41, 115, -66, -70, -122, 50, -50, -22, -20, -18, -21, 23, -2, -48, 96, 65, -105, 123, -14, -110, 69, -24, -120, -75, 74, 127, -60, 113, 90, -114, 105, 46, 27, -125, -23, -44, 64};

        ThreadedSeedGenerator() {
            this.pool = new byte[20];
            this.end = 0;
            this.start = 0;
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("internal error: SHA-1 not available."));
            }
            final ThreadGroup[] threadGroupArray = new ThreadGroup[1];
            Thread thread = (Thread)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    ThreadGroup parent;
                    ThreadGroup group = Thread.currentThread().getThreadGroup();
                    while ((parent = group.getParent()) != null) {
                        group = parent;
                    }
                    threadGroupArray[0] = new ThreadGroup(group, "SeedGenerator ThreadGroup");
                    Thread newT = new Thread(threadGroupArray[0], (Runnable)this, "SeedGenerator Thread", 0L, false);
                    newT.setPriority(1);
                    newT.setDaemon(true);
                    return newT;
                }
            }), Thread.class);
            this.seedGroup = threadGroupArray[0];
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            try {
                block13: while (true) {
                    Object object = ah.getMonitor((Object)this);
                    synchronized (object) {
                        try {
                            while (this.count >= this.pool.length) {
                                ah.getMonitor((Object)this).wait();
                            }
                        }
                        catch (Throwable throwable) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                    byte by = 0;
                    int n2 = 0;
                    int n3 = 0;
                    while (true) {
                        long l;
                        int n4;
                        if (n3 < 64000 && n2 < 6) {
                            try {
                                BogusThread bogusThread = new BogusThread();
                                Thread thread = new Thread(((ThreadedSeedGenerator)this).seedGroup, bogusThread, "SeedGenerator Thread");
                                thread.start();
                            }
                            catch (Exception exception) {
                                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("internal error: SeedGenerator thread creation error."));
                            }
                            n4 = 0;
                            n4 = 0;
                            l = System.currentTimeMillis() + 250L;
                        } else {
                            Object object2 = ah.getMonitor((Object)this);
                            synchronized (object2) {
                                try {
                                    ((ThreadedSeedGenerator)this).pool[((ThreadedSeedGenerator)this).end] = by;
                                    ThreadedSeedGenerator threadedSeedGenerator = this;
                                    threadedSeedGenerator.end = threadedSeedGenerator.end + 1;
                                    ThreadedSeedGenerator threadedSeedGenerator2 = this;
                                    threadedSeedGenerator2.count = threadedSeedGenerator2.count + 1;
                                    if (this.end >= this.pool.length) {
                                        this.end = 0;
                                    }
                                    ah.getMonitor((Object)this).notifyAll();
                                    continue block13;
                                }
                                catch (Throwable throwable) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                                }
                            }
                        }
                        while (System.currentTimeMillis() < l) {
                            Object object3 = ah.getMonitor((Object)this);
                            synchronized (object3) {
                                try {
                                }
                                catch (Throwable throwable) {
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                                }
                            }
                            ++n4;
                        }
                        by = (byte)(by ^ rndTab[n4 % 255]);
                        n3 += n4;
                        ++n2;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("internal error: SeedGenerator thread generated an exception."));
            }
        }

        @Override
        void getSeedBytes(byte[] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.getSeedByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte getSeedByte() {
            Object object;
            byte by;
            block10: {
                by = 0;
                try {
                    object = ah.getMonitor((Object)this);
                    synchronized (object) {
                        try {
                            while (this.count <= 0) {
                                ah.getMonitor((Object)this).wait();
                            }
                        }
                        catch (Throwable throwable) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.count > 0) break block10;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("internal error: SeedGenerator thread generated an exception."));
                }
            }
            object = ah.getMonitor((Object)this);
            synchronized (object) {
                try {
                    by = this.pool[this.start];
                    ((ThreadedSeedGenerator)this).pool[((ThreadedSeedGenerator)this).start] = 0;
                    ThreadedSeedGenerator threadedSeedGenerator = this;
                    threadedSeedGenerator.start = threadedSeedGenerator.start + 1;
                    ThreadedSeedGenerator threadedSeedGenerator2 = this;
                    threadedSeedGenerator2.count = threadedSeedGenerator2.count - 1;
                    if (this.start == this.pool.length) {
                        this.start = 0;
                    }
                    ah.getMonitor((Object)this).notifyAll();
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            return by;
        }

        private static /* synthetic */ void _jr$ip$pool(ThreadedSeedGenerator threadedSeedGenerator, byte[] byArray) {
            threadedSeedGenerator.pool = byArray;
        }

        static /* synthetic */ void _jr$ip$seedGroup(Object object, ThreadGroup threadGroup) {
            ((ThreadedSeedGenerator)object).seedGroup = threadGroup;
        }

        protected /* synthetic */ ThreadedSeedGenerator(h h2) {
            super(h2);
        }

        private static class BogusThread
        extends h
        implements Runnable {
            private BogusThread() {
            }

            @Override
            public final void run() {
                try {
                    for (int i = 0; i < 5; ++i) {
                        Thread.sleep(50L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            protected /* synthetic */ BogusThread(h h2) {
                super(h2);
            }
        }
    }

    static class URLSeedGenerator
    extends SeedGenerator {
        private String deviceName;
        private InputStream devRandom;

        URLSeedGenerator(String string) throws IOException {
            if (string == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("No random source specified"));
            }
            this.deviceName = string;
            this.init();
        }

        URLSeedGenerator() throws IOException {
            this(SeedGenerator.URL_DEV_RANDOM);
        }

        private void init() throws IOException {
            final URL uRL = new URL(this.deviceName);
            try {
                this.devRandom = (InputStream)g.convertForCast((Object)AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(this){

                    @Override
                    public InputStream run() throws IOException {
                        if (uRL.getProtocol().equalsIgnoreCase("file")) {
                            File deviceFile = SunEntries.getDeviceFile((URL)uRL);
                            return FileInputStreamPool.getInputStream(deviceFile);
                        }
                        return uRL.openStream();
                    }
                }), InputStream.class);
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Failed to open " + this.deviceName, exception.getCause()));
            }
        }

        private File getDeviceFile(URL uRL) throws IOException {
            try {
                URI uRI = uRL.toURI();
                if (uRI.isOpaque()) {
                    URI uRI2 = new File(System.getProperty("user.dir")).toURI();
                    String string = uRI2.toString() + uRI.toString().substring(5);
                    return new File(URI.create(string));
                }
                return new File(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                return new File(uRL.getPath());
            }
        }

        @Override
        void getSeedBytes(byte[] byArray) {
            int n2 = byArray.length;
            try {
                int n3;
                for (int i = 0; i < n2; i += n3) {
                    n3 = this.devRandom.read(byArray, i, n2 - i);
                    if (n3 >= 0) continue;
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("URLSeedGenerator " + this.deviceName + " reached end of file"));
                }
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("URLSeedGenerator " + this.deviceName + " generated exception: " + iOException.getMessage()));
            }
        }

        static /* synthetic */ File access$200(URLSeedGenerator uRLSeedGenerator, URL uRL) throws IOException {
            return uRLSeedGenerator.getDeviceFile(uRL);
        }

        private static /* synthetic */ void _jr$ip$deviceName(URLSeedGenerator uRLSeedGenerator, String string) {
            uRLSeedGenerator.deviceName = string;
        }

        protected /* synthetic */ URLSeedGenerator(h h2) {
            super(h2);
        }
    }
}

