/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public final class RSAKeyFactory
extends KeyFactorySpi {
    private static final Class<?> rsaPublicKeySpecClass = RSAPublicKeySpec.class;
    private static final Class<?> rsaPrivateKeySpecClass = RSAPrivateKeySpec.class;
    private static final Class<?> rsaPrivateCrtKeySpecClass = RSAPrivateCrtKeySpec.class;
    private static final Class<?> x509KeySpecClass = X509EncodedKeySpec.class;
    private static final Class<?> pkcs8KeySpecClass = PKCS8EncodedKeySpec.class;
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean restrictExpLen = "true".equalsIgnoreCase((String)AccessController.doPrivileged(new GetPropertyAction("sun.security.rsa.restrictRSAExponent", "true")));
    private static final RSAKeyFactory INSTANCE = new RSAKeyFactory();

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateKeyImpl || g.convertForInstanceOf((Object)key, RSAPrivateCrtKeyImpl.class) instanceof RSAPrivateCrtKeyImpl || g.convertForInstanceOf((Object)key, RSAPublicKeyImpl.class) instanceof RSAPublicKeyImpl) {
            return (RSAKey)g.convertForCast((Object)key, RSAKey.class);
        }
        return (RSAKey)g.convertForCast((Object)INSTANCE.engineTranslateKey(key), RSAKey.class);
    }

    static void checkRSAProviderKeyLengths(int n2, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n2 + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    public static void checkKeyLengths(int n2, BigInteger bigInteger, int n3, int n4) throws InvalidKeyException {
        if (n3 > 0 && n2 < n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("RSA keys must be at least " + n3 + " bits long"));
        }
        int n5 = Math.min(n4, 16384);
        if (n2 > n5) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("RSA keys must be no longer than " + n5 + " bits"));
        }
        if (restrictExpLen && bigInteger != null && n2 > 3072 && bigInteger.bitLength() > 64) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("RSA exponents can be no longer than 64 bits  if modulus is greater than 3072 bits"));
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Key must not be null"));
        }
        String string = key.getAlgorithm();
        if (!string.equals("RSA")) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Not an RSA key: " + string));
        }
        if (g.convertForInstanceOf((Object)key, PublicKey.class) instanceof PublicKey) {
            return this.translatePublicKey((PublicKey)g.convertForCast((Object)key, PublicKey.class));
        }
        if (g.convertForInstanceOf((Object)key, PrivateKey.class) instanceof PrivateKey) {
            return this.translatePrivateKey((PrivateKey)g.convertForCast((Object)key, PrivateKey.class));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Neither a public nor a private key"));
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)invalidKeySpecException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException(generalSecurityException));
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)invalidKeySpecException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException(generalSecurityException));
        }
    }

    private PublicKey translatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (g.convertForInstanceOf((Object)publicKey, RSAPublicKey.class) instanceof RSAPublicKey) {
            if (g.convertForInstanceOf((Object)publicKey, RSAPublicKeyImpl.class) instanceof RSAPublicKeyImpl) {
                return publicKey;
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)g.convertForCast((Object)publicKey, RSAPublicKey.class);
            try {
                return new RSAPublicKeyImpl(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            catch (RuntimeException runtimeException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid key", runtimeException));
            }
        }
        if ("X.509".equals(publicKey.getFormat())) {
            byte[] byArray = publicKey.getEncoded();
            return new RSAPublicKeyImpl(byArray);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Public keys must be instance of RSAPublicKey or have X.509 encoding"));
    }

    private PrivateKey translatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (g.convertForInstanceOf((Object)privateKey, RSAPrivateCrtKey.class) instanceof RSAPrivateCrtKey) {
            if (g.convertForInstanceOf((Object)privateKey, RSAPrivateCrtKeyImpl.class) instanceof RSAPrivateCrtKeyImpl) {
                return privateKey;
            }
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)g.convertForCast((Object)privateKey, RSAPrivateCrtKey.class);
            try {
                return new RSAPrivateCrtKeyImpl(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            catch (RuntimeException runtimeException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid key", runtimeException));
            }
        }
        if (g.convertForInstanceOf((Object)privateKey, RSAPrivateKey.class) instanceof RSAPrivateKey) {
            if (privateKey instanceof RSAPrivateKeyImpl) {
                return privateKey;
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)g.convertForCast((Object)privateKey, RSAPrivateKey.class);
            try {
                return new RSAPrivateKeyImpl(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            catch (RuntimeException runtimeException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid key", runtimeException));
            }
        }
        if ("PKCS#8".equals(privateKey.getFormat())) {
            byte[] byArray = privateKey.getEncoded();
            return RSAPrivateCrtKeyImpl.newKey(byArray);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Private keys must be instance of RSAPrivate(Crt)Key or have PKCS#8 encoding"));
    }

    private PublicKey generatePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (g.convertForInstanceOf((Object)keySpec, X509EncodedKeySpec.class) instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)g.convertForCast((Object)keySpec, X509EncodedKeySpec.class);
            return new RSAPublicKeyImpl(x509EncodedKeySpec.getEncoded());
        }
        if (g.convertForInstanceOf((Object)keySpec, RSAPublicKeySpec.class) instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)g.convertForCast((Object)keySpec, RSAPublicKeySpec.class);
            return new RSAPublicKeyImpl(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys"));
    }

    private PrivateKey generatePrivate(KeySpec keySpec) throws GeneralSecurityException {
        if (g.convertForInstanceOf((Object)keySpec, PKCS8EncodedKeySpec.class) instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)g.convertForCast((Object)keySpec, PKCS8EncodedKeySpec.class);
            return RSAPrivateCrtKeyImpl.newKey(pKCS8EncodedKeySpec.getEncoded());
        }
        if (g.convertForInstanceOf((Object)keySpec, RSAPrivateCrtKeySpec.class) instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)g.convertForCast((Object)keySpec, RSAPrivateCrtKeySpec.class);
            return new RSAPrivateCrtKeyImpl(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }
        if (g.convertForInstanceOf((Object)keySpec, RSAPrivateKeySpec.class) instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)g.convertForCast((Object)keySpec, RSAPrivateKeySpec.class);
            return new RSAPrivateKeyImpl(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys"));
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException(invalidKeyException));
        }
        if (g.convertForInstanceOf((Object)key, RSAPublicKey.class) instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)g.convertForCast((Object)key, RSAPublicKey.class);
            if (x.isAssignableFrom(rsaPublicKeySpecClass, clazz)) {
                return (T)new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            if (x.isAssignableFrom(x509KeySpecClass, clazz)) {
                return (T)new X509EncodedKeySpec(key.getEncoded());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("KeySpec must be RSAPublicKeySpec or X509EncodedKeySpec for RSA public keys"));
        }
        if (g.convertForInstanceOf((Object)key, RSAPrivateKey.class) instanceof RSAPrivateKey) {
            if (x.isAssignableFrom(pkcs8KeySpecClass, clazz)) {
                return (T)new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (x.isAssignableFrom(rsaPrivateCrtKeySpecClass, clazz)) {
                if (g.convertForInstanceOf((Object)key, RSAPrivateCrtKey.class) instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)g.convertForCast((Object)key, RSAPrivateCrtKey.class);
                    return (T)new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("RSAPrivateCrtKeySpec can only be used with CRT keys"));
            }
            if (x.isAssignableFrom(rsaPrivateKeySpecClass, clazz)) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)g.convertForCast((Object)key, RSAPrivateKey.class);
                return (T)new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("KeySpec must be RSAPrivate(Crt)KeySpec or PKCS8EncodedKeySpec for RSA private keys"));
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeySpecException("Neither public nor private key"));
    }
}

