/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSACore;

public final class RSAPadding
extends h {
    public static final int PAD_BLOCKTYPE_1 = 1;
    public static final int PAD_BLOCKTYPE_2 = 2;
    public static final int PAD_NONE = 3;
    public static final int PAD_OAEP_MGF1 = 4;
    private final int type;
    private final int paddedSize;
    private SecureRandom random;
    private final int maxDataSize;
    private MessageDigest md;
    private MessageDigest mgfMd;
    private byte[] lHash;
    private static final Map<String, byte[]> emptyHashes = Collections.synchronizedMap(new HashMap());

    public static RSAPadding getInstance(int n2, int n3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, null, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, null);
    }

    public static RSAPadding getInstance(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return new RSAPadding(n2, n3, secureRandom, oAEPParameterSpec);
    }

    private RSAPadding(int n2, int n3, SecureRandom secureRandom, OAEPParameterSpec oAEPParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.type = n2;
        this.paddedSize = n3;
        this.random = secureRandom;
        if (n3 < 64) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Padded size must be at least 64"));
        }
        switch (n2) {
            case 1: 
            case 2: {
                this.maxDataSize = n3 - 11;
                break;
            }
            case 3: {
                this.maxDataSize = n3;
                break;
            }
            case 4: {
                String string = "SHA-1";
                String string2 = "SHA-1";
                byte[] byArray = null;
                try {
                    if (oAEPParameterSpec != null) {
                        string = oAEPParameterSpec.getDigestAlgorithm();
                        String string3 = oAEPParameterSpec.getMGFAlgorithm();
                        if (!string3.equalsIgnoreCase("MGF1")) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidAlgorithmParameterException("Unsupported MGF algo: " + string3));
                        }
                        string2 = ((MGF1ParameterSpec)g.convertForCast((Object)oAEPParameterSpec.getMGFParameters(), MGF1ParameterSpec.class)).getDigestAlgorithm();
                        PSource pSource = oAEPParameterSpec.getPSource();
                        String string4 = pSource.getAlgorithm();
                        if (!string4.equalsIgnoreCase("PSpecified")) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidAlgorithmParameterException("Unsupported pSource algo: " + string4));
                        }
                        byArray = ((PSource.PSpecified)g.convertForCast((Object)pSource, PSource.PSpecified.class)).getValue();
                    }
                    this.md = MessageDigest.getInstance(string);
                    this.mgfMd = MessageDigest.getInstance(string2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Digest " + string + " not available", noSuchAlgorithmException));
                }
                this.lHash = RSAPadding.getInitialHash(this.md, byArray);
                int n4 = this.lHash.length;
                this.maxDataSize = n3 - 2 - 2 * n4;
                if (this.maxDataSize > 0) break;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Key is too short for encryption using OAEPPadding with " + string + " and MGF1" + string2));
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid padding: " + n2));
            }
        }
    }

    private static byte[] getInitialHash(MessageDigest messageDigest, byte[] byArray) {
        byte[] byArray2 = null;
        if (byArray == null || byArray.length == 0) {
            String string = messageDigest.getAlgorithm();
            byArray2 = emptyHashes.get(string);
            if (byArray2 == null) {
                byArray2 = messageDigest.digest();
                emptyHashes.put(string, byArray2);
            }
        } else {
            byArray2 = messageDigest.digest(byArray);
        }
        return byArray2;
    }

    public int getMaxDataSize() {
        return this.maxDataSize;
    }

    public byte[] pad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        return this.pad(RSACore.convert(byArray, n2, n3));
    }

    public byte[] pad(byte[] byArray) throws BadPaddingException {
        if (byArray.length > this.maxDataSize) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Data must be shorter than " + (this.maxDataSize + 1) + " bytes"));
        }
        switch (this.type) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.padV15(byArray);
            }
            case 4: {
                return this.padOAEP(byArray);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
    }

    public byte[] unpad(byte[] byArray, int n2, int n3) throws BadPaddingException {
        return this.unpad(RSACore.convert(byArray, n2, n3));
    }

    public byte[] unpad(byte[] byArray) throws BadPaddingException {
        if (byArray.length != this.paddedSize) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Padded length must be " + this.paddedSize));
        }
        switch (this.type) {
            case 3: {
                return byArray;
            }
            case 1: 
            case 2: {
                return this.unpadV15(byArray);
            }
            case 4: {
                return this.unpadOAEP(byArray);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError());
    }

    private byte[] padV15(byte[] byArray) throws BadPaddingException {
        byte[] byArray2 = new byte[this.paddedSize];
        a.arraycopy((Object)byArray, (int)0, (Object)byArray2, (int)(this.paddedSize - byArray.length), (int)byArray.length);
        int n2 = this.paddedSize - 3 - byArray.length;
        int n3 = 0;
        byArray2[n3++] = 0;
        byArray2[n3++] = (byte)this.type;
        if (this.type == 1) {
            while (n2-- > 0) {
                byArray2[n3++] = -1;
            }
        } else {
            if (this.random == null) {
                this.random = JCAUtil.getSecureRandom();
            }
            byte[] byArray3 = new byte[64];
            int n4 = -1;
            while (n2-- > 0) {
                int n5;
                do {
                    if (n4 >= 0) continue;
                    this.random.nextBytes(byArray3);
                    n4 = byArray3.length - 1;
                } while ((n5 = byArray3[n4--] & 0xFF) == 0);
                byArray2[n3++] = (byte)n5;
            }
        }
        return byArray2;
    }

    private byte[] unpadV15(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3 = 0;
        if (byArray[n3++] != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Data must start with zero"));
        }
        if (byArray[n3++] != this.type) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Blocktype mismatch: " + byArray[1]));
        }
        while ((n2 = byArray[n3++] & 0xFF) != 0) {
            if (n3 == byArray.length) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Padding string not terminated"));
            }
            if (this.type != 1 || n2 == 255) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Padding byte not 0xff: " + n2));
        }
        n2 = byArray.length - n3;
        if (n2 > this.maxDataSize) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Padding string too short"));
        }
        byte[] byArray2 = new byte[n2];
        a.arraycopy((Object)byArray, (int)(byArray.length - n2), (Object)byArray2, (int)0, (int)n2);
        return byArray2;
    }

    private byte[] padOAEP(byte[] byArray) throws BadPaddingException {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        int n2 = this.lHash.length;
        byte[] byArray2 = new byte[n2];
        this.random.nextBytes(byArray2);
        byte[] byArray3 = new byte[this.paddedSize];
        int n3 = 1;
        int n4 = n2;
        a.arraycopy((Object)byArray2, (int)0, (Object)byArray3, (int)n3, (int)n4);
        int n5 = n2 + 1;
        int n6 = byArray3.length - n5;
        int n7 = this.paddedSize - byArray.length;
        a.arraycopy((Object)this.lHash, (int)0, (Object)byArray3, (int)n5, (int)n2);
        byArray3[n7 - 1] = 1;
        a.arraycopy((Object)byArray, (int)0, (Object)byArray3, (int)n7, (int)byArray.length);
        this.mgf1(byArray3, n3, n4, byArray3, n5, n6);
        this.mgf1(byArray3, n5, n6, byArray3, n3, n4);
        return byArray3;
    }

    private byte[] unpadOAEP(byte[] byArray) throws BadPaddingException {
        int n2;
        byte[] byArray2 = byArray;
        int n3 = this.lHash.length;
        if (byArray2[0] != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Data must start with zero"));
        }
        int n4 = 1;
        int n5 = n3;
        int n6 = n3 + 1;
        int n7 = byArray2.length - n6;
        this.mgf1(byArray2, n6, n7, byArray2, n4, n5);
        this.mgf1(byArray2, n4, n5, byArray2, n6, n7);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.lHash[n2] == byArray2[n6 + n2]) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("lHash mismatch"));
        }
        n2 = n6 + n3;
        while (byArray2[n2] == 0) {
            if (++n2 < byArray2.length) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Padding string not terminated"));
        }
        if (byArray2[n2++] != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException("Padding string not terminated by 0x01 byte"));
        }
        int n8 = byArray2.length - n2;
        byte[] byArray3 = new byte[n8];
        a.arraycopy((Object)byArray2, (int)n2, (Object)byArray3, (int)0, (int)n8);
        return byArray3;
    }

    private void mgf1(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) throws BadPaddingException {
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[20];
        block2: while (n5 > 0) {
            this.mgfMd.update(byArray, n2, n3);
            this.mgfMd.update(byArray3);
            try {
                this.mgfMd.digest(byArray4, 0, byArray4.length);
            }
            catch (DigestException digestException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new BadPaddingException(digestException.toString()));
            }
            int n6 = 0;
            while (n6 < byArray4.length && n5 > 0) {
                int n7 = n4++;
                byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n6++]);
                --n5;
            }
            if (n5 <= 0) continue;
            n6 = byArray3.length - 1;
            while (true) {
                int n8 = --n6;
                byArray3[n8] = (byte)(byArray3[n8] + 1);
                if (byArray3[n8] != 0 || n6 <= 0) continue block2;
            }
        }
    }

    private static /* synthetic */ int _jr$ig$type(RSAPadding rSAPadding) {
        return rSAPadding.type;
    }

    private static /* synthetic */ void _jr$ip$type(RSAPadding rSAPadding, int n2) {
        rSAPadding.type = n2;
    }

    private static /* synthetic */ int _jr$ig$paddedSize(RSAPadding rSAPadding) {
        return rSAPadding.paddedSize;
    }

    private static /* synthetic */ void _jr$ip$paddedSize(RSAPadding rSAPadding, int n2) {
        rSAPadding.paddedSize = n2;
    }

    private static /* synthetic */ SecureRandom _jr$ig$random(RSAPadding rSAPadding) {
        return rSAPadding.random;
    }

    private static /* synthetic */ void _jr$ip$random(RSAPadding rSAPadding, SecureRandom secureRandom) {
        rSAPadding.random = secureRandom;
    }

    private static /* synthetic */ int _jr$ig$maxDataSize(RSAPadding rSAPadding) {
        return rSAPadding.maxDataSize;
    }

    private static /* synthetic */ void _jr$ip$maxDataSize(RSAPadding rSAPadding, int n2) {
        rSAPadding.maxDataSize = n2;
    }

    private static /* synthetic */ MessageDigest _jr$ig$md(RSAPadding rSAPadding) {
        return rSAPadding.md;
    }

    private static /* synthetic */ void _jr$ip$md(RSAPadding rSAPadding, MessageDigest messageDigest) {
        rSAPadding.md = messageDigest;
    }

    private static /* synthetic */ MessageDigest _jr$ig$mgfMd(RSAPadding rSAPadding) {
        return rSAPadding.mgfMd;
    }

    private static /* synthetic */ void _jr$ip$mgfMd(RSAPadding rSAPadding, MessageDigest messageDigest) {
        rSAPadding.mgfMd = messageDigest;
    }

    private static /* synthetic */ byte[] _jr$ig$lHash(RSAPadding rSAPadding) {
        return rSAPadding.lHash;
    }

    private static /* synthetic */ void _jr$ip$lHash(RSAPadding rSAPadding, byte[] byArray) {
        rSAPadding.lHash = byArray;
    }
}

