/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateCrtKeyImpl
extends PKCS8Key
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -1326088454257084918L;
    private BigInteger n;
    private BigInteger e;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger pe;
    private BigInteger qe;
    private BigInteger coeff;
    static final AlgorithmId rsaId = new AlgorithmId(AlgorithmId.RSAEncryption_oid);

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl = new RSAPrivateCrtKeyImpl(byArray);
        if (rSAPrivateCrtKeyImpl.getPublicExponent().signum() == 0) {
            return new RSAPrivateKeyImpl(rSAPrivateCrtKeyImpl.getModulus(), rSAPrivateCrtKeyImpl.getPrivateExponent());
        }
        return rSAPrivateCrtKeyImpl;
    }

    RSAPrivateCrtKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
    }

    RSAPrivateCrtKeyImpl(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) throws InvalidKeyException {
        this.n = bigInteger;
        this.e = bigInteger2;
        this.d = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.pe = bigInteger6;
        this.qe = bigInteger7;
        this.coeff = bigInteger8;
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        this.algid = rsaId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(0);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            derOutputStream.putInteger(bigInteger3);
            derOutputStream.putInteger(bigInteger4);
            derOutputStream.putInteger(bigInteger5);
            derOutputStream.putInteger(bigInteger6);
            derOutputStream.putInteger(bigInteger7);
            derOutputStream.putInteger(bigInteger8);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException(iOException));
        }
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.p;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.q;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.pe;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.qe;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.coeff;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (DerValue._jr$ig$tag((Object)derValue) != 48) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Not a SEQUENCE"));
            }
            DerInputStream derInputStream2 = DerValue._jr$ig$data((Object)derValue);
            int n2 = derInputStream2.getInteger();
            if (n2 != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Version must be 0"));
            }
            this.n = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.e = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.d = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.p = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.q = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.pe = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.qe = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.coeff = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Extra data available"));
            }
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid RSA private key", iOException));
        }
    }

    static BigInteger getBigInteger(DerInputStream derInputStream) throws IOException {
        BigInteger bigInteger = derInputStream.getBigInteger();
        if (bigInteger.signum() < 0) {
            bigInteger = new BigInteger(1, bigInteger.toByteArray());
        }
        return bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$n(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.n;
    }

    private static /* synthetic */ void _jr$ip$n(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.n = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$e(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.e;
    }

    private static /* synthetic */ void _jr$ip$e(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.e = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$d(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.d;
    }

    private static /* synthetic */ void _jr$ip$d(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.d = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$p(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.p;
    }

    private static /* synthetic */ void _jr$ip$p(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.p = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$q(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.q;
    }

    private static /* synthetic */ void _jr$ip$q(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.q = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$pe(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.pe;
    }

    private static /* synthetic */ void _jr$ip$pe(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.pe = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$qe(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.qe;
    }

    private static /* synthetic */ void _jr$ip$qe(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.qe = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$coeff(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl) {
        return rSAPrivateCrtKeyImpl.coeff;
    }

    private static /* synthetic */ void _jr$ip$coeff(RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, BigInteger bigInteger) {
        rSAPrivateCrtKeyImpl.coeff = bigInteger;
    }
}

