/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.RSAPublicKey;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.X509Key;

public final class RSAPublicKeyImpl
extends X509Key
implements RSAPublicKey {
    private static final long serialVersionUID = 2644735423591199609L;
    private BigInteger n;
    private BigInteger e;

    public RSAPublicKeyImpl(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.n = bigInteger;
        this.e = bigInteger2;
        RSAKeyFactory.checkRSAProviderKeyLengths(bigInteger.bitLength(), bigInteger2);
        this.algid = RSAPrivateCrtKeyImpl.rsaId;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException(iOException));
        }
    }

    public RSAPublicKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (DerValue._jr$ig$tag((Object)derValue) != 48) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Not a SEQUENCE"));
            }
            DerInputStream derInputStream2 = DerValue._jr$ig$data((Object)derValue);
            this.n = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            this.e = RSAPrivateCrtKeyImpl.getBigInteger(derInputStream2);
            if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Extra data available"));
            }
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Invalid RSA public key", iOException));
        }
    }

    @Override
    public String toString() {
        return "Sun RSA public key, " + this.n.bitLength() + " bits\n  modulus: " + this.n + "\n  public exponent: " + this.e;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private static /* synthetic */ BigInteger _jr$ig$n(RSAPublicKeyImpl rSAPublicKeyImpl) {
        return rSAPublicKeyImpl.n;
    }

    private static /* synthetic */ void _jr$ip$n(RSAPublicKeyImpl rSAPublicKeyImpl, BigInteger bigInteger) {
        rSAPublicKeyImpl.n = bigInteger;
    }

    private static /* synthetic */ BigInteger _jr$ig$e(RSAPublicKeyImpl rSAPublicKeyImpl) {
        return rSAPublicKeyImpl.e;
    }

    private static /* synthetic */ void _jr$ip$e(RSAPublicKeyImpl rSAPublicKeyImpl, BigInteger bigInteger) {
        rSAPublicKeyImpl.e = bigInteger;
    }
}

