/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public abstract class RSASignature
extends SignatureSpi {
    private static final int baseLength = 8;
    private final ObjectIdentifier digestOID;
    private final int encodedLength;
    private final MessageDigest md;
    private boolean digestReset;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private RSAPadding padding;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n2) {
        this.digestOID = objectIdentifier;
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderException(noSuchAlgorithmException));
        }
        this.digestReset = true;
        this.encodedLength = 8 + n2 + this.md.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)g.convertForCast((Object)RSAKeyFactory.toRSAKey(publicKey), RSAPublicKey.class);
        this.privateKey = null;
        this.publicKey = rSAPublicKey;
        this.initCommon(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)g.convertForCast((Object)RSAKeyFactory.toRSAKey(privateKey), RSAPrivateKey.class);
        this.privateKey = rSAPrivateKey;
        this.publicKey = null;
        this.initCommon(rSAPrivateKey, secureRandom);
    }

    private void initCommon(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.resetDigest();
        int n2 = RSACore.getByteLength(rSAKey);
        try {
            this.padding = RSAPadding.getInstance(1, n2, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException(invalidAlgorithmParameterException.getMessage()));
        }
        int n3 = this.padding.getMaxDataSize();
        if (this.encodedLength > n3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("Key is too short for this signature algorithm"));
        }
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.md.update(by);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.md.update(byArray, n2, n3);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.md.update(byteBuffer);
        this.digestReset = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.getDigestValue();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.digestOID, byArray);
            byte[] byArray3 = this.padding.pad(byArray2);
            byte[] byArray4 = RSACore.rsa(byArray3, this.privateKey);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Could not sign data", generalSecurityException));
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Could not encode data", iOException));
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.publicKey)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Signature length not correct: got " + byArray.length + " but was expecting " + RSACore.getByteLength(this.publicKey)));
        }
        byte[] byArray2 = this.getDigestValue();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.publicKey);
            byte[] byArray4 = this.padding.unpad(byArray3);
            byte[] byArray5 = RSASignature.decodeSignature(this.digestOID, byArray4);
            return Arrays.equals(byArray2, byArray5);
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Signature verification failed", generalSecurityException));
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Signature encoding error", iOException));
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2 || derInputStream.available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("SEQUENCE length error"));
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[0]);
        if (!algorithmId.getOID().equals(objectIdentifier)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier mismatch: " + algorithmId.getOID()));
        }
        if (algorithmId.getEncodedParams() != null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unexpected AlgorithmId parameters"));
        }
        byte[] byArray2 = derValueArray[1].getOctetString();
        return byArray2;
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("setParameter() not supported"));
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException("getParameter() not supported"));
    }

    private static /* synthetic */ void _jr$ip$digestOID(RSASignature rSASignature, ObjectIdentifier objectIdentifier) {
        rSASignature.digestOID = objectIdentifier;
    }

    private static /* synthetic */ void _jr$ip$encodedLength(RSASignature rSASignature, int n2) {
        rSASignature.encodedLength = n2;
    }

    private static /* synthetic */ void _jr$ip$md(RSASignature rSASignature, MessageDigest messageDigest) {
        rSASignature.md = messageDigest;
    }

    protected /* synthetic */ RSASignature(h h2) {
        super(h2);
    }

    public static final class MD2withRSA
    extends RSASignature {
        public MD2withRSA() {
            super("MD2", AlgorithmId.MD2_oid, 10);
        }
    }

    public static final class MD5withRSA
    extends RSASignature {
        public MD5withRSA() {
            super("MD5", AlgorithmId.MD5_oid, 10);
        }
    }

    public static final class SHA1withRSA
    extends RSASignature {
        public SHA1withRSA() {
            super("SHA-1", AlgorithmId.SHA_oid, 7);
        }
    }

    public static final class SHA256withRSA
    extends RSASignature {
        public SHA256withRSA() {
            super("SHA-256", AlgorithmId.SHA256_oid, 11);
        }
    }

    public static final class SHA384withRSA
    extends RSASignature {
        public SHA384withRSA() {
            super("SHA-384", AlgorithmId.SHA384_oid, 11);
        }
    }

    public static final class SHA512withRSA
    extends RSASignature {
        public SHA512withRSA() {
            super("SHA-512", AlgorithmId.SHA512_oid, 11);
        }
    }
}

