/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.X509KeyManagerImpl;

abstract class KeyManagerFactoryImpl
extends KeyManagerFactorySpi {
    X509ExtendedKeyManager keyManager;
    boolean isInitialized;

    KeyManagerFactoryImpl() {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (!((KeyManagerFactoryImpl)((Object)((Object)this))).isInitialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("KeyManagerFactoryImpl is not initialized"));
        }
        Object[] objectArray = new KeyManager[1];
        a.arrayStore((Object[])objectArray, (int)0, (Object)((KeyManagerFactoryImpl)((Object)((Object)this))).keyManager);
        return objectArray;
    }

    static /* synthetic */ void _jr$ip$keyManager(Object object, X509ExtendedKeyManager x509ExtendedKeyManager) {
        ((KeyManagerFactoryImpl)((Object)object)).keyManager = x509ExtendedKeyManager;
    }

    static /* synthetic */ void _jr$ip$isInitialized(Object object, boolean bl) {
        ((KeyManagerFactoryImpl)((Object)object)).isInitialized = bl;
    }

    protected /* synthetic */ KeyManagerFactoryImpl(h h2) {
        super(h2);
    }

    public static final class SunX509
    extends KeyManagerFactoryImpl {
        @Override
        protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keyStore != null && SunJSSE.isFIPS() && f.ifAcmp((Object)keyStore.getProvider(), (Object)SunJSSE.cryptoProvider)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("FIPS mode: KeyStore must be from provider " + SunJSSE.cryptoProvider.getName()));
            }
            this.keyManager = new SunX509KeyManagerImpl(keyStore, cArray);
            this.isInitialized = true;
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidAlgorithmParameterException("SunX509KeyManager does not use ManagerFactoryParameters"));
        }
    }

    public static final class X509
    extends KeyManagerFactoryImpl {
        @Override
        protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            if (keyStore == null) {
                this.keyManager = new X509KeyManagerImpl(Collections.emptyList());
            } else {
                if (SunJSSE.isFIPS() && f.ifAcmp((Object)keyStore.getProvider(), (Object)SunJSSE.cryptoProvider)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("FIPS mode: KeyStore must be from provider " + SunJSSE.cryptoProvider.getName()));
                }
                try {
                    KeyStore.Builder builder = KeyStore.Builder.newInstance(keyStore, new KeyStore.PasswordProtection(cArray));
                    this.keyManager = new X509KeyManagerImpl(builder);
                }
                catch (RuntimeException runtimeException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyStoreException("initialization failed", runtimeException));
                }
            }
            this.isInitialized = true;
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
            if (!(g.convertForInstanceOf((Object)managerFactoryParameters, KeyStoreBuilderParameters.class) instanceof KeyStoreBuilderParameters)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidAlgorithmParameterException("Parameters must be instance of KeyStoreBuilderParameters"));
            }
            if (SunJSSE.isFIPS()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidAlgorithmParameterException("FIPS mode: KeyStoreBuilderParameters not supported"));
            }
            List<KeyStore.Builder> list = ((KeyStoreBuilderParameters)g.convertForCast((Object)managerFactoryParameters, KeyStoreBuilderParameters.class)).getParameters();
            this.keyManager = new X509KeyManagerImpl(list);
            this.isInitialized = true;
        }
    }
}

