/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.h;
import sun.security.ssl.SunJSSE;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public final class ProtocolVersion
extends h
implements Comparable {
    static final int LIMIT_MAX_VALUE = 65535;
    static final int LIMIT_MIN_VALUE = 0;
    static final ProtocolVersion NONE = new ProtocolVersion(-1, "NONE");
    static final ProtocolVersion SSL20Hello = new ProtocolVersion(2, "SSLv2Hello");
    static final ProtocolVersion SSL30 = new ProtocolVersion(768, "SSLv3");
    static final ProtocolVersion TLS10 = new ProtocolVersion(769, "TLSv1");
    static final ProtocolVersion TLS11 = new ProtocolVersion(770, "TLSv1.1");
    static final ProtocolVersion TLS12 = new ProtocolVersion(771, "TLSv1.2");
    private static final boolean FIPS = SunJSSE.isFIPS();
    static final ProtocolVersion MIN = FIPS ? TLS10 : SSL30;
    static final ProtocolVersion MAX = TLS12;
    static final ProtocolVersion DEFAULT = TLS10;
    static final ProtocolVersion DEFAULT_HELLO = FIPS ? TLS10 : SSL30;
    public final int v;
    public final byte major;
    public final byte minor;
    final String name;

    private ProtocolVersion(int n, String string) {
        this.v = n;
        this.name = string;
        this.major = (byte)(n >>> 8);
        this.minor = (byte)(n & 0xFF);
    }

    private static ProtocolVersion valueOf(int n) {
        if (n == ProtocolVersion.SSL30.v) {
            return SSL30;
        }
        if (n == ProtocolVersion.TLS10.v) {
            return TLS10;
        }
        if (n == ProtocolVersion.TLS11.v) {
            return TLS11;
        }
        if (n == ProtocolVersion.TLS12.v) {
            return TLS12;
        }
        if (n == ProtocolVersion.SSL20Hello.v) {
            return SSL20Hello;
        }
        int n2 = n >>> 8 & 0xFF;
        int n3 = n & 0xFF;
        return new ProtocolVersion(n, "Unknown-" + n2 + "." + n3);
    }

    public static ProtocolVersion valueOf(int n, int n2) {
        int n3 = (n &= 0xFF) << 8 | (n2 &= 0xFF);
        return ProtocolVersion.valueOf(n3);
    }

    static ProtocolVersion valueOf(String string) {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Protocol cannot be null"));
        }
        if (FIPS && (string.equals(ProtocolVersion.SSL30.name) || string.equals(ProtocolVersion.SSL20Hello.name))) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Only TLS 1.0 or later allowed in FIPS mode"));
        }
        if (string.equals(ProtocolVersion.SSL30.name)) {
            return SSL30;
        }
        if (string.equals(ProtocolVersion.TLS10.name)) {
            return TLS10;
        }
        if (string.equals(ProtocolVersion.TLS11.name)) {
            return TLS11;
        }
        if (string.equals(ProtocolVersion.TLS12.name)) {
            return TLS12;
        }
        if (string.equals(ProtocolVersion.SSL20Hello.name)) {
            return SSL20Hello;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string));
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(ProtocolVersion protocolVersion) {
        return this.v - protocolVersion.v;
    }

    public static /* synthetic */ int _jr$ig$v(Object object) {
        return ((ProtocolVersion)object).v;
    }

    public static /* synthetic */ void _jr$ip$v(Object object, int n) {
        ((ProtocolVersion)object).v = n;
    }

    public static /* synthetic */ byte _jr$ig$major(Object object) {
        return ((ProtocolVersion)object).major;
    }

    public static /* synthetic */ void _jr$ip$major(Object object, byte by) {
        ((ProtocolVersion)object).major = by;
    }

    public static /* synthetic */ byte _jr$ig$minor(Object object) {
        return ((ProtocolVersion)object).minor;
    }

    public static /* synthetic */ void _jr$ip$minor(Object object, byte by) {
        ((ProtocolVersion)object).minor = by;
    }

    static /* synthetic */ String _jr$ig$name(Object object) {
        return ((ProtocolVersion)object).name;
    }

    static /* synthetic */ void _jr$ip$name(Object object, String string) {
        ((ProtocolVersion)object).name = string;
    }
}

