/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.j;
import com.zeroturnaround.jrebelbase.h;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import sun.security.ssl.CipherSuite;
import sun.security.util.DisabledAlgorithmConstraints;

final class SSLAlgorithmConstraints
extends h
implements AlgorithmConstraints {
    private static final AlgorithmConstraints tlsDisabledAlgConstraints = new TLSDisabledAlgConstraints();
    private static final AlgorithmConstraints x509DisabledAlgConstraints = new X509DisabledAlgConstraints();
    private AlgorithmConstraints userAlgConstraints = null;
    private AlgorithmConstraints peerAlgConstraints = null;
    private boolean enabledX509DisabledAlgConstraints = true;

    SSLAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.userAlgConstraints = algorithmConstraints;
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, boolean bl) {
        if (sSLSocket != null) {
            this.userAlgConstraints = sSLSocket.getSSLParameters().getAlgorithmConstraints();
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, boolean bl) {
        if (sSLEngine != null) {
            this.userAlgConstraints = sSLEngine.getSSLParameters().getAlgorithmConstraints();
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, String[] stringArray, boolean bl) {
        if (sSLSocket != null) {
            this.userAlgConstraints = sSLSocket.getSSLParameters().getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, String[] stringArray, boolean bl) {
        if (sSLEngine != null) {
            this.userAlgConstraints = sSLEngine.getSSLParameters().getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        return bl;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, Key key) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, key);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, key);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, key);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, key);
        }
        return bl;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        return bl;
    }

    private static /* synthetic */ AlgorithmConstraints _jr$ig$userAlgConstraints(SSLAlgorithmConstraints sSLAlgorithmConstraints) {
        return sSLAlgorithmConstraints.userAlgConstraints;
    }

    private static /* synthetic */ void _jr$ip$userAlgConstraints(SSLAlgorithmConstraints sSLAlgorithmConstraints, AlgorithmConstraints algorithmConstraints) {
        sSLAlgorithmConstraints.userAlgConstraints = algorithmConstraints;
    }

    private static /* synthetic */ AlgorithmConstraints _jr$ig$peerAlgConstraints(SSLAlgorithmConstraints sSLAlgorithmConstraints) {
        return sSLAlgorithmConstraints.peerAlgConstraints;
    }

    private static /* synthetic */ void _jr$ip$peerAlgConstraints(SSLAlgorithmConstraints sSLAlgorithmConstraints, AlgorithmConstraints algorithmConstraints) {
        sSLAlgorithmConstraints.peerAlgConstraints = algorithmConstraints;
    }

    private static /* synthetic */ boolean _jr$ig$enabledX509DisabledAlgConstraints(SSLAlgorithmConstraints sSLAlgorithmConstraints) {
        return sSLAlgorithmConstraints.enabledX509DisabledAlgConstraints;
    }

    private static /* synthetic */ void _jr$ip$enabledX509DisabledAlgConstraints(SSLAlgorithmConstraints sSLAlgorithmConstraints, boolean bl) {
        sSLAlgorithmConstraints.enabledX509DisabledAlgConstraints = bl;
    }

    static class 1
    extends h {
        static final /* synthetic */ int[] $SwitchMap$sun$security$ssl$CipherSuite$KeyExchange;

        static {
            CipherSuite.KeyExchange[] keyExchangeArray = CipherSuite.KeyExchange.values();
            j.registerSwitchClass(1.class, CipherSuite.KeyExchange.class, null);
            int[] nArray = new int[keyExchangeArray.length + 1];
            nArray[0] = -1;
            $SwitchMap$sun$security$ssl$CipherSuite$KeyExchange = nArray;
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_NULL.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_RSA.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_RSA_EXPORT.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DH_RSA.ordinal() + 1] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DH_DSS.ordinal() + 1] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DHE_DSS.ordinal() + 1] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DHE_RSA.ordinal() + 1] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DH_ANON.ordinal() + 1] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDH_ECDSA.ordinal() + 1] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDH_RSA.ordinal() + 1] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDHE_ECDSA.ordinal() + 1] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDHE_RSA.ordinal() + 1] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDH_ANON.ordinal() + 1] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_KRB5.ordinal() + 1] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_KRB5_EXPORT.ordinal() + 1] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        public static /* synthetic */ void _jr$$rebel_clinit() {
            CipherSuite.KeyExchange[] keyExchangeArray = CipherSuite.KeyExchange.values();
            j.registerSwitchClass(1.class, CipherSuite.KeyExchange.class, null);
            int[] nArray = new int[keyExchangeArray.length + 1];
            nArray[0] = -1;
            j.updateSwitchMap((int[])nArray, 1.class, (String)"$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange");
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_NULL.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_RSA.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_RSA_EXPORT.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DH_RSA.ordinal() + 1] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DH_DSS.ordinal() + 1] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DHE_DSS.ordinal() + 1] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DHE_RSA.ordinal() + 1] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_DH_ANON.ordinal() + 1] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDH_ECDSA.ordinal() + 1] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDH_RSA.ordinal() + 1] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDHE_ECDSA.ordinal() + 1] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDHE_RSA.ordinal() + 1] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_ECDH_ANON.ordinal() + 1] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_KRB5.ordinal() + 1] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[CipherSuite.KeyExchange.K_KRB5_EXPORT.ordinal() + 1] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        protected /* synthetic */ 1(h h2) {
            super(h2);
        }
    }

    private static class BasicDisabledAlgConstraints
    extends DisabledAlgorithmConstraints {
        BasicDisabledAlgConstraints(String string) {
            super(string);
        }

        protected Set<String> decomposes(CipherSuite.KeyExchange keyExchange, boolean bl) {
            HashSet<String> hashSet = new HashSet<String>();
            switch (1.$SwitchMap$sun$security$ssl$CipherSuite$KeyExchange[keyExchange.ordinal() + 1]) {
                case 1: {
                    if (bl) break;
                    hashSet.add("NULL");
                    break;
                }
                case 2: {
                    hashSet.add("RSA");
                    break;
                }
                case 3: {
                    hashSet.add("RSA");
                    hashSet.add("RSA_EXPORT");
                    break;
                }
                case 4: {
                    hashSet.add("RSA");
                    hashSet.add("DH");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DH_RSA");
                    break;
                }
                case 5: {
                    hashSet.add("DSA");
                    hashSet.add("DSS");
                    hashSet.add("DH");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DH_DSS");
                    break;
                }
                case 6: {
                    hashSet.add("DSA");
                    hashSet.add("DSS");
                    hashSet.add("DH");
                    hashSet.add("DHE");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DHE_DSS");
                    break;
                }
                case 7: {
                    hashSet.add("RSA");
                    hashSet.add("DH");
                    hashSet.add("DHE");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DHE_RSA");
                    break;
                }
                case 8: {
                    if (bl) break;
                    hashSet.add("ANON");
                    hashSet.add("DH");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DH_ANON");
                    break;
                }
                case 9: {
                    hashSet.add("ECDH");
                    hashSet.add("ECDSA");
                    hashSet.add("ECDH_ECDSA");
                    break;
                }
                case 10: {
                    hashSet.add("ECDH");
                    hashSet.add("RSA");
                    hashSet.add("ECDH_RSA");
                    break;
                }
                case 11: {
                    hashSet.add("ECDHE");
                    hashSet.add("ECDSA");
                    hashSet.add("ECDHE_ECDSA");
                    break;
                }
                case 12: {
                    hashSet.add("ECDHE");
                    hashSet.add("RSA");
                    hashSet.add("ECDHE_RSA");
                    break;
                }
                case 13: {
                    if (bl) break;
                    hashSet.add("ECDH");
                    hashSet.add("ANON");
                    hashSet.add("ECDH_ANON");
                    break;
                }
                case 14: {
                    if (bl) break;
                    hashSet.add("KRB5");
                    break;
                }
                case 15: {
                    if (bl) break;
                    hashSet.add("KRB5_EXPORT");
                    break;
                }
            }
            return hashSet;
        }

        protected Set<String> decomposes(CipherSuite.BulkCipher bulkCipher) {
            HashSet<String> hashSet = new HashSet<String>();
            if (CipherSuite.BulkCipher._jr$ig$transformation((Object)bulkCipher) != null) {
                hashSet.addAll(super.decomposes(CipherSuite.BulkCipher._jr$ig$transformation((Object)bulkCipher)));
            }
            return hashSet;
        }

        protected Set<String> decomposes(CipherSuite.MacAlg macAlg) {
            HashSet<String> hashSet = new HashSet<String>();
            if (!f.ifAcmp((Object)((Object)macAlg), (Object)((Object)CipherSuite.M_MD5))) {
                hashSet.add("MD5");
                hashSet.add("HmacMD5");
            } else if (!f.ifAcmp((Object)((Object)macAlg), (Object)((Object)CipherSuite.M_SHA))) {
                hashSet.add("SHA1");
                hashSet.add("SHA-1");
                hashSet.add("HmacSHA1");
            } else if (!f.ifAcmp((Object)((Object)macAlg), (Object)((Object)CipherSuite.M_SHA256))) {
                hashSet.add("SHA256");
                hashSet.add("SHA-256");
                hashSet.add("HmacSHA256");
            } else if (!f.ifAcmp((Object)((Object)macAlg), (Object)((Object)CipherSuite.M_SHA384))) {
                hashSet.add("SHA384");
                hashSet.add("SHA-384");
                hashSet.add("HmacSHA384");
            }
            return hashSet;
        }

        protected /* synthetic */ BasicDisabledAlgConstraints(h h2) {
            super(h2);
        }
    }

    private static class SupportedSignatureAlgorithmConstraints
    extends h
    implements AlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] stringArray) {
            this.supportedAlgorithms = stringArray != null ? (String[])a.cloneArray((Object)stringArray) : null;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No algorithm name specified"));
            }
            if (set == null || set.isEmpty()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No cryptographic primitive specified"));
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int n2 = string.indexOf("and");
            if (n2 > 0) {
                string = string.substring(0, n2);
            }
            for (String string2 : this.supportedAlgorithms) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> set, Key key) {
            return true;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No algorithm name specified"));
            }
            return this.permits(set, string, algorithmParameters);
        }

        private static /* synthetic */ void _jr$ip$supportedAlgorithms(SupportedSignatureAlgorithmConstraints supportedSignatureAlgorithmConstraints, String[] stringArray) {
            supportedSignatureAlgorithmConstraints.supportedAlgorithms = stringArray;
        }

        protected /* synthetic */ SupportedSignatureAlgorithmConstraints(h h2) {
            super(h2);
        }
    }

    private static class TLSDisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        TLSDisabledAlgConstraints() {
            super("jdk.tls.disabledAlgorithms");
        }

        @Override
        protected Set<String> decomposes(String string) {
            if (string.startsWith("SSL_") || string.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    if (CipherSuite._jr$ig$keyExchange(cipherSuite) != null) {
                        hashSet.addAll(this.decomposes(CipherSuite._jr$ig$keyExchange(cipherSuite), false));
                    }
                    if (CipherSuite._jr$ig$cipher(cipherSuite) != null) {
                        hashSet.addAll(this.decomposes(CipherSuite._jr$ig$cipher(cipherSuite)));
                    }
                    if (CipherSuite._jr$ig$macAlg(cipherSuite) != null) {
                        hashSet.addAll(this.decomposes(CipherSuite._jr$ig$macAlg(cipherSuite)));
                    }
                    return hashSet;
                }
            }
            return super.decomposes(string);
        }

        protected /* synthetic */ TLSDisabledAlgConstraints(h h2) {
            super(h2);
        }
    }

    private static class X509DisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        X509DisabledAlgConstraints() {
            super("jdk.certpath.disabledAlgorithms");
        }

        @Override
        protected Set<String> decomposes(String string) {
            if (string.startsWith("SSL_") || string.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    if (CipherSuite._jr$ig$keyExchange(cipherSuite) != null) {
                        hashSet.addAll(this.decomposes(CipherSuite._jr$ig$keyExchange(cipherSuite), true));
                    }
                    return hashSet;
                }
            }
            return super.decomposes(string);
        }

        protected /* synthetic */ X509DisabledAlgConstraints(h h2) {
            super(h2);
        }
    }
}

