/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.AbstractKeyManagerWrapper;
import sun.security.ssl.AbstractTrustManagerWrapper;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.DummyX509KeyManager;
import sun.security.ssl.DummyX509TrustManager;
import sun.security.ssl.EphemeralKeyManager;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLServerSocketFactoryImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSocketFactoryImpl;
import sun.security.ssl.SunJSSE;
import sun.security.ssl.SunX509KeyManagerImpl;
import sun.security.ssl.TrustManagerFactoryImpl;
import sun.security.ssl.X509KeyManagerImpl;
import sun.security.ssl.X509TrustManagerImpl;

public abstract class SSLContextImpl
extends SSLContextSpi {
    private static final Debug debug = Debug.getInstance("ssl");
    private final EphemeralKeyManager ephemeralKeyManager;
    private final SSLSessionContextImpl clientCache;
    private final SSLSessionContextImpl serverCache;
    private boolean isInitialized;
    private X509ExtendedKeyManager keyManager;
    private X509TrustManager trustManager;
    private SecureRandom secureRandom;
    private AlgorithmConstraints defaultAlgorithmConstraints;
    private ProtocolList defaultServerProtocolList;
    private ProtocolList defaultClientProtocolList;
    private ProtocolList supportedProtocolList;
    private CipherSuiteList defaultServerCipherSuiteList;
    private CipherSuiteList defaultClientCipherSuiteList;
    private CipherSuiteList supportedCipherSuiteList;

    SSLContextImpl() {
        this.defaultAlgorithmConstraints = new SSLAlgorithmConstraints(null);
        this.ephemeralKeyManager = new EphemeralKeyManager();
        this.clientCache = new SSLSessionContextImpl();
        this.serverCache = new SSLSessionContextImpl();
    }

    @Override
    protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.isInitialized = false;
        this.keyManager = this.chooseKeyManager(keyManagerArray);
        if (trustManagerArray == null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)((Object)g.convertForCast(null, KeyStore.class)));
                trustManagerArray = trustManagerFactory.getTrustManagers();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.trustManager = this.chooseTrustManager(trustManagerArray);
        if (secureRandom == null) {
            this.secureRandom = JsseJce.getSecureRandom();
        } else {
            if (SunJSSE.isFIPS() && f.ifAcmp((Object)secureRandom.getProvider(), (Object)SunJSSE.cryptoProvider)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyManagementException("FIPS mode: SecureRandom must be from provider " + SunJSSE.cryptoProvider.getName()));
            }
            this.secureRandom = secureRandom;
        }
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("trigger seeding of SecureRandom");
        }
        this.secureRandom.nextInt();
        if (debug != null && Debug.isOn("sslctx")) {
            System.out.println("done seeding SecureRandom");
        }
        this.isInitialized = true;
    }

    private X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        for (int i = 0; trustManagerArray != null && i < a.arrayLength((Object[])trustManagerArray); ++i) {
            if (!(g.convertForInstanceOf((Object)((TrustManager)g.convertForCast((Object)a.arrayLoad((Object[])trustManagerArray, (int)i), TrustManager.class)), X509TrustManager.class) instanceof X509TrustManager)) continue;
            if (SunJSSE.isFIPS() && !(g.convertForInstanceOf((Object)((TrustManager)g.convertForCast((Object)a.arrayLoad((Object[])trustManagerArray, (int)i), TrustManager.class)), X509TrustManagerImpl.class) instanceof X509TrustManagerImpl)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyManagementException("FIPS mode: only SunJSSE TrustManagers may be used"));
            }
            if (g.convertForInstanceOf((Object)((TrustManager)g.convertForCast((Object)a.arrayLoad((Object[])trustManagerArray, (int)i), TrustManager.class)), X509ExtendedTrustManager.class) instanceof X509ExtendedTrustManager) {
                return (X509TrustManager)g.convertForCast((Object)((TrustManager)g.convertForCast((Object)a.arrayLoad((Object[])trustManagerArray, (int)i), TrustManager.class)), X509TrustManager.class);
            }
            return new AbstractTrustManagerWrapper((X509TrustManager)g.convertForCast((Object)((TrustManager)g.convertForCast((Object)a.arrayLoad((Object[])trustManagerArray, (int)i), TrustManager.class)), X509TrustManager.class));
        }
        return DummyX509TrustManager.INSTANCE;
    }

    private X509ExtendedKeyManager chooseKeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        for (int i = 0; keyManagerArray != null && i < a.arrayLength((Object[])keyManagerArray); ++i) {
            KeyManager keyManager = (KeyManager)g.convertForCast((Object)a.arrayLoad((Object[])keyManagerArray, (int)i), KeyManager.class);
            if (!(g.convertForInstanceOf((Object)keyManager, X509KeyManager.class) instanceof X509KeyManager)) continue;
            if (SunJSSE.isFIPS()) {
                if (g.convertForInstanceOf((Object)keyManager, X509KeyManagerImpl.class) instanceof X509KeyManagerImpl || g.convertForInstanceOf((Object)keyManager, SunX509KeyManagerImpl.class) instanceof SunX509KeyManagerImpl) {
                    return (X509ExtendedKeyManager)g.convertForCast((Object)keyManager, X509ExtendedKeyManager.class);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyManagementException("FIPS mode: only SunJSSE KeyManagers may be used"));
            }
            if (g.convertForInstanceOf((Object)keyManager, X509ExtendedKeyManager.class) instanceof X509ExtendedKeyManager) {
                return (X509ExtendedKeyManager)g.convertForCast((Object)keyManager, X509ExtendedKeyManager.class);
            }
            if (debug != null && Debug.isOn("sslctx")) {
                System.out.println("X509KeyManager passed to SSLContext.init():  need an X509ExtendedKeyManager for SSLEngine use");
            }
            return new AbstractKeyManagerWrapper((X509KeyManager)g.convertForCast((Object)keyManager, X509KeyManager.class));
        }
        return DummyX509KeyManager.INSTANCE;
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        if (!this.isInitialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("SSLContextImpl is not initialized"));
        }
        return new SSLSocketFactoryImpl(this);
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.isInitialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("SSLContext is not initialized"));
        }
        return new SSLServerSocketFactoryImpl(this);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        if (!this.isInitialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("SSLContextImpl is not initialized"));
        }
        return new SSLEngineImpl(this);
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String string, int n) {
        if (!this.isInitialized) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalStateException("SSLContextImpl is not initialized"));
        }
        return new SSLEngineImpl(this, string, n);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.clientCache;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.serverCache;
    }

    SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    X509ExtendedKeyManager getX509KeyManager() {
        return this.keyManager;
    }

    X509TrustManager getX509TrustManager() {
        return this.trustManager;
    }

    EphemeralKeyManager getEphemeralKeyManager() {
        return this.ephemeralKeyManager;
    }

    abstract SSLParameters getDefaultServerSSLParams();

    abstract SSLParameters getDefaultClientSSLParams();

    abstract SSLParameters getSupportedSSLParams();

    ProtocolList getSuportedProtocolList() {
        if (this.supportedProtocolList == null) {
            this.supportedProtocolList = new ProtocolList(this.getSupportedSSLParams().getProtocols());
        }
        return this.supportedProtocolList;
    }

    ProtocolList getDefaultProtocolList(boolean bl) {
        if (bl) {
            if (this.defaultServerProtocolList == null) {
                this.defaultServerProtocolList = new ProtocolList(this.getDefaultServerSSLParams().getProtocols());
            }
            return this.defaultServerProtocolList;
        }
        if (this.defaultClientProtocolList == null) {
            this.defaultClientProtocolList = new ProtocolList(this.getDefaultClientSSLParams().getProtocols());
        }
        return this.defaultClientProtocolList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherSuiteList getSupportedCipherSuiteList() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.clearAvailableCache();
                if (this.supportedCipherSuiteList == null) {
                    this.supportedCipherSuiteList = this.getApplicableCipherSuiteList(this.getSuportedProtocolList(), false);
                }
                return this.supportedCipherSuiteList;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CipherSuiteList getDefaultCipherSuiteList(boolean bl) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.clearAvailableCache();
                if (bl) {
                    if (this.defaultServerCipherSuiteList == null) {
                        this.defaultServerCipherSuiteList = this.getApplicableCipherSuiteList(this.getDefaultProtocolList(true), true);
                    }
                    return this.defaultServerCipherSuiteList;
                }
                if (this.defaultClientCipherSuiteList == null) {
                    this.defaultClientCipherSuiteList = this.getApplicableCipherSuiteList(this.getDefaultProtocolList(false), true);
                }
                return this.defaultClientCipherSuiteList;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    boolean isDefaultProtocolList(ProtocolList protocolList) {
        return !f.ifAcmp((Object)protocolList, (Object)this.defaultServerProtocolList) || !f.ifAcmp((Object)protocolList, (Object)this.defaultClientProtocolList);
    }

    private CipherSuiteList getApplicableCipherSuiteList(ProtocolList protocolList, boolean bl) {
        int n = 1;
        if (bl) {
            n = 300;
        }
        Collection<CipherSuite> collection = CipherSuite.allowedCipherSuites();
        TreeSet<CipherSuite> treeSet = new TreeSet<CipherSuite>();
        if (!protocolList.collection().isEmpty() && ProtocolList._jr$ig$min((Object)protocolList).v != ProtocolVersion.NONE.v) {
            Iterator<CipherSuite> iterator = collection.iterator();
            while (iterator.hasNext()) {
                CipherSuite cipherSuite = (CipherSuite)g.convertForCast((Object)iterator.next(), CipherSuite.class);
                if (!CipherSuite._jr$ig$allowed(cipherSuite) || CipherSuite._jr$ig$priority(cipherSuite) < n) continue;
                if (cipherSuite.isAvailable() && CipherSuite._jr$ig$obsoleted(cipherSuite) > ProtocolList._jr$ig$min((Object)protocolList).v && CipherSuite._jr$ig$supported(cipherSuite) <= ProtocolList._jr$ig$max((Object)protocolList).v) {
                    if (!this.defaultAlgorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), CipherSuite._jr$ig$name(cipherSuite), null)) continue;
                    treeSet.add(cipherSuite);
                    continue;
                }
                if (debug == null || !Debug.isOn("sslctx") || !Debug.isOn("verbose")) continue;
                if (CipherSuite._jr$ig$obsoleted(cipherSuite) <= ProtocolList._jr$ig$min((Object)protocolList).v) {
                    System.out.println("Ignoring obsoleted cipher suite: " + cipherSuite);
                    continue;
                }
                if (CipherSuite._jr$ig$supported(cipherSuite) > ProtocolList._jr$ig$max((Object)protocolList).v) {
                    System.out.println("Ignoring unsupported cipher suite: " + cipherSuite);
                    continue;
                }
                System.out.println("Ignoring unavailable cipher suite: " + cipherSuite);
            }
        }
        return new CipherSuiteList(treeSet);
    }

    private void clearAvailableCache() {
        this.supportedCipherSuiteList = null;
        this.defaultServerCipherSuiteList = null;
        this.defaultClientCipherSuiteList = null;
        CipherSuite.BulkCipher.clearAvailableCache();
        JsseJce.clearEcAvailable();
    }

    private static /* synthetic */ void _jr$ip$ephemeralKeyManager(SSLContextImpl sSLContextImpl, EphemeralKeyManager ephemeralKeyManager) {
        sSLContextImpl.ephemeralKeyManager = ephemeralKeyManager;
    }

    private static /* synthetic */ void _jr$ip$clientCache(SSLContextImpl sSLContextImpl, SSLSessionContextImpl sSLSessionContextImpl) {
        sSLContextImpl.clientCache = sSLSessionContextImpl;
    }

    private static /* synthetic */ void _jr$ip$serverCache(SSLContextImpl sSLContextImpl, SSLSessionContextImpl sSLSessionContextImpl) {
        sSLContextImpl.serverCache = sSLSessionContextImpl;
    }

    private static /* synthetic */ void _jr$ip$defaultAlgorithmConstraints(SSLContextImpl sSLContextImpl, AlgorithmConstraints algorithmConstraints) {
        sSLContextImpl.defaultAlgorithmConstraints = algorithmConstraints;
    }

    protected /* synthetic */ SSLContextImpl(h h2) {
        super(h2);
    }

    private static class ConservativeSSLContext
    extends SSLContextImpl {
        private static SSLParameters defaultServerSSLParams;
        private static SSLParameters defaultClientSSLParams;
        private static SSLParameters supportedSSLParams;

        private ConservativeSSLContext() {
        }

        @Override
        SSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        SSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        @Override
        SSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name});
            } else {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name});
            }
        }

        protected /* synthetic */ ConservativeSSLContext(h h2) {
            super(h2);
        }
    }

    public static final class DefaultSSLContext
    extends ConservativeSSLContext {
        private static final String NONE = "NONE";
        private static final String P11KEYSTORE = "PKCS11";
        private static volatile SSLContextImpl defaultImpl;
        private static TrustManager[] defaultTrustManagers;
        private static KeyManager[] defaultKeyManagers;

        public DefaultSSLContext() throws Exception {
            try {
                super.engineInit(DefaultSSLContext.getDefaultKeyManager(), DefaultSSLContext.getDefaultTrustManager(), null);
            }
            catch (Exception exception) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("default context init failed: " + exception);
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)exception);
            }
            if (defaultImpl == null) {
                defaultImpl = this;
            }
        }

        @Override
        protected void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new KeyManagementException("Default SSLContext is initialized automatically"));
        }

        static synchronized SSLContextImpl getDefaultImpl() throws Exception {
            if (defaultImpl == null) {
                new DefaultSSLContext();
            }
            return defaultImpl;
        }

        private static synchronized TrustManager[] getDefaultTrustManager() throws Exception {
            if (defaultTrustManagers != null) {
                return defaultTrustManagers;
            }
            KeyStore keyStore = TrustManagerFactoryImpl.getCacertsKeyStore("defaultctx");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            defaultTrustManagers = trustManagerFactory.getTrustManagers();
            return defaultTrustManagers;
        }

        private static synchronized KeyManager[] getDefaultKeyManager() throws Exception {
            if (defaultKeyManagers != null) {
                return defaultKeyManagers;
            }
            HashMap hashMap = new HashMap();
            AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
            String string = (String)hashMap.get("keyStore");
            String string2 = (String)hashMap.get("keyStoreType");
            String string3 = (String)hashMap.get("keyStoreProvider");
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("keyStore is : " + string);
                System.out.println("keyStore type is : " + string2);
                System.out.println("keyStore provider is : " + string3);
            }
            if (P11KEYSTORE.equals(string2) && !NONE.equals(string)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("if keyStoreType is PKCS11, then keyStore must be NONE"));
            }
            FileInputStream fileInputStream = null;
            if (string.length() != 0 && !NONE.equals(string)) {
                fileInputStream = (FileInputStream)g.convertForCast(AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */), FileInputStream.class);
            }
            String string4 = (String)hashMap.get("keyStorePasswd");
            char[] cArray = null;
            if (string4.length() != 0) {
                cArray = string4.toCharArray();
            }
            KeyStore keyStore = null;
            if (string2.length() != 0) {
                if (debug != null && Debug.isOn("defaultctx")) {
                    System.out.println("init keystore");
                }
                keyStore = string3.length() == 0 ? KeyStore.getInstance(string2) : KeyStore.getInstance(string2, string3);
                keyStore.load(fileInputStream, cArray);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
                fileInputStream = null;
            }
            if (debug != null && Debug.isOn("defaultctx")) {
                System.out.println("init keymanager of type " + KeyManagerFactory.getDefaultAlgorithm());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (P11KEYSTORE.equals(string2)) {
                keyManagerFactory.init(keyStore, null);
            } else {
                keyManagerFactory.init(keyStore, cArray);
            }
            defaultKeyManagers = keyManagerFactory.getKeyManagers();
            return defaultKeyManagers;
        }
    }

    public static final class TLS10Context
    extends ConservativeSSLContext {
    }

    public static final class TLS11Context
    extends SSLContextImpl {
        private static SSLParameters defaultServerSSLParams;
        private static SSLParameters defaultClientSSLParams;
        private static SSLParameters supportedSSLParams;

        @Override
        SSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        SSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        @Override
        SSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name});
            } else {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name});
            }
        }
    }

    public static final class TLS12Context
    extends SSLContextImpl {
        private static SSLParameters defaultServerSSLParams;
        private static SSLParameters defaultClientSSLParams;
        private static SSLParameters supportedSSLParams;

        @Override
        SSLParameters getDefaultServerSSLParams() {
            return defaultServerSSLParams;
        }

        @Override
        SSLParameters getDefaultClientSSLParams() {
            return defaultClientSSLParams;
        }

        @Override
        SSLParameters getSupportedSSLParams() {
            return supportedSSLParams;
        }

        static {
            if (SunJSSE.isFIPS()) {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
            } else {
                supportedSSLParams = new SSLParameters();
                supportedSSLParams.setProtocols(new String[]{ProtocolVersion.SSL20Hello.name, ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
                defaultServerSSLParams = supportedSSLParams;
                defaultClientSSLParams = new SSLParameters();
                defaultClientSSLParams.setProtocols(new String[]{ProtocolVersion.SSL30.name, ProtocolVersion.TLS10.name, ProtocolVersion.TLS11.name, ProtocolVersion.TLS12.name});
            }
        }
    }
}

