/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import sun.security.ssl.Debug;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SessionId;
import sun.security.util.Cache;

final class SSLSessionContextImpl
extends h
implements SSLSessionContext {
    private Cache sessionCache;
    private Cache sessionHostPortCache;
    private int cacheLimit = this.getDefaultCacheLimit();
    private int timeout = 86400;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSessionContextImpl() {
        this.sessionCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
        this.sessionHostPortCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("session id cannot be null"));
        }
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)g.convertForCast((Object)this.sessionCache.get(new SessionId(byArray)), SSLSessionImpl.class);
        if (!this.isTimedout(sSLSessionImpl)) {
            return sSLSessionImpl;
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        SessionCacheVisitor sessionCacheVisitor = new SessionCacheVisitor();
        this.sessionCache.accept(sessionCacheVisitor);
        return sessionCacheVisitor.getSessionIds();
    }

    @Override
    public void setSessionTimeout(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (this.timeout != n) {
            this.sessionCache.setTimeout(n);
            this.sessionHostPortCache.setTimeout(n);
            this.timeout = n;
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.timeout;
    }

    @Override
    public void setSessionCacheSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (this.cacheLimit != n) {
            this.sessionCache.setCapacity(n);
            this.sessionHostPortCache.setCapacity(n);
            this.cacheLimit = n;
        }
    }

    @Override
    public int getSessionCacheSize() {
        return this.cacheLimit;
    }

    SSLSessionImpl get(byte[] byArray) {
        return (SSLSessionImpl)g.convertForCast((Object)this.getSession(byArray), SSLSessionImpl.class);
    }

    SSLSessionImpl get(String string, int n) {
        if (string == null && n == -1) {
            return null;
        }
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)g.convertForCast((Object)this.sessionHostPortCache.get(this.getKey(string, n)), SSLSessionImpl.class);
        if (!this.isTimedout(sSLSessionImpl)) {
            return sSLSessionImpl;
        }
        return null;
    }

    private String getKey(String string, int n) {
        return (string + ":" + String.valueOf(n)).toLowerCase();
    }

    void put(SSLSessionImpl sSLSessionImpl) {
        this.sessionCache.put(sSLSessionImpl.getSessionId(), sSLSessionImpl);
        if (sSLSessionImpl.getPeerHost() != null && sSLSessionImpl.getPeerPort() != -1) {
            this.sessionHostPortCache.put(this.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()), sSLSessionImpl);
        }
        sSLSessionImpl.setContext(this);
    }

    void remove(SessionId sessionId) {
        SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)g.convertForCast((Object)this.sessionCache.get(sessionId), SSLSessionImpl.class);
        if (sSLSessionImpl != null) {
            this.sessionCache.remove(sessionId);
            this.sessionHostPortCache.remove(this.getKey(sSLSessionImpl.getPeerHost(), sSLSessionImpl.getPeerPort()));
        }
    }

    private int getDefaultCacheLimit() {
        int n = 0;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(this){
                final /* synthetic */ SSLSessionContextImpl this$0;
                {
                    this.this$0 = sSLSessionContextImpl;
                }

                public String run() {
                    return System.getProperty("javax.net.ssl.sessionCacheSize");
                }

                static /* synthetic */ SSLSessionContextImpl _jr$ig$this$0(Object object) {
                    return (object).this$0;
                }

                static /* synthetic */ void _jr$ip$this$0(Object object, SSLSessionContextImpl sSLSessionContextImpl) {
                    (object).this$0 = sSLSessionContextImpl;
                }
            });
            n = string != null ? Integer.valueOf(string) : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n > 0 ? n : 0;
    }

    boolean isTimedout(SSLSession sSLSession) {
        if (this.timeout == 0) {
            return false;
        }
        if (sSLSession != null && sSLSession.getCreationTime() + (long)this.timeout * 1000L <= System.currentTimeMillis()) {
            sSLSession.invalidate();
            return true;
        }
        return false;
    }

    private static /* synthetic */ Cache _jr$ig$sessionCache(SSLSessionContextImpl sSLSessionContextImpl) {
        return sSLSessionContextImpl.sessionCache;
    }

    private static /* synthetic */ void _jr$ip$sessionCache(SSLSessionContextImpl sSLSessionContextImpl, Cache cache) {
        sSLSessionContextImpl.sessionCache = cache;
    }

    private static /* synthetic */ Cache _jr$ig$sessionHostPortCache(SSLSessionContextImpl sSLSessionContextImpl) {
        return sSLSessionContextImpl.sessionHostPortCache;
    }

    private static /* synthetic */ void _jr$ip$sessionHostPortCache(SSLSessionContextImpl sSLSessionContextImpl, Cache cache) {
        sSLSessionContextImpl.sessionHostPortCache = cache;
    }

    private static /* synthetic */ int _jr$ig$cacheLimit(SSLSessionContextImpl sSLSessionContextImpl) {
        return sSLSessionContextImpl.cacheLimit;
    }

    private static /* synthetic */ void _jr$ip$cacheLimit(SSLSessionContextImpl sSLSessionContextImpl, int n) {
        sSLSessionContextImpl.cacheLimit = n;
    }

    private static /* synthetic */ int _jr$ig$timeout(SSLSessionContextImpl sSLSessionContextImpl) {
        return sSLSessionContextImpl.timeout;
    }

    private static /* synthetic */ void _jr$ip$timeout(SSLSessionContextImpl sSLSessionContextImpl, int n) {
        sSLSessionContextImpl.timeout = n;
    }

    final class SessionCacheVisitor
    extends h
    implements Cache.CacheVisitor {
        Vector<byte[]> ids = null;

        SessionCacheVisitor() {
        }

        public void visit(Map<Object, Object> map) {
            this.ids = new Vector(map.size());
            for (Object object : map.keySet()) {
                SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)g.convertForCast((Object)map.get(object), SSLSessionImpl.class);
                if (SSLSessionContextImpl.this.isTimedout(sSLSessionImpl)) continue;
                this.ids.addElement(((SessionId)g.convertForCast((Object)object, SessionId.class)).getId());
            }
        }

        public Enumeration<byte[]> getSessionIds() {
            return this.ids != null ? this.ids.elements() : new Vector().elements();
        }

        static /* synthetic */ Vector _jr$ig$ids(Object object) {
            return ((SessionCacheVisitor)object).ids;
        }

        static /* synthetic */ void _jr$ip$ids(Object object, Vector vector) {
            ((SessionCacheVisitor)object).ids = vector;
        }

        static /* synthetic */ SSLSessionContextImpl _jr$ig$this$0(Object object) {
            return ((SessionCacheVisitor)object).SSLSessionContextImpl.this;
        }

        static /* synthetic */ void _jr$ip$this$0(Object object, SSLSessionContextImpl sSLSessionContextImpl) {
            ((SessionCacheVisitor)object).SSLSessionContextImpl.this = sSLSessionContextImpl;
        }
    }
}

