/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.Provider;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.Security;

public abstract class SunJSSE
extends java.security.Provider {
    private static final long serialVersionUID = 3231825739635378733L;
    private static String info = "Sun JSSE provider(PKCS12, SunX509 key/trust factories, SSLv3, TLSv1)";
    private static String fipsInfo = "Sun JSSE provider (FIPS mode, crypto provider ";
    private static Boolean fips;
    static java.security.Provider cryptoProvider;

    protected static synchronized boolean isFIPS() {
        if (fips == null) {
            fips = false;
        }
        return fips;
    }

    private static synchronized void ensureFIPS(java.security.Provider provider) {
        if (fips == null) {
            fips = true;
            cryptoProvider = provider;
        } else {
            if (!fips.booleanValue()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderException("SunJSSE already initialized in non-FIPS mode"));
            }
            if (f.ifAcmp((Object)cryptoProvider, (Object)provider)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderException("SunJSSE already initialized with FIPS crypto provider " + cryptoProvider));
            }
        }
    }

    protected SunJSSE() {
        super("SunJSSE", 1.7, info);
        this.subclassCheck();
        if (Boolean.TRUE.equals(fips)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderException("SunJSSE is already initialized in FIPS mode"));
        }
        this.registerAlgorithms(false);
    }

    protected SunJSSE(java.security.Provider provider) {
        this((java.security.Provider)g.convertForCast((Object)SunJSSE.checkNull(provider), java.security.Provider.class), provider.getName());
    }

    protected SunJSSE(String string) {
        this(null, SunJSSE.checkNull(string));
    }

    private static <T> T checkNull(T t) {
        if (t == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderException("cryptoProvider must not be null"));
        }
        return t;
    }

    private SunJSSE(java.security.Provider provider, String string) {
        super("SunJSSE", 1.6, fipsInfo + string + ")");
        this.subclassCheck();
        if (provider == null && (provider = Security.getProvider(string)) == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ProviderException("Crypto provider not installed: " + string));
        }
        SunJSSE.ensureFIPS(provider);
        this.registerAlgorithms(true);
    }

    private void registerAlgorithms(boolean bl) {
        AccessController.doPrivileged(new PrivilegedAction(this, bl){
            final /* synthetic */ boolean val$isfips;
            final /* synthetic */ SunJSSE this$0;
            {
                this.this$0 = sunJSSE;
                this.val$isfips = bl;
            }

            public Object run() {
                this.this$0.doRegister((this).val$isfips);
                return null;
            }

            static /* synthetic */ void _jr$ip$val$isfips(Object object, boolean bl) {
                (object).val$isfips = bl;
            }

            static /* synthetic */ SunJSSE _jr$ig$this$0(Object object) {
                return (object).this$0;
            }

            static /* synthetic */ void _jr$ip$this$0(Object object, SunJSSE sunJSSE) {
                (object).this$0 = sunJSSE;
            }
        });
    }

    private void doRegister(boolean bl) {
        if (!bl) {
            this.put("KeyFactory.RSA", "sun.security.rsa.RSAKeyFactory");
            this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1", "RSA");
            this.put("Alg.Alias.KeyFactory.OID.1.2.840.113549.1.1", "RSA");
            this.put("KeyPairGenerator.RSA", "sun.security.rsa.RSAKeyPairGenerator");
            this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1", "RSA");
            this.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.113549.1.1", "RSA");
            this.put("Signature.MD2withRSA", "sun.security.rsa.RSASignature$MD2withRSA");
            this.put("Alg.Alias.Signature.1.2.840.113549.1.1.2", "MD2withRSA");
            this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.2", "MD2withRSA");
            this.put("Signature.MD5withRSA", "sun.security.rsa.RSASignature$MD5withRSA");
            this.put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5withRSA");
            this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.4", "MD5withRSA");
            this.put("Signature.SHA1withRSA", "sun.security.rsa.RSASignature$SHA1withRSA");
            this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
            this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
            this.put("Alg.Alias.Signature.1.3.14.3.2.29", "SHA1withRSA");
            this.put("Alg.Alias.Signature.OID.1.3.14.3.2.29", "SHA1withRSA");
        }
        this.put("Signature.MD5andSHA1withRSA", "sun.security.ssl.RSASignature");
        this.put("KeyManagerFactory.SunX509", "sun.security.ssl.KeyManagerFactoryImpl$SunX509");
        this.put("KeyManagerFactory.NewSunX509", "sun.security.ssl.KeyManagerFactoryImpl$X509");
        this.put("Alg.Alias.KeyManagerFactory.PKIX", "NewSunX509");
        this.put("TrustManagerFactory.SunX509", "sun.security.ssl.TrustManagerFactoryImpl$SimpleFactory");
        this.put("TrustManagerFactory.PKIX", "sun.security.ssl.TrustManagerFactoryImpl$PKIXFactory");
        this.put("Alg.Alias.TrustManagerFactory.SunPKIX", "PKIX");
        this.put("Alg.Alias.TrustManagerFactory.X509", "PKIX");
        this.put("Alg.Alias.TrustManagerFactory.X.509", "PKIX");
        this.put("SSLContext.TLSv1", "sun.security.ssl.SSLContextImpl$TLS10Context");
        this.put("Alg.Alias.SSLContext.TLS", "TLSv1");
        if (!bl) {
            this.put("Alg.Alias.SSLContext.SSL", "TLSv1");
            this.put("Alg.Alias.SSLContext.SSLv3", "TLSv1");
        }
        this.put("SSLContext.TLSv1.1", "sun.security.ssl.SSLContextImpl$TLS11Context");
        this.put("SSLContext.TLSv1.2", "sun.security.ssl.SSLContextImpl$TLS12Context");
        this.put("SSLContext.Default", "sun.security.ssl.SSLContextImpl$DefaultSSLContext");
        this.put("KeyStore.PKCS12", "sun.security.pkcs12.PKCS12KeyStore");
    }

    private void subclassCheck() {
        if (f.ifAcmp(this.getClass(), Provider.class)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)("Illegal subclass: " + this.getClass())));
        }
    }

    protected final void finalize() throws Throwable {
        if (!this._jr$iCur()) {
            return;
        }
        super.finalize();
    }

    protected /* synthetic */ SunJSSE(h h2) {
        super(h2);
    }
}

