/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.net.Socket;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Debug;

final class SunX509KeyManagerImpl
extends X509ExtendedKeyManager {
    private static final Debug debug = Debug.getInstance("ssl");
    private static final String[] STRING0 = new String[0];
    private Map<String, X509Credentials> credentialsMap = new HashMap<String, X509Credentials>();
    private Map<String, String[]> serverAliasCache = new HashMap<String, String[]>();

    SunX509KeyManagerImpl(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object[] objectArray;
            Key key;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || !(g.convertForInstanceOf((Object)(key = keyStore.getKey(string, cArray)), PrivateKey.class) instanceof PrivateKey) || (objectArray = keyStore.getCertificateChain(string)) == null || a.arrayLength((Object[])objectArray) == 0 || !(g.convertForInstanceOf((Object)((Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), Certificate.class)), X509Certificate.class) instanceof X509Certificate)) continue;
            if (!(g.convertForInstanceOf((Object)objectArray, X509Certificate[].class) instanceof X509Certificate[])) {
                object = new X509Certificate[a.arrayLength((Object[])objectArray)];
                a.arraycopy((Object)objectArray, (int)0, (Object)object, (int)0, (int)a.arrayLength((Object[])objectArray));
                objectArray = object;
            }
            object = new X509Credentials((PrivateKey)g.convertForCast((Object)key, PrivateKey.class), (X509Certificate[])g.convertForCast((Object)((X509Certificate[])g.convertForCast((Object)objectArray, X509Certificate[].class)), X509Certificate[].class));
            this.credentialsMap.put(string, (X509Credentials)((Object)object));
            if (debug == null || !Debug.isOn("keymanager")) continue;
            System.out.println("***");
            System.out.println("found key for : " + string);
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                System.out.println("chain [" + i + "] = " + (Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Certificate.class));
            }
            System.out.println("***");
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        if (string == null) {
            return null;
        }
        X509Credentials x509Credentials = (X509Credentials)((Object)g.convertForCast((Object)((Object)this.credentialsMap.get(string)), X509Credentials.class));
        if (x509Credentials == null) {
            return null;
        }
        return (X509Certificate[])g.convertForCast((Object)a.cloneArray((Object)((X509Credentials)((Object)((Object)x509Credentials))).certificates), X509Certificate[].class);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        if (string == null) {
            return null;
        }
        X509Credentials x509Credentials = (X509Credentials)((Object)g.convertForCast((Object)((Object)this.credentialsMap.get(string)), X509Credentials.class));
        if (x509Credentials == null) {
            return null;
        }
        return ((X509Credentials)((Object)((Object)x509Credentials))).privateKey;
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getClientAliases(stringArray[i], principalArray);
            if (stringArray2 == null || stringArray2.length <= 0) continue;
            return stringArray2[0];
        }
        return null;
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseClientAlias(stringArray, principalArray, null);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        if (principalArray == null || a.arrayLength((Object[])principalArray) == 0) {
            stringArray = this.serverAliasCache.get(string);
            if (stringArray == null) {
                stringArray = this.getServerAliases(string, principalArray);
                if (stringArray == null) {
                    stringArray = STRING0;
                }
                this.serverAliasCache.put(string, stringArray);
            }
        } else {
            stringArray = this.getServerAliases(string, principalArray);
        }
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseServerAlias(string, principalArray, null);
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(string, principalArray);
    }

    private String[] getAliases(String string, Principal[] principalArray) {
        String string2;
        if (string == null) {
            return null;
        }
        if (principalArray == null) {
            principalArray = new X500Principal[]{};
        }
        if (!(principalArray instanceof X500Principal[])) {
            principalArray = SunX509KeyManagerImpl.convertPrincipals(principalArray);
        }
        if (string.contains("_")) {
            int n2 = string.indexOf("_");
            string2 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        } else {
            string2 = null;
        }
        X500Principal[] x500PrincipalArray = (X500Principal[])principalArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.credentialsMap.entrySet().iterator();
        block0: while (stringArray.hasNext()) {
            String string3;
            Object object;
            Map.Entry entry = (Map.Entry)g.convertForCast(stringArray.next(), Map.Entry.class);
            String string4 = (String)entry.getKey();
            X509Credentials x509Credentials = (X509Credentials)((Object)g.convertForCast(entry.getValue(), X509Credentials.class));
            Object[] objectArray = ((X509Credentials)((Object)((Object)x509Credentials))).certificates;
            if (!string.equals(((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), X509Certificate.class)).getPublicKey().getAlgorithm()) || string2 != null && (a.arrayLength((Object[])objectArray) <= 1 ? !((String)(object = ((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), X509Certificate.class)).getSigAlgName().toUpperCase(Locale.ENGLISH))).contains(string3 = "WITH" + string2.toUpperCase(Locale.ENGLISH)) : !string2.equals(((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), X509Certificate.class)).getPublicKey().getAlgorithm()))) continue;
            if (a.arrayLength((Object[])principalArray) == 0) {
                arrayList.add(string4);
                if (debug == null || !Debug.isOn("keymanager")) continue;
                System.out.println("matching alias: " + string4);
                continue;
            }
            object = x509Credentials.getIssuerX500Principals();
            for (int i = 0; i < x500PrincipalArray.length; ++i) {
                if (!object.contains((Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class))) continue;
                arrayList.add(string4);
                if (debug == null || !Debug.isOn("keymanager")) continue block0;
                System.out.println("matching alias: " + string4);
                continue block0;
            }
        }
        stringArray = arrayList.toArray(STRING0);
        return stringArray.length == 0 ? null : stringArray;
    }

    private static X500Principal[] convertPrincipals(Principal[] principalArray) {
        ArrayList<X500Principal> arrayList = new ArrayList<X500Principal>(a.arrayLength((Object[])principalArray));
        for (int i = 0; i < a.arrayLength((Object[])principalArray); ++i) {
            Principal principal = (Principal)g.convertForCast((Object)a.arrayLoad((Object[])principalArray, (int)i), Principal.class);
            if (principal instanceof X500Principal) {
                arrayList.add((X500Principal)principal);
                continue;
            }
            try {
                arrayList.add(new X500Principal(principal.getName()));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new X500Principal[arrayList.size()]);
    }

    private static /* synthetic */ Map _jr$ig$credentialsMap(SunX509KeyManagerImpl sunX509KeyManagerImpl) {
        return sunX509KeyManagerImpl.credentialsMap;
    }

    private static /* synthetic */ void _jr$ip$credentialsMap(SunX509KeyManagerImpl sunX509KeyManagerImpl, Map map) {
        sunX509KeyManagerImpl.credentialsMap = map;
    }

    private static /* synthetic */ Map _jr$ig$serverAliasCache(SunX509KeyManagerImpl sunX509KeyManagerImpl) {
        return sunX509KeyManagerImpl.serverAliasCache;
    }

    private static /* synthetic */ void _jr$ip$serverAliasCache(SunX509KeyManagerImpl sunX509KeyManagerImpl, Map map) {
        sunX509KeyManagerImpl.serverAliasCache = map;
    }

    private static class X509Credentials
    extends h {
        PrivateKey privateKey;
        X509Certificate[] certificates;
        private Set<X500Principal> issuerX500Principals;

        X509Credentials(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.privateKey = privateKey;
            this.certificates = x509CertificateArray;
        }

        @af(modifiers=32)
        Set<X500Principal> getIssuerX500Principals() {
            Object object = ah.getMonitor((Object)((Object)this));
            synchronized (object) {
                try {
                    if (this.issuerX500Principals == null) {
                        this.issuerX500Principals = new HashSet();
                        for (int i = 0; i < a.arrayLength((Object[])((X509Credentials)((Object)((Object)this))).certificates); ++i) {
                            this.issuerX500Principals.add(((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])((X509Credentials)((Object)((Object)this))).certificates, (int)i), X509Certificate.class)).getIssuerX500Principal());
                        }
                    }
                    return this.issuerX500Principals;
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }

        static /* synthetic */ void _jr$ip$privateKey(Object object, PrivateKey privateKey) {
            ((X509Credentials)((Object)object)).privateKey = privateKey;
        }

        static /* synthetic */ void _jr$ip$certificates(Object object, X509Certificate[] x509CertificateArray) {
            ((X509Credentials)((Object)object)).certificates = x509CertificateArray;
        }

        protected /* synthetic */ X509Credentials(h h2) {
            super(h2);
        }
    }
}

