/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.util.HostnameChecker;
import sun.security.validator.KeyStores;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final String validatorType;
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;
    private static final Debug debug = Debug.getInstance("ssl");

    X509TrustManagerImpl(String string, KeyStore keyStore) throws KeyStoreException {
        this.validatorType = string;
        this.pkixParams = null;
        this.trustedCerts = keyStore == null ? Collections.emptySet() : KeyStores.getTrustedCerts(keyStore);
        this.showTrustedCerts();
    }

    X509TrustManagerImpl(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        this.validatorType = string;
        this.pkixParams = pKIXBuilderParameters;
        Validator validator = this.getValidator("tls server");
        this.trustedCerts = validator.getTrustedCertificates();
        this.serverValidator = validator;
        this.showTrustedCerts();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)g.convertForCast(null, Socket.class), true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)g.convertForCast(null, Socket.class), false);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Validator checkTrustedInit(X509Certificate[] x509CertificateArray, String string, boolean bl) {
        if (x509CertificateArray == null || a.arrayLength((Object[])x509CertificateArray) == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("null or zero-length certificate chain"));
        }
        if (string == null || string.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("null or zero-length authentication type"));
        }
        Validator validator = null;
        if (bl) {
            validator = this.clientValidator;
            if (validator != null) return validator;
            X509TrustManagerImpl x509TrustManagerImpl = this;
            synchronized (x509TrustManagerImpl) {
                try {
                    validator = this.clientValidator;
                    if (validator != null) return validator;
                    this.clientValidator = validator = this.getValidator("tls client");
                    // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var5_5)] (shouldn't be in output)
                    return validator;
                }
                catch (Throwable throwable) {
                    // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var5_5)] (shouldn't be in output)
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
        validator = this.serverValidator;
        if (validator != null) return validator;
        X509TrustManagerImpl x509TrustManagerImpl = this;
        synchronized (x509TrustManagerImpl) {
            try {
                validator = this.serverValidator;
                if (validator != null) return validator;
                this.serverValidator = validator = this.getValidator("tls server");
                // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var5_6)] (shouldn't be in output)
                return validator;
            }
            catch (Throwable throwable) {
                // ** MonitorExit[com.zeroturnaround.jrebelbase.facade.ah.getMonitor((java.lang.Object)var5_6)] (shouldn't be in output)
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        Object object;
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
        if (socket != null && socket.isConnected() && g.convertForInstanceOf((Object)socket, SSLSocket.class) instanceof SSLSocket) {
            Object object2;
            object = (SSLSocket)g.convertForCast((Object)socket, SSLSocket.class);
            SSLSession sSLSession = ((SSLSocket)object).getHandshakeSession();
            if (sSLSession == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("No handshake session"));
            }
            String string2 = ((SSLSocket)object).getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object2 = sSLSession.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object2, (X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])x509CertificateArray, (int)0), X509Certificate.class), string2);
            }
            object2 = ProtocolVersion.valueOf(sSLSession.getProtocol());
            if (((ProtocolVersion)object2).v >= ProtocolVersion.TLS12.v) {
                if (g.convertForInstanceOf((Object)sSLSession, ExtendedSSLSession.class) instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)g.convertForCast((Object)sSLSession, ExtendedSSLSession.class);
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)object, stringArray, false);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)object, false);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)object, false);
            }
        }
        object = null;
        object = bl ? X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, null) : X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, string);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])object, (int)(a.arrayLength((Object[])object) - 1)), X509Certificate.class));
        }
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        Object[] objectArray;
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
        if (sSLEngine != null) {
            Object object;
            objectArray = sSLEngine.getHandshakeSession();
            if (objectArray == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("No handshake session"));
            }
            String string2 = sSLEngine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                object = objectArray.getPeerHost();
                X509TrustManagerImpl.checkIdentity((String)object, (X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])x509CertificateArray, (int)0), X509Certificate.class), string2);
            }
            object = ProtocolVersion.valueOf(objectArray.getProtocol());
            if (((ProtocolVersion)object).v >= ProtocolVersion.TLS12.v) {
                if (g.convertForInstanceOf((Object)objectArray, ExtendedSSLSession.class) instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)g.convertForCast((Object)objectArray, ExtendedSSLSession.class);
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, stringArray, false);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
            }
        }
        objectArray = null;
        objectArray = bl ? X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, null) : X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, string);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println((X509Certificate)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)(a.arrayLength((Object[])objectArray) - 1)), X509Certificate.class));
        }
    }

    private void showTrustedCerts() {
        if (debug != null && Debug.isOn("trustmanager")) {
            Iterator<X509Certificate> iterator = this.trustedCerts.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)g.convertForCast((Object)iterator.next(), X509Certificate.class);
                System.out.println("adding as trusted cert:");
                System.out.println("  Subject: " + x509Certificate.getSubjectX500Principal());
                System.out.println("  Issuer:  " + x509Certificate.getIssuerX500Principal());
                System.out.println("  Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "; Serial number: 0x" + x509Certificate.getSerialNumber().toString(16));
                System.out.println("  Valid from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
                System.out.println();
            }
        }
    }

    private Validator getValidator(String string) {
        Validator validator = this.pkixParams == null ? Validator.getInstance(this.validatorType, string, this.trustedCerts) : Validator.getInstance(this.validatorType, string, this.pkixParams);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] validate(Validator validator, X509Certificate[] x509CertificateArray, AlgorithmConstraints algorithmConstraints, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Object object = JsseJce.beginFipsProvider();
        try {
            x509CertificateArray2 = validator.validate(x509CertificateArray, null, algorithmConstraints, string);
        }
        catch (Throwable throwable) {
            JsseJce.endFipsProvider(object);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
        }
        JsseJce.endFipsProvider(object);
        return x509CertificateArray2;
    }

    static void checkIdentity(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        if (string2 != null && string2.length() != 0) {
            if (string != null && string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string2.equalsIgnoreCase("HTTPS")) {
                HostnameChecker.getInstance((byte)1).match(string, x509Certificate);
            } else if (string2.equalsIgnoreCase("LDAP") || string2.equalsIgnoreCase("LDAPS")) {
                HostnameChecker.getInstance((byte)2).match(string, x509Certificate);
            } else {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Unknown identification algorithm: " + string2));
            }
        }
    }

    private static /* synthetic */ String _jr$ig$validatorType(X509TrustManagerImpl x509TrustManagerImpl) {
        return x509TrustManagerImpl.validatorType;
    }

    private static /* synthetic */ void _jr$ip$validatorType(X509TrustManagerImpl x509TrustManagerImpl, String string) {
        x509TrustManagerImpl.validatorType = string;
    }

    private static /* synthetic */ Collection _jr$ig$trustedCerts(X509TrustManagerImpl x509TrustManagerImpl) {
        return x509TrustManagerImpl.trustedCerts;
    }

    private static /* synthetic */ void _jr$ip$trustedCerts(X509TrustManagerImpl x509TrustManagerImpl, Collection collection) {
        x509TrustManagerImpl.trustedCerts = collection;
    }

    private static /* synthetic */ PKIXBuilderParameters _jr$ig$pkixParams(X509TrustManagerImpl x509TrustManagerImpl) {
        return x509TrustManagerImpl.pkixParams;
    }

    private static /* synthetic */ void _jr$ip$pkixParams(X509TrustManagerImpl x509TrustManagerImpl, PKIXBuilderParameters pKIXBuilderParameters) {
        x509TrustManagerImpl.pkixParams = pKIXBuilderParameters;
    }

    private static /* synthetic */ Validator _jr$ig$clientValidator(X509TrustManagerImpl x509TrustManagerImpl) {
        return x509TrustManagerImpl.clientValidator;
    }

    private static /* synthetic */ void _jr$ip$clientValidator(X509TrustManagerImpl x509TrustManagerImpl, Validator validator) {
        x509TrustManagerImpl.clientValidator = validator;
    }

    private static /* synthetic */ Validator _jr$ig$serverValidator(X509TrustManagerImpl x509TrustManagerImpl) {
        return x509TrustManagerImpl.serverValidator;
    }

    private static /* synthetic */ void _jr$ip$serverValidator(X509TrustManagerImpl x509TrustManagerImpl, Validator validator) {
        x509TrustManagerImpl.serverValidator = validator;
    }
}

