/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class BitArray
extends h {
    private byte[] repn;
    private int length;
    private static final int BITS_PER_UNIT = 8;
    private static final byte[][] NYBBLE = new byte[][]{{48, 48, 48, 48}, {48, 48, 48, 49}, {48, 48, 49, 48}, {48, 48, 49, 49}, {48, 49, 48, 48}, {48, 49, 48, 49}, {48, 49, 49, 48}, {48, 49, 49, 49}, {49, 48, 48, 48}, {49, 48, 48, 49}, {49, 48, 49, 48}, {49, 48, 49, 49}, {49, 49, 48, 48}, {49, 49, 48, 49}, {49, 49, 49, 48}, {49, 49, 49, 49}};
    private static final int BYTES_PER_LINE = 8;

    private static int subscript(int n2) {
        return n2 / 8;
    }

    private static int position(int n2) {
        return 1 << 7 - n2 % 8;
    }

    public BitArray(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative length for BitArray"));
        }
        this.length = n2;
        this.repn = new byte[(n2 + 8 - 1) / 8];
    }

    public BitArray(int n2, byte[] byArray) throws IllegalArgumentException {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Negative length for BitArray"));
        }
        if (byArray.length * 8 < n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Byte array too short to represent bit array of given length"));
        }
        this.length = n2;
        int n3 = (n2 + 8 - 1) / 8;
        int n4 = n3 * 8 - n2;
        byte by = (byte)(255 << n4);
        this.repn = new byte[n3];
        a.arraycopy((Object)byArray, (int)0, (Object)this.repn, (int)0, (int)n3);
        if (n3 > 0) {
            int n5 = n3 - 1;
            this.repn[n5] = (byte)(this.repn[n5] & by);
        }
    }

    public BitArray(boolean[] blArray) {
        this.length = blArray.length;
        this.repn = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.length; ++i) {
            this.set(i, blArray[i]);
        }
    }

    private BitArray(BitArray bitArray) {
        this.length = bitArray.length;
        this.repn = (byte[])bitArray.repn.clone();
    }

    public boolean get(int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException(Integer.toString(n2)));
        }
        return (this.repn[BitArray.subscript(n2)] & BitArray.position(n2)) != 0;
    }

    public void set(int n2, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new ArrayIndexOutOfBoundsException(Integer.toString(n2)));
        }
        int n3 = BitArray.subscript(n2);
        int n4 = BitArray.position(n2);
        if (bl) {
            byte[] byArray = this.repn;
            int n5 = n3;
            byArray[n5] = (byte)(byArray[n5] | n4);
        } else {
            byte[] byArray = this.repn;
            int n6 = n3;
            byArray[n6] = (byte)(byArray[n6] & ~n4);
        }
    }

    public int length() {
        return this.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.repn.clone();
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)object, (Object)((Object)this))) {
            return true;
        }
        if (object == null || !(g.convertForInstanceOf((Object)object, BitArray.class) instanceof BitArray)) {
            return false;
        }
        BitArray bitArray = (BitArray)((Object)g.convertForCast((Object)object, BitArray.class));
        if (bitArray.length != this.length) {
            return false;
        }
        for (int i = 0; i < this.repn.length; ++i) {
            if (this.repn[i] == bitArray.repn[i]) continue;
            return false;
        }
        return true;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            blArray[i] = this.get(i);
        }
        return blArray;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i = 0; i < this.repn.length; ++i) {
            n2 = 31 * n2 + this.repn[i];
        }
        return n2 ^ this.length;
    }

    public Object clone() {
        return new BitArray(this);
    }

    public String toString() {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (n2 = 0; n2 < this.repn.length - 1; ++n2) {
            byteArrayOutputStream.write(NYBBLE[this.repn[n2] >> 4 & 0xF], 0, 4);
            byteArrayOutputStream.write(NYBBLE[this.repn[n2] & 0xF], 0, 4);
            if (n2 % 8 == 7) {
                byteArrayOutputStream.write(10);
                continue;
            }
            byteArrayOutputStream.write(32);
        }
        for (n2 = 8 * (this.repn.length - 1); n2 < this.length; ++n2) {
            byteArrayOutputStream.write(this.get(n2) ? 49 : 48);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public BitArray truncate() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!this.get(i)) continue;
            return new BitArray(i + 1, Arrays.copyOf(this.repn, (i + 8) / 8));
        }
        return new BitArray(1);
    }

    private static /* synthetic */ void _jr$ip$repn(BitArray bitArray, byte[] byArray) {
        bitArray.repn = byArray;
    }

    private static /* synthetic */ void _jr$ip$length(BitArray bitArray, int n2) {
        bitArray.length = n2;
    }

    protected /* synthetic */ BitArray(h h2) {
        super(h2);
    }
}

