/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Vector;
import sun.security.util.BitArray;
import sun.security.util.DerIndefLenConverter;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerInputStream
extends h {
    DerInputBuffer buffer;
    public byte tag;

    public DerInputStream(byte[] byArray) throws IOException {
        this.init(byArray, 0, byArray.length);
    }

    public DerInputStream(byte[] byArray, int n2, int n3) throws IOException {
        this.init(byArray, n2, n3);
    }

    private void init(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 + 2 > byArray.length || n2 + n3 > byArray.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Encoding bytes too short"));
        }
        if (DerIndefLenConverter.isIndefinite(byArray[n2 + 1])) {
            byte[] byArray2 = new byte[n3];
            a.arraycopy((Object)byArray, (int)n2, (Object)byArray2, (int)0, (int)n3);
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            ((DerInputStream)((Object)((Object)this))).buffer = new DerInputBuffer(derIndefLenConverter.convert(byArray2));
        } else {
            ((DerInputStream)((Object)((Object)this))).buffer = new DerInputBuffer(byArray, n2, n3);
        }
        ((DerInputStream)((Object)((Object)this))).buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int n2, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = ((DerInputStream)((Object)((Object)this))).buffer.dup();
        derInputBuffer.truncate(n2);
        if (bl) {
            ((DerInputStream)((Object)((Object)this))).buffer.skip(n2);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return ((DerInputStream)((Object)((Object)this))).buffer.toByteArray();
    }

    public int getInteger() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input, Integer tag error"));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getInteger(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer));
    }

    public BigInteger getBigInteger() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input, Integer tag error"));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getBigInteger(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer), false);
    }

    public BigInteger getPositiveBigInteger() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input, Integer tag error"));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getBigInteger(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer), true);
    }

    public int getEnumerated() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 10) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input, Enumerated tag error"));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getInteger(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer));
    }

    public byte[] getBitString() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input not an bit string"));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getBitString(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer));
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input not a bit string"));
        }
        int n2 = DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer) - 1;
        int n3 = n2 * 8 - ((DerInputStream)((Object)((Object)this))).buffer.read();
        byte[] byArray = new byte[n2];
        if (n2 != 0 && ((DerInputStream)((Object)((Object)this))).buffer.read(byArray) != n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("short read of DER bit string"));
        }
        return new BitArray(n3, byArray);
    }

    public byte[] getOctetString() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 4) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input not an octet string"));
        }
        int n2 = DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer);
        byte[] byArray = new byte[n2];
        if (n2 != 0 && ((DerInputStream)((Object)((Object)this))).buffer.read(byArray) != n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("short read of DER octet string"));
        }
        return byArray;
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0 && ((DerInputStream)((Object)((Object)this))).buffer.read(byArray) != byArray.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("short read of DER octet string"));
        }
    }

    public void getNull() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 5 || ((DerInputStream)((Object)((Object)this))).buffer.read() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("getNull, bad data"));
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int n2) throws IOException {
        ((DerInputStream)((Object)((Object)this))).tag = (byte)((DerInputStream)((Object)((Object)this))).buffer.read();
        if (((DerInputStream)((Object)((Object)this))).tag != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Sequence tag error"));
        }
        return this.readVector(n2);
    }

    public DerValue[] getSet(int n2) throws IOException {
        ((DerInputStream)((Object)((Object)this))).tag = (byte)((DerInputStream)((Object)((Object)this))).buffer.read();
        if (((DerInputStream)((Object)((Object)this))).tag != 49) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Set tag error"));
        }
        return this.readVector(n2);
    }

    public DerValue[] getSet(int n2, boolean bl) throws IOException {
        ((DerInputStream)((Object)((Object)this))).tag = (byte)((DerInputStream)((Object)((Object)this))).buffer.read();
        if (!bl && ((DerInputStream)((Object)((Object)this))).tag != 49) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Set tag error"));
        }
        return this.readVector(n2);
    }

    protected DerValue[] readVector(int n2) throws IOException {
        Object object;
        byte by = (byte)((DerInputStream)((Object)((Object)this))).buffer.read();
        int n3 = DerInputStream.getLength(by & 0xFF, ((DerInputStream)((Object)((Object)this))).buffer);
        if (n3 == -1) {
            int n4 = ((DerInputStream)((Object)((Object)this))).buffer.available();
            int n5 = 2;
            byte[] byArray = new byte[n4 + n5];
            byArray[0] = ((DerInputStream)((Object)((Object)this))).tag;
            byArray[1] = by;
            DataInputStream dataInputStream = new DataInputStream(((DerInputStream)((Object)((Object)this))).buffer);
            dataInputStream.readFully(byArray, n5, n4);
            dataInputStream.close();
            object = new DerIndefLenConverter();
            ((DerInputStream)((Object)((Object)this))).buffer = new DerInputBuffer(((DerIndefLenConverter)((Object)object)).convert(byArray));
            if (((DerInputStream)((Object)((Object)this))).tag != ((DerInputStream)((Object)((Object)this))).buffer.read()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Indefinite length encoding not supported"));
            }
            n3 = DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer);
        }
        if (n3 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = ((DerInputStream)((Object)((Object)this))).buffer.available() == n3 ? this : this.subStream(n3, true);
        Vector<DerValue> vector = new Vector<DerValue>(n2);
        do {
            DerValue derValue = new DerValue(((DerInputStream)((Object)((Object)derInputStream))).buffer);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("extra data at end of vector"));
        }
        int n6 = vector.size();
        object = new DerValue[n6];
        for (int i = 0; i < n6; ++i) {
            object[i] = (DerValue)((Object)g.convertForCast(vector.elementAt(i), DerValue.class));
        }
        return object;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(((DerInputStream)((Object)((Object)this))).buffer);
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)12, "UTF-8", "UTF8");
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public String getGeneralString() throws IOException {
        return this.readString((byte)27, "General", "ASCII");
    }

    private String readString(byte by, String string, String string2) throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != by) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input not a " + string + " string"));
        }
        int n2 = DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer);
        byte[] byArray = new byte[n2];
        if (n2 != 0 && ((DerInputStream)((Object)((Object)this))).buffer.read(byArray) != n2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("short read of DER " + string + " string"));
        }
        return new String(byArray, string2);
    }

    public Date getUTCTime() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 23) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input, UTCtime tag invalid "));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getUTCTime(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer));
    }

    public Date getGeneralizedTime() throws IOException {
        if (((DerInputStream)((Object)((Object)this))).buffer.read() != 24) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DER input, GeneralizedTime tag invalid "));
        }
        return ((DerInputStream)((Object)((Object)this))).buffer.getGeneralizedTime(DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer));
    }

    int getByte() throws IOException {
        return 0xFF & ((DerInputStream)((Object)((Object)this))).buffer.read();
    }

    public int peekByte() throws IOException {
        return ((DerInputStream)((Object)((Object)this))).buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(((DerInputStream)((Object)((Object)this))).buffer);
    }

    static int getLength(InputStream inputStream) throws IOException {
        return DerInputStream.getLength(inputStream.read(), inputStream);
    }

    static int getLength(int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4 = n2;
        if ((n4 & 0x80) == 0) {
            n3 = n4;
        } else {
            if ((n4 &= 0x7F) == 0) {
                return -1;
            }
            if (n4 < 0 || n4 > 4) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerInputStream.getLength(): lengthTag=" + n4 + ", " + (n4 < 0 ? "incorrect DER encoding." : "too big.")));
            }
            n3 = 0;
            while (n4 > 0) {
                n3 <<= 8;
                n3 += 0xFF & inputStream.read();
                --n4;
            }
        }
        return n3;
    }

    public void mark(int n2) {
        ((DerInputStream)((Object)((Object)this))).buffer.mark(n2);
    }

    public void reset() {
        ((DerInputStream)((Object)((Object)this))).buffer.reset();
    }

    public int available() {
        return ((DerInputStream)((Object)((Object)this))).buffer.available();
    }

    protected /* synthetic */ DerInputStream(h h2) {
        super(h2);
    }
}

