/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.w;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Date;
import sun.misc.IOUtils;
import sun.security.util.BitArray;
import sun.security.util.DerIndefLenConverter;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

public class DerValue
extends h {
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    public byte tag;
    protected DerInputBuffer buffer;
    public final DerInputStream data;
    private int length;
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 12;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_GeneralString = 27;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_BMPString = 30;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;

    public boolean isUniversal() {
        return (((DerValue)((Object)((Object)this))).tag & 0xC0) == 0;
    }

    public boolean isApplication() {
        return (((DerValue)((Object)((Object)this))).tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (((DerValue)((Object)((Object)this))).tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte by) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (((DerValue)((Object)((Object)this))).tag & 0x1F) == by;
    }

    boolean isPrivate() {
        return (((DerValue)((Object)((Object)this))).tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (((DerValue)((Object)((Object)this))).tag & 0x20) == 32;
    }

    public boolean isConstructed(byte by) {
        if (!this.isConstructed()) {
            return false;
        }
        return (((DerValue)((Object)((Object)this))).tag & 0x1F) == by;
    }

    public DerValue(String string) throws IOException {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            if (DerValue.isPrintableStringChar(string.charAt(i))) continue;
            bl = false;
            break;
        }
        this.data = this.init(bl ? (byte)19 : 12, string);
    }

    public DerValue(byte by, String string) throws IOException {
        this.data = this.init(by, string);
    }

    public DerValue(byte by, byte[] byArray) {
        this.tag = by;
        this.buffer = new DerInputBuffer((byte[])byArray.clone());
        this.length = byArray.length;
        this.data = new DerInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DerValue(DerInputBuffer derInputBuffer) throws IOException {
        this.tag = (byte)derInputBuffer.read();
        byte by = (byte)derInputBuffer.read();
        this.length = DerInputStream.getLength(by & 0xFF, derInputBuffer);
        if (this.length == -1) {
            DerInputBuffer derInputBuffer2 = derInputBuffer.dup();
            int n = derInputBuffer2.available();
            int n2 = 2;
            byte[] byArray = new byte[n + n2];
            byArray[0] = this.tag;
            byArray[1] = by;
            DataInputStream dataInputStream = new DataInputStream(derInputBuffer2);
            dataInputStream.readFully(byArray, n2, n);
            dataInputStream.close();
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            derInputBuffer2 = new DerInputBuffer(derIndefLenConverter.convert(byArray));
            if (this.tag != derInputBuffer2.read()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Indefinite length encoding not supported"));
            }
            this.length = DerInputStream.getLength(derInputBuffer2);
            this.buffer = derInputBuffer2.dup();
            this.buffer.truncate(this.length);
            this.data = new DerInputStream(this.buffer);
            derInputBuffer.skip(this.length + n2);
        } else {
            this.buffer = derInputBuffer.dup();
            this.buffer.truncate(this.length);
            this.data = new DerInputStream(this.buffer);
            derInputBuffer.skip(this.length);
        }
    }

    public DerValue(byte[] byArray) throws IOException {
        this.data = this.init(true, new ByteArrayInputStream(byArray));
    }

    public DerValue(byte[] byArray, int n, int n2) throws IOException {
        this.data = this.init(true, new ByteArrayInputStream(byArray, n, n2));
    }

    public DerValue(InputStream inputStream) throws IOException {
        this.data = this.init(false, inputStream);
    }

    private DerInputStream init(byte by, String string) throws IOException {
        String string2 = null;
        ((DerValue)((Object)((Object)this))).tag = by;
        switch (by) {
            case 19: 
            case 22: 
            case 27: {
                string2 = "ASCII";
                break;
            }
            case 20: {
                string2 = "ISO-8859-1";
                break;
            }
            case 30: {
                string2 = "UnicodeBigUnmarked";
                break;
            }
            case 12: {
                string2 = "UTF8";
                break;
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unsupported DER string type"));
            }
        }
        byte[] byArray = string.getBytes(string2);
        this.length = byArray.length;
        ((DerValue)((Object)((Object)this))).buffer = new DerInputBuffer(byArray);
        DerInputStream derInputStream = new DerInputStream(((DerValue)((Object)((Object)this))).buffer);
        derInputStream.mark(Integer.MAX_VALUE);
        return derInputStream;
    }

    private DerInputStream init(boolean bl, InputStream inputStream) throws IOException {
        ((DerValue)((Object)((Object)this))).tag = (byte)inputStream.read();
        byte by = (byte)inputStream.read();
        this.length = DerInputStream.getLength(by & 0xFF, inputStream);
        if (this.length == -1) {
            int n = inputStream.available();
            int n2 = 2;
            byte[] byArray = new byte[n + n2];
            byArray[0] = ((DerValue)((Object)((Object)this))).tag;
            byArray[1] = by;
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray, n2, n);
            dataInputStream.close();
            DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
            inputStream = new ByteArrayInputStream(derIndefLenConverter.convert(byArray));
            if (((DerValue)((Object)((Object)this))).tag != inputStream.read()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Indefinite length encoding not supported"));
            }
            this.length = DerInputStream.getLength(inputStream);
        }
        if (bl && inputStream.available() != this.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("extra data given to DerValue constructor"));
        }
        byte[] byArray = IOUtils.readFully(inputStream, this.length, true);
        ((DerValue)((Object)((Object)this))).buffer = new DerInputBuffer(byArray);
        return new DerInputStream(((DerValue)((Object)((Object)this))).buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write(((DerValue)((Object)((Object)this))).tag);
        derOutputStream.putLength(this.length);
        if (this.length > 0) {
            byte[] byArray = new byte[this.length];
            Object object = ah.getMonitor((Object)((Object)((DerValue)((Object)((Object)this))).data));
            synchronized (object) {
                try {
                    ((DerValue)((Object)((Object)this))).buffer.reset();
                    if (((DerValue)((Object)((Object)this))).buffer.read(byArray) != this.length) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("short DER value read (encode)"));
                    }
                    derOutputStream.write(byArray);
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
        }
    }

    public final DerInputStream getData() {
        return ((DerValue)((Object)((Object)this))).data;
    }

    public final byte getTag() {
        return ((DerValue)((Object)((Object)this))).tag;
    }

    public boolean getBoolean() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBoolean, not a BOOLEAN " + ((DerValue)((Object)((Object)this))).tag));
        }
        if (this.length != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBoolean, invalid length " + this.length));
        }
        return ((DerValue)((Object)((Object)this))).buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 6) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getOID, not an OID " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new ObjectIdentifier(((DerValue)((Object)((Object)this))).buffer);
    }

    private byte[] append(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2;
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        a.arraycopy((Object)byArray, (int)0, (Object)byArray3, (int)0, (int)byArray.length);
        a.arraycopy((Object)byArray2, (int)0, (Object)byArray3, (int)byArray.length, (int)byArray2.length);
        return byArray3;
    }

    public byte[] getOctetString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 4 && !this.isConstructed((byte)4)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getOctetString, not an Octet String: " + ((DerValue)((Object)((Object)this))).tag));
        }
        byte[] byArray = new byte[this.length];
        if (this.length == 0) {
            return byArray;
        }
        if (((DerValue)((Object)((Object)this))).buffer.read(byArray) != this.length) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("short read on DerValue buffer"));
        }
        if (this.isConstructed()) {
            DerInputStream derInputStream = new DerInputStream(byArray);
            byArray = null;
            while (derInputStream.available() != 0) {
                byArray = this.append(byArray, derInputStream.getOctetString());
            }
        }
        return byArray;
    }

    public int getInteger() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getInteger, not an int " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getInteger(((DerValue)((Object)((Object)this))).data.available());
    }

    public BigInteger getBigInteger() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBigInteger, not an int " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getBigInteger(((DerValue)((Object)((Object)this))).data.available(), false);
    }

    public BigInteger getPositiveBigInteger() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBigInteger, not an int " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getBigInteger(((DerValue)((Object)((Object)this))).data.available(), true);
    }

    public int getEnumerated() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 10) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getEnumerated, incorrect tag: " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getInteger(((DerValue)((Object)((Object)this))).data.available());
    }

    public byte[] getBitString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBitString, not a bit string " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBitString, not a bit string " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag == 12) {
            return this.getUTF8String();
        }
        if (((DerValue)((Object)((Object)this))).tag == 19) {
            return this.getPrintableString();
        }
        if (((DerValue)((Object)((Object)this))).tag == 20) {
            return this.getT61String();
        }
        if (((DerValue)((Object)((Object)this))).tag == 22) {
            return this.getIA5String();
        }
        if (((DerValue)((Object)((Object)this))).tag == 30) {
            return this.getBMPString();
        }
        if (((DerValue)((Object)((Object)this))).tag == 27) {
            return this.getGeneralString();
        }
        return null;
    }

    public byte[] getBitString(boolean bl) throws IOException {
        if (!bl && ((DerValue)((Object)((Object)this))).tag != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBitString, not a bit string " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getBitString();
    }

    public BitArray getUnalignedBitString(boolean bl) throws IOException {
        if (!bl && ((DerValue)((Object)((Object)this))).tag != 3) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBitString, not a bit string " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getUnalignedBitString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDataBytes() throws IOException {
        byte[] byArray = new byte[this.length];
        Object object = ah.getMonitor((Object)((Object)((DerValue)((Object)((Object)this))).data));
        synchronized (object) {
            try {
                ((DerValue)((Object)((Object)this))).data.reset();
                ((DerValue)((Object)((Object)this))).data.getBytes(byArray);
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
        return byArray;
    }

    public String getPrintableString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 19) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getPrintableString, not a string " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getT61String() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 20) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getT61String, not T61 " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new String(this.getDataBytes(), "ISO-8859-1");
    }

    public String getIA5String() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 22) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getIA5String, not IA5 " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getBMPString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 30) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getBMPString, not BMP " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new String(this.getDataBytes(), "UnicodeBigUnmarked");
    }

    public String getUTF8String() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 12) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getUTF8String, not UTF-8 " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new String(this.getDataBytes(), "UTF8");
    }

    public String getGeneralString() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 27) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getGeneralString, not GeneralString " + ((DerValue)((Object)((Object)this))).tag));
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public Date getUTCTime() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 23) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getUTCTime, not a UtcTime: " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getUTCTime(((DerValue)((Object)((Object)this))).data.available());
    }

    public Date getGeneralizedTime() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag != 24) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DerValue.getGeneralizedTime, not a GeneralizedTime: " + ((DerValue)((Object)((Object)this))).tag));
        }
        return ((DerValue)((Object)((Object)this))).buffer.getGeneralizedTime(((DerValue)((Object)((Object)this))).data.available());
    }

    public boolean equals(Object object) {
        if (g.convertForInstanceOf((Object)object, DerValue.class) instanceof DerValue) {
            return this.equals((DerValue)((Object)g.convertForCast((Object)object, DerValue.class)));
        }
        return false;
    }

    public boolean equals(DerValue derValue) {
        if (!f.ifAcmp((Object)((Object)this), (Object)((Object)derValue))) {
            return true;
        }
        if (((DerValue)((Object)((Object)this))).tag != ((DerValue)((Object)((Object)derValue))).tag) {
            return false;
        }
        if (!f.ifAcmp((Object)((Object)((DerValue)((Object)((Object)this))).data), (Object)((Object)((DerValue)((Object)((Object)derValue))).data))) {
            return true;
        }
        return w.getIdentityHashCode((Object)((Object)((DerValue)((Object)((Object)this))).data)) > w.getIdentityHashCode((Object)((Object)((DerValue)((Object)((Object)derValue))).data)) ? DerValue.doEquals(this, derValue) : DerValue.doEquals(derValue, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doEquals(DerValue derValue, DerValue derValue2) {
        Object object = ah.getMonitor((Object)((Object)((DerValue)((Object)((Object)derValue))).data));
        synchronized (object) {
            try {
                Object object2 = ah.getMonitor((Object)((Object)((DerValue)((Object)((Object)derValue2))).data));
                synchronized (object2) {
                    try {
                        ((DerValue)((Object)((Object)derValue))).data.reset();
                        ((DerValue)((Object)((Object)derValue2))).data.reset();
                        return ((DerValue)((Object)((Object)derValue))).buffer.equals(((DerValue)((Object)((Object)derValue2))).buffer);
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public String toString() {
        try {
            String string = this.getAsString();
            if (string != null) {
                return "\"" + string + "\"";
            }
            if (((DerValue)((Object)((Object)this))).tag == 5) {
                return "[DerValue, null]";
            }
            if (((DerValue)((Object)((Object)this))).tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DerValue, tag = " + ((DerValue)((Object)((Object)this))).tag + ", length = " + this.length + "]";
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("misformatted DER value"));
        }
    }

    public byte[] toByteArray() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.encode(derOutputStream);
        ((DerValue)((Object)((Object)this))).data.reset();
        return derOutputStream.toByteArray();
    }

    public DerInputStream toDerInputStream() throws IOException {
        if (((DerValue)((Object)((Object)this))).tag == 48 || ((DerValue)((Object)((Object)this))).tag == 49) {
            return new DerInputStream(((DerValue)((Object)((Object)this))).buffer);
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("toDerInputStream rejects tag type " + ((DerValue)((Object)((Object)this))).tag));
    }

    public int length() {
        return this.length;
    }

    public static boolean isPrintableStringChar(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static byte createTag(byte by, boolean bl, byte by2) {
        byte by3 = (byte)(by | by2);
        if (bl) {
            by3 = (byte)(by3 | 0x20);
        }
        return by3;
    }

    public void resetTag(byte by) {
        ((DerValue)((Object)((Object)this))).tag = by;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static /* synthetic */ void _jr$ip$data(Object object, DerInputStream derInputStream) {
        ((DerValue)((Object)object)).data = derInputStream;
    }

    protected /* synthetic */ DerValue(h h2) {
        super(h2);
    }
}

