/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.j;
import com.zeroturnaround.jrebelbase.h;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.security.util.KeyUtil;

public class DisabledAlgorithmConstraints
extends h
implements AlgorithmConstraints {
    public static final String PROPERTY_CERTPATH_DISABLED_ALGS = "jdk.certpath.disabledAlgorithms";
    public static final String PROPERTY_TLS_DISABLED_ALGS = "jdk.tls.disabledAlgorithms";
    private static Map<String, String[]> disabledAlgorithmsMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, KeySizeConstraints> keySizeConstraintsMap = Collections.synchronizedMap(new HashMap());
    private String[] disabledAlgorithms;
    private KeySizeConstraints keySizeConstraints;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisabledAlgorithmConstraints(String string) {
        Object object = ah.getMonitor(disabledAlgorithmsMap);
        synchronized (object) {
            try {
                if (!disabledAlgorithmsMap.containsKey(string)) {
                    DisabledAlgorithmConstraints.loadDisabledAlgorithmsMap(string);
                }
                this.disabledAlgorithms = disabledAlgorithmsMap.get(string);
                this.keySizeConstraints = (KeySizeConstraints)((Object)g.convertForCast((Object)((Object)keySizeConstraintsMap.get(string)), KeySizeConstraints.class));
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No algorithm name specified"));
        }
        if (set == null || set.isEmpty()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No cryptographic primitive specified"));
        }
        Set<String> set2 = null;
        for (String string2 : this.disabledAlgorithms) {
            if (string2 == null || string2.isEmpty()) continue;
            if (string2.equalsIgnoreCase(string)) {
                return false;
            }
            if (set2 == null) {
                set2 = this.decomposes(string);
            }
            for (String string3 : set2) {
                if (!string2.equalsIgnoreCase(string3)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, Key key) {
        return this.checkConstraints(set, "", key, null);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (string == null || string.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("No algorithm name specified"));
        }
        return this.checkConstraints(set, string, key, algorithmParameters);
    }

    protected Set<String> decomposes(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<String>();
        }
        Pattern pattern = Pattern.compile("/");
        String[] stringArray = pattern.split(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (string2 == null || string2.length() == 0) continue;
            Pattern pattern2 = Pattern.compile("with|and", 2);
            for (String string3 : stringArray2 = pattern2.split(string2)) {
                if (string3 == null || string3.length() == 0) continue;
                hashSet.add(string3);
            }
        }
        if (hashSet.contains("SHA1") && !hashSet.contains("SHA-1")) {
            hashSet.add("SHA-1");
        }
        if (hashSet.contains("SHA-1") && !hashSet.contains("SHA1")) {
            hashSet.add("SHA1");
        }
        if (hashSet.contains("SHA224") && !hashSet.contains("SHA-224")) {
            hashSet.add("SHA-224");
        }
        if (hashSet.contains("SHA-224") && !hashSet.contains("SHA224")) {
            hashSet.add("SHA224");
        }
        if (hashSet.contains("SHA256") && !hashSet.contains("SHA-256")) {
            hashSet.add("SHA-256");
        }
        if (hashSet.contains("SHA-256") && !hashSet.contains("SHA256")) {
            hashSet.add("SHA256");
        }
        if (hashSet.contains("SHA384") && !hashSet.contains("SHA-384")) {
            hashSet.add("SHA-384");
        }
        if (hashSet.contains("SHA-384") && !hashSet.contains("SHA384")) {
            hashSet.add("SHA384");
        }
        if (hashSet.contains("SHA512") && !hashSet.contains("SHA-512")) {
            hashSet.add("SHA-512");
        }
        if (hashSet.contains("SHA-512") && !hashSet.contains("SHA512")) {
            hashSet.add("SHA512");
        }
        return hashSet;
    }

    private boolean checkConstraints(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        if (key == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("The key cannot be null"));
        }
        if (string != null && string.length() != 0 && !this.permits(set, string, algorithmParameters)) {
            return false;
        }
        if (!this.permits(set, key.getAlgorithm(), null)) {
            return false;
        }
        return !this.keySizeConstraints.disables(key);
    }

    private static void loadDisabledAlgorithmsMap(final String string) {
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public String run() {
                return Security.getProperty(string);
            }

            static /* synthetic */ String _jr$ig$val$propertyName(Object object) {
                return (object).string;
            }

            static /* synthetic */ void _jr$ip$val$propertyName(Object object, String string2) {
                (object).string = string2;
            }
        });
        String[] stringArray = null;
        if (string2 != null && !string2.isEmpty()) {
            if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        disabledAlgorithmsMap.put(string, stringArray);
        KeySizeConstraints keySizeConstraints = new KeySizeConstraints(stringArray);
        keySizeConstraintsMap.put(string, keySizeConstraints);
    }

    private static /* synthetic */ void _jr$ip$disabledAlgorithms(DisabledAlgorithmConstraints disabledAlgorithmConstraints, String[] stringArray) {
        disabledAlgorithmConstraints.disabledAlgorithms = stringArray;
    }

    private static /* synthetic */ void _jr$ip$keySizeConstraints(DisabledAlgorithmConstraints disabledAlgorithmConstraints, KeySizeConstraints keySizeConstraints) {
        disabledAlgorithmConstraints.keySizeConstraints = keySizeConstraints;
    }

    protected /* synthetic */ DisabledAlgorithmConstraints(h h2) {
        super(h2);
    }

    static class 2
    extends h {
        static final /* synthetic */ int[] $SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator;

        static {
            KeySizeConstraint.Operator[] operatorArray = KeySizeConstraint.Operator.values();
            j.registerSwitchClass(2.class, KeySizeConstraint.Operator.class, null);
            int[] nArray = new int[operatorArray.length + 1];
            nArray[0] = -1;
            $SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator = nArray;
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.EQ.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.NE.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.LT.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.LE.ordinal() + 1] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.GT.ordinal() + 1] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.GE.ordinal() + 1] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        public static /* synthetic */ void _jr$$rebel_clinit() {
            KeySizeConstraint.Operator[] operatorArray = KeySizeConstraint.Operator.values();
            j.registerSwitchClass(2.class, KeySizeConstraint.Operator.class, null);
            int[] nArray = new int[operatorArray.length + 1];
            nArray[0] = -1;
            j.updateSwitchMap((int[])nArray, 2.class, (String)"$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator");
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.EQ.ordinal() + 1] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.NE.ordinal() + 1] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.LT.ordinal() + 1] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.LE.ordinal() + 1] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.GT.ordinal() + 1] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[KeySizeConstraint.Operator.GE.ordinal() + 1] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        protected /* synthetic */ 2(h h2) {
            super(h2);
        }
    }

    private static class KeySizeConstraint
    extends h {
        private int minSize;
        private int maxSize;
        private int prohibitedSize;

        public KeySizeConstraint(Operator operator, int n2) {
            this.prohibitedSize = -1;
            switch (2.$SwitchMap$sun$security$util$DisabledAlgorithmConstraints$KeySizeConstraint$Operator[operator.ordinal() + 1]) {
                case 1: {
                    this.minSize = 0;
                    this.maxSize = Integer.MAX_VALUE;
                    this.prohibitedSize = n2;
                    break;
                }
                case 2: {
                    this.minSize = n2;
                    this.maxSize = n2;
                    break;
                }
                case 3: {
                    this.minSize = n2;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case 4: {
                    this.minSize = n2 + 1;
                    this.maxSize = Integer.MAX_VALUE;
                    break;
                }
                case 5: {
                    this.minSize = 0;
                    this.maxSize = n2;
                    break;
                }
                case 6: {
                    this.minSize = 0;
                    this.maxSize = n2 > 1 ? n2 - 1 : 0;
                    break;
                }
                default: {
                    this.minSize = Integer.MAX_VALUE;
                    this.maxSize = -1;
                }
            }
        }

        public boolean disables(Key key) {
            int n2 = KeyUtil.getKeySize(key);
            if (n2 == 0) {
                return true;
            }
            if (n2 > 0) {
                return n2 < this.minSize || n2 > this.maxSize || this.prohibitedSize == n2;
            }
            return false;
        }

        private static /* synthetic */ void _jr$ip$minSize(KeySizeConstraint keySizeConstraint, int n2) {
            keySizeConstraint.minSize = n2;
        }

        private static /* synthetic */ void _jr$ip$maxSize(KeySizeConstraint keySizeConstraint, int n2) {
            keySizeConstraint.maxSize = n2;
        }

        private static /* synthetic */ void _jr$ip$prohibitedSize(KeySizeConstraint keySizeConstraint, int n2) {
            keySizeConstraint.prohibitedSize = n2;
        }

        protected /* synthetic */ KeySizeConstraint(h h2) {
            super(h2);
        }

        static enum Operator {
            EQ,
            NE,
            LT,
            LE,
            GT,
            GE;


            static Operator of(String string) {
                switch (string) {
                    case "==": {
                        return EQ;
                    }
                    case "!=": {
                        return NE;
                    }
                    case "<": {
                        return LT;
                    }
                    case "<=": {
                        return LE;
                    }
                    case ">": {
                        return GT;
                    }
                    case ">=": {
                        return GE;
                    }
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException(string + " is not a legal Operator"));
            }
        }
    }

    private static class KeySizeConstraints
    extends h {
        private static final Pattern pattern = Pattern.compile("(\\S+)\\s+keySize\\s*(<=|<|==|!=|>|>=)\\s*(\\d+)");
        private Map<String, Set<KeySizeConstraint>> constraintsMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeySizeConstraints(String[] stringArray) {
            this.constraintsMap = Collections.synchronizedMap(new HashMap());
            Object[] objectArray = stringArray;
            int n2 = a.arrayLength((Object[])objectArray);
            for (int i = 0; i < n2; ++i) {
                Matcher matcher;
                String string = (String)a.arrayLoad((Object[])objectArray, (int)i);
                if (string == null || string.isEmpty() || !(matcher = pattern.matcher(string)).matches()) continue;
                String string2 = matcher.group(1);
                KeySizeConstraint.Operator operator = KeySizeConstraint.Operator.of(matcher.group(2));
                int n3 = Integer.parseInt(matcher.group(3));
                string2 = string2.toLowerCase(Locale.ENGLISH);
                Object object = ah.getMonitor(this.constraintsMap);
                synchronized (object) {
                    try {
                        if (!this.constraintsMap.containsKey(string2)) {
                            this.constraintsMap.put(string2, new HashSet());
                        }
                        Set set = (Set)g.convertForCast(this.constraintsMap.get(string2), Set.class);
                        KeySizeConstraint keySizeConstraint = new KeySizeConstraint(operator, n3);
                        set.add(keySizeConstraint);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean disables(Key key) {
            String string = key.getAlgorithm().toLowerCase(Locale.ENGLISH);
            Object object = ah.getMonitor((Object)this.constraintsMap);
            synchronized (object) {
                try {
                    if (this.constraintsMap.containsKey(string)) {
                        Set set = (Set)g.convertForCast(this.constraintsMap.get(string), Set.class);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            KeySizeConstraint keySizeConstraint = (KeySizeConstraint)((Object)g.convertForCast(iterator.next(), KeySizeConstraint.class));
                            if (!keySizeConstraint.disables(key)) continue;
                            return true;
                        }
                    }
                }
                catch (Throwable throwable) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                }
            }
            return false;
        }

        private static /* synthetic */ void _jr$ip$constraintsMap(KeySizeConstraints keySizeConstraints, Map map) {
            keySizeConstraints.constraintsMap = map;
        }

        protected /* synthetic */ KeySizeConstraints(h h2) {
            super(h2);
        }
    }
}

