/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import sun.security.util.Cache;

class MemoryCache
extends Cache {
    private static final float LOAD_FACTOR = 0.75f;
    private static final boolean DEBUG = false;
    private final Map<Object, CacheEntry> cacheMap;
    private int maxSize;
    private long lifetime;
    private final ReferenceQueue queue;

    public MemoryCache(boolean bl, int n2) {
        this(bl, n2, 0);
    }

    public MemoryCache(boolean bl, int n2, int n3) {
        this.maxSize = n2;
        this.lifetime = n3 * 1000;
        this.queue = bl ? new ReferenceQueue() : null;
        int n4 = (int)((float)n2 / 0.75f) + 1;
        this.cacheMap = new LinkedHashMap<Object, CacheEntry>(n4, 0.75f, true);
    }

    private void emptyQueue() {
        CacheEntry cacheEntry;
        if (this.queue == null) {
            return;
        }
        int n2 = this.cacheMap.size();
        while ((cacheEntry = (CacheEntry)g.convertForCast(this.queue.poll(), CacheEntry.class)) != null) {
            CacheEntry cacheEntry2;
            Object k = cacheEntry.getKey();
            if (k == null || (cacheEntry2 = (CacheEntry)g.convertForCast(this.cacheMap.remove(k), CacheEntry.class)) == null || !f.ifAcmp((Object)cacheEntry, (Object)cacheEntry2)) continue;
            this.cacheMap.put(k, cacheEntry2);
        }
    }

    private void expungeExpiredEntries() {
        this.emptyQueue();
        if (this.lifetime == 0L) {
            return;
        }
        int n2 = 0;
        long l2 = System.currentTimeMillis();
        Iterator iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)g.convertForCast(iterator.next(), CacheEntry.class);
            if (cacheEntry.isValid(l2)) continue;
            iterator.remove();
            ++n2;
        }
    }

    @Override
    @af(modifiers=33)
    public int size() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.expungeExpiredEntries();
                return this.cacheMap.size();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void clear() {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                if (this.queue != null) {
                    Iterator iterator = this.cacheMap.values().iterator();
                    while (iterator.hasNext()) {
                        CacheEntry cacheEntry = (CacheEntry)g.convertForCast(iterator.next(), CacheEntry.class);
                        cacheEntry.invalidate();
                    }
                    while (this.queue.poll() != null) {
                    }
                }
                this.cacheMap.clear();
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void put(Object object, Object object2) {
        Object object3 = ah.getMonitor((Object)((Object)this));
        synchronized (object3) {
            try {
                this.emptyQueue();
                long l2 = this.lifetime == 0L ? 0L : System.currentTimeMillis() + this.lifetime;
                CacheEntry cacheEntry = this.newEntry(object, object2, l2, this.queue);
                CacheEntry cacheEntry2 = (CacheEntry)g.convertForCast((Object)this.cacheMap.put(object, cacheEntry), CacheEntry.class);
                if (cacheEntry2 != null) {
                    cacheEntry2.invalidate();
                    return;
                }
                if (this.maxSize > 0 && this.cacheMap.size() > this.maxSize) {
                    this.expungeExpiredEntries();
                    if (this.cacheMap.size() > this.maxSize) {
                        Iterator iterator = this.cacheMap.values().iterator();
                        CacheEntry cacheEntry3 = (CacheEntry)g.convertForCast(iterator.next(), CacheEntry.class);
                        iterator.remove();
                        cacheEntry3.invalidate();
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public Object get(Object object) {
        Object object2 = ah.getMonitor((Object)((Object)this));
        synchronized (object2) {
            try {
                long l2;
                this.emptyQueue();
                CacheEntry cacheEntry = (CacheEntry)g.convertForCast(this.cacheMap.get(object), CacheEntry.class);
                if (cacheEntry == null) {
                    return null;
                }
                long l3 = l2 = this.lifetime == 0L ? 0L : System.currentTimeMillis();
                if (!cacheEntry.isValid(l2)) {
                    this.cacheMap.remove(object);
                    return null;
                }
                return cacheEntry.getValue();
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void remove(Object object) {
        Object object2 = ah.getMonitor((Object)((Object)this));
        synchronized (object2) {
            try {
                this.emptyQueue();
                CacheEntry cacheEntry = (CacheEntry)g.convertForCast(this.cacheMap.remove(object), CacheEntry.class);
                if (cacheEntry != null) {
                    cacheEntry.invalidate();
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void setCapacity(int n2) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.expungeExpiredEntries();
                if (n2 > 0 && this.cacheMap.size() > n2) {
                    Iterator iterator = this.cacheMap.values().iterator();
                    for (int i = this.cacheMap.size() - n2; i > 0; --i) {
                        CacheEntry cacheEntry = (CacheEntry)g.convertForCast(iterator.next(), CacheEntry.class);
                        iterator.remove();
                        cacheEntry.invalidate();
                    }
                }
                this.maxSize = n2 > 0 ? n2 : 0;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void setTimeout(int n2) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.emptyQueue();
                this.lifetime = n2 > 0 ? (long)n2 * 1000L : 0L;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    @af(modifiers=33)
    public void accept(Cache.CacheVisitor cacheVisitor) {
        Object object = ah.getMonitor((Object)((Object)this));
        synchronized (object) {
            try {
                this.expungeExpiredEntries();
                Map<Object, Object> map = this.getCachedEntries();
                cacheVisitor.visit(map);
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    private Map<Object, Object> getCachedEntries() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.cacheMap.size());
        Iterator iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = (CacheEntry)g.convertForCast(iterator.next(), CacheEntry.class);
            hashMap.put(cacheEntry.getKey(), cacheEntry.getValue());
        }
        return hashMap;
    }

    protected CacheEntry newEntry(Object object, Object object2, long l2, ReferenceQueue referenceQueue) {
        if (referenceQueue != null) {
            return new SoftCacheEntry(object, object2, l2, referenceQueue);
        }
        return new HardCacheEntry(object, object2, l2);
    }

    private static /* synthetic */ void _jr$ip$cacheMap(MemoryCache memoryCache, Map map) {
        memoryCache.cacheMap = map;
    }

    private static /* synthetic */ void _jr$ip$queue(MemoryCache memoryCache, ReferenceQueue referenceQueue) {
        memoryCache.queue = referenceQueue;
    }

    protected /* synthetic */ MemoryCache(h h2) {
        super(h2);
    }

    private static interface CacheEntry<K, V> {
        public boolean isValid(long var1);

        public void invalidate();

        public K getKey();

        public V getValue();

        public long getExpirationTime();
    }

    private static class HardCacheEntry
    extends h
    implements CacheEntry {
        private Object key;
        private Object value;
        private long expirationTime;

        HardCacheEntry(Object object, Object object2, long l2) {
            this.key = object;
            this.value = object2;
            this.expirationTime = l2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean isValid(long l2) {
            boolean bl;
            boolean bl2 = bl = l2 <= this.expirationTime;
            if (!bl) {
                this.invalidate();
            }
            return bl;
        }

        @Override
        public void invalidate() {
            this.key = null;
            this.value = null;
            this.expirationTime = -1L;
        }

        protected /* synthetic */ HardCacheEntry(h h2) {
            super(h2);
        }
    }

    private static class SoftCacheEntry
    extends SoftReference
    implements CacheEntry {
        private Object key;
        private long expirationTime;

        SoftCacheEntry(Object object, Object object2, long l2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
            this.expirationTime = l2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.get();
        }

        @Override
        public boolean isValid(long l2) {
            boolean bl;
            boolean bl2 = bl = l2 <= this.expirationTime && this.get() != null;
            if (!bl) {
                this.invalidate();
            }
            return bl;
        }

        @Override
        public void invalidate() {
            this.clear();
            this.key = null;
            this.expirationTime = -1L;
        }

        protected /* synthetic */ SoftCacheEntry(h h2) {
            super(h2);
        }
    }
}

