/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import sun.security.util.DerInputBuffer;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;

public final class ObjectIdentifier
extends h
implements Serializable {
    private byte[] encoding = null;
    private volatile transient String stringForm;
    private static final long serialVersionUID = 8697030238860181294L;
    private Object components = null;
    private int componentLen = -1;
    private transient boolean componentsCalculated = false;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.encoding == null) {
            this.init((int[])this.components, this.componentLen);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.componentsCalculated) {
            int[] nArray = this.toIntArray();
            if (nArray != null) {
                this.components = nArray;
                this.componentLen = nArray.length;
            } else {
                this.components = HugeOidNotSupportedByOldJDK.theOne;
            }
            this.componentsCalculated = true;
        }
        objectOutputStream.defaultWriteObject();
    }

    public ObjectIdentifier(String string) throws IOException {
        int n2 = 46;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = new byte[string.length()];
        int n6 = 0;
        int n7 = 0;
        try {
            String string2 = null;
            do {
                int n8 = 0;
                n4 = string.indexOf(n2, n3);
                if (n4 == -1) {
                    string2 = string.substring(n3);
                    n8 = string.length() - n3;
                } else {
                    string2 = string.substring(n3, n4);
                    n8 = n4 - n3;
                }
                if (n8 > 9) {
                    BigInteger bigInteger = new BigInteger(string2);
                    if (n7 == 0) {
                        ObjectIdentifier.checkFirstComponent(bigInteger);
                        n6 = bigInteger.intValue();
                    } else {
                        if (n7 == 1) {
                            ObjectIdentifier.checkSecondComponent(n6, bigInteger);
                            bigInteger = bigInteger.add(BigInteger.valueOf(40 * n6));
                        } else {
                            ObjectIdentifier.checkOtherComponent(n7, bigInteger);
                        }
                        n5 += ObjectIdentifier.pack7Oid(bigInteger, byArray, n5);
                    }
                } else {
                    int n9 = Integer.parseInt(string2);
                    if (n7 == 0) {
                        ObjectIdentifier.checkFirstComponent(n9);
                        n6 = n9;
                    } else {
                        if (n7 == 1) {
                            ObjectIdentifier.checkSecondComponent(n6, n9);
                            n9 += 40 * n6;
                        } else {
                            ObjectIdentifier.checkOtherComponent(n7, n9);
                        }
                        n5 += ObjectIdentifier.pack7Oid(n9, byArray, n5);
                    }
                }
                n3 = n4 + 1;
                ++n7;
            } while (n4 != -1);
            ObjectIdentifier.checkCount(n7);
            this.encoding = new byte[n5];
            a.arraycopy((Object)byArray, (int)0, (Object)this.encoding, (int)0, (int)n5);
            this.stringForm = string;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- Invalid format: " + exception.toString(), exception));
        }
    }

    public ObjectIdentifier(int[] nArray) throws IOException {
        ObjectIdentifier.checkCount(nArray.length);
        ObjectIdentifier.checkFirstComponent(nArray[0]);
        ObjectIdentifier.checkSecondComponent(nArray[0], nArray[1]);
        for (int i = 2; i < nArray.length; ++i) {
            ObjectIdentifier.checkOtherComponent(i, nArray[i]);
        }
        this.init(nArray, nArray.length);
    }

    public ObjectIdentifier(DerInputStream derInputStream) throws IOException {
        byte by = (byte)derInputStream.getByte();
        if (by != 6) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- data isn't an object ID (tag = " + by + ")"));
        }
        this.encoding = new byte[derInputStream.getLength()];
        derInputStream.getBytes(this.encoding);
        ObjectIdentifier.check(this.encoding);
    }

    ObjectIdentifier(DerInputBuffer derInputBuffer) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derInputBuffer);
        this.encoding = new byte[derInputStream.available()];
        derInputStream.getBytes(this.encoding);
        ObjectIdentifier.check(this.encoding);
    }

    private void init(int[] nArray, int n2) {
        int n3 = 0;
        byte[] byArray = new byte[n2 * 5 + 1];
        if (nArray[1] < Integer.MAX_VALUE - nArray[0] * 40) {
            n3 += ObjectIdentifier.pack7Oid(nArray[0] * 40 + nArray[1], byArray, n3);
        } else {
            BigInteger bigInteger = BigInteger.valueOf(nArray[1]);
            bigInteger = bigInteger.add(BigInteger.valueOf(nArray[0] * 40));
            n3 += ObjectIdentifier.pack7Oid(bigInteger, byArray, n3);
        }
        for (int i = 2; i < n2; ++i) {
            n3 += ObjectIdentifier.pack7Oid(nArray[i], byArray, n3);
        }
        this.encoding = new byte[n3];
        a.arraycopy((Object)byArray, (int)0, (Object)this.encoding, (int)0, (int)n3);
    }

    public static ObjectIdentifier newInternal(int[] nArray) {
        try {
            return new ObjectIdentifier(nArray);
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException(iOException));
        }
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.write((byte)6, this.encoding);
    }

    @Deprecated
    public boolean equals(ObjectIdentifier objectIdentifier) {
        return this.equals((Object)objectIdentifier);
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(object instanceof ObjectIdentifier)) {
            return false;
        }
        ObjectIdentifier objectIdentifier = (ObjectIdentifier)object;
        return Arrays.equals(this.encoding, objectIdentifier.encoding);
    }

    public int hashCode() {
        return Arrays.hashCode(this.encoding);
    }

    private int[] toIntArray() {
        int n2 = this.encoding.length;
        int[] nArray = new int[20];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if ((this.encoding[i] & 0x80) == 0) {
                if (i - n4 + 1 > 4) {
                    BigInteger bigInteger = new BigInteger(ObjectIdentifier.pack(this.encoding, n4, i - n4 + 1, 7, 8));
                    if (n4 == 0) {
                        nArray[n3++] = 2;
                        BigInteger bigInteger2 = bigInteger.subtract(BigInteger.valueOf(80L));
                        if (bigInteger2.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                            return null;
                        }
                        nArray[n3++] = bigInteger2.intValue();
                    } else {
                        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == 1) {
                            return null;
                        }
                        nArray[n3++] = bigInteger.intValue();
                    }
                } else {
                    int n5 = 0;
                    for (int k = n4; k <= i; ++k) {
                        n5 <<= 7;
                        byte by = this.encoding[k];
                        n5 |= by & 0x7F;
                    }
                    if (n4 == 0) {
                        if (n5 < 80) {
                            nArray[n3++] = n5 / 40;
                            nArray[n3++] = n5 % 40;
                        } else {
                            nArray[n3++] = 2;
                            nArray[n3++] = n5 - 80;
                        }
                    } else {
                        nArray[n3++] = n5;
                    }
                }
                n4 = i + 1;
            }
            if (n3 < nArray.length) continue;
            nArray = Arrays.copyOf(nArray, n3 + 10);
        }
        return Arrays.copyOf(nArray, n3);
    }

    public String toString() {
        String string = this.stringForm;
        if (string == null) {
            int n2 = this.encoding.length;
            StringBuffer stringBuffer = new StringBuffer(n2 * 4);
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if ((this.encoding[i] & 0x80) != 0) continue;
                if (n3 != 0) {
                    stringBuffer.append('.');
                }
                if (i - n3 + 1 > 4) {
                    BigInteger bigInteger = new BigInteger(ObjectIdentifier.pack(this.encoding, n3, i - n3 + 1, 7, 8));
                    if (n3 == 0) {
                        stringBuffer.append("2.");
                        stringBuffer.append(bigInteger.subtract(BigInteger.valueOf(80L)));
                    } else {
                        stringBuffer.append(bigInteger);
                    }
                } else {
                    int n4 = 0;
                    for (int k = n3; k <= i; ++k) {
                        n4 <<= 7;
                        byte by = this.encoding[k];
                        n4 |= by & 0x7F;
                    }
                    if (n3 == 0) {
                        if (n4 < 80) {
                            stringBuffer.append(n4 / 40);
                            stringBuffer.append('.');
                            stringBuffer.append(n4 % 40);
                        } else {
                            stringBuffer.append("2.");
                            stringBuffer.append(n4 - 80);
                        }
                    } else {
                        stringBuffer.append(n4);
                    }
                }
                n3 = i + 1;
            }
            this.stringForm = string = stringBuffer.toString();
        }
        return string;
    }

    private static byte[] pack(byte[] byArray, int n2, int n3, int n4, int n5) {
        if (!($assertionsDisabled || n4 > 0 && n4 <= 8)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"input NUB must be between 1 and 8"));
        }
        if (!($assertionsDisabled || n5 > 0 && n5 <= 8)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new AssertionError((Object)"output NUB must be between 1 and 8"));
        }
        if (n4 == n5) {
            return (byte[])byArray.clone();
        }
        int n6 = n3 * n4;
        byte[] byArray2 = new byte[(n6 + n5 - 1) / n5];
        int n7 = 0;
        int n8 = (n6 + n5 - 1) / n5 * n5 - n6;
        while (n7 < n6) {
            int n9 = n4 - n7 % n4;
            if (n9 > n5 - n8 % n5) {
                n9 = n5 - n8 % n5;
            }
            int n10 = n8 / n5;
            byArray2[n10] = (byte)(byArray2[n10] | (byArray[n2 + n7 / n4] + 256 >> n4 - n7 % n4 - n9 & (1 << n9) - 1) << n5 - n8 % n5 - n9);
            n7 += n9;
            n8 += n9;
        }
        return byArray2;
    }

    private static int pack7Oid(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = ObjectIdentifier.pack(byArray, n2, n3, 8, 7);
        int n5 = byArray3.length - 1;
        int n6 = byArray3.length - 2;
        while (n6 >= 0) {
            if (byArray3[n6] != 0) {
                n5 = n6;
            }
            int n7 = n6--;
            byArray3[n7] = (byte)(byArray3[n7] | 0x80);
        }
        a.arraycopy((Object)byArray3, (int)n5, (Object)byArray2, (int)n4, (int)(byArray3.length - n5));
        return byArray3.length - n5;
    }

    private static int pack8(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = ObjectIdentifier.pack(byArray, n2, n3, 7, 8);
        int n5 = byArray3.length - 1;
        for (int i = byArray3.length - 2; i >= 0; --i) {
            if (byArray3[i] == 0) continue;
            n5 = i;
        }
        a.arraycopy((Object)byArray3, (int)n5, (Object)byArray2, (int)n4, (int)(byArray3.length - n5));
        return byArray3.length - n5;
    }

    private static int pack7Oid(int n2, byte[] byArray, int n3) {
        byte[] byArray2 = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return ObjectIdentifier.pack7Oid(byArray2, 0, 4, byArray, n3);
    }

    private static int pack7Oid(BigInteger bigInteger, byte[] byArray, int n2) {
        byte[] byArray2 = bigInteger.toByteArray();
        return ObjectIdentifier.pack7Oid(byArray2, 0, byArray2.length, byArray, n2);
    }

    private static void check(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (n2 < 1 || (byArray[n2 - 1] & 0x80) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- Invalid DER encoding, not ended"));
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != -128 || i != 0 && (byArray[i - 1] & 0x80) != 0) continue;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- Invalid DER encoding, useless extra octet detected"));
        }
    }

    private static void checkCount(int n2) throws IOException {
        if (n2 < 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- Must be at least two oid components "));
        }
    }

    private static void checkFirstComponent(int n2) throws IOException {
        if (n2 < 0 || n2 > 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- First oid component is invalid "));
        }
    }

    private static void checkFirstComponent(BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() == -1 || bigInteger.compareTo(BigInteger.valueOf(2L)) == 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- First oid component is invalid "));
        }
    }

    private static void checkSecondComponent(int n2, int n3) throws IOException {
        if (n3 < 0 || n2 != 2 && n3 > 39) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- Second oid component is invalid "));
        }
    }

    private static void checkSecondComponent(int n2, BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() == -1 || n2 != 2 && bigInteger.compareTo(BigInteger.valueOf(39L)) == 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- Second oid component is invalid "));
        }
    }

    private static void checkOtherComponent(int n2, int n3) throws IOException {
        if (n3 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- oid component #" + (n2 + 1) + " must be non-negative "));
        }
    }

    private static void checkOtherComponent(int n2, BigInteger bigInteger) throws IOException {
        if (bigInteger.signum() == -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("ObjectIdentifier() -- oid component #" + (n2 + 1) + " must be non-negative "));
        }
    }

    private static /* synthetic */ byte[] _jr$ig$encoding(ObjectIdentifier objectIdentifier) {
        return objectIdentifier.encoding;
    }

    private static /* synthetic */ void _jr$ip$encoding(ObjectIdentifier objectIdentifier, byte[] byArray) {
        objectIdentifier.encoding = byArray;
    }

    private static /* synthetic */ String _jr$ig$stringForm(ObjectIdentifier objectIdentifier) {
        return objectIdentifier.stringForm;
    }

    private static /* synthetic */ void _jr$ip$stringForm(ObjectIdentifier objectIdentifier, String string) {
        objectIdentifier.stringForm = string;
    }

    private static /* synthetic */ Object _jr$ig$components(ObjectIdentifier objectIdentifier) {
        return objectIdentifier.components;
    }

    private static /* synthetic */ void _jr$ip$components(ObjectIdentifier objectIdentifier, Object object) {
        objectIdentifier.components = object;
    }

    private static /* synthetic */ int _jr$ig$componentLen(ObjectIdentifier objectIdentifier) {
        return objectIdentifier.componentLen;
    }

    private static /* synthetic */ void _jr$ip$componentLen(ObjectIdentifier objectIdentifier, int n2) {
        objectIdentifier.componentLen = n2;
    }

    private static /* synthetic */ boolean _jr$ig$componentsCalculated(ObjectIdentifier objectIdentifier) {
        return objectIdentifier.componentsCalculated;
    }

    private static /* synthetic */ void _jr$ip$componentsCalculated(ObjectIdentifier objectIdentifier, boolean bl) {
        objectIdentifier.componentsCalculated = bl;
    }

    static class HugeOidNotSupportedByOldJDK
    extends h
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static HugeOidNotSupportedByOldJDK theOne = new HugeOidNotSupportedByOldJDK();

        HugeOidNotSupportedByOldJDK() {
        }

        protected /* synthetic */ HugeOidNotSupportedByOldJDK(h h2) {
            super(h2);
        }
    }
}

