/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.security.AccessController;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import sun.security.action.GetBooleanAction;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVAKeyword;
import sun.security.x509.X500Name;

public class AVA
extends h
implements DerEncoder {
    private static final Debug debug = Debug.getInstance("x509", "\t[AVA]");
    private static final boolean PRESERVE_OLD_DC_ENCODING = (Boolean)AccessController.doPrivileged(new GetBooleanAction("com.sun.security.preserveOldDCEncoding"));
    static final int DEFAULT = 1;
    static final int RFC1779 = 2;
    static final int RFC2253 = 3;
    final ObjectIdentifier oid;
    final DerValue value;
    private static final String specialChars = ",+=\n<>#;";
    private static final String specialChars2253 = ",+\"\\<>;";
    private static final String specialCharsAll = ",=\n+<>#;\\\" ";
    private static final String hexDigits = "0123456789ABCDEF";

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        if (objectIdentifier == null || derValue == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        this.oid = objectIdentifier;
        this.value = derValue;
    }

    AVA(Reader reader) throws IOException {
        this(reader, 1);
    }

    AVA(Reader reader, Map<String, String> map) throws IOException {
        this(reader, 1, map);
    }

    AVA(Reader reader, int n2) throws IOException {
        this(reader, n2, Collections.emptyMap());
    }

    AVA(Reader reader, int n2, Map<String, String> map) throws IOException {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n3 = AVA.readChar(reader, "Incorrect AVA format")) != 61) {
            stringBuilder.append((char)n3);
        }
        this.oid = AVAKeyword.getOID(stringBuilder.toString(), n2, map);
        stringBuilder.setLength(0);
        if (n2 == 3) {
            n3 = reader.read();
            if (n3 == 32) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Incorrect AVA RFC2253 format - leading space must be escaped"));
            }
        } else {
            while ((n3 = reader.read()) == 32 || n3 == 10) {
            }
        }
        if (n3 == -1) {
            this.value = new DerValue("");
            return;
        }
        this.value = n3 == 35 ? AVA.parseHexString(reader, n2) : (n3 == 34 && n2 != 3 ? this.parseQuotedString(reader, stringBuilder) : this.parseString(reader, n3, n2, stringBuilder));
    }

    public ObjectIdentifier getObjectIdentifier() {
        return ((AVA)this).oid;
    }

    public DerValue getDerValue() {
        return ((AVA)this).value;
    }

    public String getValueString() {
        try {
            String string = ((AVA)this).value.getAsString();
            if (string == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("AVA string is null"));
            }
            return string;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("AVA error: " + iOException, iOException));
        }
    }

    private static DerValue parseHexString(Reader reader, int n2) throws IOException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = 0;
        int n5 = 0;
        while (!AVA.isTerminator(n3 = reader.read(), n2)) {
            int n6 = hexDigits.indexOf(Character.toUpperCase((char)n3));
            if (n6 == -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("AVA parse, invalid hex digit: " + (char)n3));
            }
            if (n5 % 2 == 1) {
                n4 = (byte)(n4 * 16 + (byte)n6);
                byteArrayOutputStream.write(n4);
            } else {
                n4 = (byte)n6;
            }
            ++n5;
        }
        if (n5 == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("AVA parse, zero hex digits"));
        }
        if (n5 % 2 == 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("AVA parse, odd number of hex digits"));
        }
        return new DerValue(byteArrayOutputStream.toByteArray());
    }

    private DerValue parseQuotedString(Reader reader, StringBuilder stringBuilder) throws IOException {
        Object object;
        int n2 = AVA.readChar(reader, "Quoted string did not end in quote");
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        boolean bl = true;
        while (n2 != 34) {
            if (n2 == 92) {
                n2 = AVA.readChar(reader, "Quoted string did not end in quote");
                object = null;
                object = AVA.getEmbeddedHexPair(n2, reader);
                if (object != null) {
                    bl = false;
                    arrayList.add((Byte)object);
                    n2 = reader.read();
                    continue;
                }
                if (n2 != 92 && n2 != 34 && specialChars.indexOf((char)n2) < 0) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid escaped character in AVA: " + (char)n2));
                }
            }
            if (arrayList.size() > 0) {
                object = AVA.getEmbeddedHexString(arrayList);
                stringBuilder.append((String)object);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n2);
            stringBuilder.append((char)n2);
            n2 = AVA.readChar(reader, "Quoted string did not end in quote");
        }
        if (arrayList.size() > 0) {
            object = AVA.getEmbeddedHexString(arrayList);
            stringBuilder.append((String)object);
            arrayList.clear();
        }
        while ((n2 = reader.read()) == 10 || n2 == 32) {
        }
        if (n2 != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("AVA had characters other than whitespace after terminating quote"));
        }
        if (((AVA)this).oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID) || ((AVA)this).oid.equals(X500Name.DOMAIN_COMPONENT_OID) && !PRESERVE_OLD_DC_ENCODING) {
            return new DerValue(22, stringBuilder.toString().trim());
        }
        if (bl) {
            return new DerValue(stringBuilder.toString().trim());
        }
        return new DerValue(12, stringBuilder.toString().trim());
    }

    private DerValue parseString(Reader reader, int n2, int n3, StringBuilder stringBuilder) throws IOException {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = true;
        int n4 = 0;
        do {
            bl2 = false;
            if (n2 == 92) {
                bl2 = true;
                n2 = AVA.readChar(reader, "Invalid trailing backslash");
                Byte by = null;
                by = AVA.getEmbeddedHexPair(n2, reader);
                if (by != null) {
                    bl = false;
                    arrayList.add(by);
                    n2 = reader.read();
                    bl3 = false;
                    continue;
                }
                if (n3 == 1 && specialCharsAll.indexOf((char)n2) == -1 || n3 == 2 && specialChars.indexOf((char)n2) == -1 && n2 != 92 && n2 != 34) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid escaped character in AVA: '" + (char)n2 + "'"));
                }
                if (n3 == 3) {
                    if (n2 == 32) {
                        if (!bl3 && !AVA.trailingSpace(reader)) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid escaped space character in AVA.  Only a leading or trailing space character can be escaped."));
                        }
                    } else if (n2 == 35) {
                        if (!bl3) {
                            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid escaped '#' character in AVA.  Only a leading '#' can be escaped."));
                        }
                    } else if (specialChars2253.indexOf((char)n2) == -1) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid escaped character in AVA: '" + (char)n2 + "'"));
                    }
                }
            } else if (n3 == 3 && specialChars2253.indexOf((char)n2) != -1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Character '" + (char)n2 + "' in AVA appears without escape"));
            }
            if (arrayList.size() > 0) {
                for (int i = 0; i < n4; ++i) {
                    stringBuilder.append(" ");
                }
                n4 = 0;
                String string = AVA.getEmbeddedHexString(arrayList);
                stringBuilder.append(string);
                arrayList.clear();
            }
            bl &= DerValue.isPrintableStringChar((char)n2);
            if (n2 == 32 && !bl2) {
                ++n4;
            } else {
                for (int i = 0; i < n4; ++i) {
                    stringBuilder.append(" ");
                }
                n4 = 0;
                stringBuilder.append((char)n2);
            }
            n2 = reader.read();
            bl3 = false;
        } while (!AVA.isTerminator(n2, n3));
        if (n3 == 3 && n4 > 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Incorrect AVA RFC2253 format - trailing space must be escaped"));
        }
        if (arrayList.size() > 0) {
            String string = AVA.getEmbeddedHexString(arrayList);
            stringBuilder.append(string);
            arrayList.clear();
        }
        if (((AVA)this).oid.equals(PKCS9Attribute.EMAIL_ADDRESS_OID) || ((AVA)this).oid.equals(X500Name.DOMAIN_COMPONENT_OID) && !PRESERVE_OLD_DC_ENCODING) {
            return new DerValue(22, stringBuilder.toString());
        }
        if (bl) {
            return new DerValue(stringBuilder.toString());
        }
        return new DerValue(12, stringBuilder.toString());
    }

    private static Byte getEmbeddedHexPair(int n2, Reader reader) throws IOException {
        if (hexDigits.indexOf(Character.toUpperCase((char)n2)) >= 0) {
            int n3 = AVA.readChar(reader, "unexpected EOF - escaped hex value must include two valid digits");
            if (hexDigits.indexOf(Character.toUpperCase((char)n3)) >= 0) {
                int n4 = Character.digit((char)n2, 16);
                int n5 = Character.digit((char)n3, 16);
                return new Byte((byte)((n4 << 4) + n5));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("escaped hex value must include two valid digits"));
        }
        return null;
    }

    private static String getEmbeddedHexString(List<Byte> list) throws IOException {
        int n2 = list.size();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = list.get(i);
        }
        return new String(byArray, "UTF8");
    }

    private static boolean isTerminator(int n2, int n3) {
        switch (n2) {
            case -1: 
            case 43: 
            case 44: {
                return true;
            }
            case 59: 
            case 62: {
                return n3 != 3;
            }
        }
        return false;
    }

    private static int readChar(Reader reader, String string) throws IOException {
        int n2 = reader.read();
        if (n2 == -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(string));
        }
        return n2;
    }

    private static boolean trailingSpace(Reader reader) throws IOException {
        boolean bl;
        block3: {
            block4: {
                bl = false;
                if (!reader.markSupported()) {
                    return true;
                }
                reader.mark(9999);
                while (true) {
                    int n2;
                    if ((n2 = reader.read()) == -1) {
                        bl = true;
                        break block3;
                    }
                    if (n2 == 32) continue;
                    if (n2 != 92) break block4;
                    int n3 = reader.read();
                    if (n3 != 32) break;
                }
                bl = false;
                break block3;
            }
            bl = false;
        }
        reader.reset();
        return bl;
    }

    AVA(DerValue derValue) throws IOException {
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("AVA not a sequence"));
        }
        this.oid = X500Name.intern(DerValue._jr$ig$data((Object)derValue).getOID());
        this.value = DerValue._jr$ig$data((Object)derValue).getDerValue();
        if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("AVA, extra bytes = " + DerValue._jr$ig$data((Object)derValue).available()));
        }
    }

    AVA(DerInputStream derInputStream) throws IOException {
        this(derInputStream.getDerValue());
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, AVA.class) instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)g.convertForCast((Object)object, AVA.class);
        return this.toRFC2253CanonicalString().equals(aVA.toRFC2253CanonicalString());
    }

    public int hashCode() {
        return this.toRFC2253CanonicalString().hashCode();
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(((AVA)this).oid);
        ((AVA)this).value.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    private String toKeyword(int n2, Map<String, String> map) {
        return AVAKeyword.getKeyword(((AVA)this).oid, n2, map);
    }

    public String toString() {
        return this.toKeywordValueString(this.toKeyword(1, Collections.emptyMap()));
    }

    public String toRFC1779String() {
        return this.toRFC1779String(Collections.emptyMap());
    }

    public String toRFC1779String(Map<String, String> map) {
        return this.toKeywordValueString(this.toKeyword(2, map));
    }

    public String toRFC2253String() {
        return this.toRFC2253String(Collections.emptyMap());
    }

    public String toRFC2253String(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.toKeyword(3, map));
        stringBuilder.append('=');
        if (stringBuilder.charAt(0) >= '0' && stringBuilder.charAt(0) <= '9' || !AVA.isDerString(((AVA)this).value, false)) {
            byte[] byArray = null;
            try {
                byArray = ((AVA)this).value.toByteArray();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
            }
            stringBuilder.append('#');
            for (int i = 0; i < byArray.length; ++i) {
                byte by = byArray[i];
                stringBuilder.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuilder.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            int n2;
            char c2;
            int n3;
            char c3;
            String string = null;
            try {
                string = new String(((AVA)this).value.getDataBytes(), "UTF8");
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                c3 = string.charAt(i);
                if (DerValue.isPrintableStringChar(c3) || ",=+<>#;\"\\".indexOf(c3) >= 0) {
                    if (",=+<>#;\"\\".indexOf(c3) >= 0) {
                        stringBuilder2.append('\\');
                    }
                    stringBuilder2.append(c3);
                    continue;
                }
                if (c3 == '\u0000') {
                    stringBuilder2.append("\\00");
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString(c3).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
                    }
                    for (n3 = 0; n3 < byArray.length; ++n3) {
                        stringBuilder2.append('\\');
                        c2 = Character.forDigit(0xF & byArray[n3] >>> 4, 16);
                        stringBuilder2.append(Character.toUpperCase(c2));
                        c2 = Character.forDigit(0xF & byArray[n3], 16);
                        stringBuilder2.append(Character.toUpperCase(c2));
                    }
                    continue;
                }
                stringBuilder2.append(c3);
            }
            char[] cArray = stringBuilder2.toString().toCharArray();
            stringBuilder2 = new StringBuilder();
            for (c3 = '\u0000'; c3 < cArray.length && (cArray[c3] == ' ' || cArray[c3] == '\r'); ++c3) {
            }
            for (n2 = cArray.length - 1; n2 >= 0 && (cArray[n2] == ' ' || cArray[n2] == '\r'); --n2) {
            }
            for (n3 = 0; n3 < cArray.length; ++n3) {
                c2 = cArray[n3];
                if (n3 < c3 || n3 > n2) {
                    stringBuilder2.append('\\');
                }
                stringBuilder2.append(c2);
            }
            stringBuilder.append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    public String toRFC2253CanonicalString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(this.toKeyword(3, Collections.emptyMap()));
        stringBuilder.append('=');
        if (stringBuilder.charAt(0) >= '0' && stringBuilder.charAt(0) <= '9' || !AVA.isDerString(((AVA)this).value, true)) {
            object = null;
            try {
                object = ((AVA)this).value.toByteArray();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
            }
            stringBuilder.append('#');
            for (int i = 0; i < ((byte[])object).length; ++i) {
                byte by = object[i];
                stringBuilder.append(Character.forDigit(0xF & by >>> 4, 16));
                stringBuilder.append(Character.forDigit(0xF & by, 16));
            }
        } else {
            object = null;
            try {
                object = new String(((AVA)this).value.getDataBytes(), "UTF8");
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < ((String)object).length(); ++i) {
                char c2 = ((String)object).charAt(i);
                if (DerValue.isPrintableStringChar(c2) || ",+<>;\"\\".indexOf(c2) >= 0 || i == 0 && c2 == '#') {
                    if (i == 0 && c2 == '#' || ",+<>;\"\\".indexOf(c2) >= 0) {
                        stringBuilder2.append('\\');
                    }
                    if (!Character.isWhitespace(c2)) {
                        bl = false;
                        stringBuilder2.append(c2);
                        continue;
                    }
                    if (bl) continue;
                    bl = true;
                    stringBuilder2.append(c2);
                    continue;
                }
                if (debug != null && Debug.isOn("ava")) {
                    bl = false;
                    byte[] byArray = null;
                    try {
                        byArray = Character.toString(c2).getBytes("UTF8");
                    }
                    catch (IOException iOException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
                    }
                    for (int k = 0; k < byArray.length; ++k) {
                        stringBuilder2.append('\\');
                        stringBuilder2.append(Character.forDigit(0xF & byArray[k] >>> 4, 16));
                        stringBuilder2.append(Character.forDigit(0xF & byArray[k], 16));
                    }
                    continue;
                }
                bl = false;
                stringBuilder2.append(c2);
            }
            stringBuilder.append(stringBuilder2.toString().trim());
        }
        object = stringBuilder.toString();
        object = ((String)object).toUpperCase(Locale.US).toLowerCase(Locale.US);
        return Normalizer.normalize((CharSequence)object, Normalizer.Form.NFKD);
    }

    private static boolean isDerString(DerValue derValue, boolean bl) {
        if (bl) {
            switch (DerValue._jr$ig$tag((Object)derValue)) {
                case 12: 
                case 19: {
                    return true;
                }
            }
            return false;
        }
        switch (DerValue._jr$ig$tag((Object)derValue)) {
            case 12: 
            case 19: 
            case 20: 
            case 22: 
            case 27: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    boolean hasRFC2253Keyword() {
        return AVAKeyword.hasKeyword(((AVA)this).oid, 3);
    }

    private String toKeywordValueString(String string) {
        StringBuilder stringBuilder;
        block17: {
            stringBuilder = new StringBuilder(40);
            stringBuilder.append(string);
            stringBuilder.append("=");
            try {
                int n2;
                String string2 = ((AVA)this).value.getAsString();
                if (string2 == null) {
                    byte[] byArray = ((AVA)this).value.toByteArray();
                    stringBuilder.append('#');
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuilder.append(hexDigits.charAt(byArray[i] >> 4 & 0xF));
                        stringBuilder.append(hexDigits.charAt(byArray[i] & 0xF));
                    }
                    break block17;
                }
                boolean bl = false;
                StringBuilder stringBuilder2 = new StringBuilder();
                boolean bl2 = false;
                int n3 = string2.length();
                boolean bl3 = n3 > 1 && string2.charAt(0) == '\"' && string2.charAt(n3 - 1) == '\"';
                for (n2 = 0; n2 < n3; ++n2) {
                    char c2 = string2.charAt(n2);
                    if (bl3 && (n2 == 0 || n2 == n3 - 1)) {
                        stringBuilder2.append(c2);
                        continue;
                    }
                    if (DerValue.isPrintableStringChar(c2) || ",+=\n<>#;\\\"".indexOf(c2) >= 0) {
                        if (!(bl || (n2 != 0 || c2 != ' ' && c2 != '\n') && ",+=\n<>#;\\\"".indexOf(c2) < 0)) {
                            bl = true;
                        }
                        if (c2 != ' ' && c2 != '\n') {
                            if (c2 == '\"' || c2 == '\\') {
                                stringBuilder2.append('\\');
                            }
                            bl2 = false;
                        } else {
                            if (!bl && bl2) {
                                bl = true;
                            }
                            bl2 = true;
                        }
                        stringBuilder2.append(c2);
                        continue;
                    }
                    if (debug != null && Debug.isOn("ava")) {
                        bl2 = false;
                        byte[] byArray = Character.toString(c2).getBytes("UTF8");
                        for (int i = 0; i < byArray.length; ++i) {
                            stringBuilder2.append('\\');
                            char c3 = Character.forDigit(0xF & byArray[i] >>> 4, 16);
                            stringBuilder2.append(Character.toUpperCase(c3));
                            c3 = Character.forDigit(0xF & byArray[i], 16);
                            stringBuilder2.append(Character.toUpperCase(c3));
                        }
                        continue;
                    }
                    bl2 = false;
                    stringBuilder2.append(c2);
                }
                if (stringBuilder2.length() > 0 && ((n2 = (int)stringBuilder2.charAt(stringBuilder2.length() - 1)) == 32 || n2 == 10)) {
                    bl = true;
                }
                if (!bl3 && bl) {
                    stringBuilder.append("\"" + stringBuilder2.toString() + "\"");
                } else {
                    stringBuilder.append(stringBuilder2.toString());
                }
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("DER Value conversion"));
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ void _jr$ip$oid(Object object, ObjectIdentifier objectIdentifier) {
        ((AVA)object).oid = objectIdentifier;
    }

    static /* synthetic */ void _jr$ip$value(Object object, DerValue derValue) {
        ((AVA)object).value = derValue;
    }

    protected /* synthetic */ AVA(h h2) {
        super(h2);
    }
}

