/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.X500Name;

class AVAKeyword
extends h {
    private static final Map<ObjectIdentifier, AVAKeyword> oidMap = new HashMap<ObjectIdentifier, AVAKeyword>();
    private static final Map<String, AVAKeyword> keywordMap = new HashMap<String, AVAKeyword>();
    private String keyword;
    private ObjectIdentifier oid;
    private boolean rfc1779Compliant;
    private boolean rfc2253Compliant;

    private AVAKeyword(String string, ObjectIdentifier objectIdentifier, boolean bl, boolean bl2) {
        this.keyword = string;
        this.oid = objectIdentifier;
        this.rfc1779Compliant = bl;
        this.rfc2253Compliant = bl2;
        oidMap.put(objectIdentifier, this);
        keywordMap.put(string, this);
    }

    private boolean isCompliant(int n2) {
        switch (n2) {
            case 2: {
                return this.rfc1779Compliant;
            }
            case 3: {
                return this.rfc2253Compliant;
            }
            case 1: {
                return true;
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Invalid standard " + n2));
    }

    static ObjectIdentifier getOID(String string, int n2) throws IOException {
        return AVAKeyword.getOID(string, n2, Collections.emptyMap());
    }

    static ObjectIdentifier getOID(String string, int n2, Map<String, String> map) throws IOException {
        char c2;
        String string2;
        string = string.toUpperCase(Locale.ENGLISH);
        if (n2 == 3) {
            if (string.startsWith(" ") || string.endsWith(" ")) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid leading or trailing space in keyword \"" + string + "\""));
            }
        } else {
            string = string.trim();
        }
        if ((string2 = map.get(string)) == null) {
            AVAKeyword aVAKeyword = (AVAKeyword)((Object)g.convertForCast((Object)((Object)keywordMap.get(string)), AVAKeyword.class));
            if (aVAKeyword != null && aVAKeyword.isCompliant(n2)) {
                return aVAKeyword.oid;
            }
        } else {
            return new ObjectIdentifier(string2);
        }
        if (n2 == 2) {
            if (!string.startsWith("OID.")) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid RFC1779 keyword: " + string));
            }
            string = string.substring(4);
        } else if (n2 == 1 && string.startsWith("OID.")) {
            string = string.substring(4);
        }
        boolean bl = false;
        if (string.length() != 0 && (c2 = string.charAt(0)) >= '0' && c2 <= '9') {
            bl = true;
        }
        if (!bl) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid keyword \"" + string + "\""));
        }
        return new ObjectIdentifier(string);
    }

    static String getKeyword(ObjectIdentifier objectIdentifier, int n2) {
        return AVAKeyword.getKeyword(objectIdentifier, n2, Collections.emptyMap());
    }

    static String getKeyword(ObjectIdentifier objectIdentifier, int n2, Map<String, String> map) {
        String string = objectIdentifier.toString();
        String string2 = map.get(string);
        if (string2 == null) {
            AVAKeyword aVAKeyword = (AVAKeyword)((Object)g.convertForCast((Object)((Object)oidMap.get(objectIdentifier)), AVAKeyword.class));
            if (aVAKeyword != null && aVAKeyword.isCompliant(n2)) {
                return aVAKeyword.keyword;
            }
        } else {
            if (string2.length() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("keyword cannot be empty"));
            }
            char c2 = (string2 = string2.trim()).charAt(0);
            if (c2 < 'A' || c2 > 'z' || c2 > 'Z' && c2 < 'a') {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("keyword does not start with letter"));
            }
            for (int i = 1; i < string2.length(); ++i) {
                c2 = string2.charAt(i);
                if (c2 >= 'A' && c2 <= 'z' && (c2 <= 'Z' || c2 >= 'a') || c2 >= '0' && c2 <= '9' || c2 == '_') continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("keyword character is not a letter, digit, or underscore"));
            }
            return string2;
        }
        if (n2 == 3) {
            return string;
        }
        return "OID." + string;
    }

    static boolean hasKeyword(ObjectIdentifier objectIdentifier, int n2) {
        AVAKeyword aVAKeyword = (AVAKeyword)((Object)g.convertForCast((Object)((Object)oidMap.get(objectIdentifier)), AVAKeyword.class));
        if (aVAKeyword == null) {
            return false;
        }
        return aVAKeyword.isCompliant(n2);
    }

    static {
        new AVAKeyword("CN", X500Name.commonName_oid, true, true);
        new AVAKeyword("C", X500Name.countryName_oid, true, true);
        new AVAKeyword("L", X500Name.localityName_oid, true, true);
        new AVAKeyword("S", X500Name.stateName_oid, false, false);
        new AVAKeyword("ST", X500Name.stateName_oid, true, true);
        new AVAKeyword("O", X500Name.orgName_oid, true, true);
        new AVAKeyword("OU", X500Name.orgUnitName_oid, true, true);
        new AVAKeyword("T", X500Name.title_oid, false, false);
        new AVAKeyword("IP", X500Name.ipAddress_oid, false, false);
        new AVAKeyword("STREET", X500Name.streetAddress_oid, true, true);
        new AVAKeyword("DC", X500Name.DOMAIN_COMPONENT_OID, false, true);
        new AVAKeyword("DNQUALIFIER", X500Name.DNQUALIFIER_OID, false, false);
        new AVAKeyword("DNQ", X500Name.DNQUALIFIER_OID, false, false);
        new AVAKeyword("SURNAME", X500Name.SURNAME_OID, false, false);
        new AVAKeyword("GIVENNAME", X500Name.GIVENNAME_OID, false, false);
        new AVAKeyword("INITIALS", X500Name.INITIALS_OID, false, false);
        new AVAKeyword("GENERATION", X500Name.GENERATIONQUALIFIER_OID, false, false);
        new AVAKeyword("EMAIL", PKCS9Attribute.EMAIL_ADDRESS_OID, false, false);
        new AVAKeyword("EMAILADDRESS", PKCS9Attribute.EMAIL_ADDRESS_OID, false, false);
        new AVAKeyword("UID", X500Name.userid_oid, false, true);
        new AVAKeyword("SERIALNUMBER", X500Name.SERIALNUMBER_OID, false, false);
    }

    private static /* synthetic */ void _jr$ip$keyword(AVAKeyword aVAKeyword, String string) {
        aVAKeyword.keyword = string;
    }

    private static /* synthetic */ void _jr$ip$oid(AVAKeyword aVAKeyword, ObjectIdentifier objectIdentifier) {
        aVAKeyword.oid = objectIdentifier;
    }

    private static /* synthetic */ void _jr$ip$rfc1779Compliant(AVAKeyword aVAKeyword, boolean bl) {
        aVAKeyword.rfc1779Compliant = bl;
    }

    private static /* synthetic */ void _jr$ip$rfc2253Compliant(AVAKeyword aVAKeyword, boolean bl) {
        aVAKeyword.rfc2253Compliant = bl;
    }

    protected /* synthetic */ AVAKeyword(h h2) {
        super(h2);
    }
}

