/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;

public class AuthorityKeyIdentifierExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.AuthorityKeyIdentifier";
    public static final String NAME = "AuthorityKeyIdentifier";
    public static final String KEY_ID = "key_id";
    public static final String AUTH_NAME = "auth_name";
    public static final String SERIAL_NUMBER = "serial_number";
    private static final byte TAG_ID = 0;
    private static final byte TAG_NAMES = 1;
    private static final byte TAG_SERIAL_NUM = 2;
    private KeyIdentifier id;
    private GeneralNames names;
    private SerialNumber serialNum;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.id == null && this.names == null && this.serialNum == null) {
            AuthorityKeyIdentifierExtension._jr$ip$extensionValue(this, null);
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.id != null) {
            derOutputStream = new DerOutputStream();
            this.id.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        try {
            if (this.names != null) {
                derOutputStream = new DerOutputStream();
                this.names.encode(derOutputStream);
                derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(exception.toString()));
        }
        if (this.serialNum != null) {
            derOutputStream = new DerOutputStream();
            this.serialNum.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        AuthorityKeyIdentifierExtension._jr$ip$extensionValue(this, derOutputStream2.toByteArray());
    }

    public AuthorityKeyIdentifierExtension(KeyIdentifier keyIdentifier, GeneralNames generalNames, SerialNumber serialNumber) throws IOException {
        this.id = null;
        this.names = null;
        this.serialNum = null;
        this.id = keyIdentifier;
        this.names = generalNames;
        this.serialNum = serialNumber;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        this.encodeThis();
    }

    public AuthorityKeyIdentifierExtension(Boolean bl, Object object) throws IOException {
        this.id = null;
        this.names = null;
        this.serialNum = null;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding for AuthorityKeyIdentifierExtension."));
        }
        while (derValue.data != null && derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.id != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate KeyIdentifier in AuthorityKeyIdentifier."));
                }
                derValue2.resetTag((byte)4);
                this.id = new KeyIdentifier(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                if (this.names != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate GeneralNames in AuthorityKeyIdentifier."));
                }
                derValue2.resetTag((byte)48);
                this.names = new GeneralNames(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)2) && !derValue2.isConstructed()) {
                if (this.serialNum != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate SerialNumber in AuthorityKeyIdentifier."));
                }
                derValue2.resetTag((byte)2);
                this.serialNum = new SerialNumber(derValue2);
                continue;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of AuthorityKeyIdentifierExtension."));
        }
    }

    @Override
    public String toString() {
        String string = super.toString() + "AuthorityKeyIdentifier [\n";
        if (this.id != null) {
            string = string + this.id.toString();
        }
        if (this.names != null) {
            string = string + this.names.toString() + "\n";
        }
        if (this.serialNum != null) {
            string = string + this.serialNum.toString() + "\n";
        }
        return string + "]\n";
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (AuthorityKeyIdentifierExtension._jr$ig$extensionValue(this) == null) {
            AuthorityKeyIdentifierExtension._jr$ip$extensionId(this, PKIXExtensions.AuthorityKey_Id);
            AuthorityKeyIdentifierExtension._jr$ip$critical(this, false);
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            if (!(g.convertForInstanceOf((Object)object, KeyIdentifier.class) instanceof KeyIdentifier)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute value should be of type KeyIdentifier."));
            }
            this.id = (KeyIdentifier)((Object)g.convertForCast((Object)object, KeyIdentifier.class));
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            if (!(g.convertForInstanceOf((Object)object, GeneralNames.class) instanceof GeneralNames)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute value should be of type GeneralNames."));
            }
            this.names = (GeneralNames)((Object)g.convertForCast((Object)object, GeneralNames.class));
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (!(g.convertForInstanceOf((Object)object, SerialNumber.class) instanceof SerialNumber)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute value should be of type SerialNumber."));
            }
            this.serialNum = (SerialNumber)((Object)g.convertForCast((Object)object, SerialNumber.class));
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier."));
        }
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            return this.id;
        }
        if (string.equalsIgnoreCase(AUTH_NAME)) {
            return this.names;
        }
        if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            return this.serialNum;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier."));
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            this.id = null;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            this.names = null;
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            this.serialNum = null;
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier."));
        }
        this.encodeThis();
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)KEY_ID);
        attributeNameEnumeration.addElement((Object)AUTH_NAME);
        attributeNameEnumeration.addElement((Object)SERIAL_NUMBER);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    protected /* synthetic */ AuthorityKeyIdentifierExtension(h h2) {
        super(h2);
    }
}

