/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.OIDMap;
import sun.security.x509.UnparseableExtension;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class CertificateExtensions
extends h
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private static final Debug debug = Debug.getInstance("x509");
    private Map<String, Extension> map;
    private boolean unsupportedCritExt;
    private Map<String, Extension> unparseableExtensions;
    private static Class[] PARAMS;

    public CertificateExtensions() {
        this.map = Collections.synchronizedMap(new TreeMap());
        this.unsupportedCritExt = false;
    }

    public CertificateExtensions(DerInputStream derInputStream) throws IOException {
        this.map = Collections.synchronizedMap(new TreeMap());
        this.unsupportedCritExt = false;
        this.init(derInputStream);
    }

    private void init(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSequence(5);
        for (int i = 0; i < a.arrayLength((Object[])derValueArray); ++i) {
            Extension extension = new Extension((DerValue)((Object)g.convertForCast((Object)a.arrayLoad((Object[])derValueArray, (int)i), DerValue.class)));
            this.parseExtension(extension);
        }
    }

    private void parseExtension(Extension extension) throws IOException {
        try {
            Class clazz = OIDMap.getClass(extension.getExtensionId());
            if (clazz == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) == null) {
                    return;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate extensions not allowed"));
            }
            aj aj2 = ai.convertArgs((Class)clazz, (Class[])PARAMS);
            Constructor constructor = aj2.clazz.getConstructor(aj2.args);
            Object[] objectArray = new Object[2];
            a.arrayStore((Object[])objectArray, (int)0, (Object)extension.isCritical());
            a.arrayStore((Object[])objectArray, (int)1, (Object)extension.getExtensionValue());
            Object[] objectArray2 = objectArray;
            CertAttrSet certAttrSet = (CertAttrSet)g.convertForCast(constructor.newInstance(objectArray2), CertAttrSet.class);
            if (this.map.put(certAttrSet.getName(), (Extension)g.convertForCast((Object)certAttrSet, Extension.class)) != null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate extensions not allowed"));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!extension.isCritical()) {
                if (this.unparseableExtensions == null) {
                    this.unparseableExtensions = new TreeMap();
                }
                this.unparseableExtensions.put(extension.getExtensionId().toString(), new UnparseableExtension(extension, throwable));
                if (debug != null) {
                    debug.println("Error parsing extension: " + extension);
                    throwable.printStackTrace();
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    System.err.println(hexDumpEncoder.encodeBuffer(extension.getExtensionValue()));
                }
                return;
            }
            if (g.convertForInstanceOf((Object)throwable, IOException.class) instanceof IOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)throwable, IOException.class)));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new IOException(throwable.toString()).initCause(throwable), IOException.class)));
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)iOException);
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new IOException(exception.toString()).initCause(exception), IOException.class)));
        }
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws CertificateException, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        Collection collection = this.map.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
            if (g.convertForInstanceOf((Object)a.arrayLoad((Object[])objectArray, (int)i), CertAttrSet.class) instanceof CertAttrSet) {
                ((CertAttrSet)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), CertAttrSet.class)).encode((OutputStream)derOutputStream2);
                continue;
            }
            if (g.convertForInstanceOf((Object)a.arrayLoad((Object[])objectArray, (int)i), Extension.class) instanceof Extension) {
                ((Extension)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Extension.class)).encode(derOutputStream2);
                continue;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Illegal extension object"));
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        if (!bl) {
            derOutputStream = new DerOutputStream();
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream3);
        } else {
            derOutputStream = derOutputStream3;
        }
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!(g.convertForInstanceOf((Object)object, Extension.class) instanceof Extension)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unknown extension type."));
        }
        this.map.put(string, (Extension)g.convertForCast((Object)object, Extension.class));
    }

    public Object get(String string) throws IOException {
        Object v = this.map.get(string);
        if (v == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("No extension found with name " + string));
        }
        return v;
    }

    Extension getExtension(String string) {
        return (Extension)g.convertForCast(this.map.get(string), Extension.class);
    }

    public void delete(String string) throws IOException {
        Object v = this.map.get(string);
        if (v == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("No extension found with name " + string));
        }
        this.map.remove(string);
    }

    public String getNameByOid(ObjectIdentifier objectIdentifier) throws IOException {
        for (String string : this.map.keySet()) {
            if (!((Extension)g.convertForCast(this.map.get(string), Extension.class)).getExtensionId().equals(objectIdentifier)) continue;
            return string;
        }
        return null;
    }

    public Enumeration<Extension> getElements() {
        return Collections.enumeration(this.map.values());
    }

    public Collection<Extension> getAllExtensions() {
        return this.map.values();
    }

    public Map<String, Extension> getUnparseableExtensions() {
        if (this.unparseableExtensions == null) {
            return Collections.emptyMap();
        }
        return this.unparseableExtensions;
    }

    public String getName() {
        return NAME;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.unsupportedCritExt;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, CertificateExtensions.class) instanceof CertificateExtensions)) {
            return false;
        }
        Collection<Extension> collection = ((CertificateExtensions)((Object)g.convertForCast((Object)object, CertificateExtensions.class))).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n = a.arrayLength((Object[])objectArray);
        if (n != this.map.size()) {
            return false;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            Extension extension;
            if (g.convertForInstanceOf((Object)a.arrayLoad((Object[])objectArray, (int)i), CertAttrSet.class) instanceof CertAttrSet) {
                string = ((CertAttrSet)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), CertAttrSet.class)).getName();
            }
            Extension extension2 = (Extension)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Extension.class);
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)g.convertForCast(this.map.get(string), Extension.class)) == null) {
                return false;
            }
            if (extension.equals(extension2)) continue;
            return false;
        }
        return this.getUnparseableExtensions().equals(((CertificateExtensions)((Object)g.convertForCast((Object)object, CertificateExtensions.class))).getUnparseableExtensions());
    }

    public int hashCode() {
        return this.map.hashCode() + this.getUnparseableExtensions().hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    static {
        Object[] objectArray = new Class[2];
        a.arrayStore((Object[])objectArray, (int)0, Boolean.class);
        a.arrayStore((Object[])objectArray, (int)1, Object.class);
        PARAMS = objectArray;
    }

    private static /* synthetic */ void _jr$ip$map(CertificateExtensions certificateExtensions, Map map) {
        certificateExtensions.map = map;
    }

    protected /* synthetic */ CertificateExtensions(h h2) {
        super(h2);
    }
}

