/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class CertificateValidity
extends h
implements CertAttrSet {
    public static final String IDENT = "x509.info.validity";
    public static final String NAME = "validity";
    public static final String NOT_BEFORE = "notBefore";
    public static final String NOT_AFTER = "notAfter";
    private static final long YR_2050 = 2524636800000L;
    private Date notBefore;
    private Date notAfter;

    private Date getNotBefore() {
        return new Date(this.notBefore.getTime());
    }

    private Date getNotAfter() {
        return new Date(this.notAfter.getTime());
    }

    private void construct(DerValue derValue) throws IOException {
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoded CertificateValidity, starting sequence tag missing."));
        }
        if (DerValue._jr$ig$data((Object)derValue).available() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("No data encoded for CertificateValidity"));
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding for CertificateValidity"));
        }
        if (DerValue._jr$ig$tag((Object)derValueArray[0]) == 23) {
            this.notBefore = DerValue._jr$ig$data((Object)derValue).getUTCTime();
        } else if (DerValue._jr$ig$tag((Object)derValueArray[0]) == 24) {
            this.notBefore = DerValue._jr$ig$data((Object)derValue).getGeneralizedTime();
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding for CertificateValidity"));
        }
        if (DerValue._jr$ig$tag((Object)derValueArray[1]) == 23) {
            this.notAfter = DerValue._jr$ig$data((Object)derValue).getUTCTime();
        } else if (DerValue._jr$ig$tag((Object)derValueArray[1]) == 24) {
            this.notAfter = DerValue._jr$ig$data((Object)derValue).getGeneralizedTime();
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding for CertificateValidity"));
        }
    }

    public CertificateValidity() {
    }

    public CertificateValidity(Date date, Date date2) {
        this.notBefore = date;
        this.notAfter = date2;
    }

    public CertificateValidity(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
    }

    public String toString() {
        if (this.notBefore == null || this.notAfter == null) {
            return "";
        }
        return "Validity: [From: " + this.notBefore.toString() + ",\n               To: " + this.notAfter.toString() + "]";
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.notBefore == null || this.notAfter == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("CertAttrSet:CertificateValidity: null values to encode.\n"));
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.notBefore.getTime() < 2524636800000L) {
            derOutputStream.putUTCTime(this.notBefore);
        } else {
            derOutputStream.putGeneralizedTime(this.notBefore);
        }
        if (this.notAfter.getTime() < 2524636800000L) {
            derOutputStream.putUTCTime(this.notAfter);
        } else {
            derOutputStream.putGeneralizedTime(this.notAfter);
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!(g.convertForInstanceOf((Object)object, Date.class) instanceof Date)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute must be of type Date."));
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = (Date)g.convertForCast((Object)object, Date.class);
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = (Date)g.convertForCast((Object)object, Date.class);
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity."));
        }
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            return this.getNotBefore();
        }
        if (string.equalsIgnoreCase(NOT_AFTER)) {
            return this.getNotAfter();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity."));
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet: CertificateValidity."));
        }
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)NOT_BEFORE);
        attributeNameEnumeration.addElement((Object)NOT_AFTER);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        Date date = new Date();
        this.valid(date);
    }

    public void valid(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.notBefore.after(date)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString()));
        }
        if (this.notAfter.before(date)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateExpiredException("NotAfter: " + this.notAfter.toString()));
        }
    }

    protected /* synthetic */ CertificateValidity(h h2) {
        super(h2);
    }
}

