/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class CertificateVersion
extends h
implements CertAttrSet {
    public static final int V1 = 0;
    public static final int V2 = 1;
    public static final int V3 = 2;
    public static final String IDENT = "x509.info.version";
    public static final String NAME = "version";
    public static final String VERSION = "number";
    int version;

    private int getVersion() {
        return ((CertificateVersion)((Object)((Object)this))).version;
    }

    private void construct(DerValue derValue) throws IOException {
        if (derValue.isConstructed() && derValue.isContextSpecific()) {
            derValue = DerValue._jr$ig$data((Object)derValue).getDerValue();
            ((CertificateVersion)((Object)((Object)this))).version = derValue.getInteger();
            if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("X.509 version, bad format"));
            }
        }
    }

    public CertificateVersion() {
        this.version = 0;
        this.version = 0;
    }

    public CertificateVersion(int n2) throws IOException {
        this.version = 0;
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("X.509 Certificate version " + n2 + " not supported.\n"));
        }
        this.version = n2;
    }

    public CertificateVersion(DerInputStream derInputStream) throws IOException {
        this.version = 0;
        this.version = 0;
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
    }

    public CertificateVersion(InputStream inputStream) throws IOException {
        this.version = 0;
        this.version = 0;
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
    }

    public CertificateVersion(DerValue derValue) throws IOException {
        this.version = 0;
        this.version = 0;
        this.construct(derValue);
    }

    public String toString() {
        return "Version: V" + (((CertificateVersion)((Object)((Object)this))).version + 1);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (((CertificateVersion)((Object)((Object)this))).version == 0) {
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(((CertificateVersion)((Object)((Object)this))).version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Integer)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute must be of type Integer."));
        }
        if (!string.equalsIgnoreCase(VERSION)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion."));
        }
        ((CertificateVersion)((Object)((Object)this))).version = (Integer)object;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(VERSION)) {
            return new Integer(this.getVersion());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion."));
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(VERSION)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion."));
        }
        ((CertificateVersion)((Object)((Object)this))).version = 0;
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)VERSION);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public int compare(int n2) {
        return ((CertificateVersion)((Object)((Object)this))).version - n2;
    }

    protected /* synthetic */ CertificateVersion(h h2) {
        super(h2);
    }
}

