/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.util.Locale;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class DNSName
extends h
implements GeneralNameInterface {
    private String name;
    private static final String alpha = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String digitsAndHyphen = "0123456789-";
    private static final String alphaDigitsAndHyphen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-";

    public DNSName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
    }

    public DNSName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DNS name must not be null"));
        }
        if (string.indexOf(32) != -1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DNS names or NameConstraints with blank components are not permitted"));
        }
        if (string.charAt(0) == '.' || string.charAt(string.length() - 1) == '.') {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DNS names or NameConstraints may not begin or end with a ."));
        }
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(46, n2);
            if (n3 < 0) {
                n3 = string.length();
            }
            if (n3 - n2 < 1) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DNSName SubjectAltNames with empty components are not permitted"));
            }
            if (alpha.indexOf(string.charAt(n2)) < 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DNSName components must begin with a letter"));
            }
            for (int i = n2 + 1; i < n3; ++i) {
                char c = string.charAt(i);
                if (alphaDigitsAndHyphen.indexOf(c) >= 0) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("DNSName components must consist of letters, digits, and hyphens"));
            }
            n2 = n3 + 1;
        }
        this.name = string;
    }

    @Override
    public int getType() {
        return 2;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public String toString() {
        return "DNSName: " + this.name;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, DNSName.class) instanceof DNSName)) {
            return false;
        }
        DNSName dNSName = (DNSName)g.convertForCast((Object)object, DNSName.class);
        return this.name.equalsIgnoreCase(dNSName.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        int n3;
        String string;
        String string2;
        int n4 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 2 ? -1 : ((string2 = ((DNSName)g.convertForCast((Object)generalNameInterface, DNSName.class)).getName().toLowerCase(Locale.ENGLISH)).equals(string = this.name.toLowerCase(Locale.ENGLISH)) ? 0 : (string.endsWith(string2) ? (string.charAt((n3 = string.lastIndexOf(string2)) - 1) == '.' ? 2 : 3) : (string2.endsWith(string) ? (string2.charAt((n2 = string2.lastIndexOf(string)) - 1) == '.' ? 1 : 3) : 3))));
        return n4;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        String string = this.name;
        int n2 = 1;
        while (string.lastIndexOf(46) >= 0) {
            string = string.substring(0, string.lastIndexOf(46));
            ++n2;
        }
        return n2;
    }

    private static /* synthetic */ void _jr$ip$name(DNSName dNSName, String string) {
        dNSName.name = string;
    }

    protected /* synthetic */ DNSName(h h2) {
        super(h2);
    }
}

