/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.util.Arrays;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNames;
import sun.security.x509.RDN;

public class DistributionPoint
extends h {
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int PRIVILEGE_WITHDRAWN = 7;
    public static final int AA_COMPROMISE = 8;
    private static final String[] REASON_STRINGS;
    private static final byte TAG_DIST_PT = 0;
    private static final byte TAG_REASONS = 1;
    private static final byte TAG_ISSUER = 2;
    private static final byte TAG_FULL_NAME = 0;
    private static final byte TAG_REL_NAME = 1;
    private GeneralNames fullName;
    private RDN relativeName;
    private boolean[] reasonFlags;
    private GeneralNames crlIssuer;
    private volatile int hashCode;

    public DistributionPoint(GeneralNames generalNames, boolean[] blArray, GeneralNames generalNames2) {
        if (generalNames == null && generalNames2 == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("fullName and crlIssuer may not both be null"));
        }
        this.fullName = generalNames;
        this.reasonFlags = blArray;
        this.crlIssuer = generalNames2;
    }

    public DistributionPoint(RDN rDN, boolean[] blArray, GeneralNames generalNames) {
        if (rDN == null && generalNames == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("relativeName and crlIssuer may not both be null"));
        }
        this.relativeName = rDN;
        this.reasonFlags = blArray;
        this.crlIssuer = generalNames;
    }

    public DistributionPoint(DerValue derValue) throws IOException {
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of DistributionPoint."));
        }
        while (DerValue._jr$ig$data((Object)derValue) != null && DerValue._jr$ig$data((Object)derValue).available() != 0) {
            DerValue derValue2 = DerValue._jr$ig$data((Object)derValue).getDerValue();
            if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                if (this.fullName != null || this.relativeName != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate DistributionPointName in DistributionPoint."));
                }
                DerValue derValue3 = DerValue._jr$ig$data((Object)derValue2).getDerValue();
                if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed()) {
                    derValue3.resetTag((byte)48);
                    this.fullName = new GeneralNames(derValue3);
                    continue;
                }
                if (derValue3.isContextSpecific((byte)1) && derValue3.isConstructed()) {
                    derValue3.resetTag((byte)49);
                    this.relativeName = new RDN(derValue3);
                    continue;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid DistributionPointName in DistributionPoint"));
            }
            if (derValue2.isContextSpecific((byte)1) && !derValue2.isConstructed()) {
                if (this.reasonFlags != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate Reasons in DistributionPoint."));
                }
                derValue2.resetTag((byte)3);
                this.reasonFlags = derValue2.getUnalignedBitString().toBooleanArray();
                continue;
            }
            if (derValue2.isContextSpecific((byte)2) && derValue2.isConstructed()) {
                if (this.crlIssuer != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Duplicate CRLIssuer in DistributionPoint."));
                }
                derValue2.resetTag((byte)48);
                this.crlIssuer = new GeneralNames(derValue2);
                continue;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of DistributionPoint."));
        }
        if (this.crlIssuer == null && this.fullName == null && this.relativeName == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("One of fullName, relativeName,  and crlIssuer has to be set"));
        }
    }

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public boolean[] getReasonFlags() {
        return this.reasonFlags;
    }

    public GeneralNames getCRLIssuer() {
        return this.crlIssuer;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        h h2;
        DerOutputStream derOutputStream2;
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.fullName != null || this.relativeName != null) {
            derOutputStream2 = new DerOutputStream();
            if (this.fullName != null) {
                h2 = new DerOutputStream();
                this.fullName.encode((DerOutputStream)h2);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), (DerOutputStream)h2);
            } else if (this.relativeName != null) {
                h2 = new DerOutputStream();
                this.relativeName.encode((DerOutputStream)h2);
                derOutputStream2.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), (DerOutputStream)h2);
            }
            derOutputStream3.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream2);
        }
        if (this.reasonFlags != null) {
            derOutputStream2 = new DerOutputStream();
            h2 = new BitArray(this.reasonFlags);
            derOutputStream2.putTruncatedUnalignedBitString((BitArray)h2);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream2);
        }
        if (this.crlIssuer != null) {
            derOutputStream2 = new DerOutputStream();
            this.crlIssuer.encode(derOutputStream2);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream3);
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, DistributionPoint.class) instanceof DistributionPoint)) {
            return false;
        }
        DistributionPoint distributionPoint = (DistributionPoint)((Object)g.convertForCast((Object)object, DistributionPoint.class));
        boolean bl = DistributionPoint.equals((Object)this.fullName, (Object)distributionPoint.fullName) && DistributionPoint.equals((Object)this.relativeName, (Object)distributionPoint.relativeName) && DistributionPoint.equals((Object)this.crlIssuer, (Object)distributionPoint.crlIssuer) && Arrays.equals(this.reasonFlags, distributionPoint.reasonFlags);
        return bl;
    }

    public int hashCode() {
        int n2 = this.hashCode;
        if (n2 == 0) {
            n2 = 1;
            if (this.fullName != null) {
                n2 += this.fullName.hashCode();
            }
            if (this.relativeName != null) {
                n2 += this.relativeName.hashCode();
            }
            if (this.crlIssuer != null) {
                n2 += this.crlIssuer.hashCode();
            }
            if (this.reasonFlags != null) {
                for (int i = 0; i < this.reasonFlags.length; ++i) {
                    if (!this.reasonFlags[i]) continue;
                    n2 += i;
                }
            }
            this.hashCode = n2;
        }
        return n2;
    }

    private static String reasonToString(int n2) {
        if (n2 > 0 && n2 < a.arrayLength((Object[])REASON_STRINGS)) {
            return (String)a.arrayLoad((Object[])REASON_STRINGS, (int)n2);
        }
        return "Unknown reason " + n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fullName != null) {
            stringBuilder.append("DistributionPoint:\n     " + (Object)((Object)this.fullName) + "\n");
        }
        if (this.relativeName != null) {
            stringBuilder.append("DistributionPoint:\n     " + (Object)((Object)this.relativeName) + "\n");
        }
        if (this.reasonFlags != null) {
            stringBuilder.append("   ReasonFlags:\n");
            for (int i = 0; i < this.reasonFlags.length; ++i) {
                if (!this.reasonFlags[i]) continue;
                stringBuilder.append("    " + DistributionPoint.reasonToString(i) + "\n");
            }
        }
        if (this.crlIssuer != null) {
            stringBuilder.append("   CRLIssuer:" + (Object)((Object)this.crlIssuer) + "\n");
        }
        return stringBuilder.toString();
    }

    static {
        Object[] objectArray = new String[9];
        a.arrayStore((Object[])objectArray, (int)0, null);
        a.arrayStore((Object[])objectArray, (int)1, (Object)"key compromise");
        a.arrayStore((Object[])objectArray, (int)2, (Object)"CA compromise");
        a.arrayStore((Object[])objectArray, (int)3, (Object)"affiliation changed");
        a.arrayStore((Object[])objectArray, (int)4, (Object)"superseded");
        a.arrayStore((Object[])objectArray, (int)5, (Object)"cessation of operation");
        a.arrayStore((Object[])objectArray, (int)6, (Object)"certificate hold");
        a.arrayStore((Object[])objectArray, (int)7, (Object)"privilege withdrawn");
        a.arrayStore((Object[])objectArray, (int)8, (Object)"AA compromise");
        REASON_STRINGS = objectArray;
    }

    private static /* synthetic */ void _jr$ip$fullName(DistributionPoint distributionPoint, GeneralNames generalNames) {
        distributionPoint.fullName = generalNames;
    }

    private static /* synthetic */ void _jr$ip$relativeName(DistributionPoint distributionPoint, RDN rDN) {
        distributionPoint.relativeName = rDN;
    }

    private static /* synthetic */ void _jr$ip$reasonFlags(DistributionPoint distributionPoint, boolean[] blArray) {
        distributionPoint.reasonFlags = blArray;
    }

    private static /* synthetic */ void _jr$ip$crlIssuer(DistributionPoint distributionPoint, GeneralNames generalNames) {
        distributionPoint.crlIssuer = generalNames;
    }

    protected /* synthetic */ DistributionPoint(h h2) {
        super(h2);
    }
}

