/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;

public class GeneralName
extends h {
    private GeneralNameInterface name;

    public GeneralName(GeneralNameInterface generalNameInterface) {
        this.name = null;
        if (generalNameInterface == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("GeneralName must not be null"));
        }
        this.name = generalNameInterface;
    }

    public GeneralName(DerValue derValue) throws IOException {
        this(derValue, false);
    }

    public GeneralName(DerValue derValue, boolean bl) throws IOException {
        this.name = null;
        short s = (byte)(DerValue._jr$ig$tag((Object)derValue) & 0x1F);
        switch (s) {
            case 0: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new OtherName(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of Other-Name"));
            }
            case 1: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new RFC822Name(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of RFC822 name"));
            }
            case 2: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = new DNSName(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of DNS name"));
            }
            case 6: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)22);
                    this.name = bl ? URIName.nameConstraint(derValue) : new URIName(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of URI"));
            }
            case 7: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)4);
                    this.name = new IPAddressName(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of IP address"));
            }
            case 8: {
                if (derValue.isContextSpecific() && !derValue.isConstructed()) {
                    derValue.resetTag((byte)6);
                    this.name = new OIDName(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of OID name"));
            }
            case 4: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    this.name = new X500Name(derValue.getData());
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of Directory name"));
            }
            case 5: {
                if (derValue.isContextSpecific() && derValue.isConstructed()) {
                    derValue.resetTag((byte)48);
                    this.name = new EDIPartyName(derValue);
                    break;
                }
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of EDI name"));
            }
            default: {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unrecognized GeneralName tag, (" + s + ")"));
            }
        }
    }

    public int getType() {
        return this.name.getType();
    }

    public GeneralNameInterface getName() {
        return this.name;
    }

    public String toString() {
        return this.name.toString();
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, GeneralName.class) instanceof GeneralName)) {
            return false;
        }
        GeneralNameInterface generalNameInterface = ((GeneralName)((Object)g.convertForCast((Object)object, GeneralName.class))).name;
        try {
            return this.name.constrains(generalNameInterface) == 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.name.encode(derOutputStream2);
        int n = this.name.getType();
        if (n == 0 || n == 3 || n == 5) {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream2);
        } else if (n == 4) {
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)n), derOutputStream2);
        } else {
            derOutputStream.writeImplicit(DerValue.createTag((byte)-128, false, (byte)n), derOutputStream2);
        }
    }

    private static /* synthetic */ void _jr$ip$name(GeneralName generalName, GeneralNameInterface generalNameInterface) {
        generalName.name = generalNameInterface;
    }

    protected /* synthetic */ GeneralName(h h2) {
        super(h2);
    }
}

