/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class KeyIdentifier
extends h {
    private byte[] octetString;

    public KeyIdentifier(byte[] byArray) {
        this.octetString = (byte[])byArray.clone();
    }

    public KeyIdentifier(DerValue derValue) throws IOException {
        this.octetString = derValue.getOctetString();
    }

    public KeyIdentifier(PublicKey publicKey) throws IOException {
        DerValue derValue = new DerValue(publicKey.getEncoded());
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("PublicKey value is not a valid X.509 public key"));
        }
        AlgorithmId algorithmId = AlgorithmId.parse(DerValue._jr$ig$data((Object)derValue).getDerValue());
        byte[] byArray = DerValue._jr$ig$data((Object)derValue).getUnalignedBitString().toByteArray();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("SHA1 not supported"));
        }
        messageDigest.update(byArray);
        this.octetString = messageDigest.digest();
    }

    public byte[] getIdentifier() {
        return (byte[])this.octetString.clone();
    }

    public String toString() {
        String string = "KeyIdentifier [\n";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.octetString);
        string = string + "]\n";
        return string;
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOctetString(this.octetString);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i = 0; i < this.octetString.length; ++i) {
            n2 += this.octetString[i] * i;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)((Object)this), (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, KeyIdentifier.class) instanceof KeyIdentifier)) {
            return false;
        }
        return Arrays.equals(this.octetString, ((KeyIdentifier)((Object)g.convertForCast((Object)object, KeyIdentifier.class))).getIdentifier());
    }

    private static /* synthetic */ void _jr$ip$octetString(KeyIdentifier keyIdentifier, byte[] byArray) {
        keyIdentifier.octetString = byArray;
    }

    protected /* synthetic */ KeyIdentifier(h h2) {
        super(h2);
    }
}

