/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertificatePolicyId;

public class PolicyInformation
extends h {
    public static final String NAME = "PolicyInformation";
    public static final String ID = "id";
    public static final String QUALIFIERS = "qualifiers";
    private CertificatePolicyId policyIdentifier;
    private Set<PolicyQualifierInfo> policyQualifiers;

    public PolicyInformation(CertificatePolicyId certificatePolicyId, Set<PolicyQualifierInfo> set) throws IOException {
        if (set == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("policyQualifiers is null"));
        }
        this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>(set);
        this.policyIdentifier = certificatePolicyId;
    }

    public PolicyInformation(DerValue derValue) throws IOException {
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of PolicyInformation"));
        }
        this.policyIdentifier = new CertificatePolicyId(DerValue._jr$ig$data((Object)derValue).getDerValue());
        if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
            this.policyQualifiers = new LinkedHashSet<PolicyQualifierInfo>();
            DerValue derValue2 = DerValue._jr$ig$data((Object)derValue).getDerValue();
            if (DerValue._jr$ig$tag((Object)derValue2) != 48) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of PolicyInformation"));
            }
            if (DerValue._jr$ig$data((Object)derValue2).available() == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("No data available in policyQualifiers"));
            }
            while (DerValue._jr$ig$data((Object)derValue2).available() != 0) {
                this.policyQualifiers.add(new PolicyQualifierInfo(DerValue._jr$ig$data((Object)derValue2).getDerValue().toByteArray()));
            }
        } else {
            this.policyQualifiers = Collections.emptySet();
        }
    }

    public boolean equals(Object object) {
        if (!(g.convertForInstanceOf((Object)object, PolicyInformation.class) instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation policyInformation = (PolicyInformation)((Object)g.convertForCast((Object)object, PolicyInformation.class));
        if (!this.policyIdentifier.equals((Object)policyInformation.getPolicyIdentifier())) {
            return false;
        }
        return this.policyQualifiers.equals(policyInformation.getPolicyQualifiers());
    }

    public int hashCode() {
        int n2 = 37 + this.policyIdentifier.hashCode();
        n2 = 37 * n2 + this.policyQualifiers.hashCode();
        return n2;
    }

    public CertificatePolicyId getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Set<PolicyQualifierInfo> getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            return this.policyIdentifier;
        }
        if (string.equalsIgnoreCase(QUALIFIERS)) {
            return this.policyQualifiers;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name [" + string + "] not recognized by PolicyInformation."));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            if (!(g.convertForInstanceOf((Object)object, CertificatePolicyId.class) instanceof CertificatePolicyId)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute value must be instance of CertificatePolicyId."));
            this.policyIdentifier = (CertificatePolicyId)((Object)g.convertForCast((Object)object, CertificatePolicyId.class));
            return;
        } else {
            if (!string.equalsIgnoreCase(QUALIFIERS)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name [" + string + "] not recognized by PolicyInformation"));
            if (this.policyIdentifier == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute must have a CertificatePolicyIdentifier value before PolicyQualifierInfo can be set."));
            }
            if (!(g.convertForInstanceOf((Object)object, Set.class) instanceof Set)) throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute value must be of type Set."));
            for (Object e2 : (Set)g.convertForCast((Object)object, Set.class)) {
                if (g.convertForInstanceOf(e2, PolicyQualifierInfo.class) instanceof PolicyQualifierInfo) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute value must be aSet of PolicyQualifierInfo objects."));
            }
            this.policyQualifiers = (Set)g.convertForCast((Object)object, Set.class);
        }
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(QUALIFIERS)) {
            if (string.equalsIgnoreCase(ID)) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute ID may not be deleted from PolicyInformation."));
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Attribute name [" + string + "] not recognized by PolicyInformation."));
        }
        this.policyQualifiers = Collections.emptySet();
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)ID);
        attributeNameEnumeration.addElement((Object)QUALIFIERS);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("  [" + this.policyIdentifier.toString());
        stringBuilder.append(this.policyQualifiers + "  ]\n");
        return stringBuilder.toString();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.policyIdentifier.encode(derOutputStream2);
        if (!this.policyQualifiers.isEmpty()) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            Iterator iterator = this.policyQualifiers.iterator();
            while (iterator.hasNext()) {
                PolicyQualifierInfo policyQualifierInfo = (PolicyQualifierInfo)((Object)g.convertForCast(iterator.next(), PolicyQualifierInfo.class));
                derOutputStream3.write(policyQualifierInfo.getEncoded());
            }
            derOutputStream2.write((byte)48, derOutputStream3);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    protected /* synthetic */ PolicyInformation(h h2) {
        super(h2);
    }
}

