/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;

public class PrivateKeyUsageExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.PrivateKeyUsage";
    public static final String NAME = "PrivateKeyUsage";
    public static final String NOT_BEFORE = "not_before";
    public static final String NOT_AFTER = "not_after";
    private static final byte TAG_BEFORE = 0;
    private static final byte TAG_AFTER = 1;
    private Date notBefore;
    private Date notAfter;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.notBefore == null && this.notAfter == null) {
            PrivateKeyUsageExtension._jr$ip$extensionValue(this, null);
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.notBefore != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.notBefore);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        if (this.notAfter != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putGeneralizedTime(this.notAfter);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        PrivateKeyUsageExtension._jr$ip$extensionValue(this, derOutputStream2.toByteArray());
    }

    public PrivateKeyUsageExtension(Date date, Date date2) throws IOException {
        this.notBefore = null;
        this.notAfter = null;
        this.notBefore = date;
        this.notAfter = date2;
        this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
        this.critical = false;
        this.encodeThis();
    }

    public PrivateKeyUsageExtension(Boolean bl, Object object) throws CertificateException, IOException {
        this.notBefore = null;
        this.notAfter = null;
        this.extensionId = PKIXExtensions.PrivateKeyUsage_Id;
        this.critical = bl;
        this.extensionValue = (byte[])object;
        DerInputStream derInputStream = new DerInputStream(this.extensionValue);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        for (int i = 0; i < derValueArray.length; ++i) {
            DerValue derValue = derValueArray[i];
            if (derValue.isContextSpecific((byte)0) && !derValue.isConstructed()) {
                if (this.notBefore != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Duplicate notBefore in PrivateKeyUsage."));
                }
                derValue.resetTag((byte)24);
                derInputStream = new DerInputStream(derValue.toByteArray());
                this.notBefore = derInputStream.getGeneralizedTime();
                continue;
            }
            if (derValue.isContextSpecific((byte)1) && !derValue.isConstructed()) {
                if (this.notAfter != null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Duplicate notAfter in PrivateKeyUsage."));
                }
                derValue.resetTag((byte)24);
                derInputStream = new DerInputStream(derValue.toByteArray());
                this.notAfter = derInputStream.getGeneralizedTime();
                continue;
            }
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Invalid encoding of PrivateKeyUsageExtension"));
        }
    }

    @Override
    public String toString() {
        return super.toString() + "PrivateKeyUsage: [\n" + (this.notBefore == null ? "" : "From: " + this.notBefore.toString() + ", ") + (this.notAfter == null ? "" : "To: " + this.notAfter.toString()) + "]\n";
    }

    public void valid() throws CertificateNotYetValidException, CertificateExpiredException {
        Date date = new Date();
        this.valid(date);
    }

    public void valid(Date date) throws CertificateNotYetValidException, CertificateExpiredException {
        if (this.notBefore.after(date)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateNotYetValidException("NotBefore: " + this.notBefore.toString()));
        }
        if (this.notAfter.before(date)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateExpiredException("NotAfter: " + this.notAfter.toString()));
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (PrivateKeyUsageExtension._jr$ig$extensionValue(this) == null) {
            PrivateKeyUsageExtension._jr$ip$extensionId(this, PKIXExtensions.PrivateKeyUsage_Id);
            PrivateKeyUsageExtension._jr$ip$critical(this, false);
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        if (!(g.convertForInstanceOf((Object)object, Date.class) instanceof Date)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute must be of type Date."));
        }
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = (Date)g.convertForCast((Object)object, Date.class);
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = (Date)g.convertForCast((Object)object, Date.class);
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage."));
        }
        this.encodeThis();
    }

    public Object get(String string) throws CertificateException {
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            return new Date(this.notBefore.getTime());
        }
        if (string.equalsIgnoreCase(NOT_AFTER)) {
            return new Date(this.notAfter.getTime());
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage."));
    }

    public void delete(String string) throws CertificateException, IOException {
        if (string.equalsIgnoreCase(NOT_BEFORE)) {
            this.notBefore = null;
        } else if (string.equalsIgnoreCase(NOT_AFTER)) {
            this.notAfter = null;
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized by CertAttrSet:PrivateKeyUsage."));
        }
        this.encodeThis();
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)NOT_BEFORE);
        attributeNameEnumeration.addElement((Object)NOT_AFTER);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    protected /* synthetic */ PrivateKeyUsageExtension(h h2) {
        super(h2);
    }
}

