/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.IPAddressName;

public class URIName
extends h
implements GeneralNameInterface {
    private URI uri;
    private String host;
    private DNSName hostDNS;
    private IPAddressName hostIP;

    public URIName(DerValue derValue) throws IOException {
        this(derValue.getIA5String());
    }

    public URIName(String string) throws IOException {
        try {
            this.uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new IOException("invalid URI name:" + string).initCause(uRISyntaxException), IOException.class)));
        }
        if (this.uri.getScheme() == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("URI name must include scheme:" + string));
        }
        this.host = this.uri.getHost();
        if (this.host != null) {
            if (this.host.charAt(0) == '[') {
                String string2 = this.host.substring(1, this.host.length() - 1);
                try {
                    this.hostIP = new IPAddressName(string2);
                }
                catch (IOException iOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("invalid URI name (host portion is not a valid IPv6 address):" + string));
                }
            }
            try {
                this.hostDNS = new DNSName(this.host);
            }
            catch (IOException iOException) {
                try {
                    this.hostIP = new IPAddressName(this.host);
                }
                catch (Exception exception) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("invalid URI name (host portion is not a valid DNS name, IPv4 address, or IPv6 address):" + string));
                }
            }
        }
    }

    public static URIName nameConstraint(DerValue derValue) throws IOException {
        URI uRI;
        String string = derValue.getIA5String();
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new IOException("invalid URI name constraint:" + string).initCause(uRISyntaxException), IOException.class)));
        }
        if (uRI.getScheme() == null) {
            String string2 = uRI.getSchemeSpecificPart();
            try {
                DNSName dNSName = string2.charAt(0) == '.' ? new DNSName(string2.substring(1)) : new DNSName(string2);
                return new URIName(uRI, string2, dNSName);
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((IOException)g.convertForCast((Object)new IOException("invalid URI name constraint:" + string).initCause(iOException), IOException.class)));
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("invalid URI name constraint (should not include scheme):" + string));
    }

    URIName(URI uRI, String string, DNSName dNSName) {
        this.uri = uRI;
        this.host = string;
        this.hostDNS = dNSName;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.uri.toASCIIString());
    }

    public String toString() {
        return "URIName: " + this.uri.toString();
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, URIName.class) instanceof URIName)) {
            return false;
        }
        URIName uRIName = (URIName)g.convertForCast((Object)object, URIName.class);
        return this.uri.equals(uRIName.getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public String getName() {
        return this.uri.toString();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getHost() {
        return this.host;
    }

    public Object getHostObject() {
        if (this.hostIP != null) {
            return this.hostIP;
        }
        return this.hostDNS;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n;
        if (generalNameInterface == null) {
            n = -1;
        } else if (generalNameInterface.getType() != 6) {
            n = -1;
        } else {
            String string = ((URIName)g.convertForCast((Object)generalNameInterface, URIName.class)).getHost();
            if (string.equalsIgnoreCase(this.host)) {
                n = 0;
            } else {
                Object object = ((URIName)g.convertForCast((Object)generalNameInterface, URIName.class)).getHostObject();
                if (this.hostDNS == null || !(g.convertForInstanceOf((Object)object, DNSName.class) instanceof DNSName)) {
                    n = 3;
                } else {
                    boolean bl = this.host.charAt(0) == '.';
                    boolean bl2 = string.charAt(0) == '.';
                    DNSName dNSName = (DNSName)g.convertForCast((Object)object, DNSName.class);
                    n = this.hostDNS.constrains(dNSName);
                    if (!(bl || bl2 || n != 2 && n != 1)) {
                        n = 3;
                    }
                    if (bl != bl2 && n == 0) {
                        n = bl ? 2 : 1;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        DNSName dNSName = null;
        try {
            dNSName = new DNSName(this.host);
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new UnsupportedOperationException(iOException.getMessage()));
        }
        return dNSName.subtreeDepth();
    }

    private static /* synthetic */ void _jr$ip$uri(URIName uRIName, URI uRI) {
        uRIName.uri = uRI;
    }

    private static /* synthetic */ void _jr$ip$host(URIName uRIName, String string) {
        uRIName.host = string;
    }

    private static /* synthetic */ void _jr$ip$hostDNS(URIName uRIName, DNSName dNSName) {
        uRIName.hostDNS = dNSName;
    }

    private static /* synthetic */ void _jr$ip$hostIP(URIName uRIName, IPAddressName iPAddressName) {
        uRIName.hostIP = iPAddressName;
    }

    protected /* synthetic */ URIName(h h2) {
        super(h2);
    }
}

