/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.aj;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.RDN;

public class X500Name
extends h
implements GeneralNameInterface,
Principal {
    private String dn;
    private String rfc1779Dn;
    private String rfc2253Dn;
    private String canonicalDn;
    private RDN[] names;
    private X500Principal x500Principal;
    private byte[] encoded;
    private volatile List<RDN> rdnList;
    private volatile List<AVA> allAvaList;
    private static final Map<ObjectIdentifier, ObjectIdentifier> internedOIDs = new HashMap<ObjectIdentifier, ObjectIdentifier>();
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] SURNAME_DATA = new int[]{2, 5, 4, 4};
    private static final int[] SERIALNUMBER_DATA = new int[]{2, 5, 4, 5};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] GIVENNAME_DATA = new int[]{2, 5, 4, 42};
    private static final int[] INITIALS_DATA = new int[]{2, 5, 4, 43};
    private static final int[] GENERATIONQUALIFIER_DATA = new int[]{2, 5, 4, 44};
    private static final int[] DNQUALIFIER_DATA = new int[]{2, 5, 4, 46};
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    private static final int[] DOMAIN_COMPONENT_DATA = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    private static final int[] userid_data = new int[]{0, 9, 2342, 19200300, 100, 1, 1};
    public static final ObjectIdentifier commonName_oid = X500Name.intern(ObjectIdentifier.newInternal(commonName_data));
    public static final ObjectIdentifier countryName_oid;
    public static final ObjectIdentifier localityName_oid;
    public static final ObjectIdentifier orgName_oid;
    public static final ObjectIdentifier orgUnitName_oid;
    public static final ObjectIdentifier stateName_oid;
    public static final ObjectIdentifier streetAddress_oid;
    public static final ObjectIdentifier title_oid;
    public static final ObjectIdentifier DNQUALIFIER_OID;
    public static final ObjectIdentifier SURNAME_OID;
    public static final ObjectIdentifier GIVENNAME_OID;
    public static final ObjectIdentifier INITIALS_OID;
    public static final ObjectIdentifier GENERATIONQUALIFIER_OID;
    public static final ObjectIdentifier ipAddress_oid;
    public static final ObjectIdentifier DOMAIN_COMPONENT_OID;
    public static final ObjectIdentifier userid_oid;
    public static final ObjectIdentifier SERIALNUMBER_OID;
    private static final Constructor principalConstructor;
    private static final Field principalField;

    public X500Name(String string) throws IOException {
        this(string, Collections.emptyMap());
    }

    public X500Name(String string, Map<String, String> map) throws IOException {
        this.parseDN(string, map);
    }

    public X500Name(String string, String string2) throws IOException {
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("Name must not be null"));
        }
        if (string2.equalsIgnoreCase("RFC2253")) {
            this.parseRFC2253DN(string);
        } else if (string2.equalsIgnoreCase("DEFAULT")) {
            this.parseDN(string, Collections.emptyMap());
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unsupported format " + string2));
        }
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[3]))[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[2] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[2]))[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[1] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[1]))[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[0] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[0]))[0] = new AVA(countryName_oid, new DerValue(string4));
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[5]))[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[4] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[4]))[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[3] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[3]))[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[2] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[2]))[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[1] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[1]))[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[0] = new RDN(1);
        RDN._jr$ig$assertion((Object)((Object)this.names[0]))[0] = new AVA(countryName_oid, new DerValue(string6));
    }

    public X500Name(RDN[] rDNArray) throws IOException {
        if (rDNArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = (RDN[])g.convertForCast((Object)a.cloneArray((Object)rDNArray), RDN[].class);
            for (int i = 0; i < a.arrayLength((Object[])this.names); ++i) {
                if ((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class)) != null) continue;
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Cannot create an X500Name"));
            }
        }
    }

    public X500Name(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        this.parseDER(derInputStream);
    }

    public X500Name(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parseDER(derInputStream);
    }

    public List<RDN> rdns() {
        List<RDN> list = this.rdnList;
        if (list == null) {
            list = Collections.unmodifiableList(Arrays.asList(this.names));
            this.rdnList = list;
        }
        return list;
    }

    public int size() {
        return a.arrayLength((Object[])this.names);
    }

    public List<AVA> allAvas() {
        ArrayList<AVA> arrayList = this.allAvaList;
        if (arrayList == null) {
            arrayList = new ArrayList<AVA>();
            for (int i = 0; i < a.arrayLength((Object[])this.names); ++i) {
                arrayList.addAll(((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).avas());
            }
        }
        return arrayList;
    }

    public int avaSize() {
        return this.allAvas().size();
    }

    public boolean isEmpty() {
        int n2 = this.names.length;
        if (n2 == 0) {
            return true;
        }
        for (int i = 0; i < n2; ++i) {
            if (RDN._jr$ig$assertion((Object)this.names[i]).length == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getRFC2253CanonicalName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        Object object2;
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, X500Name.class) instanceof X500Name)) {
            return false;
        }
        X500Name x500Name = (X500Name)g.convertForCast((Object)object, X500Name.class);
        if (this.canonicalDn != null && x500Name.canonicalDn != null) {
            return this.canonicalDn.equals(x500Name.canonicalDn);
        }
        int n2 = this.names.length;
        if (n2 != x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            object2 = this.names[i];
            RDN rDN = x500Name.names[i];
            if (RDN._jr$ig$assertion(object2).length == RDN._jr$ig$assertion((Object)rDN).length) continue;
            return false;
        }
        String string = this.getRFC2253CanonicalName();
        object2 = x500Name.getRFC2253CanonicalName();
        return string.equals(object2);
    }

    private String getString(DerValue derValue) throws IOException {
        if (derValue == null) {
            return null;
        }
        String string = derValue.getAsString();
        if (string == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("not a DER string encoding, " + DerValue._jr$ig$tag((Object)derValue)));
        }
        return string;
    }

    @Override
    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute(countryName_oid);
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute(orgName_oid);
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute(commonName_oid);
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute(localityName_oid);
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute(stateName_oid);
        return this.getString(derValue);
    }

    public String getDomain() throws IOException {
        DerValue derValue = this.findAttribute(DOMAIN_COMPONENT_OID);
        return this.getString(derValue);
    }

    public String getDNQualifier() throws IOException {
        DerValue derValue = this.findAttribute(DNQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getSurname() throws IOException {
        DerValue derValue = this.findAttribute(SURNAME_OID);
        return this.getString(derValue);
    }

    public String getGivenName() throws IOException {
        DerValue derValue = this.findAttribute(GIVENNAME_OID);
        return this.getString(derValue);
    }

    public String getInitials() throws IOException {
        DerValue derValue = this.findAttribute(INITIALS_OID);
        return this.getString(derValue);
    }

    public String getGeneration() throws IOException {
        DerValue derValue = this.findAttribute(GENERATIONQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getIP() throws IOException {
        DerValue derValue = this.findAttribute(ipAddress_oid);
        return this.getString(derValue);
    }

    @Override
    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getRFC1779Name() {
        return this.getRFC1779Name(Collections.emptyMap());
    }

    public String getRFC1779Name(Map<String, String> map) throws IllegalArgumentException {
        if (map.isEmpty()) {
            if (this.rfc1779Dn != null) {
                return this.rfc1779Dn;
            }
            this.rfc1779Dn = this.generateRFC1779DN(map);
            return this.rfc1779Dn;
        }
        return this.generateRFC1779DN(map);
    }

    public String getRFC2253Name() {
        return this.getRFC2253Name(Collections.emptyMap());
    }

    public String getRFC2253Name(Map<String, String> map) {
        if (map.isEmpty()) {
            if (this.rfc2253Dn != null) {
                return this.rfc2253Dn;
            }
            this.rfc2253Dn = this.generateRFC2253DN(map);
            return this.rfc2253Dn;
        }
        return this.generateRFC2253DN(map);
    }

    private String generateRFC2253DN(Map<String, String> map) {
        if (a.arrayLength((Object[])this.names) == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        for (int i = a.arrayLength((Object[])this.names) - 1; i >= 0; --i) {
            if (i < a.arrayLength((Object[])this.names) - 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).toRFC2253String(map));
        }
        return stringBuilder.toString();
    }

    public String getRFC2253CanonicalName() {
        if (this.canonicalDn != null) {
            return this.canonicalDn;
        }
        if (a.arrayLength((Object[])this.names) == 0) {
            this.canonicalDn = "";
            return this.canonicalDn;
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        for (int i = a.arrayLength((Object[])this.names) - 1; i >= 0; --i) {
            if (i < a.arrayLength((Object[])this.names) - 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).toRFC2253String(true));
        }
        this.canonicalDn = stringBuilder.toString();
        return this.canonicalDn;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                DerValue derValue = this.names[i].findAttribute(objectIdentifier);
                if (derValue == null) continue;
                return derValue;
            }
        }
        return null;
    }

    public DerValue findMostSpecificAttribute(ObjectIdentifier objectIdentifier) {
        if (this.names != null) {
            for (int i = this.names.length - 1; i >= 0; --i) {
                DerValue derValue = this.names[i].findAttribute(objectIdentifier);
                if (derValue == null) continue;
                return derValue;
            }
        }
        return null;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = null;
        byte[] byArray = derInputStream.toByteArray();
        try {
            derValueArray = derInputStream.getSequence(5);
        }
        catch (IOException iOException) {
            if (byArray == null) {
                derValueArray = null;
            }
            DerValue derValue = new DerValue(48, byArray);
            byArray = derValue.toByteArray();
            derValueArray = new DerInputStream(byArray).getSequence(5);
        }
        if (derValueArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = new RDN[derValueArray.length];
            for (int i = 0; i < derValueArray.length; ++i) {
                ((X500Name)this).names[i] = new RDN(derValueArray[i]);
            }
        }
    }

    @Deprecated
    public void emit(DerOutputStream derOutputStream) throws IOException {
        this.encode(derOutputStream);
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < a.arrayLength((Object[])this.names); ++i) {
            ((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getEncodedInternal() throws IOException {
        if (this.encoded == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i].encode(derOutputStream2);
            }
            derOutputStream.write((byte)48, derOutputStream2);
            this.encoded = derOutputStream.toByteArray();
        }
        return this.encoded;
    }

    public byte[] getEncoded() throws IOException {
        return (byte[])this.getEncodedInternal().clone();
    }

    private void parseDN(String string, Map<String, String> map) throws IOException {
        RDN rDN;
        String string2;
        if (string == null || string.length() == 0) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> arrayList = new ArrayList<RDN>();
        int n2 = 0;
        int n3 = 0;
        String string3 = string;
        int n4 = 0;
        int n5 = string3.indexOf(44);
        int n6 = string3.indexOf(59);
        while (n5 >= 0 || n6 >= 0) {
            int n7 = n6 < 0 ? n5 : (n5 < 0 ? n6 : Math.min(n5, n6));
            if (n7 >= 0 && (n3 += X500Name.countQuotes(string3, n4, n7)) != 1 && !X500Name.escaped(n7, n4, string3)) {
                string2 = string3.substring(n2, n7);
                rDN = new RDN(string2, map);
                arrayList.add(rDN);
                n2 = n7 + 1;
                n3 = 0;
            }
            n4 = n7 + 1;
            n5 = string3.indexOf(44, n4);
            n6 = string3.indexOf(59, n4);
        }
        string2 = string3.substring(n2);
        rDN = new RDN(string2, map);
        arrayList.add(rDN);
        Collections.reverse(arrayList);
        this.names = (RDN[])g.convertForCast((Object)arrayList.toArray(new RDN[arrayList.size()]), RDN[].class);
    }

    private void parseRFC2253DN(String string) throws IOException {
        RDN rDN;
        String string2;
        if (string.length() == 0) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> arrayList = new ArrayList<RDN>();
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(44);
        while (n4 >= 0) {
            if (n4 > 0 && !X500Name.escaped(n4, n3, string)) {
                string2 = string.substring(n2, n4);
                rDN = new RDN(string2, "RFC2253");
                arrayList.add(rDN);
                n2 = n4 + 1;
            }
            n3 = n4 + 1;
            n4 = string.indexOf(44, n3);
        }
        string2 = string.substring(n2);
        rDN = new RDN(string2, "RFC2253");
        arrayList.add(rDN);
        Collections.reverse(arrayList);
        this.names = (RDN[])g.convertForCast((Object)arrayList.toArray(new RDN[arrayList.size()]), RDN[].class);
    }

    static int countQuotes(String string, int n2, int n3) {
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            if ((string.charAt(i) != '\"' || i != n2) && (string.charAt(i) != '\"' || string.charAt(i - 1) == '\\')) continue;
            ++n4;
        }
        return n4;
    }

    private static boolean escaped(int n2, int n3, String string) {
        if (n2 == 1 && string.charAt(n2 - 1) == '\\') {
            return true;
        }
        if (n2 > 1 && string.charAt(n2 - 1) == '\\' && string.charAt(n2 - 2) != '\\') {
            return true;
        }
        if (n2 > 1 && string.charAt(n2 - 1) == '\\' && string.charAt(n2 - 2) == '\\') {
            int n4 = 0;
            --n2;
            while (n2 >= n3) {
                if (string.charAt(n2) == '\\') {
                    ++n4;
                }
                --n2;
            }
            return n4 % 2 != 0;
        }
        return false;
    }

    private void generateDN() {
        if (a.arrayLength((Object[])this.names) == 1) {
            this.dn = ((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)0), RDN.class))).toString();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        if (this.names != null) {
            for (int i = a.arrayLength((Object[])this.names) - 1; i >= 0; --i) {
                if (i != a.arrayLength((Object[])this.names) - 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).toString());
            }
        }
        this.dn = stringBuilder.toString();
    }

    private String generateRFC1779DN(Map<String, String> map) {
        if (a.arrayLength((Object[])this.names) == 1) {
            return ((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)0), RDN.class))).toRFC1779String(map);
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        if (this.names != null) {
            for (int i = a.arrayLength((Object[])this.names) - 1; i >= 0; --i) {
                if (i != a.arrayLength((Object[])this.names) - 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).toRFC1779String(map));
            }
        }
        return stringBuilder.toString();
    }

    static ObjectIdentifier intern(ObjectIdentifier objectIdentifier) {
        ObjectIdentifier objectIdentifier2 = (ObjectIdentifier)g.convertForCast((Object)internedOIDs.get(objectIdentifier), ObjectIdentifier.class);
        if (objectIdentifier2 != null) {
            return objectIdentifier2;
        }
        internedOIDs.put(objectIdentifier, objectIdentifier);
        return objectIdentifier;
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        X500Name x500Name;
        int n2 = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 4 ? -1 : ((x500Name = (X500Name)g.convertForCast((Object)generalNameInterface, X500Name.class)).equals(this) ? 0 : (a.arrayLength((Object[])x500Name.names) == 0 ? 2 : (a.arrayLength((Object[])this.names) == 0 ? 1 : (x500Name.isWithinSubtree(this) ? 1 : (this.isWithinSubtree(x500Name) ? 2 : 3))))));
        return n2;
    }

    private boolean isWithinSubtree(X500Name x500Name) {
        if (!f.ifAcmp((Object)this, (Object)x500Name)) {
            return true;
        }
        if (x500Name == null) {
            return false;
        }
        if (a.arrayLength((Object[])x500Name.names) == 0) {
            return true;
        }
        if (a.arrayLength((Object[])this.names) == 0) {
            return false;
        }
        if (a.arrayLength((Object[])this.names) < a.arrayLength((Object[])x500Name.names)) {
            return false;
        }
        for (int i = 0; i < a.arrayLength((Object[])x500Name.names); ++i) {
            if (((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])this.names, (int)i), RDN.class))).equals((Object)((RDN)((Object)g.convertForCast((Object)a.arrayLoad((Object[])x500Name.names, (int)i), RDN.class))))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        return a.arrayLength((Object[])this.names);
    }

    public X500Name commonAncestor(X500Name x500Name) {
        int n2;
        if (x500Name == null) {
            return null;
        }
        int n3 = x500Name.names.length;
        int n4 = this.names.length;
        if (n4 == 0 || n3 == 0) {
            return null;
        }
        int n5 = n4 < n3 ? n4 : n3;
        for (n2 = 0; n2 < n5; ++n2) {
            if (this.names[n2].equals((Object)x500Name.names[n2])) continue;
            if (n2 != 0) break;
            return null;
        }
        RDN[] rDNArray = new RDN[n2];
        for (int i = 0; i < n2; ++i) {
            rDNArray[i] = this.names[i];
        }
        X500Name x500Name2 = null;
        try {
            x500Name2 = new X500Name(rDNArray);
        }
        catch (IOException iOException) {
            return null;
        }
        return x500Name2;
    }

    public X500Principal asX500Principal() {
        if (this.x500Principal == null) {
            try {
                Object[] objectArray = new Object[1];
                a.arrayStore((Object[])objectArray, (int)0, (Object)this);
                Object[] objectArray2 = objectArray;
                this.x500Principal = (X500Principal)g.convertForCast(X500Name.principalConstructor.newInstance(objectArray2), X500Principal.class);
            }
            catch (Exception exception) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("Unexpected exception", exception));
            }
        }
        return this.x500Principal;
    }

    public static X500Name asX500Name(X500Principal x500Principal) {
        try {
            X500Name x500Name = (X500Name)g.convertForCast((Object)principalField.get(x500Principal), X500Name.class);
            x500Name.x500Principal = x500Principal;
            return x500Name;
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("Unexpected exception", exception));
        }
    }

    static {
        SERIALNUMBER_OID = X500Name.intern(ObjectIdentifier.newInternal(SERIALNUMBER_DATA));
        countryName_oid = X500Name.intern(ObjectIdentifier.newInternal(countryName_data));
        localityName_oid = X500Name.intern(ObjectIdentifier.newInternal(localityName_data));
        orgName_oid = X500Name.intern(ObjectIdentifier.newInternal(orgName_data));
        orgUnitName_oid = X500Name.intern(ObjectIdentifier.newInternal(orgUnitName_data));
        stateName_oid = X500Name.intern(ObjectIdentifier.newInternal(stateName_data));
        streetAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(streetAddress_data));
        title_oid = X500Name.intern(ObjectIdentifier.newInternal(title_data));
        DNQUALIFIER_OID = X500Name.intern(ObjectIdentifier.newInternal(DNQUALIFIER_DATA));
        SURNAME_OID = X500Name.intern(ObjectIdentifier.newInternal(SURNAME_DATA));
        GIVENNAME_OID = X500Name.intern(ObjectIdentifier.newInternal(GIVENNAME_DATA));
        INITIALS_OID = X500Name.intern(ObjectIdentifier.newInternal(INITIALS_DATA));
        GENERATIONQUALIFIER_OID = X500Name.intern(ObjectIdentifier.newInternal(GENERATIONQUALIFIER_DATA));
        ipAddress_oid = X500Name.intern(ObjectIdentifier.newInternal(ipAddress_data));
        DOMAIN_COMPONENT_OID = X500Name.intern(ObjectIdentifier.newInternal(DOMAIN_COMPONENT_DATA));
        userid_oid = X500Name.intern(ObjectIdentifier.newInternal(userid_data));
        PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

            public Object[] run() throws Exception {
                Class<X500Principal> clazz = X500Principal.class;
                Object[] objectArray = new Class[1];
                a.arrayStore((Object[])objectArray, (int)0, X500Name.class);
                Object[] objectArray2 = objectArray;
                aj aj2 = ai.convertArgs(clazz, (Class[])objectArray2);
                Constructor constructor = aj2.clazz.getDeclaredConstructor(aj2.args);
                constructor.setAccessible(true);
                Field field = ai.getCurrentClass(clazz).getDeclaredField("thisX500Name");
                field.setAccessible(true);
                Object[] objectArray3 = new Object[2];
                a.arrayStore((Object[])objectArray3, (int)0, constructor);
                a.arrayStore((Object[])objectArray3, (int)1, (Object)field);
                return objectArray3;
            }
        };
        try {
            Object[] objectArray = (Object[])g.convertForCast(AccessController.doPrivileged(privilegedExceptionAction), Object[].class);
            principalConstructor = (Constructor)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)0), Constructor.class);
            principalField = (Field)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)1), Field.class);
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)((InternalError)g.convertForCast((Object)new InternalError("Could not obtain X500Principal access").initCause(exception), InternalError.class)));
        }
    }

    private static /* synthetic */ void _jr$ip$allAvaList(X500Name x500Name, List list) {
        x500Name.allAvaList = list;
    }

    protected /* synthetic */ X500Name(h h2) {
        super(h2);
    }
}

