/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import sun.misc.BASE64Decoder;
import sun.misc.HexDumpEncoder;
import sun.security.provider.X509Factory;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.CertificateValidity;
import sun.security.x509.DNSName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.OIDMap;
import sun.security.x509.OIDName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyConstraintsExtension;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.PrivateKeyUsageExtension;
import sun.security.x509.RFC822Name;
import sun.security.x509.SerialNumber;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.UniqueIdentity;
import sun.security.x509.X500Name;
import sun.security.x509.X509AttributeName;
import sun.security.x509.X509CertInfo;

public class X509CertImpl
extends X509Certificate
implements DerEncoder {
    private static final long serialVersionUID = -3457612960190864406L;
    private static final String DOT = ".";
    public static final String NAME = "x509";
    public static final String INFO = "info";
    public static final String ALG_ID = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNED_CERT = "signed_cert";
    public static final String SUBJECT_DN = "x509.info.subject.dname";
    public static final String ISSUER_DN = "x509.info.issuer.dname";
    public static final String SERIAL_ID = "x509.info.serialNumber.number";
    public static final String PUBLIC_KEY = "x509.info.key.value";
    public static final String VERSION = "x509.info.version.number";
    public static final String SIG_ALG = "x509.algorithm";
    public static final String SIG = "x509.signature";
    private boolean readOnly;
    private byte[] signedCert;
    protected X509CertInfo info;
    protected AlgorithmId algId;
    protected byte[] signature;
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    private static final String BASIC_CONSTRAINT_OID = "2.5.29.19";
    private static final String SUBJECT_ALT_NAME_OID = "2.5.29.17";
    private static final String ISSUER_ALT_NAME_OID = "2.5.29.18";
    private static final String AUTH_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.1";
    private static final int NUM_STANDARD_KEY_USAGE = 9;
    private Collection<List<?>> subjectAlternativeNames;
    private Collection<List<?>> issuerAlternativeNames;
    private List<String> extKeyUsage;
    private Set<AccessDescription> authInfoAccess;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;
    private boolean verificationResult;

    public X509CertImpl() {
        this.readOnly = false;
        this.signedCert = null;
        this.info = null;
        this.algId = null;
        this.signature = null;
    }

    public X509CertImpl(byte[] byArray) throws CertificateException {
        this.readOnly = false;
        this.signedCert = null;
        this.info = null;
        this.algId = null;
        this.signature = null;
        try {
            this.parse(new DerValue(byArray));
        }
        catch (IOException iOException) {
            this.signedCert = null;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Unable to initialize, " + iOException, iOException));
        }
    }

    public X509CertImpl(InputStream inputStream) throws CertificateException {
        this.readOnly = false;
        this.signedCert = null;
        this.info = null;
        this.algId = null;
        this.signature = null;
        DerValue derValue = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            bufferedInputStream.mark(Integer.MAX_VALUE);
            derValue = this.readRFC1421Cert(bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                bufferedInputStream.reset();
                derValue = new DerValue(bufferedInputStream);
            }
            catch (IOException iOException2) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Input stream must be either DER-encoded bytes or RFC1421 hex-encoded DER-encoded bytes: " + iOException2.getMessage(), iOException2));
            }
        }
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCert = null;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Unable to parse DER value of certificate, " + iOException, iOException));
        }
    }

    private DerValue readRFC1421Cert(InputStream inputStream) throws IOException {
        DerValue derValue = null;
        String string = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ASCII"));
        try {
            string = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unable to read InputStream: " + iOException.getMessage()));
        }
        if (string.equals("-----BEGIN CERTIFICATE-----")) {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.equals("-----END CERTIFICATE-----")) {
                        derValue = new DerValue(byteArrayOutputStream.toByteArray());
                    }
                    byteArrayOutputStream.write(bASE64Decoder.decodeBuffer(string));
                }
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Unable to read InputStream: " + iOException.getMessage()));
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("InputStream is not RFC1421 hex-encoded DER bytes"));
        }
        return derValue;
    }

    public X509CertImpl(X509CertInfo x509CertInfo) {
        this.readOnly = false;
        this.signedCert = null;
        this.info = null;
        this.algId = null;
        this.signature = null;
        this.info = x509CertInfo;
    }

    public X509CertImpl(DerValue derValue) throws CertificateException {
        this.readOnly = false;
        this.signedCert = null;
        this.info = null;
        this.algId = null;
        this.signature = null;
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            this.signedCert = null;
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Unable to initialize, " + iOException, iOException));
        }
    }

    public void encode(OutputStream outputStream) throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException("Null certificate to encode"));
        }
        try {
            outputStream.write((byte[])this.signedCert.clone());
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException(iOException.toString()));
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (this.signedCert == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("Null certificate to encode"));
        }
        outputStream.write((byte[])this.signedCert.clone());
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public byte[] getEncodedInternal() throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException("Null certificate to encode"));
        }
        return this.signedCert;
    }

    @Override
    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "");
    }

    @Override
    @af(modifiers=33)
    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (string == null) {
                    string = "";
                }
                if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(publicKey) && string.equals(this.verifiedProvider)) {
                    if (this.verificationResult) {
                        return;
                    }
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Signature does not match."));
                }
                if (this.signedCert == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException("Uninitialized certificate"));
                }
                Signature signature = null;
                signature = string.length() == 0 ? Signature.getInstance(((X509CertImpl)this).algId.getName()) : Signature.getInstance(((X509CertImpl)this).algId.getName(), string);
                signature.initVerify(publicKey);
                byte[] byArray = ((X509CertImpl)this).info.getEncodedInfo();
                signature.update(byArray, 0, byArray.length);
                this.verificationResult = signature.verify(((X509CertImpl)this).signature);
                this.verifiedPublicKey = publicKey;
                this.verifiedProvider = string;
                if (!this.verificationResult) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new SignatureException("Signature does not match."));
                }
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public void sign(PrivateKey privateKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(privateKey, string, null);
    }

    public void sign(PrivateKey privateKey, String string, String string2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException("cannot over-write existing certificate"));
            }
            Signature signature = null;
            signature = string2 == null || string2.length() == 0 ? Signature.getInstance(string) : Signature.getInstance(string, string2);
            signature.initSign(privateKey);
            ((X509CertImpl)this).algId = AlgorithmId.get(signature.getAlgorithm());
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            ((X509CertImpl)this).info.encode(derOutputStream2);
            byte[] byArray = derOutputStream2.toByteArray();
            ((X509CertImpl)this).algId.encode(derOutputStream2);
            signature.update(byArray, 0, byArray.length);
            ((X509CertImpl)this).signature = signature.sign();
            derOutputStream2.putBitString(((X509CertImpl)this).signature);
            derOutputStream.write((byte)48, derOutputStream2);
            this.signedCert = derOutputStream.toByteArray();
            this.readOnly = true;
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException(iOException.toString()));
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        this.checkValidity(date);
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        CertificateValidity certificateValidity = null;
        try {
            certificateValidity = (CertificateValidity)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("validity"), CertificateValidity.class));
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateNotYetValidException("Incorrect validity period"));
        }
        if (certificateValidity == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateNotYetValidException("Null validity period"));
        }
        certificateValidity.valid(date);
    }

    public Object get(String string) throws CertificateParsingException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Invalid root of attribute name, expected [x509], received [" + string2 + "]"));
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (((X509CertImpl)this).info == null) {
                return null;
            }
            if (x509AttributeName.getSuffix() != null) {
                try {
                    return ((X509CertImpl)this).info.get(x509AttributeName.getSuffix());
                }
                catch (IOException iOException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException(iOException.toString()));
                }
                catch (CertificateException certificateException) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException(certificateException.toString()));
                }
            }
            return ((X509CertImpl)this).info;
        }
        if (string2.equalsIgnoreCase(ALG_ID)) {
            return ((X509CertImpl)this).algId;
        }
        if (string2.equalsIgnoreCase(SIGNATURE)) {
            if (((X509CertImpl)this).signature != null) {
                return ((X509CertImpl)this).signature.clone();
            }
            return null;
        }
        if (string2.equalsIgnoreCase(SIGNED_CERT)) {
            if (this.signedCert != null) {
                return this.signedCert.clone();
            }
            return null;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Attribute name not recognized or get() not allowed for the same: " + string2));
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        if (this.readOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("cannot over-write existing certificate"));
        }
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Invalid root of attribute name, expected [x509], received " + string2));
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() == null) {
                if (!(g.convertForInstanceOf((Object)object, X509CertInfo.class) instanceof X509CertInfo)) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute value should be of type X509CertInfo."));
                }
                ((X509CertImpl)this).info = (X509CertInfo)((Object)g.convertForCast((Object)object, X509CertInfo.class));
                this.signedCert = null;
            } else {
                ((X509CertImpl)this).info.set(x509AttributeName.getSuffix(), object);
                this.signedCert = null;
            }
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized or set() not allowed for the same: " + string2));
        }
    }

    public void delete(String string) throws CertificateException, IOException {
        if (this.readOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("cannot over-write existing certificate"));
        }
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        String string2 = x509AttributeName.getPrefix();
        if (!string2.equalsIgnoreCase(NAME)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Invalid root of attribute name, expected [x509], received " + string2));
        }
        string2 = (x509AttributeName = new X509AttributeName(x509AttributeName.getSuffix())).getPrefix();
        if (string2.equalsIgnoreCase(INFO)) {
            if (x509AttributeName.getSuffix() != null) {
                ((X509CertImpl)this).info = null;
            } else {
                ((X509CertImpl)this).info.delete(x509AttributeName.getSuffix());
            }
        } else if (string2.equalsIgnoreCase(ALG_ID)) {
            ((X509CertImpl)this).algId = null;
        } else if (string2.equalsIgnoreCase(SIGNATURE)) {
            ((X509CertImpl)this).signature = null;
        } else if (string2.equalsIgnoreCase(SIGNED_CERT)) {
            this.signedCert = null;
        } else {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized or delete() not allowed for the same: " + string2));
        }
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)"x509.info");
        attributeNameEnumeration.addElement((Object)SIG_ALG);
        attributeNameEnumeration.addElement((Object)SIG);
        attributeNameEnumeration.addElement((Object)"x509.signed_cert");
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        if (((X509CertImpl)this).info == null || ((X509CertImpl)this).algId == null || ((X509CertImpl)this).signature == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        stringBuilder.append(((X509CertImpl)this).info.toString() + "\n");
        stringBuilder.append("  Algorithm: [" + ((X509CertImpl)this).algId.toString() + "]\n");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        stringBuilder.append("  Signature:\n" + hexDumpEncoder.encodeBuffer(((X509CertImpl)this).signature));
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            PublicKey publicKey = (PublicKey)g.convertForCast((Object)((X509CertImpl)this).info.get("key.value"), PublicKey.class);
            return publicKey;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int getVersion() {
        if (((X509CertImpl)this).info == null) {
            return -1;
        }
        try {
            int n2 = (Integer)((X509CertImpl)this).info.get("version.number");
            return n2 + 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        SerialNumber serialNumber = this.getSerialNumberObject();
        return serialNumber != null ? serialNumber.getNumber() : null;
    }

    public SerialNumber getSerialNumberObject() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            SerialNumber serialNumber = (SerialNumber)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("serialNumber.number"), SerialNumber.class));
            return serialNumber;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Principal getSubjectDN() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            Principal principal = (Principal)g.convertForCast((Object)((X509CertImpl)this).info.get("subject.dname"), Principal.class);
            return principal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            X500Principal x500Principal = (X500Principal)((X509CertImpl)this).info.get("subject.x500principal");
            return x500Principal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Principal getIssuerDN() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            Principal principal = (Principal)g.convertForCast((Object)((X509CertImpl)this).info.get("issuer.dname"), Principal.class);
            return principal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            X500Principal x500Principal = (X500Principal)((X509CertImpl)this).info.get("issuer.x500principal");
            return x500Principal;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Date getNotBefore() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            Date date = (Date)g.convertForCast((Object)((X509CertImpl)this).info.get("validity.notBefore"), Date.class);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Date getNotAfter() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            Date date = (Date)g.convertForCast((Object)((X509CertImpl)this).info.get("validity.notAfter"), Date.class);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (((X509CertImpl)this).info != null) {
            return ((X509CertImpl)this).info.getEncodedInfo();
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException("Uninitialized certificate"));
    }

    @Override
    public byte[] getSignature() {
        if (((X509CertImpl)this).signature == null) {
            return null;
        }
        byte[] byArray = new byte[((X509CertImpl)this).signature.length];
        a.arraycopy((Object)((X509CertImpl)this).signature, (int)0, (Object)byArray, (int)0, (int)byArray.length);
        return byArray;
    }

    @Override
    public String getSigAlgName() {
        if (((X509CertImpl)this).algId == null) {
            return null;
        }
        return ((X509CertImpl)this).algId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (((X509CertImpl)this).algId == null) {
            return null;
        }
        ObjectIdentifier objectIdentifier = ((X509CertImpl)this).algId.getOID();
        return objectIdentifier.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (((X509CertImpl)this).algId == null) {
            return null;
        }
        try {
            return ((X509CertImpl)this).algId.getEncodedParams();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            UniqueIdentity uniqueIdentity = (UniqueIdentity)g.convertForCast((Object)((X509CertImpl)this).info.get("issuerID.id"), UniqueIdentity.class);
            if (uniqueIdentity == null) {
                return null;
            }
            return uniqueIdentity.getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            UniqueIdentity uniqueIdentity = (UniqueIdentity)g.convertForCast((Object)((X509CertImpl)this).info.get("subjectID.id"), UniqueIdentity.class);
            if (uniqueIdentity == null) {
                return null;
            }
            return uniqueIdentity.getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AuthorityKeyIdentifierExtension getAuthorityKeyIdentifierExtension() {
        return (AuthorityKeyIdentifierExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.AuthorityKey_Id), AuthorityKeyIdentifierExtension.class);
    }

    public byte[] getIssuerKeyIdentifier() {
        byte[] byArray = null;
        AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = this.getAuthorityKeyIdentifierExtension();
        if (authorityKeyIdentifierExtension != null) {
            try {
                KeyIdentifier keyIdentifier = (KeyIdentifier)((Object)g.convertForCast((Object)authorityKeyIdentifierExtension.get("key_id"), KeyIdentifier.class));
                if (keyIdentifier != null) {
                    byArray = keyIdentifier.getIdentifier();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public BasicConstraintsExtension getBasicConstraintsExtension() {
        return (BasicConstraintsExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.BasicConstraints_Id), BasicConstraintsExtension.class);
    }

    public CertificatePoliciesExtension getCertificatePoliciesExtension() {
        return (CertificatePoliciesExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.CertificatePolicies_Id), CertificatePoliciesExtension.class);
    }

    public ExtendedKeyUsageExtension getExtendedKeyUsageExtension() {
        return (ExtendedKeyUsageExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.ExtendedKeyUsage_Id), ExtendedKeyUsageExtension.class);
    }

    public IssuerAlternativeNameExtension getIssuerAlternativeNameExtension() {
        return (IssuerAlternativeNameExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id), IssuerAlternativeNameExtension.class);
    }

    public NameConstraintsExtension getNameConstraintsExtension() {
        return (NameConstraintsExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.NameConstraints_Id), NameConstraintsExtension.class);
    }

    public PolicyConstraintsExtension getPolicyConstraintsExtension() {
        return (PolicyConstraintsExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.PolicyConstraints_Id), PolicyConstraintsExtension.class);
    }

    public PolicyMappingsExtension getPolicyMappingsExtension() {
        return (PolicyMappingsExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.PolicyMappings_Id), PolicyMappingsExtension.class);
    }

    public PrivateKeyUsageExtension getPrivateKeyUsageExtension() {
        return (PrivateKeyUsageExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.PrivateKeyUsage_Id), PrivateKeyUsageExtension.class);
    }

    public SubjectAlternativeNameExtension getSubjectAlternativeNameExtension() {
        return (SubjectAlternativeNameExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id), SubjectAlternativeNameExtension.class);
    }

    public SubjectKeyIdentifierExtension getSubjectKeyIdentifierExtension() {
        return (SubjectKeyIdentifierExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.SubjectKey_Id), SubjectKeyIdentifierExtension.class);
    }

    public byte[] getSubjectKeyIdentifier() {
        byte[] byArray = null;
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = this.getSubjectKeyIdentifierExtension();
        if (subjectKeyIdentifierExtension != null) {
            try {
                KeyIdentifier keyIdentifier = (KeyIdentifier)((Object)g.convertForCast((Object)subjectKeyIdentifierExtension.get("key_id"), KeyIdentifier.class));
                if (keyIdentifier != null) {
                    byArray = keyIdentifier.getIdentifier();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public CRLDistributionPointsExtension getCRLDistributionPointsExtension() {
        return (CRLDistributionPointsExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id), CRLDistributionPointsExtension.class);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (((X509CertImpl)this).info == null) {
            return false;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("extensions"), CertificateExtensions.class));
            if (certificateExtensions == null) {
                return false;
            }
            return certificateExtensions.hasUnsupportedCriticalExtension();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("extensions"), CertificateExtensions.class));
            if (certificateExtensions == null) {
                return null;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator<Extension> iterator = certificateExtensions.getAllExtensions().iterator();
            while (iterator.hasNext()) {
                Extension extension = (Extension)g.convertForCast((Object)iterator.next(), Extension.class);
                if (!extension.isCritical()) continue;
                treeSet.add(extension.getExtensionId().toString());
            }
            return treeSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions = (CertificateExtensions)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("extensions"), CertificateExtensions.class));
            if (certificateExtensions == null) {
                return null;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            Iterator<Extension> iterator = certificateExtensions.getAllExtensions().iterator();
            while (iterator.hasNext()) {
                Extension extension = (Extension)g.convertForCast((Object)iterator.next(), Extension.class);
                if (extension.isCritical()) continue;
                treeSet.add(extension.getExtensionId().toString());
            }
            treeSet.addAll(certificateExtensions.getUnparseableExtensions().keySet());
            return treeSet;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Extension getExtension(ObjectIdentifier objectIdentifier) {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions;
            try {
                certificateExtensions = (CertificateExtensions)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("extensions"), CertificateExtensions.class));
            }
            catch (CertificateException certificateException) {
                return null;
            }
            if (certificateExtensions == null) {
                return null;
            }
            Extension extension = certificateExtensions.getExtension(objectIdentifier.toString());
            if (extension != null) {
                return extension;
            }
            Iterator<Extension> iterator = certificateExtensions.getAllExtensions().iterator();
            while (iterator.hasNext()) {
                Extension extension2 = (Extension)g.convertForCast((Object)iterator.next(), Extension.class);
                if (!extension2.getExtensionId().equals((Object)objectIdentifier)) continue;
                return extension2;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Extension getUnparseableExtension(ObjectIdentifier objectIdentifier) {
        if (((X509CertImpl)this).info == null) {
            return null;
        }
        try {
            CertificateExtensions certificateExtensions;
            try {
                certificateExtensions = (CertificateExtensions)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("extensions"), CertificateExtensions.class));
            }
            catch (CertificateException certificateException) {
                return null;
            }
            if (certificateExtensions == null) {
                return null;
            }
            return (Extension)g.convertForCast((Object)certificateExtensions.getUnparseableExtensions().get(objectIdentifier.toString()), Extension.class);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public byte[] getExtensionValue(String string) {
        try {
            h h2;
            Object object;
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(string);
            String string2 = OIDMap.getName(objectIdentifier);
            Extension extension = null;
            CertificateExtensions certificateExtensions = (CertificateExtensions)((Object)g.convertForCast((Object)((X509CertImpl)this).info.get("extensions"), CertificateExtensions.class));
            if (string2 == null) {
                if (certificateExtensions == null) {
                    return null;
                }
                object = certificateExtensions.getAllExtensions().iterator();
                while (object.hasNext()) {
                    h2 = (Extension)g.convertForCast(object.next(), Extension.class);
                    ObjectIdentifier objectIdentifier2 = h2.getExtensionId();
                    if (!objectIdentifier2.equals((Object)objectIdentifier)) continue;
                    extension = h2;
                    break;
                }
            } else {
                try {
                    extension = (Extension)g.convertForCast((Object)this.get(string2), Extension.class);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            if (extension == null) {
                if (certificateExtensions != null) {
                    extension = (Extension)g.convertForCast((Object)certificateExtensions.getUnparseableExtensions().get(string), Extension.class);
                }
                if (extension == null) {
                    return null;
                }
            }
            if ((object = (Object)extension.getExtensionValue()) == null) {
                return null;
            }
            h2 = new DerOutputStream();
            h2.putOctetString((byte[])object);
            return h2.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        try {
            String string = OIDMap.getName(PKIXExtensions.KeyUsage_Id);
            if (string == null) {
                return null;
            }
            KeyUsageExtension keyUsageExtension = (KeyUsageExtension)g.convertForCast((Object)this.get(string), KeyUsageExtension.class);
            if (keyUsageExtension == null) {
                return null;
            }
            boolean[] blArray = keyUsageExtension.getBits();
            if (blArray.length < 9) {
                boolean[] blArray2 = new boolean[9];
                a.arraycopy((Object)blArray, (int)0, (Object)blArray2, (int)0, (int)blArray.length);
                blArray = blArray2;
            }
            return blArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @af(modifiers=33)
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.readOnly && this.extKeyUsage != null) {
                    return this.extKeyUsage;
                }
                ExtendedKeyUsageExtension extendedKeyUsageExtension = this.getExtendedKeyUsageExtension();
                if (extendedKeyUsageExtension == null) {
                    return null;
                }
                this.extKeyUsage = Collections.unmodifiableList(extendedKeyUsageExtension.getExtendedKeyUsage());
                return this.extKeyUsage;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static List<String> getExtendedKeyUsage(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            byte[] byArray = x509Certificate.getExtensionValue(EXTENDED_KEY_USAGE_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            ExtendedKeyUsageExtension extendedKeyUsageExtension = new ExtendedKeyUsageExtension(Boolean.FALSE, byArray2);
            return Collections.unmodifiableList(extendedKeyUsageExtension.getExtendedKeyUsage());
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException(iOException));
        }
    }

    @Override
    public int getBasicConstraints() {
        try {
            String string = OIDMap.getName(PKIXExtensions.BasicConstraints_Id);
            if (string == null) {
                return -1;
            }
            BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)g.convertForCast((Object)this.get(string), BasicConstraintsExtension.class);
            if (basicConstraintsExtension == null) {
                return -1;
            }
            if (((Boolean)g.convertForCast((Object)basicConstraintsExtension.get("is_ca"), Boolean.class)).booleanValue()) {
                return (Integer)basicConstraintsExtension.get("path_len");
            }
            return -1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static Collection<List<?>> makeAltNames(GeneralNames generalNames) {
        if (generalNames.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList arrayList = new ArrayList();
        Iterator<GeneralName> iterator = generalNames.names().iterator();
        while (iterator.hasNext()) {
            GeneralName generalName = (GeneralName)((Object)g.convertForCast((Object)((Object)iterator.next()), GeneralName.class));
            GeneralNameInterface generalNameInterface = generalName.getName();
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add(generalNameInterface.getType());
            switch (generalNameInterface.getType()) {
                case 1: {
                    arrayList2.add(((RFC822Name)g.convertForCast((Object)generalNameInterface, RFC822Name.class)).getName());
                    break;
                }
                case 2: {
                    arrayList2.add(((DNSName)g.convertForCast((Object)generalNameInterface, DNSName.class)).getName());
                    break;
                }
                case 4: {
                    arrayList2.add(((X500Name)g.convertForCast((Object)generalNameInterface, X500Name.class)).getRFC2253Name());
                    break;
                }
                case 6: {
                    arrayList2.add(((URIName)g.convertForCast((Object)generalNameInterface, URIName.class)).getName());
                    break;
                }
                case 7: {
                    try {
                        arrayList2.add(((IPAddressName)g.convertForCast((Object)generalNameInterface, IPAddressName.class)).getName());
                        break;
                    }
                    catch (IOException iOException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("IPAddress cannot be parsed", iOException));
                    }
                }
                case 8: {
                    arrayList2.add(((OIDName)g.convertForCast((Object)generalNameInterface, OIDName.class)).getOID().toString());
                    break;
                }
                default: {
                    DerOutputStream derOutputStream = new DerOutputStream();
                    try {
                        generalNameInterface.encode(derOutputStream);
                    }
                    catch (IOException iOException) {
                        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("name cannot be encoded", iOException));
                    }
                    arrayList2.add(derOutputStream.toByteArray());
                }
            }
            arrayList.add(Collections.unmodifiableList(arrayList2));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    private static Collection<List<?>> cloneAltNames(Collection<List<?>> collection) {
        Object object;
        boolean bl = false;
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (List)g.convertForCast(object2.next(), List.class);
            if (!(object.get(1) instanceof byte[])) continue;
            bl = true;
        }
        if (bl) {
            object2 = new ArrayList();
            object = collection.iterator();
            while (object.hasNext()) {
                List list = (List)g.convertForCast(object.next(), List.class);
                Object e2 = list.get(1);
                if (e2 instanceof byte[]) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(list);
                    arrayList.set(1, ((byte[])e2).clone());
                    object2.add(Collections.unmodifiableList(arrayList));
                    continue;
                }
                object2.add(list);
            }
            return Collections.unmodifiableCollection(object2);
        }
        return collection;
    }

    @Override
    @af(modifiers=33)
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                GeneralNames generalNames;
                if (this.readOnly && this.subjectAlternativeNames != null) {
                    return X509CertImpl.cloneAltNames(this.subjectAlternativeNames);
                }
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = this.getSubjectAlternativeNameExtension();
                if (subjectAlternativeNameExtension == null) {
                    return null;
                }
                try {
                    generalNames = (GeneralNames)((Object)g.convertForCast((Object)subjectAlternativeNameExtension.get("subject_name"), GeneralNames.class));
                }
                catch (IOException iOException) {
                    return Collections.emptySet();
                }
                this.subjectAlternativeNames = X509CertImpl.makeAltNames(generalNames);
                return this.subjectAlternativeNames;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static Collection<List<?>> getSubjectAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            GeneralNames generalNames;
            byte[] byArray = x509Certificate.getExtensionValue(SUBJECT_ALT_NAME_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = new SubjectAlternativeNameExtension(Boolean.FALSE, byArray2);
            try {
                generalNames = (GeneralNames)((Object)g.convertForCast((Object)subjectAlternativeNameExtension.get("subject_name"), GeneralNames.class));
            }
            catch (IOException iOException) {
                return Collections.emptySet();
            }
            return X509CertImpl.makeAltNames(generalNames);
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException(iOException));
        }
    }

    @Override
    @af(modifiers=33)
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                GeneralNames generalNames;
                if (this.readOnly && this.issuerAlternativeNames != null) {
                    return X509CertImpl.cloneAltNames(this.issuerAlternativeNames);
                }
                IssuerAlternativeNameExtension issuerAlternativeNameExtension = this.getIssuerAlternativeNameExtension();
                if (issuerAlternativeNameExtension == null) {
                    return null;
                }
                try {
                    generalNames = (GeneralNames)((Object)g.convertForCast((Object)issuerAlternativeNameExtension.get("issuer_name"), GeneralNames.class));
                }
                catch (IOException iOException) {
                    return Collections.emptySet();
                }
                this.issuerAlternativeNames = X509CertImpl.makeAltNames(generalNames);
                return this.issuerAlternativeNames;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public static Collection<List<?>> getIssuerAlternativeNames(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            GeneralNames generalNames;
            byte[] byArray = x509Certificate.getExtensionValue(ISSUER_ALT_NAME_OID);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            IssuerAlternativeNameExtension issuerAlternativeNameExtension = new IssuerAlternativeNameExtension(Boolean.FALSE, byArray2);
            try {
                generalNames = (GeneralNames)((Object)g.convertForCast((Object)issuerAlternativeNameExtension.get("issuer_name"), GeneralNames.class));
            }
            catch (IOException iOException) {
                return Collections.emptySet();
            }
            return X509CertImpl.makeAltNames(generalNames);
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException(iOException));
        }
    }

    public AuthorityInfoAccessExtension getAuthorityInfoAccessExtension() {
        return (AuthorityInfoAccessExtension)g.convertForCast((Object)this.getExtension(PKIXExtensions.AuthInfoAccess_Id), AuthorityInfoAccessExtension.class);
    }

    private void parse(DerValue derValue) throws CertificateException, IOException {
        if (this.readOnly) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("cannot over-write existing certificate"));
        }
        if (DerValue._jr$ig$data((Object)derValue) == null || DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("invalid DER-encoded certificate data"));
        }
        this.signedCert = derValue.toByteArray();
        DerValue[] derValueArray = new DerValue[]{DerValue._jr$ig$data((Object)derValue).getDerValue(), DerValue._jr$ig$data((Object)derValue).getDerValue(), DerValue._jr$ig$data((Object)derValue).getDerValue()};
        if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("signed overrun, bytes = " + DerValue._jr$ig$data((Object)derValue).available()));
        }
        if (DerValue._jr$ig$tag((Object)derValueArray[0]) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("signed fields invalid"));
        }
        ((X509CertImpl)this).algId = AlgorithmId.parse(derValueArray[1]);
        ((X509CertImpl)this).signature = derValueArray[2].getBitString();
        if (DerValue._jr$ig$data((Object)derValueArray[1]).available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("algid field overrun"));
        }
        if (DerValue._jr$ig$data((Object)derValueArray[2]).available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("signed fields overrun"));
        }
        ((X509CertImpl)this).info = new X509CertInfo(derValueArray[0]);
        AlgorithmId algorithmId = (AlgorithmId)g.convertForCast((Object)((X509CertImpl)this).info.get("algorithmID.algorithm"), AlgorithmId.class);
        if (!((X509CertImpl)this).algId.equals(algorithmId)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Signature algorithm mismatch"));
        }
        this.readOnly = true;
    }

    private static X500Principal getX500Principal(X509Certificate x509Certificate, boolean bl) throws Exception {
        byte[] byArray = x509Certificate.getEncoded();
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getSequence(3)[0];
        DerInputStream derInputStream2 = DerValue._jr$ig$data((Object)derValue);
        DerValue derValue2 = derInputStream2.getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            derValue2 = derInputStream2.getDerValue();
        }
        derValue2 = derInputStream2.getDerValue();
        derValue2 = derInputStream2.getDerValue();
        if (!bl) {
            derValue2 = derInputStream2.getDerValue();
            derValue2 = derInputStream2.getDerValue();
        }
        byte[] byArray2 = derValue2.toByteArray();
        return new X500Principal(byArray2);
    }

    public static X500Principal getSubjectX500Principal(X509Certificate x509Certificate) {
        try {
            return X509CertImpl.getX500Principal(x509Certificate, false);
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("Could not parse subject", exception));
        }
    }

    public static X500Principal getIssuerX500Principal(X509Certificate x509Certificate) {
        try {
            return X509CertImpl.getX500Principal(x509Certificate, true);
        }
        catch (Exception exception) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new RuntimeException("Could not parse issuer", exception));
        }
    }

    public static byte[] getEncodedInternal(Certificate certificate) throws CertificateEncodingException {
        if (g.convertForInstanceOf((Object)certificate, X509CertImpl.class) instanceof X509CertImpl) {
            return ((X509CertImpl)g.convertForCast((Object)certificate, X509CertImpl.class)).getEncodedInternal();
        }
        return certificate.getEncoded();
    }

    public static X509CertImpl toImpl(X509Certificate x509Certificate) throws CertificateException {
        if (g.convertForInstanceOf((Object)x509Certificate, X509CertImpl.class) instanceof X509CertImpl) {
            return (X509CertImpl)g.convertForCast((Object)x509Certificate, X509CertImpl.class);
        }
        return X509Factory.intern(x509Certificate);
    }

    public static boolean isSelfIssued(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
        return x500Principal.equals(x500Principal2);
    }

    public static boolean isSelfSigned(X509Certificate x509Certificate, String string) {
        if (X509CertImpl.isSelfIssued(x509Certificate)) {
            try {
                if (string == null) {
                    x509Certificate.verify(x509Certificate.getPublicKey());
                } else {
                    x509Certificate.verify(x509Certificate.getPublicKey(), string);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static /* synthetic */ Set _jr$ig$authInfoAccess(X509CertImpl x509CertImpl) {
        return x509CertImpl.authInfoAccess;
    }

    private static /* synthetic */ void _jr$ip$authInfoAccess(X509CertImpl x509CertImpl, Set set) {
        x509CertImpl.authInfoAccess = set;
    }

    protected /* synthetic */ X509CertImpl(h h2) {
        super(h2);
    }
}

