/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateIssuerUniqueIdentity;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateSubjectUniqueIdentity;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.OIDMap;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509AttributeName;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public class X509CertInfo
extends h
implements CertAttrSet {
    public static final String IDENT = "x509.info";
    public static final String NAME = "info";
    public static final String VERSION = "version";
    public static final String SERIAL_NUMBER = "serialNumber";
    public static final String ALGORITHM_ID = "algorithmID";
    public static final String ISSUER = "issuer";
    public static final String VALIDITY = "validity";
    public static final String SUBJECT = "subject";
    public static final String KEY = "key";
    public static final String ISSUER_ID = "issuerID";
    public static final String SUBJECT_ID = "subjectID";
    public static final String EXTENSIONS = "extensions";
    protected CertificateVersion version;
    protected CertificateSerialNumber serialNum;
    protected CertificateAlgorithmId algId;
    protected CertificateIssuerName issuer;
    protected CertificateValidity interval;
    protected CertificateSubjectName subject;
    protected CertificateX509Key pubKey;
    protected CertificateIssuerUniqueIdentity issuerUniqueId;
    protected CertificateSubjectUniqueIdentity subjectUniqueId;
    protected CertificateExtensions extensions;
    private static final int ATTR_VERSION = 1;
    private static final int ATTR_SERIAL = 2;
    private static final int ATTR_ALGORITHM = 3;
    private static final int ATTR_ISSUER = 4;
    private static final int ATTR_VALIDITY = 5;
    private static final int ATTR_SUBJECT = 6;
    private static final int ATTR_KEY = 7;
    private static final int ATTR_ISSUER_ID = 8;
    private static final int ATTR_SUBJECT_ID = 9;
    private static final int ATTR_EXTENSIONS = 10;
    private byte[] rawCertInfo;
    private static final Map<String, Integer> map = new HashMap<String, Integer>();

    public X509CertInfo() {
        this.version = new CertificateVersion();
        this.serialNum = null;
        this.algId = null;
        this.issuer = null;
        this.interval = null;
        this.subject = null;
        this.pubKey = null;
        this.issuerUniqueId = null;
        this.subjectUniqueId = null;
        this.extensions = null;
        this.rawCertInfo = null;
    }

    public X509CertInfo(byte[] byArray) throws CertificateParsingException {
        this.version = new CertificateVersion();
        this.serialNum = null;
        this.algId = null;
        this.issuer = null;
        this.interval = null;
        this.subject = null;
        this.pubKey = null;
        this.issuerUniqueId = null;
        this.subjectUniqueId = null;
        this.extensions = null;
        this.rawCertInfo = null;
        try {
            DerValue derValue = new DerValue(byArray);
            this.parse(derValue);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            certificateParsingException.initCause(iOException);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)certificateParsingException);
        }
    }

    public X509CertInfo(DerValue derValue) throws CertificateParsingException {
        this.version = new CertificateVersion();
        this.serialNum = null;
        this.algId = null;
        this.issuer = null;
        this.interval = null;
        this.subject = null;
        this.pubKey = null;
        this.issuerUniqueId = null;
        this.subjectUniqueId = null;
        this.extensions = null;
        this.rawCertInfo = null;
        try {
            this.parse(derValue);
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.toString());
            certificateParsingException.initCause(iOException);
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)certificateParsingException);
        }
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (this.rawCertInfo == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.emit(derOutputStream);
            this.rawCertInfo = derOutputStream.toByteArray();
        }
        outputStream.write((byte[])this.rawCertInfo.clone());
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)VERSION);
        attributeNameEnumeration.addElement((Object)SERIAL_NUMBER);
        attributeNameEnumeration.addElement((Object)ALGORITHM_ID);
        attributeNameEnumeration.addElement((Object)ISSUER);
        attributeNameEnumeration.addElement((Object)VALIDITY);
        attributeNameEnumeration.addElement((Object)SUBJECT);
        attributeNameEnumeration.addElement((Object)KEY);
        attributeNameEnumeration.addElement((Object)ISSUER_ID);
        attributeNameEnumeration.addElement((Object)SUBJECT_ID);
        attributeNameEnumeration.addElement((Object)EXTENSIONS);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public byte[] getEncodedInfo() throws CertificateEncodingException {
        try {
            if (this.rawCertInfo == null) {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.rawCertInfo = derOutputStream.toByteArray();
            }
            return (byte[])this.rawCertInfo.clone();
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException(iOException.toString()));
        }
        catch (CertificateException certificateException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateEncodingException(certificateException.toString()));
        }
    }

    public boolean equals(Object object) {
        if (g.convertForInstanceOf((Object)object, X509CertInfo.class) instanceof X509CertInfo) {
            return this.equals((X509CertInfo)((Object)g.convertForCast((Object)object, X509CertInfo.class)));
        }
        return false;
    }

    public boolean equals(X509CertInfo x509CertInfo) {
        if (!f.ifAcmp((Object)((Object)this), (Object)((Object)x509CertInfo))) {
            return true;
        }
        if (this.rawCertInfo == null || x509CertInfo.rawCertInfo == null) {
            return false;
        }
        if (this.rawCertInfo.length != x509CertInfo.rawCertInfo.length) {
            return false;
        }
        for (int i = 0; i < this.rawCertInfo.length; ++i) {
            if (this.rawCertInfo[i] == x509CertInfo.rawCertInfo[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.rawCertInfo.length; ++i) {
            n += this.rawCertInfo[i] * i;
        }
        return n;
    }

    public String toString() {
        if (((X509CertInfo)((Object)((Object)this))).subject == null || ((X509CertInfo)((Object)((Object)this))).pubKey == null || ((X509CertInfo)((Object)((Object)this))).interval == null || ((X509CertInfo)((Object)((Object)this))).issuer == null || ((X509CertInfo)((Object)((Object)this))).algId == null || ((X509CertInfo)((Object)((Object)this))).serialNum == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException("X.509 cert is incomplete"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        stringBuilder.append("  " + ((X509CertInfo)((Object)((Object)this))).version.toString() + "\n");
        stringBuilder.append("  Subject: " + ((X509CertInfo)((Object)((Object)this))).subject.toString() + "\n");
        stringBuilder.append("  Signature Algorithm: " + ((X509CertInfo)((Object)((Object)this))).algId.toString() + "\n");
        stringBuilder.append("  Key:  " + ((X509CertInfo)((Object)((Object)this))).pubKey.toString() + "\n");
        stringBuilder.append("  " + ((X509CertInfo)((Object)((Object)this))).interval.toString() + "\n");
        stringBuilder.append("  Issuer: " + ((X509CertInfo)((Object)((Object)this))).issuer.toString() + "\n");
        stringBuilder.append("  " + ((X509CertInfo)((Object)((Object)this))).serialNum.toString() + "\n");
        if (((X509CertInfo)((Object)((Object)this))).issuerUniqueId != null) {
            stringBuilder.append("  Issuer Id:\n" + ((X509CertInfo)((Object)((Object)this))).issuerUniqueId.toString() + "\n");
        }
        if (((X509CertInfo)((Object)((Object)this))).subjectUniqueId != null) {
            stringBuilder.append("  Subject Id:\n" + ((X509CertInfo)((Object)((Object)this))).subjectUniqueId.toString() + "\n");
        }
        if (((X509CertInfo)((Object)((Object)this))).extensions != null) {
            h h2;
            Object object;
            Collection<Extension> collection = ((X509CertInfo)((Object)((Object)this))).extensions.getAllExtensions();
            Object[] objectArray = collection.toArray();
            stringBuilder.append("\nCertificate Extensions: " + a.arrayLength((Object[])objectArray));
            for (int i = 0; i < a.arrayLength((Object[])objectArray); ++i) {
                stringBuilder.append("\n[" + (i + 1) + "]: ");
                Extension extension = (Extension)g.convertForCast((Object)a.arrayLoad((Object[])objectArray, (int)i), Extension.class);
                try {
                    if (OIDMap.getClass(extension.getExtensionId()) == null) {
                        stringBuilder.append(extension.toString());
                        object = extension.getExtensionValue();
                        if (object == null) continue;
                        h2 = new DerOutputStream();
                        h2.putOctetString((byte[])object);
                        object = h2.toByteArray();
                        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                        stringBuilder.append("Extension unknown: DER encoded OCTET string =\n" + hexDumpEncoder.encodeBuffer((byte[])object) + "\n");
                        continue;
                    }
                    stringBuilder.append(extension.toString());
                    continue;
                }
                catch (Exception exception) {
                    stringBuilder.append(", Error parsing this extension");
                }
            }
            Map<String, Extension> map = ((X509CertInfo)((Object)((Object)this))).extensions.getUnparseableExtensions();
            if (!map.isEmpty()) {
                stringBuilder.append("\nUnparseable certificate extensions: " + map.size());
                int n = 1;
                object = map.values().iterator();
                while (object.hasNext()) {
                    h2 = (Extension)g.convertForCast((Object)object.next(), Extension.class);
                    stringBuilder.append("\n[" + n++ + "]: ");
                    stringBuilder.append(h2);
                }
            }
        }
        stringBuilder.append("\n]");
        return stringBuilder.toString();
    }

    public void set(String string, Object object) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized: " + string));
        }
        this.rawCertInfo = null;
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 1: {
                if (string2 == null) {
                    this.setVersion(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).version.set(string2, object);
                break;
            }
            case 2: {
                if (string2 == null) {
                    this.setSerialNumber(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).serialNum.set(string2, object);
                break;
            }
            case 3: {
                if (string2 == null) {
                    this.setAlgorithmId(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).algId.set(string2, object);
                break;
            }
            case 4: {
                if (string2 == null) {
                    this.setIssuer(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).issuer.set(string2, object);
                break;
            }
            case 5: {
                if (string2 == null) {
                    this.setValidity(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).interval.set(string2, object);
                break;
            }
            case 6: {
                if (string2 == null) {
                    this.setSubject(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).subject.set(string2, object);
                break;
            }
            case 7: {
                if (string2 == null) {
                    this.setKey(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).pubKey.set(string2, object);
                break;
            }
            case 8: {
                if (string2 == null) {
                    this.setIssuerUniqueId(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).issuerUniqueId.set(string2, object);
                break;
            }
            case 9: {
                if (string2 == null) {
                    this.setSubjectUniqueId(object);
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).subjectUniqueId.set(string2, object);
                break;
            }
            case 10: {
                if (string2 == null) {
                    this.setExtensions(object);
                    break;
                }
                if (((X509CertInfo)((Object)((Object)this))).extensions == null) {
                    ((X509CertInfo)((Object)((Object)this))).extensions = new CertificateExtensions();
                }
                ((X509CertInfo)((Object)((Object)this))).extensions.set(string2, object);
            }
        }
    }

    public void delete(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Attribute name not recognized: " + string));
        }
        this.rawCertInfo = null;
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 1: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).version = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).version.delete(string2);
                break;
            }
            case 2: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).serialNum = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).serialNum.delete(string2);
                break;
            }
            case 3: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).algId = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).algId.delete(string2);
                break;
            }
            case 4: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).issuer = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).issuer.delete(string2);
                break;
            }
            case 5: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).interval = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).interval.delete(string2);
                break;
            }
            case 6: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).subject = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).subject.delete(string2);
                break;
            }
            case 7: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).pubKey = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).pubKey.delete(string2);
                break;
            }
            case 8: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).issuerUniqueId = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).issuerUniqueId.delete(string2);
                break;
            }
            case 9: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).subjectUniqueId = null;
                    break;
                }
                ((X509CertInfo)((Object)((Object)this))).subjectUniqueId.delete(string2);
                break;
            }
            case 10: {
                if (string2 == null) {
                    ((X509CertInfo)((Object)((Object)this))).extensions = null;
                    break;
                }
                if (((X509CertInfo)((Object)((Object)this))).extensions == null) break;
                ((X509CertInfo)((Object)((Object)this))).extensions.delete(string2);
            }
        }
    }

    public Object get(String string) throws CertificateException, IOException {
        X509AttributeName x509AttributeName = new X509AttributeName(string);
        int n = this.attributeMap(x509AttributeName.getPrefix());
        if (n == 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Attribute name not recognized: " + string));
        }
        String string2 = x509AttributeName.getSuffix();
        switch (n) {
            case 10: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).extensions;
                }
                if (((X509CertInfo)((Object)((Object)this))).extensions == null) {
                    return null;
                }
                return ((X509CertInfo)((Object)((Object)this))).extensions.get(string2);
            }
            case 6: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).subject;
                }
                return ((X509CertInfo)((Object)((Object)this))).subject.get(string2);
            }
            case 4: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).issuer;
                }
                return ((X509CertInfo)((Object)((Object)this))).issuer.get(string2);
            }
            case 7: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).pubKey;
                }
                return ((X509CertInfo)((Object)((Object)this))).pubKey.get(string2);
            }
            case 3: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).algId;
                }
                return ((X509CertInfo)((Object)((Object)this))).algId.get(string2);
            }
            case 5: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).interval;
                }
                return ((X509CertInfo)((Object)((Object)this))).interval.get(string2);
            }
            case 1: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).version;
                }
                return ((X509CertInfo)((Object)((Object)this))).version.get(string2);
            }
            case 2: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).serialNum;
                }
                return ((X509CertInfo)((Object)((Object)this))).serialNum.get(string2);
            }
            case 8: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).issuerUniqueId;
                }
                if (((X509CertInfo)((Object)((Object)this))).issuerUniqueId == null) {
                    return null;
                }
                return ((X509CertInfo)((Object)((Object)this))).issuerUniqueId.get(string2);
            }
            case 9: {
                if (string2 == null) {
                    return ((X509CertInfo)((Object)((Object)this))).subjectUniqueId;
                }
                if (((X509CertInfo)((Object)((Object)this))).subjectUniqueId == null) {
                    return null;
                }
                return ((X509CertInfo)((Object)((Object)this))).subjectUniqueId.get(string2);
            }
        }
        return null;
    }

    private void parse(DerValue derValue) throws CertificateParsingException, IOException {
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("signed fields invalid"));
        }
        this.rawCertInfo = derValue.toByteArray();
        DerInputStream derInputStream = DerValue._jr$ig$data((Object)derValue);
        DerValue derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)0)) {
            ((X509CertInfo)((Object)((Object)this))).version = new CertificateVersion(derValue2);
            derValue2 = derInputStream.getDerValue();
        }
        ((X509CertInfo)((Object)((Object)this))).serialNum = new CertificateSerialNumber(derValue2);
        ((X509CertInfo)((Object)((Object)this))).algId = new CertificateAlgorithmId(derInputStream);
        ((X509CertInfo)((Object)((Object)this))).issuer = new CertificateIssuerName(derInputStream);
        X500Name x500Name = (X500Name)g.convertForCast((Object)((X509CertInfo)((Object)((Object)this))).issuer.get("dname"), X500Name.class);
        if (x500Name.isEmpty()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Empty issuer DN not allowed in X509Certificates"));
        }
        ((X509CertInfo)((Object)((Object)this))).interval = new CertificateValidity(derInputStream);
        ((X509CertInfo)((Object)((Object)this))).subject = new CertificateSubjectName(derInputStream);
        X500Name x500Name2 = (X500Name)g.convertForCast((Object)((X509CertInfo)((Object)((Object)this))).subject.get("dname"), X500Name.class);
        if (((X509CertInfo)((Object)((Object)this))).version.compare(0) == 0 && x500Name2.isEmpty()) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Empty subject DN not allowed in v1 certificate"));
        }
        ((X509CertInfo)((Object)((Object)this))).pubKey = new CertificateX509Key(derInputStream);
        if (derInputStream.available() != 0) {
            if (((X509CertInfo)((Object)((Object)this))).version.compare(0) == 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("no more data allowed for version 1 certificate"));
            }
        } else {
            return;
        }
        derValue2 = derInputStream.getDerValue();
        if (derValue2.isContextSpecific((byte)1)) {
            ((X509CertInfo)((Object)((Object)this))).issuerUniqueId = new CertificateIssuerUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (derValue2.isContextSpecific((byte)2)) {
            ((X509CertInfo)((Object)((Object)this))).subjectUniqueId = new CertificateSubjectUniqueIdentity(derValue2);
            if (derInputStream.available() == 0) {
                return;
            }
            derValue2 = derInputStream.getDerValue();
        }
        if (((X509CertInfo)((Object)((Object)this))).version.compare(2) != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Extensions not allowed in v2 certificate"));
        }
        if (derValue2.isConstructed() && derValue2.isContextSpecific((byte)3)) {
            ((X509CertInfo)((Object)((Object)this))).extensions = new CertificateExtensions(DerValue._jr$ig$data((Object)derValue2));
        }
        this.verifyCert(((X509CertInfo)((Object)((Object)this))).subject, ((X509CertInfo)((Object)((Object)this))).extensions);
    }

    private void verifyCert(CertificateSubjectName certificateSubjectName, CertificateExtensions certificateExtensions) throws CertificateParsingException, IOException {
        X500Name x500Name = (X500Name)g.convertForCast((Object)certificateSubjectName.get("dname"), X500Name.class);
        if (x500Name.isEmpty()) {
            if (certificateExtensions == null) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and certificate has no extensions"));
            }
            SubjectAlternativeNameExtension subjectAlternativeNameExtension = null;
            Object var5_5 = null;
            GeneralNames generalNames = null;
            try {
                subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)g.convertForCast((Object)certificateExtensions.get("SubjectAlternativeName"), SubjectAlternativeNameExtension.class);
                generalNames = (GeneralNames)((Object)g.convertForCast((Object)subjectAlternativeNameExtension.get("subject_name"), GeneralNames.class));
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is absent"));
            }
            if (generalNames == null || generalNames.isEmpty()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("X.509 Certificate is incomplete: subject field is empty, and SubjectAlternativeName extension is empty"));
            }
            if (!subjectAlternativeNameExtension.isCritical()) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("X.509 Certificate is incomplete: SubjectAlternativeName extension MUST be marked critical when subject field is empty"));
            }
        }
    }

    private void emit(DerOutputStream derOutputStream) throws CertificateException, IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        ((X509CertInfo)((Object)((Object)this))).version.encode(derOutputStream2);
        ((X509CertInfo)((Object)((Object)this))).serialNum.encode(derOutputStream2);
        ((X509CertInfo)((Object)((Object)this))).algId.encode(derOutputStream2);
        if (((X509CertInfo)((Object)((Object)this))).version.compare(0) == 0 && ((X509CertInfo)((Object)((Object)this))).issuer.toString() == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Null issuer DN not allowed in v1 certificate"));
        }
        ((X509CertInfo)((Object)((Object)this))).issuer.encode(derOutputStream2);
        ((X509CertInfo)((Object)((Object)this))).interval.encode(derOutputStream2);
        if (((X509CertInfo)((Object)((Object)this))).version.compare(0) == 0 && ((X509CertInfo)((Object)((Object)this))).subject.toString() == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateParsingException("Null subject DN not allowed in v1 certificate"));
        }
        ((X509CertInfo)((Object)((Object)this))).subject.encode(derOutputStream2);
        ((X509CertInfo)((Object)((Object)this))).pubKey.encode(derOutputStream2);
        if (((X509CertInfo)((Object)((Object)this))).issuerUniqueId != null) {
            ((X509CertInfo)((Object)((Object)this))).issuerUniqueId.encode((OutputStream)derOutputStream2);
        }
        if (((X509CertInfo)((Object)((Object)this))).subjectUniqueId != null) {
            ((X509CertInfo)((Object)((Object)this))).subjectUniqueId.encode((OutputStream)derOutputStream2);
        }
        if (((X509CertInfo)((Object)((Object)this))).extensions != null) {
            ((X509CertInfo)((Object)((Object)this))).extensions.encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    private int attributeMap(String string) {
        Integer n = (Integer)g.convertForCast((Object)map.get(string), Integer.class);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private void setVersion(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateVersion.class) instanceof CertificateVersion)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Version class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).version = (CertificateVersion)((Object)g.convertForCast((Object)object, CertificateVersion.class));
    }

    private void setSerialNumber(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateSerialNumber.class) instanceof CertificateSerialNumber)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("SerialNumber class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).serialNum = (CertificateSerialNumber)((Object)g.convertForCast((Object)object, CertificateSerialNumber.class));
    }

    private void setAlgorithmId(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateAlgorithmId.class) instanceof CertificateAlgorithmId)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("AlgorithmId class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).algId = (CertificateAlgorithmId)((Object)g.convertForCast((Object)object, CertificateAlgorithmId.class));
    }

    private void setIssuer(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateIssuerName.class) instanceof CertificateIssuerName)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Issuer class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).issuer = (CertificateIssuerName)((Object)g.convertForCast((Object)object, CertificateIssuerName.class));
    }

    private void setValidity(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateValidity.class) instanceof CertificateValidity)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("CertificateValidity class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).interval = (CertificateValidity)((Object)g.convertForCast((Object)object, CertificateValidity.class));
    }

    private void setSubject(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateSubjectName.class) instanceof CertificateSubjectName)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Subject class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).subject = (CertificateSubjectName)((Object)g.convertForCast((Object)object, CertificateSubjectName.class));
    }

    private void setKey(Object object) throws CertificateException {
        if (!(g.convertForInstanceOf((Object)object, CertificateX509Key.class) instanceof CertificateX509Key)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Key class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).pubKey = (CertificateX509Key)((Object)g.convertForCast((Object)object, CertificateX509Key.class));
    }

    private void setIssuerUniqueId(Object object) throws CertificateException {
        if (((X509CertInfo)((Object)((Object)this))).version.compare(1) < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Invalid version"));
        }
        if (!(g.convertForInstanceOf((Object)object, CertificateIssuerUniqueIdentity.class) instanceof CertificateIssuerUniqueIdentity)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("IssuerUniqueId class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).issuerUniqueId = (CertificateIssuerUniqueIdentity)g.convertForCast((Object)object, CertificateIssuerUniqueIdentity.class);
    }

    private void setSubjectUniqueId(Object object) throws CertificateException {
        if (((X509CertInfo)((Object)((Object)this))).version.compare(1) < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Invalid version"));
        }
        if (!(g.convertForInstanceOf((Object)object, CertificateSubjectUniqueIdentity.class) instanceof CertificateSubjectUniqueIdentity)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("SubjectUniqueId class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).subjectUniqueId = (CertificateSubjectUniqueIdentity)g.convertForCast((Object)object, CertificateSubjectUniqueIdentity.class);
    }

    private void setExtensions(Object object) throws CertificateException {
        if (((X509CertInfo)((Object)((Object)this))).version.compare(2) < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Invalid version"));
        }
        if (!(g.convertForInstanceOf((Object)object, CertificateExtensions.class) instanceof CertificateExtensions)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new CertificateException("Extensions class type invalid."));
        }
        ((X509CertInfo)((Object)((Object)this))).extensions = (CertificateExtensions)((Object)g.convertForCast((Object)object, CertificateExtensions.class));
    }

    static {
        map.put(VERSION, 1);
        map.put(SERIAL_NUMBER, 2);
        map.put(ALGORITHM_ID, 3);
        map.put(ISSUER, 4);
        map.put(VALIDITY, 5);
        map.put(SUBJECT, 6);
        map.put(KEY, 7);
        map.put(ISSUER_ID, 8);
        map.put(SUBJECT_ID, 9);
        map.put(EXTENSIONS, 10);
    }

    protected /* synthetic */ X509CertInfo(h h2) {
        super(h2);
    }
}

