/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import com.zeroturnaround.jrebelbase.facade.ai;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class X509Key
extends h
implements PublicKey {
    private static final long serialVersionUID = -5359250853002055002L;
    protected AlgorithmId algid;
    @Deprecated
    protected byte[] key;
    private int unusedBits;
    private BitArray bitStringKey;
    protected byte[] encodedKey;

    public X509Key() {
        this.key = null;
        this.unusedBits = 0;
        this.bitStringKey = null;
    }

    private X509Key(AlgorithmId algorithmId, BitArray bitArray) throws InvalidKeyException {
        this.key = null;
        this.unusedBits = 0;
        this.bitStringKey = null;
        this.algid = algorithmId;
        this.setKey(bitArray);
        this.encode();
    }

    protected void setKey(BitArray bitArray) {
        this.bitStringKey = (BitArray)((Object)g.convertForCast((Object)bitArray.clone(), BitArray.class));
        ((X509Key)this).key = bitArray.toByteArray();
        int n = bitArray.length() % 8;
        this.unusedBits = n == 0 ? 0 : 8 - n;
    }

    protected BitArray getKey() {
        this.bitStringKey = new BitArray(((X509Key)this).key.length * 8 - this.unusedBits, ((X509Key)this).key);
        return (BitArray)((Object)g.convertForCast((Object)this.bitStringKey.clone(), BitArray.class));
    }

    public static PublicKey parse(DerValue derValue) throws IOException {
        PublicKey publicKey;
        if (DerValue._jr$ig$tag((Object)derValue) != 48) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("corrupt subject key"));
        }
        AlgorithmId algorithmId = AlgorithmId.parse(DerValue._jr$ig$data((Object)derValue).getDerValue());
        try {
            publicKey = X509Key.buildX509Key(algorithmId, DerValue._jr$ig$data((Object)derValue).getUnalignedBitString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("subject key, " + invalidKeyException.getMessage(), invalidKeyException));
        }
        if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("excess subject key"));
        }
        return publicKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static PublicKey buildX509Key(AlgorithmId algorithmId, BitArray bitArray) throws IOException, InvalidKeyException {
        DerOutputStream derOutputStream = new DerOutputStream();
        X509Key.encode(derOutputStream, algorithmId, bitArray);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(derOutputStream.toByteArray());
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithmId.getName());
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException(invalidKeySpecException.getMessage(), invalidKeySpecException));
        }
        String string = "";
        try {
            h h2;
            Class<?> clazz;
            block13: {
                Provider provider = Security.getProvider("SUN");
                if (provider == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InstantiationException());
                }
                string = provider.getProperty("PublicKey.X.509." + algorithmId.getName());
                if (string == null) {
                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InstantiationException());
                }
                clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    h2 = ClassLoader.getSystemClassLoader();
                    if (h2 == null) break block13;
                    clazz = h2.loadClass(string);
                }
            }
            Object var9_11 = null;
            if (clazz != null) {
                var9_11 = ai.getCurrentClass(clazz).newInstance();
            }
            if (g.convertForInstanceOf(var9_11, X509Key.class) instanceof X509Key) {
                h2 = (X509Key)g.convertForCast(var9_11, X509Key.class);
                ((X509Key)h2).algid = algorithmId;
                h2.setKey(bitArray);
                h2.parseKeyBits();
                return h2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException(string + " [internal error]"));
        }
        X509Key x509Key = new X509Key(algorithmId, bitArray);
        return x509Key;
    }

    @Override
    public String getAlgorithm() {
        return ((X509Key)this).algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return ((X509Key)this).algid;
    }

    public final void encode(DerOutputStream derOutputStream) throws IOException {
        X509Key.encode(derOutputStream, ((X509Key)this).algid, this.getKey());
    }

    @Override
    public byte[] getEncoded() {
        try {
            return (byte[])this.getEncodedInternal().clone();
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    public byte[] getEncodedInternal() throws InvalidKeyException {
        byte[] byArray = ((X509Key)this).encodedKey;
        if (byArray == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.encode(derOutputStream);
                byArray = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("IOException : " + iOException.getMessage()));
            }
            ((X509Key)this).encodedKey = byArray;
        }
        return byArray;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public byte[] encode() throws InvalidKeyException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + ((X509Key)this).algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(((X509Key)this).key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (DerValue._jr$ig$tag((Object)derValue) != 48) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("invalid key format"));
            }
            ((X509Key)this).algid = AlgorithmId.parse(DerValue._jr$ig$data((Object)derValue).getDerValue());
            this.setKey(DerValue._jr$ig$data((Object)derValue).getUnalignedBitString());
            this.parseKeyBits();
            if (DerValue._jr$ig$data((Object)derValue).available() != 0) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("excess key data"));
            }
        }
        catch (IOException iOException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InvalidKeyException("IOException: " + iOException.getMessage()));
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("deserialized key is invalid: " + invalidKeyException.getMessage()));
        }
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, Key.class) instanceof Key)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncodedInternal();
            byte[] byArray2 = g.convertForInstanceOf((Object)object, X509Key.class) instanceof X509Key ? ((X509Key)g.convertForCast((Object)object, X509Key.class)).getEncodedInternal() : ((Key)g.convertForCast((Object)object, Key.class)).getEncoded();
            return Arrays.equals(byArray, byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            byte[] byArray = this.getEncodedInternal();
            int n = byArray.length;
            for (int i = 0; i < byArray.length; ++i) {
                n += (byArray[i] & 0xFF) * 37;
            }
            return n;
        }
        catch (InvalidKeyException invalidKeyException) {
            return 0;
        }
    }

    static void encode(DerOutputStream derOutputStream, AlgorithmId algorithmId, BitArray bitArray) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        algorithmId.encode(derOutputStream2);
        derOutputStream2.putUnalignedBitString(bitArray);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    protected /* synthetic */ X509Key(h h2) {
        super(h2);
    }
}

