/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.text.CharacterIterator;
import java.text.Normalizer;
import sun.text.normalizer.NormalizerBase;
import sun.text.normalizer.NormalizerImpl;
import sun.text.normalizer.UCharacterIterator;
import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.UnicodeSet;
import sun.text.normalizer.Utility;

public final class NormalizerBase
extends h
implements Cloneable {
    private char[] buffer = new char[100];
    private int bufferStart = 0;
    private int bufferPos = 0;
    private int bufferLimit = 0;
    private UCharacterIterator text;
    private Mode mode = NFC;
    private int options = 0;
    private int currentIndex;
    private int nextIndex;
    public static final int UNICODE_3_2 = 32;
    public static final int DONE = -1;
    public static final Mode NONE = new Mode(1);
    public static final Mode NFD = new NFDMode(2);
    public static final Mode NFKD = new NFKDMode(3);
    public static final Mode NFC = new NFCMode(4);
    public static final Mode NFKC = new NFKCMode(5);
    public static final QuickCheckResult NO = new QuickCheckResult(0);
    public static final QuickCheckResult YES = new QuickCheckResult(1);
    public static final QuickCheckResult MAYBE = new QuickCheckResult(2);
    private static final int MAX_BUF_SIZE_COMPOSE = 2;
    private static final int MAX_BUF_SIZE_DECOMPOSE = 3;
    public static final int UNICODE_3_2_0_ORIGINAL = 262432;
    public static final int UNICODE_LATEST = 0;

    public NormalizerBase(String string, Mode mode, int n2) {
        this.text = UCharacterIterator.getInstance((String)string);
        this.mode = mode;
        this.options = n2;
    }

    public NormalizerBase(CharacterIterator characterIterator, Mode mode) {
        this(characterIterator, mode, 0);
    }

    public NormalizerBase(CharacterIterator characterIterator, Mode mode, int n2) {
        this.text = UCharacterIterator.getInstance((CharacterIterator)((CharacterIterator)g.convertForCast((Object)characterIterator.clone(), CharacterIterator.class)));
        this.mode = mode;
        this.options = n2;
    }

    public Object clone() {
        try {
            NormalizerBase normalizerBase = (NormalizerBase)super.clone();
            normalizerBase.text = (UCharacterIterator)g.convertForCast((Object)this.text.clone(), UCharacterIterator.class);
            if (this.buffer != null) {
                normalizerBase.buffer = new char[this.buffer.length];
                a.arraycopy((Object)this.buffer, (int)0, (Object)normalizerBase.buffer, (int)0, (int)this.buffer.length);
            }
            return normalizerBase;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError(cloneNotSupportedException.toString()));
        }
    }

    public static String compose(String string, boolean bl, int n2) {
        char[] cArray;
        char[] cArray2;
        if (n2 == 262432) {
            String string2 = NormalizerImpl.convert((String)string);
            cArray2 = new char[string2.length() * 2];
            cArray = string2.toCharArray();
        } else {
            cArray2 = new char[string.length() * 2];
            cArray = string.toCharArray();
        }
        int n3 = 0;
        UnicodeSet unicodeSet = NormalizerImpl.getNX((int)n2);
        n2 &= 0xFFFFCF00;
        if (bl) {
            n2 |= 0x1000;
        }
        while ((n3 = NormalizerImpl.compose((char[])cArray, (int)0, (int)cArray.length, (char[])cArray2, (int)0, (int)cArray2.length, (int)n2, (UnicodeSet)unicodeSet)) > cArray2.length) {
            cArray2 = new char[n3];
        }
        return new String(cArray2, 0, n3);
    }

    public static String decompose(String string, boolean bl) {
        return NormalizerBase.decompose(string, bl, 0);
    }

    public static String decompose(String string, boolean bl, int n2) {
        int[] nArray = new int[1];
        int n3 = 0;
        UnicodeSet unicodeSet = NormalizerImpl.getNX((int)n2);
        if (n2 == 262432) {
            String string2 = NormalizerImpl.convert((String)string);
            char[] cArray = new char[string2.length() * 3];
            while (true) {
                if ((n3 = NormalizerImpl.decompose((char[])string2.toCharArray(), (int)0, (int)string2.length(), (char[])cArray, (int)0, (int)cArray.length, (boolean)bl, (int[])nArray, (UnicodeSet)unicodeSet)) <= cArray.length) {
                    return new String(cArray, 0, n3);
                }
                cArray = new char[n3];
            }
        }
        char[] cArray = new char[string.length() * 3];
        while ((n3 = NormalizerImpl.decompose((char[])string.toCharArray(), (int)0, (int)string.length(), (char[])cArray, (int)0, (int)cArray.length, (boolean)bl, (int[])nArray, (UnicodeSet)unicodeSet)) > cArray.length) {
            cArray = new char[n3];
        }
        return new String(cArray, 0, n3);
    }

    public static int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, Mode mode, int n6) {
        int n7 = mode.normalize(cArray, n2, n3, cArray2, n4, n5, n6);
        if (n7 <= n5 - n4) {
            return n7;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IndexOutOfBoundsException(Integer.toString(n7)));
    }

    public int current() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            return this.getCodePointAt(this.bufferPos);
        }
        return -1;
    }

    public int next() {
        if (this.bufferPos < this.bufferLimit || this.nextNormalize()) {
            int n2 = this.getCodePointAt(this.bufferPos);
            this.bufferPos += n2 > 65535 ? 2 : 1;
            return n2;
        }
        return -1;
    }

    public int previous() {
        if (this.bufferPos > 0 || this.previousNormalize()) {
            int n2 = this.getCodePointAt(this.bufferPos - 1);
            this.bufferPos -= n2 > 65535 ? 2 : 1;
            return n2;
        }
        return -1;
    }

    public void reset() {
        this.text.setIndex(0);
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    public void setIndexOnly(int n2) {
        this.text.setIndex(n2);
        this.currentIndex = this.nextIndex = n2;
        this.clearBuffer();
    }

    public int setIndex(int n2) {
        this.setIndexOnly(n2);
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.endIndex();
    }

    public int getIndex() {
        if (this.bufferPos < this.bufferLimit) {
            return this.currentIndex;
        }
        return this.nextIndex;
    }

    public int endIndex() {
        return this.text.getLength();
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setText(String string) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance((String)string);
        if (uCharacterIterator == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Could not create a new UCharacterIterator"));
        }
        this.text = uCharacterIterator;
        this.reset();
    }

    public void setText(CharacterIterator characterIterator) {
        UCharacterIterator uCharacterIterator = UCharacterIterator.getInstance((CharacterIterator)characterIterator);
        if (uCharacterIterator == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new InternalError("Could not create a new UCharacterIterator"));
        }
        this.text = uCharacterIterator;
        this.nextIndex = 0;
        this.currentIndex = 0;
        this.clearBuffer();
    }

    private static long getPrevNorm32(UCharacterIterator uCharacterIterator, int n2, int n3, char[] cArray) {
        int n4 = 0;
        n4 = uCharacterIterator.previous();
        if (n4 == -1) {
            return 0L;
        }
        cArray[0] = (char)n4;
        cArray[1] = '\u0000';
        if (cArray[0] < n2) {
            return 0L;
        }
        if (!UTF16.isSurrogate((char)cArray[0])) {
            return NormalizerImpl.getNorm32((char)cArray[0]);
        }
        if (UTF16.isLeadSurrogate((char)cArray[0]) || uCharacterIterator.getIndex() == 0) {
            cArray[1] = (char)uCharacterIterator.current();
            return 0L;
        }
        cArray[1] = (char)uCharacterIterator.previous();
        if (UTF16.isLeadSurrogate((char)cArray[1])) {
            long l2 = NormalizerImpl.getNorm32((char)cArray[1]);
            if ((l2 & (long)n3) == 0L) {
                return 0L;
            }
            return NormalizerImpl.getNorm32FromSurrogatePair((long)l2, (char)cArray[0]);
        }
        uCharacterIterator.moveIndex(1);
        return 0L;
    }

    private static int findPreviousIterationBoundary(UCharacterIterator uCharacterIterator, IsPrevBoundary isPrevBoundary, int n2, int n3, char[] cArray, int[] nArray) {
        char[] cArray2 = new char[2];
        nArray[0] = cArray.length;
        cArray2[0] = '\u0000';
        while (uCharacterIterator.getIndex() > 0 && cArray2[0] != '\uffffffff') {
            boolean bl = isPrevBoundary.isPrevBoundary(uCharacterIterator, n2, n3, cArray2);
            if (nArray[0] < (cArray2[1] == '\u0000' ? 1 : 2)) {
                char[] cArray3 = new char[cArray.length * 2];
                a.arraycopy((Object)cArray, (int)nArray[0], (Object)cArray3, (int)(cArray3.length - (cArray.length - nArray[0])), (int)(cArray.length - nArray[0]));
                nArray[0] = nArray[0] + (cArray3.length - cArray.length);
                cArray = cArray3;
                cArray3 = null;
            }
            nArray[0] = nArray[0] - 1;
            cArray[nArray[0]] = cArray2[0];
            if (cArray2[1] != '\u0000') {
                nArray[0] = nArray[0] - 1;
                cArray[nArray[0]] = cArray2[1];
            }
            if (!bl) continue;
            break;
        }
        return cArray.length - nArray[0];
    }

    private static int previous(UCharacterIterator uCharacterIterator, char[] cArray, int n2, int n3, Mode mode, boolean bl, boolean[] blArray, int n4) {
        int n5 = n3 - n2;
        int n6 = 0;
        if (blArray != null) {
            blArray[0] = false;
        }
        char c2 = (char)mode.getMinC();
        int n7 = mode.getMask();
        IsPrevBoundary isPrevBoundary = mode.getPrevBoundary();
        if (isPrevBoundary == null) {
            n6 = 0;
            int n8 = uCharacterIterator.previous();
            if (n8 >= 0) {
                int n9;
                n6 = 1;
                if (UTF16.isTrailSurrogate((char)((char)n8)) && (n9 = uCharacterIterator.previous()) != -1) {
                    if (UTF16.isLeadSurrogate((char)((char)n9))) {
                        if (n5 >= 2) {
                            cArray[1] = (char)n8;
                            n6 = 2;
                        }
                        n8 = n9;
                    } else {
                        uCharacterIterator.moveIndex(1);
                    }
                }
                if (n5 > 0) {
                    cArray[0] = (char)n8;
                }
            }
            return n6;
        }
        char[] cArray2 = new char[100];
        int[] nArray = new int[1];
        int n10 = NormalizerBase.findPreviousIterationBoundary(uCharacterIterator, isPrevBoundary, c2, n7, cArray2, nArray);
        if (n10 > 0) {
            if (bl) {
                n6 = NormalizerBase.normalize(cArray2, nArray[0], nArray[0] + n10, cArray, n2, n3, mode, n4);
                if (blArray != null) {
                    blArray[0] = n6 != n10 || Utility.arrayRegionMatches((char[])cArray2, (int)0, (char[])cArray, (int)n2, (int)n3);
                }
            } else if (n5 > 0) {
                a.arraycopy((Object)cArray2, (int)nArray[0], (Object)cArray, (int)0, (int)(n10 < n5 ? n10 : n5));
            }
        }
        return n6;
    }

    private static long getNextNorm32(UCharacterIterator uCharacterIterator, int n2, int n3, int[] nArray) {
        nArray[0] = uCharacterIterator.next();
        nArray[1] = 0;
        if (nArray[0] < n2) {
            return 0L;
        }
        long l2 = NormalizerImpl.getNorm32((char)((char)nArray[0]));
        if (UTF16.isLeadSurrogate((char)((char)nArray[0]))) {
            if (uCharacterIterator.current() != -1 && UTF16.isTrailSurrogate((char)((char)(nArray[1] = uCharacterIterator.current())))) {
                uCharacterIterator.moveIndex(1);
                if ((l2 & (long)n3) == 0L) {
                    return 0L;
                }
                return NormalizerImpl.getNorm32FromSurrogatePair((long)l2, (char)((char)nArray[1]));
            }
            return 0L;
        }
        return l2;
    }

    private static int findNextIterationBoundary(UCharacterIterator uCharacterIterator, IsNextBoundary isNextBoundary, int n2, int n3, char[] cArray) {
        if (uCharacterIterator.current() == -1) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = uCharacterIterator.next();
        cArray[0] = (char)nArray[0];
        int n4 = 1;
        if (UTF16.isLeadSurrogate((char)((char)nArray[0])) && uCharacterIterator.current() != -1) {
            nArray[1] = uCharacterIterator.next();
            if (UTF16.isTrailSurrogate((char)((char)nArray[1]))) {
                cArray[n4++] = (char)nArray[1];
            } else {
                uCharacterIterator.moveIndex(-1);
            }
        }
        while (uCharacterIterator.current() != -1) {
            if (isNextBoundary.isNextBoundary(uCharacterIterator, n2, n3, nArray)) {
                uCharacterIterator.moveIndex(nArray[1] == 0 ? -1 : -2);
                break;
            }
            if (n4 + (nArray[1] == 0 ? 1 : 2) <= cArray.length) {
                cArray[n4++] = (char)nArray[0];
                if (nArray[1] == 0) continue;
                cArray[n4++] = (char)nArray[1];
                continue;
            }
            char[] cArray2 = new char[cArray.length * 2];
            a.arraycopy((Object)cArray, (int)0, (Object)cArray2, (int)0, (int)n4);
            cArray = cArray2;
            cArray[n4++] = (char)nArray[0];
            if (nArray[1] == 0) continue;
            cArray[n4++] = (char)nArray[1];
        }
        return n4;
    }

    private static int next(UCharacterIterator uCharacterIterator, char[] cArray, int n2, int n3, Mode mode, boolean bl, boolean[] blArray, int n4) {
        int n5 = n3 - n2;
        int n6 = 0;
        if (blArray != null) {
            blArray[0] = false;
        }
        char c2 = (char)mode.getMinC();
        int n7 = mode.getMask();
        IsNextBoundary isNextBoundary = mode.getNextBoundary();
        if (isNextBoundary == null) {
            n6 = 0;
            int n8 = uCharacterIterator.next();
            if (n8 != -1) {
                int n9;
                n6 = 1;
                if (UTF16.isLeadSurrogate((char)((char)n8)) && (n9 = uCharacterIterator.next()) != -1) {
                    if (UTF16.isTrailSurrogate((char)((char)n9))) {
                        if (n5 >= 2) {
                            cArray[1] = (char)n9;
                            n6 = 2;
                        }
                    } else {
                        uCharacterIterator.moveIndex(-1);
                    }
                }
                if (n5 > 0) {
                    cArray[0] = (char)n8;
                }
            }
            return n6;
        }
        char[] cArray2 = new char[100];
        int[] nArray = new int[1];
        int n10 = NormalizerBase.findNextIterationBoundary(uCharacterIterator, isNextBoundary, c2, n7, cArray2);
        if (n10 > 0) {
            if (bl) {
                n6 = mode.normalize(cArray2, nArray[0], n10, cArray, n2, n3, n4);
                if (blArray != null) {
                    blArray[0] = n6 != n10 || Utility.arrayRegionMatches((char[])cArray2, (int)nArray[0], (char[])cArray, (int)n2, (int)n6);
                }
            } else if (n5 > 0) {
                a.arraycopy((Object)cArray2, (int)0, (Object)cArray, (int)n2, (int)Math.min(n10, n5));
            }
        }
        return n6;
    }

    private void clearBuffer() {
        this.bufferPos = 0;
        this.bufferStart = 0;
        this.bufferLimit = 0;
    }

    private boolean nextNormalize() {
        this.clearBuffer();
        this.currentIndex = this.nextIndex;
        this.text.setIndex(this.nextIndex);
        this.bufferLimit = NormalizerBase.next(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.nextIndex = this.text.getIndex();
        return this.bufferLimit > 0;
    }

    private boolean previousNormalize() {
        this.clearBuffer();
        this.nextIndex = this.currentIndex;
        this.text.setIndex(this.currentIndex);
        this.bufferLimit = NormalizerBase.previous(this.text, this.buffer, this.bufferStart, this.buffer.length, this.mode, true, null, this.options);
        this.currentIndex = this.text.getIndex();
        this.bufferPos = this.bufferLimit;
        return this.bufferLimit > 0;
    }

    private int getCodePointAt(int n2) {
        if (UTF16.isSurrogate((char)this.buffer[n2])) {
            if (UTF16.isLeadSurrogate((char)this.buffer[n2])) {
                if (n2 + 1 < this.bufferLimit && UTF16.isTrailSurrogate((char)this.buffer[n2 + 1])) {
                    return UCharacterProperty.getRawSupplementary((char)this.buffer[n2], (char)this.buffer[n2 + 1]);
                }
            } else if (UTF16.isTrailSurrogate((char)this.buffer[n2]) && n2 > 0 && UTF16.isLeadSurrogate((char)this.buffer[n2 - 1])) {
                return UCharacterProperty.getRawSupplementary((char)this.buffer[n2 - 1], (char)this.buffer[n2]);
            }
        }
        return this.buffer[n2];
    }

    public static boolean isNFSkippable(int n2, Mode mode) {
        return mode.isNFSkippable(n2);
    }

    public NormalizerBase(String string, Mode mode) {
        this(string, mode, 0);
    }

    public static String normalize(String string, Normalizer.Form form) {
        return NormalizerBase.normalize(string, form, 0);
    }

    public static String normalize(String string, Normalizer.Form form, int n2) {
        int n3 = string.length();
        boolean bl = true;
        if (n3 < 80) {
            for (int i = 0; i < n3; ++i) {
                if (string.charAt(i) <= '\u007f') continue;
                bl = false;
                break;
            }
        } else {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < n3; ++i) {
                if (cArray[i] <= '\u007f') continue;
                bl = false;
                break;
            }
        }
        switch (1.$SwitchMap$java$text$Normalizer$Form[form.ordinal() + 1]) {
            case 1: {
                return bl ? string : NFC.normalize(string, n2);
            }
            case 2: {
                return bl ? string : NFD.normalize(string, n2);
            }
            case 3: {
                return bl ? string : NFKC.normalize(string, n2);
            }
            case 4: {
                return bl ? string : NFKD.normalize(string, n2);
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unexpected normalization form: " + (Object)((Object)form)));
    }

    public static boolean isNormalized(String string, Normalizer.Form form) {
        return NormalizerBase.isNormalized(string, form, 0);
    }

    public static boolean isNormalized(String string, Normalizer.Form form, int n2) {
        switch (1.$SwitchMap$java$text$Normalizer$Form[form.ordinal() + 1]) {
            case 1: {
                return !f.ifAcmp((Object)((Object)NFC.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX((int)n2))), (Object)((Object)YES));
            }
            case 2: {
                return !f.ifAcmp((Object)((Object)NFD.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX((int)n2))), (Object)((Object)YES));
            }
            case 3: {
                return !f.ifAcmp((Object)((Object)NFKC.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX((int)n2))), (Object)((Object)YES));
            }
            case 4: {
                return !f.ifAcmp((Object)((Object)NFKD.quickCheck(string.toCharArray(), 0, string.length(), false, NormalizerImpl.getNX((int)n2))), (Object)((Object)YES));
            }
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("Unexpected normalization form: " + (Object)((Object)form)));
    }

    private static /* synthetic */ char[] _jr$ig$buffer(NormalizerBase normalizerBase) {
        return normalizerBase.buffer;
    }

    private static /* synthetic */ void _jr$ip$buffer(NormalizerBase normalizerBase, char[] cArray) {
        normalizerBase.buffer = cArray;
    }

    private static /* synthetic */ int _jr$ig$bufferStart(NormalizerBase normalizerBase) {
        return normalizerBase.bufferStart;
    }

    private static /* synthetic */ void _jr$ip$bufferStart(NormalizerBase normalizerBase, int n2) {
        normalizerBase.bufferStart = n2;
    }

    private static /* synthetic */ int _jr$ig$bufferPos(NormalizerBase normalizerBase) {
        return normalizerBase.bufferPos;
    }

    private static /* synthetic */ void _jr$ip$bufferPos(NormalizerBase normalizerBase, int n2) {
        normalizerBase.bufferPos = n2;
    }

    private static /* synthetic */ int _jr$ig$bufferLimit(NormalizerBase normalizerBase) {
        return normalizerBase.bufferLimit;
    }

    private static /* synthetic */ void _jr$ip$bufferLimit(NormalizerBase normalizerBase, int n2) {
        normalizerBase.bufferLimit = n2;
    }

    private static /* synthetic */ UCharacterIterator _jr$ig$text(NormalizerBase normalizerBase) {
        return normalizerBase.text;
    }

    private static /* synthetic */ void _jr$ip$text(NormalizerBase normalizerBase, UCharacterIterator uCharacterIterator) {
        normalizerBase.text = uCharacterIterator;
    }

    private static /* synthetic */ Mode _jr$ig$mode(NormalizerBase normalizerBase) {
        return normalizerBase.mode;
    }

    private static /* synthetic */ void _jr$ip$mode(NormalizerBase normalizerBase, Mode mode) {
        normalizerBase.mode = mode;
    }

    private static /* synthetic */ int _jr$ig$options(NormalizerBase normalizerBase) {
        return normalizerBase.options;
    }

    private static /* synthetic */ void _jr$ip$options(NormalizerBase normalizerBase, int n2) {
        normalizerBase.options = n2;
    }

    private static /* synthetic */ int _jr$ig$currentIndex(NormalizerBase normalizerBase) {
        return normalizerBase.currentIndex;
    }

    private static /* synthetic */ void _jr$ip$currentIndex(NormalizerBase normalizerBase, int n2) {
        normalizerBase.currentIndex = n2;
    }

    private static /* synthetic */ int _jr$ig$nextIndex(NormalizerBase normalizerBase) {
        return normalizerBase.nextIndex;
    }

    private static /* synthetic */ void _jr$ip$nextIndex(NormalizerBase normalizerBase, int n2) {
        normalizerBase.nextIndex = n2;
    }

    private static final class IsNextNFDSafe
    extends h
    implements IsNextBoundary {
        private IsNextNFDSafe() {
        }

        public boolean isNextBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, int[] nArray) {
            return NormalizerImpl.isNFDSafe((long)NormalizerBase.getNextNorm32(uCharacterIterator, n2, n3, nArray), (int)n3, (int)(n3 & 0x3F));
        }
    }

    private static final class IsNextTrueStarter
    extends h
    implements IsNextBoundary {
        private IsNextTrueStarter() {
        }

        public boolean isNextBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, int[] nArray) {
            int n4 = n3 << 2 & 0xF;
            long l2 = NormalizerBase.getNextNorm32(uCharacterIterator, n2, n3 | n4, nArray);
            return NormalizerImpl.isTrueStarter((long)l2, (int)n3, (int)n4);
        }
    }

    private static final class IsPrevNFDSafe
    extends h
    implements IsPrevBoundary {
        private IsPrevNFDSafe() {
        }

        public boolean isPrevBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, char[] cArray) {
            return NormalizerImpl.isNFDSafe((long)NormalizerBase.getPrevNorm32(uCharacterIterator, n2, n3, cArray), (int)n3, (int)(n3 & 0x3F));
        }
    }

    private static final class IsPrevTrueStarter
    extends h
    implements IsPrevBoundary {
        private IsPrevTrueStarter() {
        }

        public boolean isPrevBoundary(UCharacterIterator uCharacterIterator, int n2, int n3, char[] cArray) {
            int n4 = n3 << 2 & 0xF;
            long l2 = NormalizerBase.getPrevNorm32(uCharacterIterator, n2, n3 | n4, cArray);
            return NormalizerImpl.isTrueStarter((long)l2, (int)n3, (int)n4);
        }
    }

    public static class Mode
    extends h {
        private int modeValue;

        private Mode(int n2) {
            this.modeValue = n2;
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, UnicodeSet unicodeSet) {
            int n6 = n3 - n2;
            int n7 = n5 - n4;
            if (n6 > n7) {
                return n6;
            }
            a.arraycopy((Object)cArray, (int)n2, (Object)cArray2, (int)n4, (int)n6);
            return n6;
        }

        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, int n6) {
            return this.normalize(cArray, n2, n3, cArray2, n4, n5, NormalizerImpl.getNX((int)n6));
        }

        protected String normalize(String string, int n2) {
            return string;
        }

        protected int getMinC() {
            return -1;
        }

        protected int getMask() {
            return -1;
        }

        protected IsPrevBoundary getPrevBoundary() {
            return null;
        }

        protected IsNextBoundary getNextBoundary() {
            return null;
        }

        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl, UnicodeSet unicodeSet) {
            if (bl) {
                return MAYBE;
            }
            return NO;
        }

        protected boolean isNFSkippable(int n2) {
            return true;
        }

        private static /* synthetic */ int _jr$ig$modeValue(Mode mode) {
            return mode.modeValue;
        }

        private static /* synthetic */ void _jr$ip$modeValue(Mode mode, int n2) {
            mode.modeValue = n2;
        }

        protected /* synthetic */ Mode(h h2) {
            super(h2);
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode(int n2) {
            super(n2);
        }

        @Override
        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, UnicodeSet unicodeSet) {
            return NormalizerImpl.compose((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (int)0, (UnicodeSet)unicodeSet);
        }

        @Override
        protected String normalize(String string, int n2) {
            return NormalizerBase.compose(string, false, n2);
        }

        @Override
        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr((int)6);
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        @Override
        protected int getMask() {
            return 65297;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck((char[])cArray, (int)n2, (int)n3, (int)NormalizerImpl.getFromIndexesArr((int)6), (int)17, (int)0, (boolean)bl, (UnicodeSet)unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n2) {
            return NormalizerImpl.isNFSkippable((int)n2, (Mode)this, (long)65473L);
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode(int n2) {
            super(n2);
        }

        @Override
        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, UnicodeSet unicodeSet) {
            int[] nArray = new int[1];
            return NormalizerImpl.decompose((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (boolean)false, (int[])nArray, (UnicodeSet)unicodeSet);
        }

        @Override
        protected String normalize(String string, int n2) {
            return NormalizerBase.decompose(string, false, n2);
        }

        @Override
        protected int getMinC() {
            return 768;
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        @Override
        protected int getMask() {
            return 65284;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck((char[])cArray, (int)n2, (int)n3, (int)NormalizerImpl.getFromIndexesArr((int)8), (int)4, (int)0, (boolean)bl, (UnicodeSet)unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n2) {
            return NormalizerImpl.isNFSkippable((int)n2, (Mode)this, (long)65284L);
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode(int n2) {
            super(n2);
        }

        @Override
        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, UnicodeSet unicodeSet) {
            return NormalizerImpl.compose((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (int)4096, (UnicodeSet)unicodeSet);
        }

        @Override
        protected String normalize(String string, int n2) {
            return NormalizerBase.compose(string, true, n2);
        }

        @Override
        protected int getMinC() {
            return NormalizerImpl.getFromIndexesArr((int)7);
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevTrueStarter();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextTrueStarter();
        }

        @Override
        protected int getMask() {
            return 65314;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck((char[])cArray, (int)n2, (int)n3, (int)NormalizerImpl.getFromIndexesArr((int)7), (int)34, (int)4096, (boolean)bl, (UnicodeSet)unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n2) {
            return NormalizerImpl.isNFSkippable((int)n2, (Mode)this, (long)65474L);
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode(int n2) {
            super(n2);
        }

        @Override
        protected int normalize(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5, UnicodeSet unicodeSet) {
            int[] nArray = new int[1];
            return NormalizerImpl.decompose((char[])cArray, (int)n2, (int)n3, (char[])cArray2, (int)n4, (int)n5, (boolean)true, (int[])nArray, (UnicodeSet)unicodeSet);
        }

        @Override
        protected String normalize(String string, int n2) {
            return NormalizerBase.decompose(string, true, n2);
        }

        @Override
        protected int getMinC() {
            return 768;
        }

        @Override
        protected IsPrevBoundary getPrevBoundary() {
            return new IsPrevNFDSafe();
        }

        @Override
        protected IsNextBoundary getNextBoundary() {
            return new IsNextNFDSafe();
        }

        @Override
        protected int getMask() {
            return 65288;
        }

        @Override
        protected QuickCheckResult quickCheck(char[] cArray, int n2, int n3, boolean bl, UnicodeSet unicodeSet) {
            return NormalizerImpl.quickCheck((char[])cArray, (int)n2, (int)n3, (int)NormalizerImpl.getFromIndexesArr((int)9), (int)8, (int)4096, (boolean)bl, (UnicodeSet)unicodeSet);
        }

        @Override
        protected boolean isNFSkippable(int n2) {
            return NormalizerImpl.isNFSkippable((int)n2, (Mode)this, (long)65288L);
        }
    }

    public static final class QuickCheckResult
    extends h {
        private int resultValue;

        private QuickCheckResult(int n2) {
            this.resultValue = n2;
        }

        private static /* synthetic */ int _jr$ig$resultValue(QuickCheckResult quickCheckResult) {
            return quickCheckResult.resultValue;
        }

        private static /* synthetic */ void _jr$ip$resultValue(QuickCheckResult quickCheckResult, int n2) {
            quickCheckResult.resultValue = n2;
        }
    }
}

