/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.ZoneInfo;

public abstract class AbstractCalendar
extends CalendarSystem {
    static final int SECOND_IN_MILLIS = 1000;
    static final int MINUTE_IN_MILLIS = 60000;
    static final int HOUR_IN_MILLIS = 3600000;
    static final int DAY_IN_MILLIS = 86400000;
    static final int EPOCH_OFFSET = 719163;
    private Era[] eras;

    protected AbstractCalendar() {
    }

    @Override
    public Era getEra(String string) {
        if (this.eras != null) {
            for (int i = 0; i < this.eras.length; ++i) {
                if (!this.eras[i].equals(string)) continue;
                return this.eras[i];
            }
        }
        return null;
    }

    @Override
    public Era[] getEras() {
        Era[] eraArray = null;
        if (this.eras != null) {
            eraArray = new Era[this.eras.length];
            a.arraycopy((Object)this.eras, (int)0, (Object)eraArray, (int)0, (int)this.eras.length);
        }
        return eraArray;
    }

    @Override
    public void setEra(CalendarDate calendarDate, String string) {
        if (this.eras == null) {
            return;
        }
        for (int i = 0; i < a.arrayLength((Object[])this.eras); ++i) {
            Era era = (Era)g.convertForCast((Object)a.arrayLoad((Object[])this.eras, (int)i), Era.class);
            if (era == null || !era.getName().equals(string)) continue;
            calendarDate.setEra(era);
            return;
        }
        throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException("unknown era name: " + string));
    }

    protected void setEras(Era[] eraArray) {
        this.eras = eraArray;
    }

    @Override
    public CalendarDate getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    @Override
    public CalendarDate getCalendarDate(long l) {
        return this.getCalendarDate(l, this.newCalendarDate());
    }

    @Override
    public CalendarDate getCalendarDate(long l, TimeZone timeZone) {
        CalendarDate calendarDate = this.newCalendarDate(timeZone);
        return this.getCalendarDate(l, calendarDate);
    }

    @Override
    public CalendarDate getCalendarDate(long l, CalendarDate calendarDate) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long l2 = 0L;
        TimeZone timeZone = calendarDate.getZone();
        if (timeZone != null) {
            int[] nArray = new int[2];
            if (g.convertForInstanceOf((Object)timeZone, ZoneInfo.class) instanceof ZoneInfo) {
                n3 = ((ZoneInfo)g.convertForCast((Object)timeZone, ZoneInfo.class)).getOffsets(l, nArray);
            } else {
                n3 = timeZone.getOffset(l);
                nArray[0] = timeZone.getRawOffset();
                nArray[1] = n3 - nArray[0];
            }
            l2 = n3 / 86400000;
            n2 = n3 % 86400000;
            n4 = nArray[1];
        }
        calendarDate.setZoneOffset(n3);
        calendarDate.setDaylightSaving(n4);
        l2 += l / 86400000L;
        if ((n2 += (int)(l % 86400000L)) >= 86400000) {
            n2 -= 86400000;
            ++l2;
        } else {
            while (n2 < 0) {
                n2 += 86400000;
                --l2;
            }
        }
        this.getCalendarDateFromFixedDate(calendarDate, l2 += 719163L);
        this.setTimeOfDay(calendarDate, n2);
        calendarDate.setLeapYear(this.isLeapYear(calendarDate));
        calendarDate.setNormalized(true);
        return calendarDate;
    }

    @Override
    public long getTime(CalendarDate calendarDate) {
        long l = this.getFixedDate(calendarDate);
        long l2 = (l - 719163L) * 86400000L + this.getTimeOfDay(calendarDate);
        int n2 = 0;
        TimeZone timeZone = calendarDate.getZone();
        if (timeZone != null) {
            if (calendarDate.isNormalized()) {
                return l2 - (long)calendarDate.getZoneOffset();
            }
            int[] nArray = new int[2];
            if (calendarDate.isStandardTime()) {
                if (g.convertForInstanceOf((Object)timeZone, ZoneInfo.class) instanceof ZoneInfo) {
                    ((ZoneInfo)g.convertForCast((Object)timeZone, ZoneInfo.class)).getOffsetsByStandard(l2, nArray);
                    n2 = nArray[0];
                } else {
                    n2 = timeZone.getOffset(l2 - (long)timeZone.getRawOffset());
                }
            } else {
                n2 = g.convertForInstanceOf((Object)timeZone, ZoneInfo.class) instanceof ZoneInfo ? ((ZoneInfo)g.convertForCast((Object)timeZone, ZoneInfo.class)).getOffsetsByWall(l2, nArray) : timeZone.getOffset(l2 - (long)timeZone.getRawOffset());
            }
        }
        this.getCalendarDate(l2 -= (long)n2, calendarDate);
        return l2;
    }

    protected long getTimeOfDay(CalendarDate calendarDate) {
        long l = calendarDate.getTimeOfDay();
        if (l != Long.MIN_VALUE) {
            return l;
        }
        l = this.getTimeOfDayValue(calendarDate);
        calendarDate.setTimeOfDay(l);
        return l;
    }

    public long getTimeOfDayValue(CalendarDate calendarDate) {
        long l = calendarDate.getHours();
        l *= 60L;
        l += (long)calendarDate.getMinutes();
        l *= 60L;
        l += (long)calendarDate.getSeconds();
        l *= 1000L;
        return l += (long)calendarDate.getMillis();
    }

    @Override
    public CalendarDate setTimeOfDay(CalendarDate calendarDate, int n2) {
        if (n2 < 0) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        boolean bl = calendarDate.isNormalized();
        int n3 = n2;
        int n4 = n3 / 3600000;
        int n5 = (n3 %= 3600000) / 60000;
        int n6 = (n3 %= 60000) / 1000;
        n3 %= 1000;
        calendarDate.setHours(n4);
        calendarDate.setMinutes(n5);
        calendarDate.setSeconds(n6);
        calendarDate.setMillis(n3);
        calendarDate.setTimeOfDay(n2);
        if (n4 < 24 && bl) {
            calendarDate.setNormalized(bl);
        }
        return calendarDate;
    }

    @Override
    public int getWeekLength() {
        return 7;
    }

    protected abstract boolean isLeapYear(CalendarDate var1);

    @Override
    public CalendarDate getNthDayOfWeek(int n2, int n3, CalendarDate calendarDate) {
        CalendarDate calendarDate2 = (CalendarDate)g.convertForCast((Object)calendarDate.clone(), CalendarDate.class);
        this.normalize(calendarDate2);
        long l = this.getFixedDate(calendarDate2);
        long l2 = n2 > 0 ? (long)(7 * n2) + AbstractCalendar.getDayOfWeekDateBefore(l, n3) : (long)(7 * n2) + AbstractCalendar.getDayOfWeekDateAfter(l, n3);
        this.getCalendarDateFromFixedDate(calendarDate2, l2);
        return calendarDate2;
    }

    static long getDayOfWeekDateBefore(long l, int n2) {
        return AbstractCalendar.getDayOfWeekDateOnOrBefore(l - 1L, n2);
    }

    static long getDayOfWeekDateAfter(long l, int n2) {
        return AbstractCalendar.getDayOfWeekDateOnOrBefore(l + 7L, n2);
    }

    public static long getDayOfWeekDateOnOrBefore(long l, int n2) {
        long l2 = l - (long)(n2 - 1);
        if (l2 >= 0L) {
            return l - l2 % 7L;
        }
        return l - CalendarUtils.mod(l2, 7L);
    }

    protected abstract long getFixedDate(CalendarDate var1);

    protected abstract void getCalendarDateFromFixedDate(CalendarDate var1, long var2);

    public boolean validateTime(CalendarDate calendarDate) {
        int n2 = calendarDate.getHours();
        if (n2 < 0 || n2 >= 24) {
            return false;
        }
        n2 = calendarDate.getMinutes();
        if (n2 < 0 || n2 >= 60) {
            return false;
        }
        n2 = calendarDate.getSeconds();
        if (n2 < 0 || n2 >= 60) {
            return false;
        }
        n2 = calendarDate.getMillis();
        return n2 >= 0 && n2 < 1000;
    }

    int normalizeTime(CalendarDate calendarDate) {
        long l = this.getTimeOfDay(calendarDate);
        long l2 = 0L;
        if (l >= 86400000L) {
            l2 = l / 86400000L;
            l %= 86400000L;
        } else if (l < 0L && (l2 = CalendarUtils.floorDivide(l, 86400000L)) != 0L) {
            l -= 86400000L * l2;
        }
        if (l2 != 0L) {
            calendarDate.setTimeOfDay(l);
        }
        calendarDate.setMillis((int)(l % 1000L));
        calendarDate.setSeconds((int)((l /= 1000L) % 60L));
        calendarDate.setMinutes((int)((l /= 60L) % 60L));
        calendarDate.setHours((int)(l / 60L));
        return (int)l2;
    }

    protected /* synthetic */ AbstractCalendar(h h2) {
        super(h2);
    }
}

