/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import com.zeroturnaround.jrebelbase.facade.af;
import com.zeroturnaround.jrebelbase.facade.ah;
import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.facade.x;
import com.zeroturnaround.jrebelbase.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.TzIDOldMapping;
import sun.util.calendar.ZoneInfoFile;

public class ZoneInfo
extends TimeZone {
    private static final int UTC_TIME = 0;
    private static final int STANDARD_TIME = 1;
    private static final int WALL_TIME = 2;
    private static final long OFFSET_MASK = 15L;
    private static final long DST_MASK = 240L;
    private static final int DST_NSHIFT = 4;
    private static final long ABBR_MASK = 3840L;
    private static final int TRANSITION_NSHIFT = 12;
    static final boolean USE_OLDMAPPING;
    static final String[] conflictingIDs;
    private static final CalendarSystem gcal;
    private int rawOffset;
    private int rawOffsetDiff;
    private int checksum;
    private int dstSavings;
    private long[] transitions;
    private int[] offsets;
    private int[] simpleTimeZoneParams;
    private boolean willGMTOffsetChange;
    private transient boolean dirty;
    private static final long serialVersionUID = 2653134537216586139L;
    private transient SimpleTimeZone lastRule;
    private static SoftReference<Map<String, String>> aliasTable;

    public ZoneInfo() {
        this.rawOffsetDiff = 0;
        this.willGMTOffsetChange = false;
        this.dirty = false;
    }

    public ZoneInfo(String string, int n2) {
        this(string, n2, 0, 0, null, null, null, false);
    }

    ZoneInfo(String string, int n2, int n3, int n4, long[] lArray, int[] nArray, int[] nArray2, boolean bl) {
        this.rawOffsetDiff = 0;
        this.willGMTOffsetChange = false;
        this.dirty = false;
        this.setID(string);
        this.rawOffset = n2;
        this.dstSavings = n3;
        this.checksum = n4;
        this.transitions = lArray;
        this.offsets = nArray;
        this.simpleTimeZoneParams = nArray2;
        this.willGMTOffsetChange = bl;
    }

    @Override
    public int getOffset(long l) {
        return this.getOffsets(l, null, 0);
    }

    public int getOffsets(long l, int[] nArray) {
        return this.getOffsets(l, nArray, 0);
    }

    public int getOffsetsByStandard(long l, int[] nArray) {
        return this.getOffsets(l, nArray, 1);
    }

    public int getOffsetsByWall(long l, int[] nArray) {
        return this.getOffsets(l, nArray, 2);
    }

    private int getOffsets(long l, int[] nArray, int n2) {
        if (this.transitions == null) {
            int n3 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n3;
                nArray[1] = 0;
            }
            return n3;
        }
        int n4 = this.getTransitionIndex(l -= (long)this.rawOffsetDiff, n2);
        if (n4 < 0) {
            int n5 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n5;
                nArray[1] = 0;
            }
            return n5;
        }
        if (n4 < this.transitions.length) {
            long l2 = this.transitions[n4];
            int n6 = this.offsets[(int)(l2 & 0xFL)] + this.rawOffsetDiff;
            if (nArray != null) {
                int n7 = (int)(l2 >>> 4 & 0xFL);
                int n8 = n7 == 0 ? 0 : this.offsets[n7];
                nArray[0] = n6 - n8;
                nArray[1] = n8;
            }
            return n6;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            int n9;
            int n10 = simpleTimeZone.getRawOffset();
            long l3 = l;
            if (n2 != 0) {
                l3 -= (long)this.rawOffset;
            }
            if ((n9 = simpleTimeZone.getOffset(l3) - this.rawOffset) > 0 && simpleTimeZone.getOffset(l3 - (long)n9) == n10) {
                n9 = 0;
            }
            if (nArray != null) {
                nArray[0] = n10;
                nArray[1] = n9;
            }
            return n10 + n9;
        }
        int n11 = this.getLastRawOffset();
        if (nArray != null) {
            nArray[0] = n11;
            nArray[1] = 0;
        }
        return n11;
    }

    private final int getTransitionIndex(long l, int n2) {
        int n3 = 0;
        int n4 = this.transitions.length - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = (n3 + n4) / 2;
            long l2 = this.transitions[n6];
            long l3 = l2 >> 12;
            if (n2 != 0) {
                l3 += (long)this.offsets[(int)(l2 & 0xFL)];
            }
            if (n2 == 1 && (n5 = (int)(l2 >>> 4 & 0xFL)) != 0) {
                l3 -= (long)this.offsets[n5];
            }
            if (l3 < l) {
                n3 = n6 + 1;
                continue;
            }
            if (l3 > l) {
                n4 = n6 - 1;
                continue;
            }
            return n6;
        }
        if (n3 >= this.transitions.length) {
            return n3;
        }
        return n3 - 1;
    }

    @Override
    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 < 0 || n7 >= 86400000) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n2 == 0) {
            n3 = 1 - n3;
        } else if (n2 != 1) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        CalendarDate calendarDate = gcal.newCalendarDate(null);
        calendarDate.setDate(n3, n4 + 1, n5);
        if (!gcal.validate(calendarDate)) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (n6 < 1 || n6 > 7) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IllegalArgumentException());
        }
        if (this.transitions == null) {
            return this.getLastRawOffset();
        }
        long l = gcal.getTime(calendarDate) + (long)n7;
        return this.getOffsets(l -= (long)this.rawOffset, null, 0);
    }

    @Override
    @af(modifiers=33)
    public void setRawOffset(int n2) {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (n2 == this.rawOffset + this.rawOffsetDiff) {
                    return;
                }
                this.rawOffsetDiff = n2 - this.rawOffset;
                if (this.lastRule != null) {
                    this.lastRule.setRawOffset(n2);
                }
                this.dirty = true;
                return;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    @Override
    public int getRawOffset() {
        if (!this.willGMTOffsetChange) {
            return this.rawOffset + this.rawOffsetDiff;
        }
        int[] nArray = new int[2];
        this.getOffsets(System.currentTimeMillis(), nArray, 0);
        return nArray[0];
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private int getLastRawOffset() {
        return this.rawOffset + this.rawOffsetDiff;
    }

    @Override
    public boolean useDaylightTime() {
        return this.simpleTimeZoneParams != null;
    }

    @Override
    public boolean observesDaylightTime() {
        if (this.simpleTimeZoneParams != null) {
            return true;
        }
        if (this.transitions == null) {
            return false;
        }
        long l = System.currentTimeMillis() - (long)this.rawOffsetDiff;
        int n2 = this.getTransitionIndex(l, 0);
        if (n2 < 0) {
            return false;
        }
        for (int i = n2; i < this.transitions.length; ++i) {
            if ((this.transitions[i] & 0xF0L) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inDaylightTime(Date date) {
        if (date == null) {
            throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new NullPointerException());
        }
        if (this.transitions == null) {
            return false;
        }
        long l = date.getTime() - (long)this.rawOffsetDiff;
        int n2 = this.getTransitionIndex(l, 0);
        if (n2 < 0) {
            return false;
        }
        if (n2 < this.transitions.length) {
            return (this.transitions[n2] & 0xF0L) != 0L;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            return simpleTimeZone.inDaylightTime(date);
        }
        return false;
    }

    @Override
    public int getDSTSavings() {
        return this.dstSavings;
    }

    public String toString() {
        return x.getName(this.getClass()) + "[id=\"" + this.getID() + "\"" + ",offset=" + this.getLastRawOffset() + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylightTime() + ",transitions=" + (this.transitions != null ? this.transitions.length : 0) + ",lastRule=" + (this.lastRule == null ? this.getLastRuleInstance() : this.lastRule) + "]";
    }

    public static String[] getAvailableIDs() {
        Object object;
        Object object2 = ZoneInfoFile.getZoneIDs();
        List<String> list = ZoneInfoFile.getExcludedZones();
        if (list != null) {
            object = new ArrayList(object2.size() + list.size());
            object.addAll(object2);
            object.addAll(list);
            object2 = object;
        }
        object = new String[object2.size()];
        return object2.toArray((T[])object);
    }

    public static String[] getAvailableIDs(int n2) {
        List<String> list;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list2 = ZoneInfoFile.getZoneIDs();
        int[] nArray = ZoneInfoFile.getRawOffsets();
        block0: for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n2) continue;
            object = ZoneInfoFile.getRawOffsetIndices();
            for (int k = 0; k < ((Object)object).length; ++k) {
                if (object[k] != i) continue;
                arrayList.add(list2.get(k++));
                while (k < ((Object)object).length && object[k] == i) {
                    arrayList.add(list2.get(k++));
                }
                break block0;
            }
        }
        if ((list = ZoneInfoFile.getExcludedZones()) != null) {
            object = list.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                TimeZone timeZone = ZoneInfo.getTimeZone(string);
                if (timeZone == null || timeZone.getRawOffset() != n2) continue;
                arrayList.add(string);
            }
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static TimeZone getTimeZone(String object) {
        Object object2;
        String string = null;
        if (USE_OLDMAPPING && (object2 = (String)TzIDOldMapping.MAP.get(object)) != null) {
            string = object;
            object = object2;
        }
        if ((object2 = ZoneInfoFile.getZoneInfo((String)object)) == null) {
            try {
                Map<String, String> map = ZoneInfo.getAliasTable();
                String string2 = object;
                while ((string2 = map.get(string2)) != null) {
                    object2 = ZoneInfoFile.getZoneInfo(string2);
                    if (object2 == null) continue;
                    ((TimeZone)object2).setID((String)object);
                    object2 = ZoneInfoFile.addToCache((String)object, (ZoneInfo)object2);
                    object2 = (ZoneInfo)g.convertForCast((Object)((ZoneInfo)object2).clone(), ZoneInfo.class);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null && object2 != null) {
            ((TimeZone)object2).setID(string);
        }
        return object2;
    }

    @af(modifiers=34)
    private SimpleTimeZone getLastRule() {
        Object object = ah.getMonitor((Object)this);
        synchronized (object) {
            try {
                if (this.lastRule == null) {
                    this.lastRule = this.getLastRuleInstance();
                }
                return this.lastRule;
            }
            catch (Throwable throwable) {
                throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
            }
        }
    }

    public SimpleTimeZone getLastRuleInstance() {
        if (this.simpleTimeZoneParams == null) {
            return null;
        }
        if (this.simpleTimeZoneParams.length == 10) {
            return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.simpleTimeZoneParams[8], this.simpleTimeZoneParams[9], this.dstSavings);
        }
        return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.dstSavings);
    }

    @Override
    public Object clone() {
        ZoneInfo zoneInfo = (ZoneInfo)g.convertForCast((Object)super.clone(), ZoneInfo.class);
        zoneInfo.lastRule = null;
        return zoneInfo;
    }

    public int hashCode() {
        return this.getLastRawOffset() ^ this.checksum;
    }

    public boolean equals(Object object) {
        if (!f.ifAcmp((Object)this, (Object)object)) {
            return true;
        }
        if (!(g.convertForInstanceOf((Object)object, ZoneInfo.class) instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)g.convertForCast((Object)object, ZoneInfo.class);
        return this.getID().equals(zoneInfo.getID()) && this.getLastRawOffset() == zoneInfo.getLastRawOffset() && this.checksum == zoneInfo.checksum;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (!f.ifAcmp((Object)this, (Object)timeZone)) {
            return true;
        }
        if (timeZone == null) {
            return false;
        }
        if (!(g.convertForInstanceOf((Object)timeZone, ZoneInfo.class) instanceof ZoneInfo)) {
            if (this.getRawOffset() != timeZone.getRawOffset()) {
                return false;
            }
            return this.transitions == null && !this.useDaylightTime() && !timeZone.useDaylightTime();
        }
        if (this.getLastRawOffset() != ((ZoneInfo)g.convertForCast((Object)timeZone, ZoneInfo.class)).getLastRawOffset()) {
            return false;
        }
        return this.checksum == ((ZoneInfo)g.convertForCast((Object)timeZone, ZoneInfo.class)).checksum;
    }

    static Map<String, String> getCachedAliasTable() {
        Map map = null;
        SoftReference<Map<String, String>> softReference = aliasTable;
        if (softReference != null) {
            map = (Map)g.convertForCast(softReference.get(), Map.class);
        }
        return map;
    }

    public static synchronized Map<String, String> getAliasTable() {
        Map<String, String> map = ZoneInfo.getCachedAliasTable();
        if (map == null && (map = ZoneInfoFile.getZoneAliases()) != null) {
            if (!USE_OLDMAPPING) {
                for (String string : conflictingIDs) {
                    map.remove(string);
                }
            }
            aliasTable = new SoftReference<Map<String, String>>(map);
        }
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.dirty = true;
    }

    static {
        String string = ((String)AccessController.doPrivileged(new GetPropertyAction("sun.timezone.ids.oldmapping", "false"))).toLowerCase(Locale.ROOT);
        USE_OLDMAPPING = string.equals("yes") || string.equals("true");
        conflictingIDs = new String[]{"EST", "MST", "HST"};
        gcal = CalendarSystem.getGregorianCalendar();
    }

    private static /* synthetic */ void _jr$ip$rawOffset(ZoneInfo zoneInfo, int n2) {
        zoneInfo.rawOffset = n2;
    }

    private static /* synthetic */ void _jr$ip$checksum(ZoneInfo zoneInfo, int n2) {
        zoneInfo.checksum = n2;
    }

    private static /* synthetic */ void _jr$ip$dstSavings(ZoneInfo zoneInfo, int n2) {
        zoneInfo.dstSavings = n2;
    }

    private static /* synthetic */ void _jr$ip$transitions(ZoneInfo zoneInfo, long[] lArray) {
        zoneInfo.transitions = lArray;
    }

    private static /* synthetic */ void _jr$ip$offsets(ZoneInfo zoneInfo, int[] nArray) {
        zoneInfo.offsets = nArray;
    }

    private static /* synthetic */ void _jr$ip$simpleTimeZoneParams(ZoneInfo zoneInfo, int[] nArray) {
        zoneInfo.simpleTimeZoneParams = nArray;
    }

    private static /* synthetic */ void _jr$ip$willGMTOffsetChange(ZoneInfo zoneInfo, boolean bl) {
        zoneInfo.willGMTOffsetChange = bl;
    }

    protected /* synthetic */ ZoneInfo(h h2) {
        super(h2);
    }
}

