/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.util.calendar.ZoneInfo;

public class ZoneInfoFile
extends h {
    public static final byte[] JAVAZI_LABEL = new byte[]{106, 97, 118, 97, 122, 105, 0};
    private static final int JAVAZI_LABEL_LENGTH = JAVAZI_LABEL.length;
    public static final byte JAVAZI_VERSION = 1;
    public static final byte TAG_RawOffset = 1;
    public static final byte TAG_LastDSTSaving = 2;
    public static final byte TAG_CRC32 = 3;
    public static final byte TAG_Transition = 4;
    public static final byte TAG_Offset = 5;
    public static final byte TAG_SimpleTimeZone = 6;
    public static final byte TAG_GMTOffsetWillChange = 7;
    public static final String JAVAZM_FILE_NAME = "ZoneInfoMappings";
    public static final byte[] JAVAZM_LABEL = new byte[]{106, 97, 118, 97, 122, 109, 0};
    private static final int JAVAZM_LABEL_LENGTH = JAVAZM_LABEL.length;
    public static final byte JAVAZM_VERSION = 1;
    public static final byte TAG_ZoneIDs = 64;
    public static final byte TAG_RawOffsets = 65;
    public static final byte TAG_RawOffsetIndices = 66;
    public static final byte TAG_ZoneAliases = 67;
    public static final byte TAG_TZDataVersion = 68;
    public static final byte TAG_ExcludedZones = 69;
    private static Map<String, ZoneInfo> zoneInfoObjects = null;
    private static final ZoneInfo GMT = new ZoneInfo("GMT", 0);
    private static final String ziDir = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public String run() {
            String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "zi";
            try {
                string = FileSystems.getDefault().getPath(string, new String[0]).toRealPath(new LinkOption[0]).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }
    });
    private static volatile SoftReference<List<String>> zoneIDs = null;
    private static volatile SoftReference<List<String>> excludedIDs = null;
    private static volatile boolean hasNoExcludeList = false;
    private static volatile SoftReference<byte[]> rawOffsetIndices = null;
    private static volatile SoftReference<int[]> rawOffsets = null;
    private static volatile SoftReference<byte[]> zoneInfoMappings = null;

    public ZoneInfoFile() {
    }

    public static String getFileName(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        return string.replace('/', File.separatorChar);
    }

    public static ZoneInfo getCustomTimeZone(String string, int n2) {
        String string2 = ZoneInfoFile.toCustomID(n2);
        ZoneInfo zoneInfo = ZoneInfoFile.getFromCache(string2);
        if (zoneInfo == null) {
            zoneInfo = new ZoneInfo(string2, n2);
            zoneInfo = ZoneInfoFile.addToCache(string2, zoneInfo);
            if (!string2.equals(string)) {
                zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
            }
        }
        return (ZoneInfo)g.convertForCast((Object)zoneInfo.clone(), ZoneInfo.class);
    }

    public static String toCustomID(int n2) {
        char c2;
        int n3 = n2 / 60000;
        if (n3 >= 0) {
            c2 = '+';
        } else {
            c2 = '-';
            n3 = -n3;
        }
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        char[] cArray = new char[]{'G', 'M', 'T', c2, '0', '0', ':', '0', '0'};
        if (n4 >= 10) {
            cArray[4] = (char)(cArray[4] + n4 / 10);
        }
        cArray[5] = (char)(cArray[5] + n4 % 10);
        if (n5 != 0) {
            cArray[7] = (char)(cArray[7] + n5 / 10);
            cArray[8] = (char)(cArray[8] + n5 % 10);
        }
        return new String(cArray);
    }

    public static ZoneInfo getZoneInfo(String string) {
        if ("GMT".equals(string)) {
            return (ZoneInfo)g.convertForCast((Object)GMT.clone(), ZoneInfo.class);
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getFromCache(string);
        if (zoneInfo == null) {
            Map<String, String> map = ZoneInfo.getCachedAliasTable();
            if (map != null && map.get(string) != null) {
                return null;
            }
            zoneInfo = ZoneInfoFile.createZoneInfo(string);
            if (zoneInfo == null) {
                return null;
            }
            zoneInfo = ZoneInfoFile.addToCache(string, zoneInfo);
        }
        return (ZoneInfo)g.convertForCast((Object)zoneInfo.clone(), ZoneInfo.class);
    }

    static synchronized ZoneInfo getFromCache(String string) {
        if (zoneInfoObjects == null) {
            return null;
        }
        return (ZoneInfo)g.convertForCast((Object)zoneInfoObjects.get(string), ZoneInfo.class);
    }

    static synchronized ZoneInfo addToCache(String string, ZoneInfo zoneInfo) {
        if (zoneInfoObjects == null) {
            zoneInfoObjects = new HashMap<String, ZoneInfo>();
        } else {
            ZoneInfo zoneInfo2 = (ZoneInfo)g.convertForCast((Object)zoneInfoObjects.get(string), ZoneInfo.class);
            if (zoneInfo2 != null) {
                return zoneInfo2;
            }
        }
        zoneInfoObjects.put(string, zoneInfo);
        return zoneInfo;
    }

    private static ZoneInfo createZoneInfo(String string) {
        byte[] byArray = ZoneInfoFile.readZoneInfoFile(ZoneInfoFile.getFileName(string));
        if (byArray == null) {
            return null;
        }
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        long[] lArray = null;
        int[] nArray = null;
        int[] nArray2 = null;
        try {
            for (n2 = 0; n2 < JAVAZI_LABEL.length; ++n2) {
                if (byArray[n2] == JAVAZI_LABEL[n2]) continue;
                System.err.println("ZoneInfo: wrong magic number: " + string);
                return null;
            }
            if (byArray[n2++] > 1) {
                System.err.println("ZoneInfo: incompatible version (" + byArray[n2 - 1] + "): " + string);
                return null;
            }
            block12: while (n2 < n3) {
                int n7;
                byte by = byArray[n2++];
                if (n3 >= n2 + (n7 = ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF))) {
                    switch (by) {
                        case 3: {
                            int n8 = byArray[n2++] & 0xFF;
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n6 = n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            break;
                        }
                        case 2: {
                            int n8 = (short)(byArray[n2++] & 0xFF);
                            n8 = (short)((n8 << 8) + (byArray[n2++] & 0xFF));
                            n5 = n8 * 1000;
                            break;
                        }
                        case 1: {
                            int n8 = byArray[n2++] & 0xFF;
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            n4 = n8 = (n8 << 8) + (byArray[n2++] & 0xFF);
                            break;
                        }
                        case 4: {
                            int n9;
                            int n8 = n7 / 8;
                            lArray = new long[n8];
                            for (n9 = 0; n9 < n8; ++n9) {
                                long l2 = byArray[n2++] & 0xFF;
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                                lArray[n9] = l2 = (l2 << 8) + (long)(byArray[n2++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 5: {
                            int n9;
                            int n8 = n7 / 4;
                            nArray = new int[n8];
                            for (n9 = 0; n9 < n8; ++n9) {
                                int n10 = byArray[n2++] & 0xFF;
                                n10 = (n10 << 8) + (byArray[n2++] & 0xFF);
                                n10 = (n10 << 8) + (byArray[n2++] & 0xFF);
                                nArray[n9] = n10 = (n10 << 8) + (byArray[n2++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 6: {
                            int n9;
                            if (n7 != 32 && n7 != 40) {
                                System.err.println("ZoneInfo: wrong SimpleTimeZone parameter size");
                                return null;
                            }
                            int n8 = n7 / 4;
                            nArray2 = new int[n8];
                            for (n9 = 0; n9 < n8; ++n9) {
                                int n11 = byArray[n2++] & 0xFF;
                                n11 = (n11 << 8) + (byArray[n2++] & 0xFF);
                                n11 = (n11 << 8) + (byArray[n2++] & 0xFF);
                                nArray2[n9] = n11 = (n11 << 8) + (byArray[n2++] & 0xFF);
                            }
                            continue block12;
                        }
                        case 7: {
                            if (n7 != 1) {
                                System.err.println("ZoneInfo: wrong byte length for TAG_GMTOffsetWillChange");
                            }
                            bl = byArray[n2++] == 1;
                            break;
                        }
                        default: {
                            System.err.println("ZoneInfo: unknown tag < " + by + ">. ignored.");
                            n2 += n7;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("ZoneInfo: corrupted zoneinfo file: " + string);
            return null;
        }
        if (n2 != n3) {
            System.err.println("ZoneInfo: wrong file size: " + string);
            return null;
        }
        return new ZoneInfo(string, n4, n5, n6, lArray, nArray, nArray2, bl);
    }

    static List<String> getZoneIDs() {
        ArrayList<String> arrayList;
        block8: {
            arrayList = null;
            SoftReference<List<String>> softReference = zoneIDs;
            if (softReference != null && (arrayList = (ArrayList<String>)g.convertForCast(softReference.get(), List.class)) != null) {
                return arrayList;
            }
            byte[] byArray = null;
            byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = byArray.length;
            try {
                int n3;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n2; i += n3) {
                    byte by = byArray[i++];
                    n3 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 64: {
                            int n4 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            arrayList = new ArrayList<String>(n4);
                            for (int k = 0; k < n4; ++k) {
                                byte by2 = byArray[i++];
                                arrayList.add(new String(byArray, i, (int)by2, "UTF-8"));
                                i += by2;
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        zoneIDs = new SoftReference<List>(arrayList);
        return arrayList;
    }

    static Map<String, String> getZoneAliases() {
        HashMap<String, String> hashMap;
        block7: {
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = byArray.length;
            hashMap = null;
            try {
                int n3;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n2; i += n3) {
                    byte by = byArray[i++];
                    n3 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 67: {
                            int n4 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            hashMap = new HashMap<String, String>(n4);
                            for (int k = 0; k < n4; ++k) {
                                byte by2 = byArray[i++];
                                String string = new String(byArray, i, (int)by2, "UTF-8");
                                i += by2;
                                by2 = byArray[i++];
                                String string2 = new String(byArray, i, (int)by2, "UTF-8");
                                i += by2;
                                hashMap.put(string, string2);
                            }
                            break block7;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        return hashMap;
    }

    static List<String> getExcludedZones() {
        ArrayList<String> arrayList;
        block11: {
            if (hasNoExcludeList) {
                return null;
            }
            arrayList = null;
            SoftReference<List<String>> softReference = excludedIDs;
            if (softReference != null && (arrayList = (ArrayList<String>)g.convertForCast(softReference.get(), List.class)) != null) {
                return arrayList;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = byArray.length;
            try {
                int n3;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n2; i += n3) {
                    byte by = byArray[i++];
                    n3 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 69: {
                            int n4 = (byArray[i++] << 8) + (byArray[i++] & 0xFF);
                            arrayList = new ArrayList<String>();
                            for (int k = 0; k < n4; ++k) {
                                byte by2 = byArray[i++];
                                String string = new String(byArray, i, (int)by2, "UTF-8");
                                i += by2;
                                arrayList.add(string);
                            }
                            break block11;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
                return null;
            }
        }
        if (arrayList != null) {
            excludedIDs = new SoftReference<List>(arrayList);
        } else {
            hasNoExcludeList = true;
        }
        return arrayList;
    }

    static byte[] getRawOffsetIndices() {
        byte[] byArray;
        block8: {
            byArray = null;
            SoftReference<byte[]> softReference = rawOffsetIndices;
            if (softReference != null && (byArray = softReference.get()) != null) {
                return byArray;
            }
            byte[] byArray2 = ZoneInfoFile.getZoneInfoMappings();
            int n2 = byArray2.length;
            try {
                int n3;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n2; i += n3) {
                    byte by = byArray2[i++];
                    n3 = ((byArray2[i++] & 0xFF) << 8) + (byArray2[i++] & 0xFF);
                    switch (by) {
                        case 66: {
                            byArray = new byte[n3];
                            for (int k = 0; k < n3; ++k) {
                                byArray[k] = byArray2[i++];
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsetIndices = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    static int[] getRawOffsets() {
        int[] nArray;
        block8: {
            nArray = null;
            SoftReference<int[]> softReference = rawOffsets;
            if (softReference != null && (nArray = softReference.get()) != null) {
                return nArray;
            }
            byte[] byArray = ZoneInfoFile.getZoneInfoMappings();
            int n2 = byArray.length;
            try {
                int n3;
                block5: for (int i = JAVAZM_LABEL_LENGTH + 1; i < n2; i += n3) {
                    byte by = byArray[i++];
                    n3 = ((byArray[i++] & 0xFF) << 8) + (byArray[i++] & 0xFF);
                    switch (by) {
                        case 65: {
                            int n4 = n3 / 4;
                            nArray = new int[n4];
                            for (int k = 0; k < n4; ++k) {
                                int n5 = byArray[i++] & 0xFF;
                                n5 = (n5 << 8) + (byArray[i++] & 0xFF);
                                n5 = (n5 << 8) + (byArray[i++] & 0xFF);
                                nArray[k] = n5 = (n5 << 8) + (byArray[i++] & 0xFF);
                            }
                            break block8;
                        }
                        default: {
                            continue block5;
                        }
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.err.println("ZoneInfo: corrupted ZoneInfoMappings");
            }
        }
        rawOffsets = new SoftReference<int[]>(nArray);
        return nArray;
    }

    private static byte[] getZoneInfoMappings() {
        int n2;
        byte[] byArray;
        SoftReference<byte[]> softReference = zoneInfoMappings;
        if (softReference != null && (byArray = softReference.get()) != null) {
            return byArray;
        }
        byArray = ZoneInfoFile.readZoneInfoFile(JAVAZM_FILE_NAME);
        if (byArray == null) {
            return null;
        }
        for (n2 = 0; n2 < JAVAZM_LABEL.length; ++n2) {
            if (byArray[n2] == JAVAZM_LABEL[n2]) continue;
            System.err.println("ZoneInfo: wrong magic number: ZoneInfoMappings");
            return null;
        }
        if (byArray[n2++] > 1) {
            System.err.println("ZoneInfo: incompatible version (" + byArray[n2 - 1] + "): " + JAVAZM_FILE_NAME);
            return null;
        }
        zoneInfoMappings = new SoftReference<byte[]>(byArray);
        return byArray;
    }

    private static byte[] readZoneInfoFile(final String string) {
        byte[] byArray;
        block3: {
            if (string.indexOf("..") >= 0) {
                return null;
            }
            byArray = null;
            try {
                byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws IOException {
                        File file = new File(ziDir, string);
                        byte[] byArray = null;
                        int n2 = (int)file.length();
                        if (n2 > 0) {
                            FileInputStream fileInputStream;
                            block3: {
                                fileInputStream = new FileInputStream(file);
                                byArray = new byte[n2];
                                try {
                                    if (fileInputStream.read(byArray) == n2) break block3;
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)new IOException("read error on " + string));
                                }
                                catch (Throwable throwable) {
                                    fileInputStream.close();
                                    throw (Throwable)com.zeroturnaround.jrebelbase.facade.h.getCurrentVersion((h)throwable);
                                }
                            }
                            fileInputStream.close();
                        }
                        return byArray;
                    }

                    static /* synthetic */ String _jr$ig$val$fileName(Object object) {
                        return (object).string;
                    }

                    static /* synthetic */ void _jr$ip$val$fileName(Object object, String string2) {
                        (object).string = string2;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (g.convertForInstanceOf((Object)exception, FileNotFoundException.class) instanceof FileNotFoundException && !JAVAZM_FILE_NAME.equals(string)) break block3;
                System.err.println("ZoneInfo: " + exception.getMessage());
            }
        }
        return byArray;
    }

    protected /* synthetic */ ZoneInfoFile(h h2) {
        super(h2);
    }
}

