/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import com.zeroturnaround.jrebelbase.facade.a;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.util.locale.BaseLocale;
import sun.util.locale.Extension;
import sun.util.locale.LocaleExtensions;
import sun.util.locale.LocaleUtils;
import sun.util.locale.ParseStatus;
import sun.util.locale.StringTokenIterator;

public class LanguageTag
extends h {
    public static final String SEP = "-";
    public static final String PRIVATEUSE = "x";
    public static final String UNDETERMINED = "und";
    public static final String PRIVUSE_VARIANT_PREFIX = "lvariant";
    private String language;
    private String script;
    private String region;
    private String privateuse;
    private List<String> extlangs;
    private List<String> variants;
    private List<String> extensions;
    private static final Map<String, String[]> GRANDFATHERED;

    private LanguageTag() {
        this.language = "";
        this.script = "";
        this.region = "";
        this.privateuse = "";
        this.extlangs = Collections.emptyList();
        this.variants = Collections.emptyList();
        this.extensions = Collections.emptyList();
    }

    public static LanguageTag parse(String string, ParseStatus parseStatus) {
        if (parseStatus == null) {
            parseStatus = new ParseStatus();
        } else {
            parseStatus.reset();
        }
        Object[] objectArray = GRANDFATHERED.get(LocaleUtils.toLowerString(string));
        StringTokenIterator stringTokenIterator = objectArray != null ? new StringTokenIterator((String)a.arrayLoad((Object[])objectArray, (int)1), SEP) : new StringTokenIterator(string, SEP);
        LanguageTag languageTag = new LanguageTag();
        if (languageTag.parseLanguage(stringTokenIterator, parseStatus)) {
            languageTag.parseExtlangs(stringTokenIterator, parseStatus);
            languageTag.parseScript(stringTokenIterator, parseStatus);
            languageTag.parseRegion(stringTokenIterator, parseStatus);
            languageTag.parseVariants(stringTokenIterator, parseStatus);
            languageTag.parseExtensions(stringTokenIterator, parseStatus);
        }
        languageTag.parsePrivateuse(stringTokenIterator, parseStatus);
        if (!stringTokenIterator.isDone() && !parseStatus.isError()) {
            String string2 = stringTokenIterator.current();
            ParseStatus._jr$ip$errorIndex((Object)parseStatus, (int)stringTokenIterator.currentStart());
            if (string2.length() == 0) {
                ParseStatus._jr$ip$errorMsg((Object)parseStatus, (String)"Empty subtag");
            } else {
                ParseStatus._jr$ip$errorMsg((Object)parseStatus, (String)("Invalid subtag: " + string2));
            }
        }
        return languageTag;
    }

    private boolean parseLanguage(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isLanguage(string)) {
            bl = true;
            this.language = string;
            ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseExtlangs(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        String string;
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        while (!stringTokenIterator.isDone() && LanguageTag.isExtlang(string = stringTokenIterator.current())) {
            bl = true;
            if (this.extlangs.isEmpty()) {
                this.extlangs = new ArrayList(3);
            }
            this.extlangs.add(string);
            ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
            stringTokenIterator.next();
            if (this.extlangs.size() != 3) continue;
            break;
        }
        return bl;
    }

    private boolean parseScript(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isScript(string)) {
            bl = true;
            this.script = string;
            ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseRegion(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isRegion(string)) {
            bl = true;
            this.region = string;
            ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseVariants(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        String string;
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        while (!stringTokenIterator.isDone() && LanguageTag.isVariant(string = stringTokenIterator.current())) {
            bl = true;
            if (this.variants.isEmpty()) {
                this.variants = new ArrayList(3);
            }
            this.variants.add(string);
            ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
            stringTokenIterator.next();
        }
        return bl;
    }

    private boolean parseExtensions(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        String string;
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        while (!stringTokenIterator.isDone() && LanguageTag.isExtensionSingleton(string = stringTokenIterator.current())) {
            int n = stringTokenIterator.currentStart();
            String string2 = string;
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringTokenIterator.next();
            while (!stringTokenIterator.isDone() && LanguageTag.isExtensionSubtag(string = stringTokenIterator.current())) {
                stringBuilder.append(SEP).append(string);
                ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
                stringTokenIterator.next();
            }
            if (ParseStatus._jr$ig$parseLength((Object)parseStatus) <= n) {
                ParseStatus._jr$ip$errorIndex((Object)parseStatus, (int)n);
                ParseStatus._jr$ip$errorMsg((Object)parseStatus, (String)("Incomplete extension '" + string2 + "'"));
                break;
            }
            if (this.extensions.isEmpty()) {
                this.extensions = new ArrayList(4);
            }
            this.extensions.add(stringBuilder.toString());
            bl = true;
        }
        return bl;
    }

    private boolean parsePrivateuse(StringTokenIterator stringTokenIterator, ParseStatus parseStatus) {
        if (stringTokenIterator.isDone() || parseStatus.isError()) {
            return false;
        }
        boolean bl = false;
        String string = stringTokenIterator.current();
        if (LanguageTag.isPrivateusePrefix(string)) {
            int n = stringTokenIterator.currentStart();
            StringBuilder stringBuilder = new StringBuilder(string);
            stringTokenIterator.next();
            while (!stringTokenIterator.isDone() && LanguageTag.isPrivateuseSubtag(string = stringTokenIterator.current())) {
                stringBuilder.append(SEP).append(string);
                ParseStatus._jr$ip$parseLength((Object)parseStatus, (int)stringTokenIterator.currentEnd());
                stringTokenIterator.next();
            }
            if (ParseStatus._jr$ig$parseLength((Object)parseStatus) <= n) {
                ParseStatus._jr$ip$errorIndex((Object)parseStatus, (int)n);
                ParseStatus._jr$ip$errorMsg((Object)parseStatus, (String)"Incomplete privateuse");
            } else {
                this.privateuse = stringBuilder.toString();
                bl = true;
            }
        }
        return bl;
    }

    public static LanguageTag parseLocale(BaseLocale baseLocale, LocaleExtensions localeExtensions) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList;
        LanguageTag languageTag = new LanguageTag();
        String string = baseLocale.getLanguage();
        String string2 = baseLocale.getScript();
        String string3 = baseLocale.getRegion();
        String string4 = baseLocale.getVariant();
        boolean bl = false;
        String string5 = null;
        if (LanguageTag.isLanguage(string)) {
            if (string.equals("iw")) {
                string = "he";
            } else if (string.equals("ji")) {
                string = "yi";
            } else if (string.equals("in")) {
                string = "id";
            }
            languageTag.language = string;
        }
        if (LanguageTag.isScript(string2)) {
            languageTag.script = LanguageTag.canonicalizeScript(string2);
            bl = true;
        }
        if (LanguageTag.isRegion(string3)) {
            languageTag.region = LanguageTag.canonicalizeRegion(string3);
            bl = true;
        }
        if (languageTag.language.equals("no") && languageTag.region.equals("NO") && string4.equals("NY")) {
            languageTag.language = "nn";
            string4 = "";
        }
        if (string4.length() > 0) {
            arrayList = null;
            object3 = new StringTokenIterator(string4, "_");
            while (!((StringTokenIterator)object3).isDone() && LanguageTag.isVariant((String)(object2 = ((StringTokenIterator)object3).current()))) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add((String)object2);
                ((StringTokenIterator)object3).next();
            }
            if (arrayList != null) {
                languageTag.variants = arrayList;
                bl = true;
            }
            if (!((StringTokenIterator)object3).isDone()) {
                object2 = new StringBuilder();
                while (!((StringTokenIterator)object3).isDone() && LanguageTag.isPrivateuseSubtag((String)(object = ((StringTokenIterator)object3).current()))) {
                    if (((StringBuilder)object2).length() > 0) {
                        ((StringBuilder)object2).append(SEP);
                    }
                    ((StringBuilder)object2).append((String)object);
                    ((StringTokenIterator)object3).next();
                }
                if (((StringBuilder)object2).length() > 0) {
                    string5 = ((StringBuilder)object2).toString();
                }
            }
        }
        arrayList = null;
        object3 = null;
        if (localeExtensions != null) {
            object2 = localeExtensions.getKeys();
            object = object2.iterator();
            while (object.hasNext()) {
                Character c = (Character)g.convertForCast((Object)object.next(), Character.class);
                Extension extension = localeExtensions.getExtension(c);
                if (LanguageTag.isPrivateusePrefixChar(c.charValue())) {
                    object3 = extension.getValue();
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(c.toString() + SEP + extension.getValue());
            }
        }
        if (arrayList != null) {
            languageTag.extensions = arrayList;
            bl = true;
        }
        if (string5 != null) {
            object3 = object3 == null ? "lvariant-" + string5 : (String)object3 + SEP + PRIVUSE_VARIANT_PREFIX + SEP + string5.replace("_", SEP);
        }
        if (object3 != null) {
            languageTag.privateuse = (String)object3;
        }
        if (languageTag.language.length() == 0 && (bl || object3 == null)) {
            languageTag.language = UNDETERMINED;
        }
        return languageTag;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<String> getExtlangs() {
        if (this.extlangs.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extlangs);
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getVariants() {
        if (this.variants.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.variants);
    }

    public List<String> getExtensions() {
        if (this.extensions.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extensions);
    }

    public String getPrivateuse() {
        return this.privateuse;
    }

    public static boolean isLanguage(String string) {
        int n = string.length();
        return n >= 2 && n <= 8 && LocaleUtils.isAlphaString(string);
    }

    public static boolean isExtlang(String string) {
        return string.length() == 3 && LocaleUtils.isAlphaString(string);
    }

    public static boolean isScript(String string) {
        return string.length() == 4 && LocaleUtils.isAlphaString(string);
    }

    public static boolean isRegion(String string) {
        return string.length() == 2 && LocaleUtils.isAlphaString(string) || string.length() == 3 && LocaleUtils.isNumericString(string);
    }

    public static boolean isVariant(String string) {
        int n = string.length();
        if (n >= 5 && n <= 8) {
            return LocaleUtils.isAlphaNumericString(string);
        }
        if (n == 4) {
            return LocaleUtils.isNumeric(string.charAt(0)) && LocaleUtils.isAlphaNumeric(string.charAt(1)) && LocaleUtils.isAlphaNumeric(string.charAt(2)) && LocaleUtils.isAlphaNumeric(string.charAt(3));
        }
        return false;
    }

    public static boolean isExtensionSingleton(String string) {
        return string.length() == 1 && LocaleUtils.isAlphaString(string) && !LocaleUtils.caseIgnoreMatch(PRIVATEUSE, string);
    }

    public static boolean isExtensionSingletonChar(char c) {
        return LanguageTag.isExtensionSingleton(String.valueOf(c));
    }

    public static boolean isExtensionSubtag(String string) {
        int n = string.length();
        return n >= 2 && n <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    public static boolean isPrivateusePrefix(String string) {
        return string.length() == 1 && LocaleUtils.caseIgnoreMatch(PRIVATEUSE, string);
    }

    public static boolean isPrivateusePrefixChar(char c) {
        return LocaleUtils.caseIgnoreMatch(PRIVATEUSE, String.valueOf(c));
    }

    public static boolean isPrivateuseSubtag(String string) {
        int n = string.length();
        return n >= 1 && n <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    public static String canonicalizeLanguage(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtlang(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeScript(String string) {
        return LocaleUtils.toTitleString(string);
    }

    public static String canonicalizeRegion(String string) {
        return LocaleUtils.toUpperString(string);
    }

    public static String canonicalizeVariant(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtension(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtensionSingleton(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizeExtensionSubtag(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizePrivateuse(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public static String canonicalizePrivateuseSubtag(String string) {
        return LocaleUtils.toLowerString(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.language.length() > 0) {
            stringBuilder.append(this.language);
            for (String string : this.extlangs) {
                stringBuilder.append(SEP).append(string);
            }
            if (this.script.length() > 0) {
                stringBuilder.append(SEP).append(this.script);
            }
            if (this.region.length() > 0) {
                stringBuilder.append(SEP).append(this.region);
            }
            for (String string : this.variants) {
                stringBuilder.append(SEP).append(string);
            }
            for (String string : this.extensions) {
                stringBuilder.append(SEP).append(string);
            }
        }
        if (this.privateuse.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(SEP);
            }
            stringBuilder.append(this.privateuse);
        }
        return stringBuilder.toString();
    }

    static {
        String[][] stringArrayArray;
        GRANDFATHERED = new HashMap<String, String[]>();
        String[][] stringArrayArray2 = new String[26][];
        Object[] objectArray = new String[2];
        a.arrayStore((Object[])objectArray, (int)0, (Object)"art-lojban");
        a.arrayStore((Object[])objectArray, (int)1, (Object)"jbo");
        a.arrayStore((Object[])stringArrayArray2, (int)0, (Object)objectArray);
        Object[] objectArray2 = new String[2];
        a.arrayStore((Object[])objectArray2, (int)0, (Object)"cel-gaulish");
        a.arrayStore((Object[])objectArray2, (int)1, (Object)"xtg-x-cel-gaulish");
        a.arrayStore((Object[])stringArrayArray2, (int)1, (Object)objectArray2);
        Object[] objectArray3 = new String[2];
        a.arrayStore((Object[])objectArray3, (int)0, (Object)"en-GB-oed");
        a.arrayStore((Object[])objectArray3, (int)1, (Object)"en-GB-x-oed");
        a.arrayStore((Object[])stringArrayArray2, (int)2, (Object)objectArray3);
        Object[] objectArray4 = new String[2];
        a.arrayStore((Object[])objectArray4, (int)0, (Object)"i-ami");
        a.arrayStore((Object[])objectArray4, (int)1, (Object)"ami");
        a.arrayStore((Object[])stringArrayArray2, (int)3, (Object)objectArray4);
        Object[] objectArray5 = new String[2];
        a.arrayStore((Object[])objectArray5, (int)0, (Object)"i-bnn");
        a.arrayStore((Object[])objectArray5, (int)1, (Object)"bnn");
        a.arrayStore((Object[])stringArrayArray2, (int)4, (Object)objectArray5);
        Object[] objectArray6 = new String[2];
        a.arrayStore((Object[])objectArray6, (int)0, (Object)"i-default");
        a.arrayStore((Object[])objectArray6, (int)1, (Object)"en-x-i-default");
        a.arrayStore((Object[])stringArrayArray2, (int)5, (Object)objectArray6);
        Object[] objectArray7 = new String[2];
        a.arrayStore((Object[])objectArray7, (int)0, (Object)"i-enochian");
        a.arrayStore((Object[])objectArray7, (int)1, (Object)"und-x-i-enochian");
        a.arrayStore((Object[])stringArrayArray2, (int)6, (Object)objectArray7);
        Object[] objectArray8 = new String[2];
        a.arrayStore((Object[])objectArray8, (int)0, (Object)"i-hak");
        a.arrayStore((Object[])objectArray8, (int)1, (Object)"hak");
        a.arrayStore((Object[])stringArrayArray2, (int)7, (Object)objectArray8);
        Object[] objectArray9 = new String[2];
        a.arrayStore((Object[])objectArray9, (int)0, (Object)"i-klingon");
        a.arrayStore((Object[])objectArray9, (int)1, (Object)"tlh");
        a.arrayStore((Object[])stringArrayArray2, (int)8, (Object)objectArray9);
        Object[] objectArray10 = new String[2];
        a.arrayStore((Object[])objectArray10, (int)0, (Object)"i-lux");
        a.arrayStore((Object[])objectArray10, (int)1, (Object)"lb");
        a.arrayStore((Object[])stringArrayArray2, (int)9, (Object)objectArray10);
        Object[] objectArray11 = new String[2];
        a.arrayStore((Object[])objectArray11, (int)0, (Object)"i-mingo");
        a.arrayStore((Object[])objectArray11, (int)1, (Object)"see-x-i-mingo");
        a.arrayStore((Object[])stringArrayArray2, (int)10, (Object)objectArray11);
        Object[] objectArray12 = new String[2];
        a.arrayStore((Object[])objectArray12, (int)0, (Object)"i-navajo");
        a.arrayStore((Object[])objectArray12, (int)1, (Object)"nv");
        a.arrayStore((Object[])stringArrayArray2, (int)11, (Object)objectArray12);
        Object[] objectArray13 = new String[2];
        a.arrayStore((Object[])objectArray13, (int)0, (Object)"i-pwn");
        a.arrayStore((Object[])objectArray13, (int)1, (Object)"pwn");
        a.arrayStore((Object[])stringArrayArray2, (int)12, (Object)objectArray13);
        Object[] objectArray14 = new String[2];
        a.arrayStore((Object[])objectArray14, (int)0, (Object)"i-tao");
        a.arrayStore((Object[])objectArray14, (int)1, (Object)"tao");
        a.arrayStore((Object[])stringArrayArray2, (int)13, (Object)objectArray14);
        Object[] objectArray15 = new String[2];
        a.arrayStore((Object[])objectArray15, (int)0, (Object)"i-tay");
        a.arrayStore((Object[])objectArray15, (int)1, (Object)"tay");
        a.arrayStore((Object[])stringArrayArray2, (int)14, (Object)objectArray15);
        Object[] objectArray16 = new String[2];
        a.arrayStore((Object[])objectArray16, (int)0, (Object)"i-tsu");
        a.arrayStore((Object[])objectArray16, (int)1, (Object)"tsu");
        a.arrayStore((Object[])stringArrayArray2, (int)15, (Object)objectArray16);
        Object[] objectArray17 = new String[2];
        a.arrayStore((Object[])objectArray17, (int)0, (Object)"no-bok");
        a.arrayStore((Object[])objectArray17, (int)1, (Object)"nb");
        a.arrayStore((Object[])stringArrayArray2, (int)16, (Object)objectArray17);
        Object[] objectArray18 = new String[2];
        a.arrayStore((Object[])objectArray18, (int)0, (Object)"no-nyn");
        a.arrayStore((Object[])objectArray18, (int)1, (Object)"nn");
        a.arrayStore((Object[])stringArrayArray2, (int)17, (Object)objectArray18);
        Object[] objectArray19 = new String[2];
        a.arrayStore((Object[])objectArray19, (int)0, (Object)"sgn-BE-FR");
        a.arrayStore((Object[])objectArray19, (int)1, (Object)"sfb");
        a.arrayStore((Object[])stringArrayArray2, (int)18, (Object)objectArray19);
        Object[] objectArray20 = new String[2];
        a.arrayStore((Object[])objectArray20, (int)0, (Object)"sgn-BE-NL");
        a.arrayStore((Object[])objectArray20, (int)1, (Object)"vgt");
        a.arrayStore((Object[])stringArrayArray2, (int)19, (Object)objectArray20);
        Object[] objectArray21 = new String[2];
        a.arrayStore((Object[])objectArray21, (int)0, (Object)"sgn-CH-DE");
        a.arrayStore((Object[])objectArray21, (int)1, (Object)"sgg");
        a.arrayStore((Object[])stringArrayArray2, (int)20, (Object)objectArray21);
        Object[] objectArray22 = new String[2];
        a.arrayStore((Object[])objectArray22, (int)0, (Object)"zh-guoyu");
        a.arrayStore((Object[])objectArray22, (int)1, (Object)"cmn");
        a.arrayStore((Object[])stringArrayArray2, (int)21, (Object)objectArray22);
        Object[] objectArray23 = new String[2];
        a.arrayStore((Object[])objectArray23, (int)0, (Object)"zh-hakka");
        a.arrayStore((Object[])objectArray23, (int)1, (Object)"hak");
        a.arrayStore((Object[])stringArrayArray2, (int)22, (Object)objectArray23);
        Object[] objectArray24 = new String[2];
        a.arrayStore((Object[])objectArray24, (int)0, (Object)"zh-min");
        a.arrayStore((Object[])objectArray24, (int)1, (Object)"nan-x-zh-min");
        a.arrayStore((Object[])stringArrayArray2, (int)23, (Object)objectArray24);
        Object[] objectArray25 = new String[2];
        a.arrayStore((Object[])objectArray25, (int)0, (Object)"zh-min-nan");
        a.arrayStore((Object[])objectArray25, (int)1, (Object)"nan");
        a.arrayStore((Object[])stringArrayArray2, (int)24, (Object)objectArray25);
        Object[] objectArray26 = new String[2];
        a.arrayStore((Object[])objectArray26, (int)0, (Object)"zh-xiang");
        a.arrayStore((Object[])objectArray26, (int)1, (Object)"hsn");
        a.arrayStore((Object[])stringArrayArray2, (int)25, (Object)objectArray26);
        for (String[] stringArray : stringArrayArray = stringArrayArray2) {
            GRANDFATHERED.put(LocaleUtils.toLowerString(stringArray[0]), stringArray);
        }
    }

    protected /* synthetic */ LanguageTag(h h2) {
        super(h2);
    }
}

