/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * Signature claims super is java.lang.Object, not com.zeroturnaround.jrebelbase.h - discarding signature.
 */
public abstract class LocaleObjectCache
extends h {
    private ConcurrentMap<K, CacheEntry<K, V>> map;
    private ReferenceQueue<V> queue;

    public LocaleObjectCache() {
        this(16, 0.75f, 16);
    }

    public LocaleObjectCache(int n2, float f2, int n3) {
        this.queue = new ReferenceQueue();
        this.map = new ConcurrentHashMap(n2, f2, n3);
    }

    public V get(K k) {
        Object v = null;
        this.cleanStaleEntries();
        CacheEntry cacheEntry = (CacheEntry)((Object)g.convertForCast(this.map.get(k), CacheEntry.class));
        if (cacheEntry != null) {
            v = cacheEntry.get();
        }
        if (v == null) {
            k = this.normalizeKey(k);
            Object v2 = this.createObject(k);
            if (k == null || v2 == null) {
                return null;
            }
            CacheEntry cacheEntry2 = new CacheEntry(k, v2, this.queue);
            cacheEntry = (CacheEntry)((Object)g.convertForCast(this.map.putIfAbsent(k, cacheEntry2), CacheEntry.class));
            if (cacheEntry == null) {
                v = v2;
            } else {
                v = cacheEntry.get();
                if (v == null) {
                    this.map.put(k, cacheEntry2);
                    v = v2;
                }
            }
        }
        return v;
    }

    protected V put(K k, V v) {
        CacheEntry cacheEntry = new CacheEntry(k, v, this.queue);
        CacheEntry cacheEntry2 = (CacheEntry)((Object)g.convertForCast(this.map.put(k, cacheEntry), CacheEntry.class));
        return cacheEntry2 == null ? null : (Object)cacheEntry2.get();
    }

    private void cleanStaleEntries() {
        CacheEntry cacheEntry;
        while ((cacheEntry = (CacheEntry)((Object)g.convertForCast(this.queue.poll(), CacheEntry.class))) != null) {
            this.map.remove(cacheEntry.getKey());
        }
    }

    protected abstract V createObject(K var1);

    protected K normalizeKey(K k) {
        return k;
    }

    private static /* synthetic */ void _jr$ip$map(LocaleObjectCache localeObjectCache, ConcurrentMap concurrentMap) {
        localeObjectCache.map = concurrentMap;
    }

    private static /* synthetic */ void _jr$ip$queue(LocaleObjectCache localeObjectCache, ReferenceQueue referenceQueue) {
        localeObjectCache.queue = referenceQueue;
    }

    protected /* synthetic */ LocaleObjectCache(h h2) {
        super(h2);
    }

    private static class CacheEntry<K, V>
    extends SoftReference<V> {
        private K key;

        CacheEntry(K k, V v, ReferenceQueue<V> referenceQueue) {
            super(v, referenceQueue);
            this.key = k;
        }

        K getKey() {
            return (K)this.key;
        }

        private static /* synthetic */ void _jr$ip$key(CacheEntry cacheEntry, Object object) {
            cacheEntry.key = object;
        }

        protected /* synthetic */ CacheEntry(h h2) {
            super(h2);
        }
    }
}

