/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.h;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LocaleUtils
extends h {
    private LocaleUtils() {
    }

    public static boolean caseIgnoreMatch(String string, String string2) {
        if (!f.ifAcmp((Object)string, (Object)string2)) {
            return true;
        }
        int n2 = string.length();
        if (n2 != string2.length()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i)) || LocaleUtils.toLower(c2) == LocaleUtils.toLower(c)) continue;
            return false;
        }
        return true;
    }

    static int caseIgnoreCompare(String string, String string2) {
        if (!f.ifAcmp((Object)string, (Object)string2)) {
            return 0;
        }
        return LocaleUtils.toLowerString(string).compareTo(LocaleUtils.toLowerString(string2));
    }

    static char toUpper(char c) {
        return LocaleUtils.isLower(c) ? (char)(c - 32) : c;
    }

    static char toLower(char c) {
        return LocaleUtils.isUpper(c) ? (char)(c + 32) : c;
    }

    public static String toLowerString(String string) {
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && !LocaleUtils.isUpper(string.charAt(n2)); ++n2) {
        }
        if (n2 == n3) {
            return string;
        }
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            cArray[i] = i < n2 ? c : LocaleUtils.toLower(c);
        }
        return new String(cArray);
    }

    static String toUpperString(String string) {
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && !LocaleUtils.isLower(string.charAt(n2)); ++n2) {
        }
        if (n2 == n3) {
            return string;
        }
        char[] cArray = new char[n3];
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            cArray[i] = i < n2 ? c : LocaleUtils.toUpper(c);
        }
        return new String(cArray);
    }

    static String toTitleString(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        if (!LocaleUtils.isLower(string.charAt(n3))) {
            for (n3 = 1; n3 < n2 && !LocaleUtils.isUpper(string.charAt(n3)); ++n3) {
            }
        }
        if (n3 == n2) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            cArray[i] = i == 0 && n3 == 0 ? LocaleUtils.toUpper(c) : (i < n3 ? c : LocaleUtils.toLower(c));
        }
        return new String(cArray);
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    static boolean isAlphaString(String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (LocaleUtils.isAlpha(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    static boolean isNumericString(String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (LocaleUtils.isNumeric(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isAlphaNumeric(char c) {
        return LocaleUtils.isAlpha(c) || LocaleUtils.isNumeric(c);
    }

    static boolean isAlphaNumericString(String string) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (LocaleUtils.isAlphaNumeric(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }
}

