/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale;

import com.zeroturnaround.jrebelbase.facade.f;
import com.zeroturnaround.jrebelbase.facade.g;
import com.zeroturnaround.jrebelbase.h;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import sun.util.locale.Extension;
import sun.util.locale.LocaleUtils;

public class UnicodeLocaleExtension
extends Extension {
    public static final char SINGLETON = 'u';
    private final Set<String> attributes;
    private final Map<String, String> keywords;
    public static final UnicodeLocaleExtension CA_JAPANESE = new UnicodeLocaleExtension("ca", "japanese");
    public static final UnicodeLocaleExtension NU_THAI = new UnicodeLocaleExtension("nu", "thai");

    private UnicodeLocaleExtension(String string, String string2) {
        super('u', string + "-" + string2);
        this.attributes = Collections.emptySet();
        this.keywords = Collections.singletonMap(string, string2);
    }

    UnicodeLocaleExtension(SortedSet<String> sortedSet, SortedMap<String, String> sortedMap) {
        super('u');
        this.attributes = sortedSet != null ? sortedSet : Collections.emptySet();
        this.keywords = sortedMap != null ? sortedMap : Collections.emptyMap();
        if (!this.attributes.isEmpty() || !this.keywords.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object : this.attributes) {
                stringBuilder.append("-").append(object);
            }
            Iterator<Object> iterator = this.keywords.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)g.convertForCast((Object)iterator.next(), Map.Entry.class);
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                stringBuilder.append("-").append(string);
                if (string2.length() <= 0) continue;
                stringBuilder.append("-").append(string2);
            }
            this.setValue(stringBuilder.substring(1));
        }
    }

    public Set<String> getUnicodeLocaleAttributes() {
        if (!f.ifAcmp((Object)this.attributes, (Object)Collections.EMPTY_SET)) {
            return this.attributes;
        }
        return Collections.unmodifiableSet(this.attributes);
    }

    public Set<String> getUnicodeLocaleKeys() {
        if (!f.ifAcmp((Object)this.keywords, (Object)Collections.EMPTY_MAP)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.keywords.keySet());
    }

    public String getUnicodeLocaleType(String string) {
        return (String)this.keywords.get(string);
    }

    public static boolean isSingletonChar(char c2) {
        return 'u' == LocaleUtils.toLower(c2);
    }

    public static boolean isAttribute(String string) {
        int n2 = string.length();
        return n2 >= 3 && n2 <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    public static boolean isKey(String string) {
        return string.length() == 2 && LocaleUtils.isAlphaNumericString(string);
    }

    public static boolean isTypeSubtag(String string) {
        int n2 = string.length();
        return n2 >= 3 && n2 <= 8 && LocaleUtils.isAlphaNumericString(string);
    }

    private static /* synthetic */ void _jr$ip$attributes(UnicodeLocaleExtension unicodeLocaleExtension, Set set) {
        unicodeLocaleExtension.attributes = set;
    }

    private static /* synthetic */ void _jr$ip$keywords(UnicodeLocaleExtension unicodeLocaleExtension, Map map) {
        unicodeLocaleExtension.keywords = map;
    }

    protected /* synthetic */ UnicodeLocaleExtension(h h2) {
        super(h2);
    }
}

