﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace RMDemo_CSharpe
{
    public partial class Form_LoadFromDataSet : Form
    {
        public Form_LoadFromDataSet()
        {
            InitializeComponent();
        }

        private void Form_LoadFromDataSet_Load(object sender, EventArgs e)
        {
            this.dataSet11.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "select * from ReportData";
            this.oleDbDataAdapter1.Fill(this.dataSet11, "ReportData");
            this.dataGridView1.DataSource = this.dataSet11.Tables["ReportData"];

            this.dataGridView1.Columns.Remove("ReportData");
            this.dataGridView1.Columns.Remove("ReportType");
            this.dataGridView1.AutoResizeColumns();
        }

        private void dataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {

        }

        private void button1_Click(object sender, EventArgs e)
        {
            DataRow row = null;
            byte[] buff = new byte[0];

            row = this.dataSet11.Tables["ReportData"].Rows[this.dataGridView1.CurrentCell.RowIndex];
            buff = (byte[])row["ReportData"];

            this.rmReport1.Init(this, RM.Interop.ReportMachine.TxRMReportType.rmrtReport);
            this.rmReport1.PreviewOptions.BtnDesignVisible = true;
            this.rmReport1.AddGlobalVariable(" dir1", "", false);
            this.rmReport1.AddGlobalVariable("公司名称", "我的公司名称", true);

            this.rmReport1.ReportData = buff;
            
            this.rmReport1.DesignReport();
        }

        private void rmReport1_OnDesginerSaveReport(object sender, AxRM.Interop.ReportMachine.IRMReportEngineEvents_OnDesignerSaveReportEvent e)
        {
            DataRow row = null;

            if (e.aSaveAs)
            {
            }
            else
            {
                row = this.dataSet11.Tables["ReportData"].Rows[this.dataGridView1.CurrentCell.RowIndex];
                row["ReportData"] = this.rmReport1.ReportData;
                e.aSaved = true;

                MessageBox.Show("保存成功！");  
                // this.oleDbDataAdapter1.Update(this.dataSet11, "ReportData");
            }
        }

        private void rmReport1_OnDesginerNewReport(object sender, AxRM.Interop.ReportMachine.IRMReportEngineEvents_OnDesignerNewReportEvent e)
        {
            this.rmReport1.AddVariable("test", "我的公司名称", true);
            this.rmReport1.ReportInfo.Company = "我的公司名称是什么";
        }

        private void button4_Click(object sender, EventArgs e)
        {
            DataRow row = null;
            byte[] buff = new byte[0];

            row = this.dataSet11.Tables["ReportData"].Rows[this.dataGridView1.CurrentCell.RowIndex];
            buff = (byte[])row["ReportData"];

            this.rmReport1.Init(this, RM.Interop.ReportMachine.TxRMReportType.rmrtReport);
            this.rmReport1.PreviewOptions.BtnDesignVisible = true;
            this.rmReport1.AddGlobalVariable(" dir1", "", false);
            this.rmReport1.AddGlobalVariable("公司名称", "我的公司名称", true);

            this.rmReport1.ReportData = buff;

            this.rmReport1.ShowReport();

        }
    }
}
