﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using RM.Interop.ReportMachine;

namespace RMDemo_CSharpe
{
    public partial class Form1 : Form
    {
        string MainPath;

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //int i;

            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "select * from Customer";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");
            this.dataView1.Table = this.dataSet1.Tables["Customer"];
            this.dataView1.RowFilter = "CustNo >= 3000";
            //this.dataGrid1.DataSource = this.dataView1;

            rmReport1.ModifyPrepared = false;
            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.PreviewOptions.BtnDesignVisible = true;
            //rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "db1");
            rmReport1.AddDataSet(this.dataView1, "db1");
            rmReport1.LoadFromFile(MainPath + "reports\\SimpleList.rmf"); //SimpleList.rmf

            rmReport1.AddVariable("公司名称", "我的公司名称", true);
            rmReport1.AddVariable("公司简称", "我的公司简称", true);
            rmReport1.AddVariable("公司电话", "我的公司电话", true);

            if (radioButton1.Checked)
            {
                this.progressBar1.Maximum = 100;
                //for (i = 0; i < 100; i++)
                {
                    //this.progressBar1.Value = i;
                    rmReport1.ShowReport();
                    //rmReport1.PrepareReport();

                }
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            DataRelation myRela1, myRela2;

            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT * from customer ORDER BY company";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT * from Orders ORDER BY CustNo,OrderNo";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Orders");

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT Items.*, Parts.ListPrice as Price, Parts.Description as PartName from Items, Parts where Items.Partno=Parts.Partno ORDER BY OrderNo";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Items");

            myRela1 = new DataRelation("Rela1", this.dataSet1.Tables["Customer"].Columns["CustNo"], this.dataSet1.Tables["Orders"].Columns["CustNo"]);
            this.dataSet1.Relations.Add(myRela1);

            myRela2 = new DataRelation("Rela2", this.dataSet1.Tables["Orders"].Columns["OrderNo"], this.dataSet1.Tables["Items"].Columns["OrderNo"]);
            this.dataSet1.Relations.Add(myRela2);

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "CustomersDS");
            rmReport1.AddDetailDataSet(this.dataSet1.Tables["Orders"], "OrdersDS", "CustomersDS", myRela1);
            rmReport1.AddDetailDataSet(this.dataSet1.Tables["Items"], "ItemsDS", "OrdersDS", myRela2);
            rmReport1.LoadFromFile(MainPath + "reports\\mainsub.rmf");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "select * from Customer order by Company";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "CustomersDS");
            rmReport1.LoadFromFile("reports\\group.rmf");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            string lSql;

            lSql = "select * FROM customer AS a, orders AS b, items AS c, parts AS d" +
                " WHERE a.custno=b.custno And b.orderno=c.orderno And c.partno=d.partno" +
                " ORDER BY a.company, b.orderno";

            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = lSql;
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "QueryDS");
            rmReport1.LoadFromFile("reports\\group1.rmf");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT * from customer";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "CustomersDS");
            rmReport1.LoadFromFile("reports\\columnSplit.rmf");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT * from country";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "RMDBDataSet1");
            rmReport1.LoadFromFile("reports\\chart.rmf");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT * from biolife";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "BioDS");
            rmReport1.LoadFromFile("reports\\image.rmf");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "SELECT * from customer";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");
            this.dataSet1.Tables["Customer"].Columns[1].Caption = "公司名称";

            rmReport1.Init(this, TxRMReportType.rmrtGridReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "CustomersDS");
            rmReport1.LoadFromFile("reports\\ShowDialog.rls");
            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            IRMReportPage lPageX;
            IRMBandMasterData lDataBand;
            IRMBand lPageHeader, lDataFooter;
            IRMMemoView lViewX;
            IRMCalcMemoView lViewX1;

            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "select * from Customer";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "db1");

            lPageX = rmReport1.AddReportPage();
            lPageX.ChangePaper(8, 0, 0, 0, /*TxRMPrinterOrientation.rmpoLandscape*/0);

            lPageHeader = lPageX.AddBand(TxRMBandType.rmbtPageHeader);
            lPageHeader.SetBounds(0, 30, 0, 30);
            lViewX = (IRMMemoView)lPageX.AddReportObject(TxRMObjectType.rmgtMemo);
            lViewX.Top = lPageHeader.Top;
            lViewX.Height = lPageHeader.Height;
            lViewX.Text = "页标题";
            lViewX.Left = 200;
            lViewX.Width = 300;
            lViewX.SetFrameVisible(false);
            lViewX.Font.Size = 12;
            lViewX.HAlign = TxRMHAlign.rmhCenter;
            lViewX.VAlign = TxRMVAlign.rmvCenter;
            lViewX.FillColor = rmReport1.ToBorlandColor(System.Drawing.Color.Red);

            //System.Drawing.Color.Red.ToArgb
            lDataBand = (IRMBandMasterData)lPageX.AddBand(TxRMBandType.rmbtMasterData);
            lDataBand.SetBounds(0, 100, 0, 20);
            lDataBand.DataSetName = "db1";
            lDataBand.Name = "MasterData1";

            lViewX = (IRMMemoView)lPageX.AddReportObject(TxRMObjectType.rmgtMemo);
            lViewX.SetBounds(0, lDataBand.Top, 200, lDataBand.Height);
            lViewX.Text = "[db1.\"CustNo\"]";
            lViewX.SetFrameVisible(true);
            lViewX.set_Prop("Font.Size", 12);

            lViewX = (IRMMemoView)lPageX.AddReportObject(TxRMObjectType.rmgtMemo);
            lViewX.Top = lDataBand.Top;
            lViewX.Height = lDataBand.Height;
            lViewX.Text = "[db1.\"Company\"]";
            lViewX.Left = 200;
            lViewX.Width = 300;
            lViewX.SetFrameVisible(true);
            lViewX.Font.Size = 12;
            lViewX.HAlign = TxRMHAlign.rmhCenter;
            lViewX.VAlign = TxRMVAlign.rmvCenter;

            lDataFooter = lPageX.AddBand(TxRMBandType.rmbtFooter);
            lDataFooter.SetBounds(0, 160, 0, 30);
            lViewX1 = (IRMCalcMemoView)lPageX.AddReportObject(TxRMObjectType.rmgtCalcMemo);
            lViewX1.SetBounds(0, lDataFooter.Top, 200, lDataFooter.Height);
            lViewX1.Text = "[db1.\"CustNo\"]";
            lViewX1.SetFrameVisible(true);
            lViewX1.set_Prop("Font.Size", 12);
            lViewX1.CalcOptions.AggrBandName = lDataBand.Name;
            lViewX1.CalcOptions.CalcType = TxRMDBCalcType.rmdcCount;

            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            IRMGridPage lGridPageX;
            IRMBand lDataBand;
            IRMGrid lGridX;
            IRMMemoView lView;

            this.dataSet1.Reset();

            this.oleDbDataAdapter1.SelectCommand.CommandText = "select * from Customer";
            this.oleDbDataAdapter1.Fill(this.dataSet1, "Customer");

            rmReport1.Init(this, TxRMReportType.rmrtGridReport);
            rmReport1.AddDataSet(this.dataSet1.Tables["Customer"], "db1");

            lGridPageX = rmReport1.AddGridPage();
            lGridX = lGridPageX.Grid;
            lGridX.ColCount = 4;
            lGridX.RowCount = 3;
            lGridX.set_RowHeights(1, 60);
            lGridX.set_RowHeights(2, 20);

            lDataBand = lGridPageX.AddBand(TxRMBandType.rmbtPageHeader);
            lGridX.SetRowBand(1, lDataBand);

            lGridX.MergeCell(1, 1, 2, 1);
            lGridX.get_Cells(1, 1).Text = "Company";
            lGridX.get_Cells(3, 1).Text = "CustNo";

            lView = (IRMMemoView)lGridX.get_Cells(1, 1);
            lView.Font.Color = rmReport1.ToBorlandColor(System.Drawing.Color.White);
            lView.Font.Size = 20;
            lView.Font.IsBold = true;
            lView.FillColor = rmReport1.ToBorlandColor(System.Drawing.Color.Green);

            lDataBand = lGridPageX.AddBand(TxRMBandType.rmbtMasterData);
            lDataBand.Top = 40;
            lDataBand.Height = 30;
            lDataBand.set_Prop("DataSetName", "db1");
            lGridX.SetRowBand(2, lDataBand);

            lGridX.MergeCell(1, 2, 2, 2);
            lGridX.get_Cells(1, 2).Text = "[db1.\"Company\"]";
            lGridX.set_ColWidths(1, 260);
            lView = (IRMMemoView)lGridX.get_Cells(3, 2);
            lView.HAlign = TxRMHAlign.rmhLeft;

            lGridX.set_ColWidths(3, 200);
            lGridX.get_Cells(3, 2).Text = "[db1.\"CustNo\"]";
            lView = (IRMMemoView)lGridX.get_Cells(3, 2);
            lView.HAlign = TxRMHAlign.rmhRight;

            if (radioButton1.Checked)
            {
                rmReport1.ShowReport();
            }
            else
            {
                rmReport1.DesignReport();
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            FormStream tmp;

            tmp = new FormStream();
            tmp.ShowDialog();
            tmp.Dispose();
        }

        private void button12_Click(object sender, EventArgs e)
        {
            FormUserFunction tmp;

            tmp = new FormUserFunction();
            tmp.ShowDialog();
            tmp.Dispose();
        }

        private void button13_Click(object sender, EventArgs e)
        {
            FormPicture tmp;

            tmp = new FormPicture();
            tmp.ShowDialog();
            tmp.Dispose();
        }

        private void button14_Click(object sender, EventArgs e)
        {
            FormDataSet tmp;

            tmp = new FormDataSet();
            tmp.ShowDialog();
            tmp.Dispose();
        }

        private void button15_Click(object sender, EventArgs e)
        {
            FormUserPreview tmp;

            tmp = new FormUserPreview();
            tmp.ShowDialog();
            tmp.Dispose();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Button l;

            MainPath = System.IO.Directory.GetCurrentDirectory() + '\\';

            l = new Button();
            l.Text = "Test";
            l.Left = 300;
            l.Top = 100;
            l.Width = 40;
            l.Height = 20;
            this.Controls.Add(l);

            this.oleDbConnection1.ConnectionString = "Provider = Microsoft.Jet.OLEDB.4.0;Data Source=" + MainPath + "database\\ReportDemo.mdb";
        }

        private void button16_Click(object sender, EventArgs e)
        {
            Form_LoadFromDataSet tmp;

            tmp = new Form_LoadFromDataSet();
            tmp.ShowDialog();
            tmp.Dispose();
        }
    }
}
